/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RelatedMetadataElementStub {
    private static PropertyHelper propertyHelper = new PropertyHelper();
    private ElementHeader relationshipHeader = null;
    private ElementProperties relationshipProperties = null;
    private ElementStub relatedElement = null;

    public RelatedMetadataElementStub() {
    }

    public RelatedMetadataElementStub(RelatedMetadataElementStub template) {
        if (template != null) {
            this.relationshipHeader = template.getRelationshipHeader();
            this.relationshipProperties = template.getRelationshipProperties();
            this.relatedElement = template.getRelatedElement();
        }
    }

    public RelatedMetadataElementStub(RelatedMetadataElement template) {
        String methodName = "clone RelatedMetadataElementStub";
        if (template != null) {
            this.relationshipHeader = new ElementHeader(template);
            this.relationshipHeader.setGUID(template.getRelationshipGUID());
            this.relationshipProperties = template.getRelationshipProperties();
            this.relatedElement = new ElementStub(template.getElement());
            this.relatedElement.setUniqueName(propertyHelper.getStringProperty(this.getClass().getName(), OpenMetadataProperty.QUALIFIED_NAME.name, template.getElement().getElementProperties(), "clone RelatedMetadataElementStub"));
        }
    }

    public ElementHeader getRelationshipHeader() {
        return this.relationshipHeader;
    }

    public void setRelationshipHeader(ElementHeader relationshipHeader) {
        this.relationshipHeader = relationshipHeader;
    }

    public ElementProperties getRelationshipProperties() {
        return this.relationshipProperties;
    }

    public void setRelationshipProperties(ElementProperties relationshipProperties) {
        this.relationshipProperties = relationshipProperties;
    }

    public ElementStub getRelatedElement() {
        return this.relatedElement;
    }

    public void setRelatedElement(ElementStub relatedElement) {
        this.relatedElement = relatedElement;
    }

    public String toString() {
        return "RelatedBy{relationshipHeader=" + String.valueOf(this.relationshipHeader) + ", relationshipProperties=" + String.valueOf(this.relationshipProperties) + ", relatedElement=" + String.valueOf(this.relatedElement) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        RelatedMetadataElementStub that = (RelatedMetadataElementStub)objectToCompare;
        return Objects.equals(this.getRelationshipHeader(), that.getRelationshipHeader()) && Objects.equals(this.getRelationshipProperties(), that.getRelationshipProperties()) && Objects.equals(this.getRelatedElement(), that.getRelatedElement());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.relationshipHeader, this.relationshipProperties, this.relatedElement);
    }
}

