/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.communities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CommunityProperties
extends ReferenceableProperties {
    private String name = null;
    private String description = null;
    private String mission = null;

    public CommunityProperties() {
    }

    public CommunityProperties(CommunityProperties template) {
        super(template);
        if (template != null) {
            this.name = template.getName();
            this.description = template.getDescription();
            this.mission = template.getMission();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMission() {
        return this.mission;
    }

    public void setMission(String mission) {
        this.mission = mission;
    }

    @Override
    public String toString() {
        return "CommunityProperties{name='" + this.name + "', description='" + this.description + "', mission='" + this.mission + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ", effectiveFrom=" + String.valueOf(this.getEffectiveFrom()) + ", effectiveTo=" + String.valueOf(this.getEffectiveTo()) + ", vendorProperties=" + String.valueOf(this.getVendorProperties()) + ", typeName='" + this.getTypeName() + "', extendedProperties=" + String.valueOf(this.getExtendedProperties()) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CommunityProperties community = (CommunityProperties)objectToCompare;
        return Objects.equals(this.getMission(), community.getMission()) && Objects.equals(this.getName(), community.getName()) && Objects.equals(this.getDescription(), community.getDescription());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMission(), this.getName(), this.getDescription());
    }
}

