/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.datadictionaries;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataClassAssignmentStatus;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataClassAssignmentProperties
extends RelationshipProperties {
    private String method = null;
    private DataClassAssignmentStatus status = DataClassAssignmentStatus.PROPOSED;
    private boolean partialMatch = false;
    private int confidence = 0;
    private float threshold = 0.0f;
    private long valueFrequency = 0L;
    private String steward = null;
    private String source = null;

    public DataClassAssignmentProperties() {
    }

    public DataClassAssignmentProperties(DataClassAssignmentProperties template) {
        super(template);
        if (template != null) {
            this.method = template.getMethod();
            this.partialMatch = template.getPartialMatch();
            this.status = template.getStatus();
            this.confidence = template.getConfidence();
            this.threshold = template.getThreshold().floatValue();
            this.valueFrequency = template.getValueFrequency();
            this.steward = template.getSteward();
            this.source = template.getSource();
        }
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setPartialMatch(boolean partialMatch) {
        this.partialMatch = partialMatch;
    }

    public boolean getPartialMatch() {
        return this.partialMatch;
    }

    public void setStatus(DataClassAssignmentStatus status) {
        this.status = status;
    }

    public DataClassAssignmentStatus getStatus() {
        return this.status;
    }

    public int getConfidence() {
        return this.confidence;
    }

    public void setConfidence(int confidence) {
        this.confidence = confidence;
    }

    public Float getThreshold() {
        return Float.valueOf(this.threshold);
    }

    public void setThreshold(Float threshold) {
        this.threshold = threshold.floatValue();
    }

    public long getValueFrequency() {
        return this.valueFrequency;
    }

    public void setValueFrequency(long valueFrequency) {
        this.valueFrequency = valueFrequency;
    }

    public void setSteward(String steward) {
        this.steward = steward;
    }

    public String getSteward() {
        return this.steward;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public String toString() {
        return "DataClassAssignmentProperties{method='" + this.method + "', status=" + String.valueOf(this.status) + ", partialMatch=" + this.partialMatch + ", confidence=" + this.confidence + ", threshold=" + this.threshold + ", valueFrequency=" + this.valueFrequency + ", steward='" + this.steward + "', source='" + this.source + "'} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof DataClassAssignmentProperties)) {
            return false;
        }
        DataClassAssignmentProperties that = (DataClassAssignmentProperties)objectToCompare;
        if (!super.equals(objectToCompare)) {
            return false;
        }
        return this.confidence == that.confidence && Objects.equals(this.method, that.method) && Objects.equals(this.partialMatch, that.partialMatch) && Objects.equals(this.valueFrequency, that.valueFrequency) && this.status == that.status && Objects.equals(Float.valueOf(this.threshold), Float.valueOf(that.threshold)) && Objects.equals(this.steward, that.steward) && Objects.equals(this.source, that.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.method, this.partialMatch, this.status, this.confidence, Float.valueOf(this.threshold), this.valueFrequency, this.steward, this.source);
    }
}

