/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.solutions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SolutionPortDirection;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SolutionPortProperties
extends ReferenceableProperties {
    private String displayName = null;
    private String description = null;
    private String version = null;
    private SolutionPortDirection solutionPortDirection = null;

    public SolutionPortProperties() {
    }

    public SolutionPortProperties(SolutionPortProperties template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.version = template.getVersion();
            this.solutionPortDirection = template.getSolutionPortDirection();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public SolutionPortDirection getSolutionPortDirection() {
        return this.solutionPortDirection;
    }

    public void setSolutionPortDirection(SolutionPortDirection solutionPortDirection) {
        this.solutionPortDirection = solutionPortDirection;
    }

    @Override
    public String toString() {
        return "SolutionPortProperties{displayName='" + this.displayName + "', description='" + this.description + "', version='" + this.version + "', solutionPortDirection=" + String.valueOf(this.solutionPortDirection) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SolutionPortProperties that = (SolutionPortProperties)objectToCompare;
        return Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.version, that.version) && this.solutionPortDirection == that.solutionPortDirection;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.displayName, this.description, this.version, this.solutionPortDirection);
    }
}

