/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.odpi.openmetadata.frameworks.openmetadata.search.ArrayTypePropertyValue;
import org.odpi.openmetadata.frameworks.openmetadata.search.EnumTypePropertyValue;
import org.odpi.openmetadata.frameworks.openmetadata.search.MapTypePropertyValue;
import org.odpi.openmetadata.frameworks.openmetadata.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.openmetadata.search.StructTypePropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ArrayTypePropertyValue.class, name="ArrayTypePropertyValue"), @JsonSubTypes.Type(value=EnumTypePropertyValue.class, name="EnumTypePropertyValue"), @JsonSubTypes.Type(value=MapTypePropertyValue.class, name="MapTypePropertyValue"), @JsonSubTypes.Type(value=PrimitiveTypePropertyValue.class, name="PrimitiveTypePropertyValue"), @JsonSubTypes.Type(value=StructTypePropertyValue.class, name="StructTypePropertyValue")})
public abstract class PropertyValue {
    private String typeName = null;

    protected PropertyValue() {
    }

    protected PropertyValue(PropertyValue template) {
        if (template != null) {
            this.typeName = template.getTypeName();
        }
    }

    public abstract PropertyValue cloneFromSubclass();

    public abstract String valueAsString();

    public abstract Object valueAsObject();

    protected <K, V extends PropertyValue> Map<K, Object> mapValuesAsObject(Map<K, V> valMap) {
        return this.convertValues(valMap, entry -> entry.getValue() == null ? null : ((PropertyValue)entry.getValue()).valueAsObject());
    }

    protected <K, V extends PropertyValue> Map<K, String> mapValuesAsString(Map<K, V> valMap) {
        return this.convertValues(valMap, entry -> entry.getValue() == null ? "<null>" : ((PropertyValue)entry.getValue()).valueAsString());
    }

    private <K, V extends PropertyValue, R> Map<K, R> convertValues(Map<K, V> valMap, Function<Map.Entry<K, V>, R> mapper) {
        return Optional.ofNullable(valMap).map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty).collect(HashMap::new, (m, e) -> m.put(e.getKey(), mapper.apply((Map.Entry)e)), HashMap::putAll);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        return "PropertyValue{, typeName='" + this.typeName + "'}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof PropertyValue)) {
            return false;
        }
        PropertyValue that = (PropertyValue)objectToCompare;
        return Objects.equals(this.getTypeName(), that.getTypeName());
    }

    public int hashCode() {
        return Objects.hash(this.getTypeName());
    }
}

