/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.measurements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.types.DataType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum RelationalDatabaseMetric implements SurveyMetric
{
    DATABASE_NAME("databaseName", DataType.STRING.getName(), "Database Name", "Name of the database"),
    SCHEMA_COUNT("schemaCount", DataType.LONG.getName(), "Number of schemas", "Number of schemas found in the database."),
    TABLE_COUNT("tableCount", DataType.LONG.getName(), "Number of tables", "Number of tables found in the database."),
    VIEW_COUNT("viewCount", DataType.LONG.getName(), "Number of views", "Count of views in the database."),
    MAT_VIEW_COUNT("materializedViewCount", DataType.LONG.getName(), "Number of materialized views", "Count of materialized views in the database."),
    COLUMN_COUNT("columnCount", DataType.LONG.getName(), "Number of columns", "Count of all columns in the tables/views."),
    DATA_SIZE("dataSize", DataType.LONG.getName(), "Data size", "Number of stored bytes of data in the surveyed resource."),
    ROWS_FETCHED("rowsFetched", DataType.LONG.getName(), "Rows Fetched", "Number of rows retrieved from any table in the database."),
    ROWS_INSERTED("rowsInserted", DataType.LONG.getName(), "Rows Inserted", "Number of rows inserted from any table in the database."),
    ROWS_UPDATED("rowsUpdated", DataType.LONG.getName(), "Rows Updated", "Number of rows updated from any table in the database."),
    ROWS_DELETED("rowsDeleted", DataType.LONG.getName(), "Rows Deleted", "Number of rows deleted from any table in the database."),
    SESSION_TIME("totalSessionTime", DataType.DOUBLE.getName(), "Session Time", "The length of time (milliseconds) that the database had at least one open session from an external client."),
    ACTIVE_TIME("totalActiveTime", DataType.DOUBLE.getName(), "Active Time", "The length of time (milliseconds) that the database was being actively queried."),
    LAST_STATISTICS_RESET("lastStatisticsReset", DataType.DATE.getName(), "Last statistics reset", "Last time that the statistics were reset in the database.");

    public final String propertyName;
    public final String dataType;
    public final String displayName;
    public final String description;

    private RelationalDatabaseMetric(String propertyName, String dataType, String displayName, String description) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static List<SurveyMetric> getMetrics() {
        return new ArrayList<SurveyMetric>(Arrays.asList(RelationalDatabaseMetric.values()));
    }

    public String toString() {
        return "RelationalDatabaseMetric{" + this.displayName + "}";
    }
}

