/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.surveyaction.properties.DataFieldAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataClassAnnotation
extends DataFieldAnnotation {
    private List<String> candidateDataClassGUIDs = null;
    private long matchingValues = 0L;
    private long nonMatchingValues = 0L;

    public DataClassAnnotation() {
    }

    public DataClassAnnotation(DataClassAnnotation template) {
        super(template);
        if (template != null) {
            this.candidateDataClassGUIDs = template.getCandidateDataClassGUIDs();
            this.matchingValues = template.getMatchingValues();
            this.nonMatchingValues = template.getNonMatchingValues();
        }
    }

    public List<String> getCandidateDataClassGUIDs() {
        return this.candidateDataClassGUIDs;
    }

    public void setCandidateDataClassGUIDs(List<String> candidateDataClassGUIDs) {
        this.candidateDataClassGUIDs = candidateDataClassGUIDs;
    }

    public long getMatchingValues() {
        return this.matchingValues;
    }

    public void setMatchingValues(long matchingValues) {
        this.matchingValues = matchingValues;
    }

    public long getNonMatchingValues() {
        return this.nonMatchingValues;
    }

    public void setNonMatchingValues(long nonMatchingValues) {
        this.nonMatchingValues = nonMatchingValues;
    }

    @Override
    public String toString() {
        return "DataClassAnnotation{candidateDataClassGUIDs=" + String.valueOf(this.candidateDataClassGUIDs) + ", matchingValues=" + this.matchingValues + ", nonMatchingValues=" + this.nonMatchingValues + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DataClassAnnotation that = (DataClassAnnotation)objectToCompare;
        return this.matchingValues == that.matchingValues && this.nonMatchingValues == that.nonMatchingValues && Objects.equals(this.candidateDataClassGUIDs, that.candidateDataClassGUIDs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.candidateDataClassGUIDs, this.matchingValues, this.nonMatchingValues);
    }
}

