/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.client;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceListener;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceCompletionInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.WatchDogEventInterface;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.EngineActionElement;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.NewActionTarget;
import org.odpi.openmetadata.frameworkservices.gaf.client.GovernanceListenerManager;
import org.odpi.openmetadata.frameworkservices.gaf.client.OpenGovernanceClientBase;
import org.odpi.openmetadata.frameworkservices.gaf.client.rest.GAFRESTClient;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CompletionStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.ActionTargetStatusRequestBody;

public class GovernanceContextClientBase
extends OpenGovernanceClientBase
implements GovernanceCompletionInterface,
WatchDogEventInterface {
    private final GAFRESTClient restClient;
    protected GovernanceListenerManager governanceListenerManager = null;
    protected String listenerId = null;

    public GovernanceContextClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot, maxPageSize);
        this.restClient = new GAFRESTClient(serverName, serverPlatformURLRoot);
    }

    public GovernanceContextClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, String serverUserId, String serverPassword, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot, maxPageSize);
        String methodName = "Client Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor (with security)");
        this.restClient = new GAFRESTClient(serverName, serverPlatformURLRoot, serverUserId, serverPassword);
    }

    public GovernanceContextClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, GAFRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot, maxPageSize);
        this.restClient = restClient;
    }

    public void setListenerManager(GovernanceListenerManager governanceListenerManager, String listenerId) {
        this.governanceListenerManager = governanceListenerManager;
        this.listenerId = listenerId;
    }

    @Override
    public void registerListener(WatchdogGovernanceListener listener, List<WatchdogEventType> interestingEventTypes, List<String> interestingMetadataTypes, String specificInstance) throws InvalidParameterException {
        this.governanceListenerManager.registerListener(this.listenerId, listener, interestingEventTypes, interestingMetadataTypes, specificInstance);
    }

    @Override
    public void disconnectListener() {
        this.governanceListenerManager.removeListener(this.listenerId);
    }

    @Override
    public void updateEngineActionStatus(String userId, String engineActionGUID, EngineActionStatus engineActionStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEngineActionStatus";
        String guidParameterName = "engineActionGUID";
        String statusParameterName = "engineActionStatus";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-context-service/users/{2}/engine-actions/{3}/status/update";
        this.invalidParameterHandler.validateUserId(userId, "updateEngineActionStatus");
        this.invalidParameterHandler.validateGUID(engineActionGUID, "engineActionGUID", "updateEngineActionStatus");
        this.invalidParameterHandler.validateEnum(engineActionStatus, "engineActionStatus", "updateEngineActionStatus");
        EngineActionStatusRequestBody requestBody = new EngineActionStatusRequestBody();
        requestBody.setStatus(engineActionStatus);
        this.restClient.callVoidPostRESTCall("updateEngineActionStatus", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, engineActionGUID);
    }

    @Override
    public void claimEngineAction(String userId, String engineActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "claimEngineAction";
        String guidParameterName = "engineActionGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-context-service/users/{2}/engine-actions/{3}/claim";
        this.invalidParameterHandler.validateUserId(userId, "claimEngineAction");
        this.invalidParameterHandler.validateGUID(engineActionGUID, "engineActionGUID", "claimEngineAction");
        this.restClient.callVoidPostRESTCall("claimEngineAction", urlTemplate, this.nullRequestBody, this.serverName, this.serviceURLMarker, userId, engineActionGUID);
    }

    @Override
    public List<EngineActionElement> getActiveClaimedEngineActions(String userId, String governanceEngineGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActiveClaimedEngineActions";
        String guidParameterName = "governanceEngineGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-context-service/users/{2}/governance-engines/{3}/active-engine-actions?startFrom={4}&pageSize={5}";
        this.invalidParameterHandler.validateUserId(userId, "getActiveClaimedEngineActions");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "getActiveClaimedEngineActions");
        EngineActionElementsResponse restResult = this.restClient.callEngineActionsGetRESTCall("getActiveClaimedEngineActions", urlTemplate, this.serverName, this.serviceURLMarker, userId, governanceEngineGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    @Override
    public void updateActionTargetStatus(String userId, String actionTargetGUID, EngineActionStatus status, Date startDate, Date completionDate, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateActionTargetStatus";
        String guidParameterName = "actionTargetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-context-service/users/{2}/engine-actions/action-targets/update";
        this.invalidParameterHandler.validateUserId(userId, "updateActionTargetStatus");
        this.invalidParameterHandler.validateGUID(actionTargetGUID, "actionTargetGUID", "updateActionTargetStatus");
        ActionTargetStatusRequestBody requestBody = new ActionTargetStatusRequestBody();
        requestBody.setActionTargetGUID(actionTargetGUID);
        requestBody.setStatus(status);
        requestBody.setStartDate(startDate);
        requestBody.setCompletionDate(completionDate);
        requestBody.setCompletionMessage(completionMessage);
        this.restClient.callVoidPostRESTCall("updateActionTargetStatus", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
    }

    @Override
    public void recordCompletionStatus(String userId, String engineActionGUID, Map<String, String> requestParameters, CompletionStatus status, List<String> outputGuards, List<NewActionTarget> newActionTargets, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "recordCompletionStatus";
        String statusParameterName = "status";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-context-service/users/{2}/engine-actions/{3}/completion-status";
        this.invalidParameterHandler.validateUserId(userId, "recordCompletionStatus");
        this.invalidParameterHandler.validateEnum((Object)status, "status", "recordCompletionStatus");
        CompletionStatusRequestBody requestBody = new CompletionStatusRequestBody();
        requestBody.setRequestParameters(requestParameters);
        requestBody.setStatus(status);
        requestBody.setOutputGuards(outputGuards);
        requestBody.setNewActionTargets(newActionTargets);
        requestBody.setCompletionMessage(completionMessage);
        this.restClient.callVoidPostRESTCall("recordCompletionStatus", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, engineActionGUID);
    }
}

