/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.client;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.governanceaction.client.ActionControlInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.DuplicateManagementInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceActionProcessInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceActionTypeInterface;
import org.odpi.openmetadata.frameworks.governanceaction.properties.EngineActionElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.FirstGovernanceActionProcessStepElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessGraph;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessStepElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessStepProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionTypeElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionTypeProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NextGovernanceActionProcessStepElement;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ProcessStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.NewActionTarget;
import org.odpi.openmetadata.frameworkservices.gaf.client.rest.GAFRESTClient;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.FirstGovernanceActionProcessStepResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessGraphResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessStepResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessStepsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypeResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypesResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateEngineActionRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NextGovernanceActionProcessStepRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NextGovernanceActionProcessStepsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionProcessStepRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.ConsolidatedDuplicatesRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.PeerDuplicatesRequestBody;

public class OpenGovernanceClientBase
implements ActionControlInterface,
GovernanceActionTypeInterface,
GovernanceActionProcessInterface,
DuplicateManagementInterface {
    protected final String serverName;
    protected final String serviceURLMarker;
    protected final String serverPlatformURLRoot;
    private final GAFRESTClient restClient;
    protected final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    protected final NullRequestBody nullRequestBody = new NullRequestBody();

    public OpenGovernanceClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.serviceURLMarker = serviceURLMarker;
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = new GAFRESTClient(serverName, serverPlatformURLRoot);
    }

    public OpenGovernanceClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, String serverUserId, String serverPassword, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor (with security)";
        this.serviceURLMarker = serviceURLMarker;
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor (with security)");
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = new GAFRESTClient(serverName, serverPlatformURLRoot, serverUserId, serverPassword);
    }

    public OpenGovernanceClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, GAFRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor (with REST client)";
        this.serviceURLMarker = serviceURLMarker;
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor (with REST client)");
        this.restClient = restClient;
    }

    @Override
    public String initiateEngineAction(String userId, String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, List<String> receivedGuards, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String processName, String requestSourceName, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "initiateEngineAction";
        String qualifiedNameParameterName = "qualifiedName";
        String engineNameParameterName = "governanceEngineName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-engines/{3}/engine-actions/initiate";
        this.invalidParameterHandler.validateUserId(userId, "initiateEngineAction");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "initiateEngineAction");
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", "initiateEngineAction");
        InitiateEngineActionRequestBody requestBody = new InitiateEngineActionRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDomainIdentifier(domainIdentifier);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setRequestSourceGUIDs(requestSourceGUIDs);
        requestBody.setActionTargets(actionTargets);
        requestBody.setReceivedGuards(receivedGuards);
        requestBody.setStartDate(startTime);
        requestBody.setRequestType(requestType);
        requestBody.setRequestParameters(requestParameters);
        requestBody.setProcessName(processName);
        requestBody.setRequestSourceName(requestSourceName);
        requestBody.setOriginatorServiceName(originatorServiceName);
        requestBody.setOriginatorEngineName(originatorEngineName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("initiateEngineAction", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, governanceEngineName);
        return restResult.getGUID();
    }

    @Override
    public String initiateGovernanceActionType(String userId, String governanceActionTypeQualifiedName, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, Map<String, String> requestParameters, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "initiateGovernanceActionType";
        String qualifiedNameParameterName = "governanceActionTypeQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-types/initiate";
        this.invalidParameterHandler.validateUserId(userId, "initiateGovernanceActionType");
        this.invalidParameterHandler.validateName(governanceActionTypeQualifiedName, "governanceActionTypeQualifiedName", "initiateGovernanceActionType");
        InitiateGovernanceActionTypeRequestBody requestBody = new InitiateGovernanceActionTypeRequestBody();
        requestBody.setGovernanceActionTypeQualifiedName(governanceActionTypeQualifiedName);
        requestBody.setRequestSourceGUIDs(requestSourceGUIDs);
        requestBody.setActionTargets(actionTargets);
        requestBody.setStartDate(startTime);
        requestBody.setRequestParameters(requestParameters);
        requestBody.setOriginatorServiceName(originatorServiceName);
        requestBody.setOriginatorEngineName(originatorEngineName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("initiateGovernanceActionType", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public String initiateGovernanceActionProcess(String userId, String processQualifiedName, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, Map<String, String> requestParameters, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "initiateGovernanceActionProcess";
        String qualifiedNameParameterName = "processQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/initiate";
        this.invalidParameterHandler.validateUserId(userId, "initiateGovernanceActionProcess");
        this.invalidParameterHandler.validateName(processQualifiedName, "processQualifiedName", "initiateGovernanceActionProcess");
        InitiateGovernanceActionProcessRequestBody requestBody = new InitiateGovernanceActionProcessRequestBody();
        requestBody.setProcessQualifiedName(processQualifiedName);
        requestBody.setRequestSourceGUIDs(requestSourceGUIDs);
        requestBody.setActionTargets(actionTargets);
        requestBody.setStartDate(startTime);
        requestBody.setRequestParameters(requestParameters);
        requestBody.setOriginatorServiceName(originatorServiceName);
        requestBody.setOriginatorEngineName(originatorEngineName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("initiateGovernanceActionProcess", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public EngineActionElement getEngineAction(String userId, String engineActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEngineAction";
        String guidParameterName = "engineActionGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/engine-actions/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getEngineAction");
        this.invalidParameterHandler.validateGUID(engineActionGUID, "engineActionGUID", "getEngineAction");
        EngineActionElementResponse restResult = this.restClient.callEngineActionGetRESTCall("getEngineAction", urlTemplate, this.serverName, this.serviceURLMarker, userId, engineActionGUID);
        return restResult.getElement();
    }

    @Override
    public void cancelEngineAction(String userId, String engineActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "cancelEngineAction";
        String guidParameterName = "engineActionGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/engine-actions/{3}/cancel";
        this.invalidParameterHandler.validateUserId(userId, "cancelEngineAction");
        this.invalidParameterHandler.validateGUID(engineActionGUID, "engineActionGUID", "cancelEngineAction");
        this.restClient.callVoidPostRESTCall("cancelEngineAction", urlTemplate, this.nullRequestBody, this.serverName, this.serviceURLMarker, userId, engineActionGUID);
    }

    @Override
    public List<EngineActionElement> getEngineActions(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEngineActions";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/engine-actions?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getEngineActions");
        EngineActionElementsResponse restResult = this.restClient.callEngineActionsGetRESTCall("getEngineActions", urlTemplate, this.serverName, this.serviceURLMarker, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    @Override
    public List<EngineActionElement> getActiveEngineActions(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActiveEngineActions";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/engine-actions/active?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getActiveEngineActions");
        EngineActionElementsResponse restResult = this.restClient.callEngineActionsGetRESTCall("getActiveEngineActions", urlTemplate, this.serverName, this.serviceURLMarker, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    @Override
    public List<EngineActionElement> findEngineActions(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findEngineActions";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/engine-actions/by-search-string?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "findEngineActions");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findEngineActions");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        EngineActionElementsResponse restResult = this.restClient.callEngineActionsPostRESTCall("findEngineActions", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    @Override
    public List<EngineActionElement> getEngineActionsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEngineActionsByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/engine-actions/by-name?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getEngineActionsByName");
        this.invalidParameterHandler.validateName(name, "name", "getEngineActionsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        EngineActionElementsResponse restResult = this.restClient.callEngineActionsPostRESTCall("getEngineActionsByName", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    @Override
    public void linkElementsAsPeerDuplicates(String userId, String metadataElement1GUID, String metadataElement2GUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, boolean setKnownDuplicate) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkElementsAsPeerDuplicates";
        String end1ParameterName = "metadataElement1GUID";
        String end2ParameterName = "metadataElement2GUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/related-elements/link-as-peer-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "linkElementsAsPeerDuplicates");
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", "linkElementsAsPeerDuplicates");
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", "linkElementsAsPeerDuplicates");
        PeerDuplicatesRequestBody requestBody = new PeerDuplicatesRequestBody();
        requestBody.setMetadataElement1GUID(metadataElement1GUID);
        requestBody.setMetadataElement2GUID(metadataElement2GUID);
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        requestBody.setSetKnownDuplicate(setKnownDuplicate);
        this.restClient.callVoidPostRESTCall("linkElementsAsPeerDuplicates", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
    }

    @Override
    public void linkConsolidatedDuplicate(String userId, String consolidatedElementGUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> sourceElementGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkConsolidatedDuplicate";
        String consolidatedElementGUIDParameterName = "consolidatedElementGUID";
        String sourceElementGUIDsParameterName = "sourceElementGUIDs";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/related-elements/link-as-consolidated-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "linkConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(consolidatedElementGUID, "consolidatedElementGUID", "linkConsolidatedDuplicate");
        this.invalidParameterHandler.validateObject(sourceElementGUIDs, "sourceElementGUIDs", "linkConsolidatedDuplicate");
        ConsolidatedDuplicatesRequestBody requestBody = new ConsolidatedDuplicatesRequestBody();
        requestBody.setConsolidatedElementGUID(consolidatedElementGUID);
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        requestBody.setSourceElementGUIDs(sourceElementGUIDs);
        this.restClient.callVoidPostRESTCall("linkConsolidatedDuplicate", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
    }

    @Override
    public String createGovernanceActionType(String userId, GovernanceActionTypeProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceActionType";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.getQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-types";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceActionType");
        this.invalidParameterHandler.validateObject(properties, "properties", "createGovernanceActionType");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.getQualifiedName", "createGovernanceActionType");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceActionType", urlTemplate, properties, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public void updateGovernanceActionType(String userId, String governanceActionTypeGUID, boolean isMergeUpdate, GovernanceActionTypeProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceActionType";
        String guidParameterName = "governanceActionTypeGUID";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.getQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-types/{3}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceActionType");
        this.invalidParameterHandler.validateGUID(governanceActionTypeGUID, "governanceActionTypeGUID", "updateGovernanceActionType");
        this.invalidParameterHandler.validateObject(properties, "properties", "updateGovernanceActionType");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.getQualifiedName", "updateGovernanceActionType");
        }
        UpdateGovernanceActionTypeRequestBody requestBody = new UpdateGovernanceActionTypeRequestBody();
        requestBody.setMergeUpdate(isMergeUpdate);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall("updateGovernanceActionType", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, governanceActionTypeGUID);
    }

    @Override
    public void removeGovernanceActionType(String userId, String governanceActionTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceActionType";
        String guidParameterName = "governanceActionTypeGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-types/{3}/remove";
        this.invalidParameterHandler.validateUserId(userId, "removeGovernanceActionType");
        this.invalidParameterHandler.validateGUID(governanceActionTypeGUID, "governanceActionTypeGUID", "removeGovernanceActionType");
        this.restClient.callVoidPostRESTCall("removeGovernanceActionType", urlTemplate, this.nullRequestBody, this.serverName, this.serviceURLMarker, userId, governanceActionTypeGUID);
    }

    @Override
    public List<GovernanceActionTypeElement> findGovernanceActionTypes(String userId, String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceActionTypes";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-types/by-search-string?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceActionTypes");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceActionTypes");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        GovernanceActionTypesResponse restResult = this.restClient.callGovernanceTypesPostRESTCall("findGovernanceActionTypes", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    @Override
    public List<GovernanceActionTypeElement> getGovernanceActionTypesByName(String userId, String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionTypesByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-types/by-name?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionTypesByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceActionTypesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        requestBody.setEffectiveTime(effectiveTime);
        GovernanceActionTypesResponse restResult = this.restClient.callGovernanceTypesPostRESTCall("getGovernanceActionTypesByName", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    @Override
    public GovernanceActionTypeElement getGovernanceActionTypeByGUID(String userId, String governanceActionTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionTypeByGUID";
        String guidParameterName = "governanceActionTypeGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-types/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionTypeByGUID");
        this.invalidParameterHandler.validateGUID(governanceActionTypeGUID, "governanceActionTypeGUID", "getGovernanceActionTypeByGUID");
        GovernanceActionTypeResponse restResult = this.restClient.callGovernanceActionTypeGetRESTCall("getGovernanceActionTypeByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, governanceActionTypeGUID);
        return restResult.getElement();
    }

    @Override
    public String createGovernanceActionProcess(String userId, GovernanceActionProcessProperties processProperties, ProcessStatus initialStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceActionProcess";
        String propertiesParameterName = "processProperties";
        String qualifiedNameParameterName = "processProperties.getQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceActionProcess");
        this.invalidParameterHandler.validateObject(processProperties, "processProperties", "createGovernanceActionProcess");
        this.invalidParameterHandler.validateName(processProperties.getQualifiedName(), "processProperties.getQualifiedName", "createGovernanceActionProcess");
        NewGovernanceActionProcessRequestBody requestBody = new NewGovernanceActionProcessRequestBody();
        requestBody.setProcessStatus(initialStatus);
        requestBody.setProperties(processProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceActionProcess", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public void updateGovernanceActionProcess(String userId, String processGUID, boolean isMergeUpdate, ProcessStatus processStatus, GovernanceActionProcessProperties processProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceActionProcess";
        String guidParameterName = "processGUID";
        String propertiesParameterName = "processProperties";
        String qualifiedNameParameterName = "processProperties.getQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/{3}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceActionProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "updateGovernanceActionProcess");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateObject(processProperties, "processProperties", "updateGovernanceActionProcess");
            this.invalidParameterHandler.validateName(processProperties.getQualifiedName(), "processProperties.getQualifiedName", "updateGovernanceActionProcess");
        }
        UpdateGovernanceActionProcessRequestBody requestBody = new UpdateGovernanceActionProcessRequestBody();
        requestBody.setMergeUpdate(isMergeUpdate);
        requestBody.setProcessStatus(processStatus);
        requestBody.setProperties(processProperties);
        this.restClient.callVoidPostRESTCall("updateGovernanceActionProcess", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, processGUID);
    }

    @Override
    public void publishGovernanceActionProcess(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishGovernanceActionProcess";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/{3}/publish";
        this.invalidParameterHandler.validateUserId(userId, "publishGovernanceActionProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "publishGovernanceActionProcess");
        this.restClient.callVoidPostRESTCall("publishGovernanceActionProcess", urlTemplate, this.nullRequestBody, this.serverName, this.serviceURLMarker, userId, processGUID);
    }

    @Override
    public void withdrawGovernanceActionProcess(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawGovernanceActionProcess";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/{3}/withdraw";
        this.invalidParameterHandler.validateUserId(userId, "withdrawGovernanceActionProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "withdrawGovernanceActionProcess");
        this.restClient.callVoidPostRESTCall("withdrawGovernanceActionProcess", urlTemplate, this.nullRequestBody, this.serverName, this.serviceURLMarker, userId, processGUID);
    }

    @Override
    public void removeGovernanceActionProcess(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceActionProcess";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/{3}/remove";
        this.invalidParameterHandler.validateUserId(userId, "removeGovernanceActionProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "removeGovernanceActionProcess");
        this.restClient.callVoidPostRESTCall("removeGovernanceActionProcess", urlTemplate, this.nullRequestBody, this.serverName, this.serviceURLMarker, userId, processGUID);
    }

    @Override
    public List<GovernanceActionProcessElement> findGovernanceActionProcesses(String userId, String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceActionProcesses";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/by-search-string?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceActionProcesses");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceActionProcesses");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GovernanceActionProcessElementsResponse restResult = this.restClient.callGovernanceActionProcessElementsPostRESTCall("findGovernanceActionProcesses", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    @Override
    public List<GovernanceActionProcessElement> getGovernanceActionProcessesByName(String userId, String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionProcessesByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/by-name?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionProcessesByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceActionProcessesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        requestBody.setEffectiveTime(effectiveTime);
        GovernanceActionProcessElementsResponse restResult = this.restClient.callGovernanceActionProcessElementsPostRESTCall("getGovernanceActionProcessesByName", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    @Override
    public GovernanceActionProcessElement getGovernanceActionProcessByGUID(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionProcessByGUID";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionProcessByGUID");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getGovernanceActionProcessByGUID");
        GovernanceActionProcessElementResponse restResult = this.restClient.callGovernanceActionProcessGetRESTCall("getGovernanceActionProcessByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, processGUID);
        return restResult.getElement();
    }

    @Override
    public GovernanceActionProcessGraph getGovernanceActionProcessGraph(String userId, String processGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionProcessGraph";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/{3}/graph";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionProcessGraph");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getGovernanceActionProcessGraph");
        ResultsRequestBody requestBody = new ResultsRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        GovernanceActionProcessGraphResponse restResult = this.restClient.callGovernanceActionProcessGraphPostRESTCall("getGovernanceActionProcessGraph", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, processGUID);
        return restResult.getElement();
    }

    @Override
    public String createGovernanceActionProcessStep(String userId, GovernanceActionProcessStepProperties processStepProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceActionProcessStep";
        String propertiesParameterName = "processStepProperties";
        String qualifiedNameParameterName = "processStepProperties.getQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-process-steps";
        this.invalidParameterHandler.validateUserId(userId, "createGovernanceActionProcessStep");
        this.invalidParameterHandler.validateObject(processStepProperties, "processStepProperties", "createGovernanceActionProcessStep");
        this.invalidParameterHandler.validateName(processStepProperties.getQualifiedName(), "processStepProperties.getQualifiedName", "createGovernanceActionProcessStep");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createGovernanceActionProcessStep", urlTemplate, processStepProperties, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public void updateGovernanceActionProcessStep(String userId, String processStepGUID, boolean isMergeUpdate, GovernanceActionProcessStepProperties processStepProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceActionProcess";
        String guidParameterName = "processStepGUID";
        String propertiesParameterName = "processStepProperties";
        String qualifiedNameParameterName = "processStepProperties.getQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-process-steps/{3}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceActionProcess");
        this.invalidParameterHandler.validateGUID(processStepGUID, "processStepGUID", "updateGovernanceActionProcess");
        this.invalidParameterHandler.validateObject(processStepProperties, "processStepProperties", "updateGovernanceActionProcess");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(processStepProperties.getQualifiedName(), "processStepProperties.getQualifiedName", "updateGovernanceActionProcess");
        }
        UpdateGovernanceActionProcessStepRequestBody requestBody = new UpdateGovernanceActionProcessStepRequestBody();
        requestBody.setMergeUpdate(isMergeUpdate);
        requestBody.setProperties(processStepProperties);
        this.restClient.callVoidPostRESTCall("updateGovernanceActionProcess", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, processStepGUID);
    }

    @Override
    public void removeGovernanceActionProcessStep(String userId, String processStepGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceActionProcessStep";
        String guidParameterName = "processStepGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-process-steps/{3}/remove";
        this.invalidParameterHandler.validateUserId(userId, "removeGovernanceActionProcessStep");
        this.invalidParameterHandler.validateGUID(processStepGUID, "processStepGUID", "removeGovernanceActionProcessStep");
        this.restClient.callVoidPostRESTCall("removeGovernanceActionProcessStep", urlTemplate, this.nullRequestBody, this.serverName, this.serviceURLMarker, userId, processStepGUID);
    }

    @Override
    public List<GovernanceActionProcessStepElement> findGovernanceActionProcessSteps(String userId, String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findGovernanceActionProcessSteps";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-process-steps/by-search-string?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "findGovernanceActionProcessSteps");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findGovernanceActionProcessSteps");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        GovernanceActionProcessStepsResponse restResult = this.restClient.callGovernanceProcessStepsPostRESTCall("findGovernanceActionProcessSteps", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    @Override
    public List<GovernanceActionProcessStepElement> getGovernanceActionProcessStepsByName(String userId, String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionProcessStepsByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-process-steps/by-name?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionProcessStepsByName");
        this.invalidParameterHandler.validateName(name, "name", "getGovernanceActionProcessStepsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        requestBody.setEffectiveTime(effectiveTime);
        GovernanceActionProcessStepsResponse restResult = this.restClient.callGovernanceProcessStepsPostRESTCall("getGovernanceActionProcessStepsByName", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    @Override
    public GovernanceActionProcessStepElement getGovernanceActionProcessStepByGUID(String userId, String processStepGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceActionProcessStepByGUID";
        String guidParameterName = "processStepGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-process-steps/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceActionProcessStepByGUID");
        this.invalidParameterHandler.validateGUID(processStepGUID, "processStepGUID", "getGovernanceActionProcessStepByGUID");
        GovernanceActionProcessStepResponse restResult = this.restClient.callGovernanceActionProcessStepGetRESTCall("getGovernanceActionProcessStepByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, processStepGUID);
        return restResult.getElement();
    }

    @Override
    public void setupFirstActionProcessStep(String userId, String processGUID, String processStepGUID, String guard) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupFirstActionProcessStep";
        String processGUIDParameterName = "processGUID";
        String processStepGUIDParameterName = "processStepGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/{3}/first-action-process-step/{4}";
        this.invalidParameterHandler.validateUserId(userId, "setupFirstActionProcessStep");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "setupFirstActionProcessStep");
        this.invalidParameterHandler.validateGUID(processStepGUID, "processStepGUID", "setupFirstActionProcessStep");
        this.restClient.callVoidPostRESTCall("setupFirstActionProcessStep", urlTemplate, guard, this.serverName, this.serviceURLMarker, userId, processGUID, processStepGUID);
    }

    @Override
    public FirstGovernanceActionProcessStepElement getFirstActionProcessStep(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFirstActionProcessStep";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/{3}/first-action-process-step";
        this.invalidParameterHandler.validateUserId(userId, "getFirstActionProcessStep");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "getFirstActionProcessStep");
        FirstGovernanceActionProcessStepResponse restResult = this.restClient.callFirstGovernanceActionProcessStepGetRESTCall("getFirstActionProcessStep", urlTemplate, this.serverName, this.serviceURLMarker, userId, processGUID);
        return restResult.getElement();
    }

    @Override
    public void removeFirstActionProcessStep(String userId, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeFirstActionProcessStep";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/{3}/first-action-process-step/remove";
        this.invalidParameterHandler.validateUserId(userId, "removeFirstActionProcessStep");
        this.invalidParameterHandler.validateGUID(processGUID, "processGUID", "removeFirstActionProcessStep");
        this.restClient.callVoidPostRESTCall("removeFirstActionProcessStep", urlTemplate, this.nullRequestBody, this.serverName, this.serviceURLMarker, userId, processGUID);
    }

    @Override
    public String setupNextActionProcessStep(String userId, String currentActionProcessStepGUID, String nextActionProcessStepGUID, String guard, boolean mandatoryGuard) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupNextActionProcessStep";
        String currentGUIDParameterName = "currentActionProcessStepGUID";
        String nextGUIDParameterName = "nextActionProcessStepGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-process-steps/{3}/next-process-steps/{4}";
        this.invalidParameterHandler.validateUserId(userId, "setupNextActionProcessStep");
        this.invalidParameterHandler.validateGUID(currentActionProcessStepGUID, "currentActionProcessStepGUID", "setupNextActionProcessStep");
        this.invalidParameterHandler.validateGUID(nextActionProcessStepGUID, "nextActionProcessStepGUID", "setupNextActionProcessStep");
        NextGovernanceActionProcessStepRequestBody requestBody = new NextGovernanceActionProcessStepRequestBody();
        requestBody.setGuard(guard);
        requestBody.setMandatoryGuard(mandatoryGuard);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("setupNextActionProcessStep", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, currentActionProcessStepGUID, nextActionProcessStepGUID);
        return restResult.getGUID();
    }

    @Override
    public void updateNextActionProcessStep(String userId, String nextProcessStepLinkGUID, String guard, boolean mandatoryGuard) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateNextActionProcessStep";
        String guidParameterName = "nextActionLinkGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-process-steps/next-process-steps/{3}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateNextActionProcessStep");
        this.invalidParameterHandler.validateGUID(nextProcessStepLinkGUID, "nextActionLinkGUID", "updateNextActionProcessStep");
        NextGovernanceActionProcessStepRequestBody requestBody = new NextGovernanceActionProcessStepRequestBody();
        requestBody.setGuard(guard);
        requestBody.setMandatoryGuard(mandatoryGuard);
        this.restClient.callVoidPostRESTCall("updateNextActionProcessStep", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, nextProcessStepLinkGUID);
    }

    @Override
    public List<NextGovernanceActionProcessStepElement> getNextGovernanceActionProcessSteps(String userId, String processStepGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNextGovernanceActionProcessSteps";
        String guidParameterName = "processStepGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-process-steps/{3}/next-process-step?startFrom={4}&pageSize={5}";
        this.invalidParameterHandler.validateUserId(userId, "getNextGovernanceActionProcessSteps");
        this.invalidParameterHandler.validateGUID(processStepGUID, "processStepGUID", "getNextGovernanceActionProcessSteps");
        NextGovernanceActionProcessStepsResponse restResult = this.restClient.callNextGovernanceActionProcessStepsGetRESTCall("getNextGovernanceActionProcessSteps", urlTemplate, this.serverName, this.serviceURLMarker, userId, processStepGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElements();
    }

    @Override
    public void removeNextActionProcessStep(String userId, String processStepLinkGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeFirstActionProcessStep";
        String guidParameterName = "processGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-process-steps/next-process-step/{3}/remove";
        this.invalidParameterHandler.validateUserId(userId, "removeFirstActionProcessStep");
        this.invalidParameterHandler.validateGUID(processStepLinkGUID, "processGUID", "removeFirstActionProcessStep");
        this.restClient.callVoidPostRESTCall("removeFirstActionProcessStep", urlTemplate, this.nullRequestBody, this.serverName, this.serviceURLMarker, userId, processStepLinkGUID);
    }
}

