/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.frameworks.connectors.properties.ExternalReferences;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ExternalReference;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.ExternalReferencesResponse;

public class ConnectedExternalReferences
extends ExternalReferences {
    private String serviceName;
    private String serverName;
    private String userId;
    private String platformURLRoot;
    private String assetGUID;
    private OCFRESTClient restClient;
    private static final long serialVersionUID = 1L;

    ConnectedExternalReferences(String serviceName, String serverName, String userId, String platformURLRoot, String assetGUID, int maxCacheSize, OCFRESTClient restClient) {
        super(maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.platformURLRoot = platformURLRoot;
        this.assetGUID = assetGUID;
        this.restClient = restClient;
    }

    private ConnectedExternalReferences(ConnectedExternalReferences template) {
        super(template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.platformURLRoot = template.platformURLRoot;
            this.assetGUID = template.assetGUID;
            this.restClient = template.restClient;
        }
    }

    @Override
    protected ExternalReferences cloneIterator() {
        return new ConnectedExternalReferences(this);
    }

    @Override
    protected List<ElementBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "ExternalReferences.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/external-references?elementStart={4}&maxElements={5}";
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            ExternalReferencesResponse restResult = this.restClient.callOCFExternalReferencesGetRESTCall("ExternalReferences.getCachedList", this.platformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/external-references?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.assetGUID, cacheStartPointer, maximumSize);
            restExceptionHandler.detectAndThrowInvalidParameterException(restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException(restResult);
            restExceptionHandler.detectAndThrowPropertyServerException(restResult);
            List<ExternalReference> beans = restResult.getList();
            if (beans == null || beans.isEmpty()) {
                return null;
            }
            ArrayList<ElementBase> resultList = new ArrayList<ElementBase>();
            for (ExternalReference bean : beans) {
                if (bean == null) continue;
                resultList.add(bean);
            }
            return resultList;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException(error, "ExternalReferences.getCachedList", this.serverName, this.platformURLRoot);
            return null;
        }
    }
}

