/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.omf.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementHeadersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.openmetadata.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ToDoStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.AnchorSearchMatches;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ArchiveProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.IncidentDependency;
import org.odpi.openmetadata.frameworks.openmetadata.properties.IncidentImpactedElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataAttributeTypeDef;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataAttributeTypeDefCategory;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElementGraph;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataRelationshipList;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataTypeDef;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataTypeDefCategory;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataTypeDefGallery;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.TranslationDetail;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ValidMetadataValue;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ValidMetadataValueDetail;
import org.odpi.openmetadata.frameworks.openmetadata.properties.contextevents.ContextEventImpactProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.contextevents.ContextEventProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.contextevents.DependentContextEventProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.contextevents.RelatedContextEventProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ClassificationCondition;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.openmetadata.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.openmetadata.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.openmetadata.search.SearchProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworkservices.omf.client.rest.OMFRESTClient;
import org.odpi.openmetadata.frameworkservices.omf.ffdc.OpenMetadataStoreErrorCode;
import org.odpi.openmetadata.frameworkservices.omf.rest.AnchorSearchMatchesListResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.AnchorSearchMatchesResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.AnyTimeRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.ArchiveRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.AttributeTypeDefListResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.AttributeTypeDefResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.FindRelationshipRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.FindRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.HistoryRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.IncidentReportRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.MetadataCorrelationHeadersResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.NewOpenMetadataElementRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataGraphResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataRelationshipListResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.OpenMetadataRelationshipResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.TemplateRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.TranslationDetailResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.TranslationListResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.TypeDefGalleryResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.TypeDefListResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.TypeDefResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.UpdateMetadataCorrelatorsRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.ValidMetadataValueDetailListResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.ValidMetadataValueListResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.ValidMetadataValueResponse;

public abstract class OpenMetadataClientBase
extends OpenMetadataClient {
    private final OMFRESTClient restClient;
    protected final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final PropertyHelper propertyHelper = new PropertyHelper();

    public OpenMetadataClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.restClient = new OMFRESTClient(serverName, serverPlatformURLRoot);
    }

    public OpenMetadataClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, String serverUserId, String serverPassword, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.restClient = new OMFRESTClient(serverName, serverPlatformURLRoot, serverUserId, serverPassword);
    }

    public OpenMetadataClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, OMFRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Client Constructor (with REST client)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor (with REST client)");
        this.restClient = restClient;
    }

    public void setMaxPageSize(int maxPageSize) {
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
    }

    @Override
    public int getMaxPagingSize() {
        return this.invalidParameterHandler.getMaxPagingSize();
    }

    @Override
    public OpenMetadataTypeDefGallery getAllTypes(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAllTypes";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types";
        this.invalidParameterHandler.validateUserId(userId, "getAllTypes");
        TypeDefGalleryResponse restResult = this.restClient.callTypeDefGalleryGetRESTCall("getAllTypes", urlTemplate, this.serverName, this.serviceURLMarker, userId);
        if (restResult != null) {
            OpenMetadataTypeDefGallery gallery = new OpenMetadataTypeDefGallery();
            gallery.setTypeDefs(restResult.getTypeDefs());
            gallery.setAttributeTypeDefs(restResult.getAttributeTypeDefs());
            return gallery;
        }
        return null;
    }

    @Override
    public List<OpenMetadataTypeDef> findTypeDefsByCategory(String userId, OpenMetadataTypeDefCategory category) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByCategory";
        String categoryParameterName = "category";
        String entityURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types/entity-defs";
        String relationshipURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types/relationship-defs";
        String classificationURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types/classification-defs";
        this.invalidParameterHandler.validateUserId(userId, "findTypeDefsByCategory");
        this.invalidParameterHandler.validateEnum((Object)category, "category", "findTypeDefsByCategory");
        String urlTemplate = entityURLTemplate;
        if (category == OpenMetadataTypeDefCategory.CLASSIFICATION_DEF) {
            urlTemplate = classificationURLTemplate;
        } else if (category == OpenMetadataTypeDefCategory.RELATIONSHIP_DEF) {
            urlTemplate = relationshipURLTemplate;
        }
        TypeDefListResponse restResult = this.restClient.callTypeDefListGetRESTCall("findTypeDefsByCategory", urlTemplate, this.serverName, this.serviceURLMarker, userId);
        return restResult.getTypeDefs();
    }

    @Override
    public List<OpenMetadataAttributeTypeDef> findAttributeTypeDefsByCategory(String userId, OpenMetadataAttributeTypeDefCategory category) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findAttributeTypeDefsByCategory";
        String categoryParameterName = "category";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-attribute-types/category/{3}";
        this.invalidParameterHandler.validateUserId(userId, "findAttributeTypeDefsByCategory");
        this.invalidParameterHandler.validateEnum((Object)category, "category", "findAttributeTypeDefsByCategory");
        AttributeTypeDefListResponse restResult = this.restClient.callAttributeTypeDefListGetRESTCall("findAttributeTypeDefsByCategory", urlTemplate, new Object[]{this.serverName, this.serviceURLMarker, userId, category});
        return restResult.getAttributeTypeDefs();
    }

    @Override
    public List<OpenMetadataTypeDef> findTypesByExternalId(String userId, String standard, String organization, String identifier) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findTypesByExternalId";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types/external-id?standard={3}&organization={4}&identifier={5}";
        this.invalidParameterHandler.validateUserId(userId, "findTypesByExternalId");
        TypeDefListResponse restResult = this.restClient.callTypeDefListGetRESTCall("findTypesByExternalId", urlTemplate, this.serverName, this.serviceURLMarker, userId, standard, organization, identifier);
        return restResult.getTypeDefs();
    }

    @Override
    public List<OpenMetadataTypeDef> getSubTypes(String userId, String typeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getSubTypes";
        String parameterName = "typeName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types/sub-types?typeName={3}";
        this.invalidParameterHandler.validateUserId(userId, "getSubTypes");
        this.invalidParameterHandler.validateName(typeName, "typeName", "getSubTypes");
        TypeDefListResponse restResult = this.restClient.callTypeDefListGetRESTCall("getSubTypes", urlTemplate, this.serverName, this.serviceURLMarker, userId, typeName);
        return restResult.getTypeDefs();
    }

    @Override
    public OpenMetadataTypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTypeDefByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types/guid/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getTypeDefByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getTypeDefByGUID");
        TypeDefResponse restResult = this.restClient.callTypeDefGetRESTCall("getTypeDefByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, guid);
        return restResult.getTypeDef();
    }

    @Override
    public OpenMetadataAttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByGUID";
        String guidParameterName = "guid";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-attribute-types/guid/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getAttributeTypeDefByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getAttributeTypeDefByGUID");
        AttributeTypeDefResponse restResult = this.restClient.callAttributeTypeDefGetRESTCall("getAttributeTypeDefByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, guid);
        return restResult.getAttributeTypeDef();
    }

    @Override
    public OpenMetadataTypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTypeDefByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-types/name/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getTypeDefByName");
        this.invalidParameterHandler.validateName(name, "name", "getTypeDefByName");
        TypeDefResponse restResult = this.restClient.callTypeDefGetRESTCall("getTypeDefByName", urlTemplate, this.serverName, this.serviceURLMarker, userId, name);
        return restResult.getTypeDef();
    }

    @Override
    public OpenMetadataAttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByName";
        String nameParameterName = "name";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/open-metadata-attribute-types/name/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getAttributeTypeDefByName");
        this.invalidParameterHandler.validateName(name, "name", "getAttributeTypeDefByName");
        AttributeTypeDefResponse restResult = this.restClient.callAttributeTypeDefGetRESTCall("getAttributeTypeDefByName", urlTemplate, this.serverName, this.serviceURLMarker, userId, name);
        return restResult.getAttributeTypeDef();
    }

    @Override
    public OpenMetadataElement getMetadataElementByGUID(String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date asOfTime, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementByGUID";
        String guidParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementByGUID");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getMetadataElementByGUID");
        AnyTimeRequestBody requestBody = new AnyTimeRequestBody();
        requestBody.setAsOfTime(asOfTime);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        OpenMetadataElementResponse restResult = this.restClient.callOpenMetadataElementPostRESTCall("getMetadataElementByGUID", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, elementGUID);
        return restResult.getElement();
    }

    @Override
    public OpenMetadataElement getMetadataElementByUniqueName(String userId, String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date asOfTime, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementByUniqueName";
        String defaultPropertyName = OpenMetadataProperty.QUALIFIED_NAME.name;
        String nameParameterName = "uniqueName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-unique-name?forLineage={3}&forDuplicateProcessing={4}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getMetadataElementByUniqueName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(uniqueName);
        requestBody.setAsOfTime(asOfTime);
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setNameParameterName("uniqueName");
        if (uniquePropertyName != null) {
            requestBody.setNamePropertyName(uniquePropertyName);
        } else {
            requestBody.setNamePropertyName(defaultPropertyName);
        }
        OpenMetadataElementResponse restResult = this.restClient.callOpenMetadataElementPostRESTCall("getMetadataElementByUniqueName", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing);
        return restResult.getElement();
    }

    @Override
    public OpenMetadataElement getDeletedElementByUniqueName(String userId, String uniqueName, String uniquePropertyName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDeletedElementByUniqueName";
        String defaultPropertyName = OpenMetadataProperty.QUALIFIED_NAME.name;
        String nameParameterName = "uniqueName";
        this.invalidParameterHandler.validateUserId(userId, "getDeletedElementByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getDeletedElementByUniqueName");
        ArrayList<String> propertyNames = new ArrayList<String>();
        if (uniquePropertyName != null) {
            propertyNames.add(uniquePropertyName);
        } else {
            propertyNames.add(defaultPropertyName);
        }
        ArrayList<ElementStatus> requiredStatuses = new ArrayList<ElementStatus>();
        requiredStatuses.add(ElementStatus.DELETED);
        List<OpenMetadataElement> matchingElements = this.findMetadataElements(userId, OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, this.propertyHelper.getSearchPropertiesByName(propertyNames, uniqueName, PropertyComparisonOperator.EQ), requiredStatuses, null, null, null, SequencingOrder.LAST_UPDATE_RECENT, true, true, null, 0, 10);
        if (matchingElements != null) {
            for (OpenMetadataElement matchingElement : matchingElements) {
                if (matchingElement == null) continue;
                return matchingElement;
            }
        }
        return null;
    }

    @Override
    public String getMetadataElementGUIDByUniqueName(String userId, String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date asOfTime, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementGUIDByUniqueName";
        String defaultPropertyName = "qualifiedName";
        String nameParameterName = "uniqueName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/guid-by-unique-name?forLineage={3}&forDuplicateProcessing={4}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementGUIDByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getMetadataElementGUIDByUniqueName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(uniqueName);
        requestBody.setNameParameterName("uniqueName");
        requestBody.setAsOfTime(asOfTime);
        requestBody.setEffectiveTime(effectiveTime);
        if (uniquePropertyName != null) {
            requestBody.setNamePropertyName(uniquePropertyName);
        } else {
            requestBody.setNamePropertyName("qualifiedName");
        }
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("getMetadataElementGUIDByUniqueName", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing);
        return restResult.getGUID();
    }

    @Override
    public List<OpenMetadataElement> findMetadataElementsWithString(String userId, String searchString, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findMetadataElementsWithString(userId, searchString, null, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    @Override
    public List<OpenMetadataElement> findMetadataElementsWithString(String userId, String searchString, String typeName, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findMetadataElementsWithString";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-string?&startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "findMetadataElementsWithString");
        if (typeName == null) {
            this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findMetadataElementsWithString");
        }
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setAsOfTime(asOfTime);
        requestBody.setSequencingOrder(sequencingOrder);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setTypeName(typeName);
        OpenMetadataElementsResponse restResult = this.restClient.callOpenMetadataElementsPostRESTCall("findMetadataElementsWithString", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, startFrom, pageSize);
        return restResult.getElementList();
    }

    @Override
    public AnchorSearchMatches findElementsForAnchor(String userId, String searchString, String anchorGUID, String typeName, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findElementsForAnchor";
        String contextParameterName = "anchorGUID";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-string/for-anchor/{3}?&startFrom={4}&pageSize={5}";
        this.invalidParameterHandler.validateUserId(userId, "findElementsForAnchor");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findElementsForAnchor");
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", "findElementsForAnchor");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setAsOfTime(asOfTime);
        requestBody.setSequencingOrder(sequencingOrder);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setTypeName(typeName);
        AnchorSearchMatchesResponse restResult = this.restClient.callAnchorSearchMatchesPostRESTCall("findElementsForAnchor", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, anchorGUID, startFrom, pageSize);
        return restResult.getElement();
    }

    @Override
    public List<AnchorSearchMatches> findElementsInAnchorDomain(String userId, String searchString, String anchorDomainName, String typeName, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findElementsInAnchorDomain";
        String contextParameterName = "anchorDomainName";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-string/in-anchor-domain/{3}?&startFrom={4}&pageSize={5}";
        this.invalidParameterHandler.validateUserId(userId, "findElementsInAnchorDomain");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findElementsInAnchorDomain");
        this.invalidParameterHandler.validateName(anchorDomainName, "anchorDomainName", "findElementsInAnchorDomain");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setAsOfTime(asOfTime);
        requestBody.setSequencingOrder(sequencingOrder);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setTypeName(typeName);
        AnchorSearchMatchesListResponse restResult = this.restClient.callAnchorSearchMatchesListPostRESTCall("findElementsInAnchorDomain", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, anchorDomainName, startFrom, pageSize);
        return restResult.getElements();
    }

    @Override
    public List<AnchorSearchMatches> findElementsInAnchorScope(String userId, String searchString, String anchorScopeGUID, String typeName, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findElementsInAnchorScope";
        String contextParameterName = "anchorScopeGUID";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-string/in-anchor-scope/{3}?&startFrom={4}&pageSize={5}";
        this.invalidParameterHandler.validateUserId(userId, "findElementsInAnchorScope");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findElementsInAnchorScope");
        this.invalidParameterHandler.validateGUID(anchorScopeGUID, "anchorScopeGUID", "findElementsInAnchorScope");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setAsOfTime(asOfTime);
        requestBody.setSequencingOrder(sequencingOrder);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setTypeName(typeName);
        AnchorSearchMatchesListResponse restResult = this.restClient.callAnchorSearchMatchesListPostRESTCall("findElementsInAnchorScope", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, anchorScopeGUID, startFrom, pageSize);
        return restResult.getElements();
    }

    @Override
    public RelatedMetadataElementList getRelatedMetadataElements(String userId, String elementGUID, int startingAtEnd, String relationshipTypeName, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedMetadataElements";
        String guidParameterName = "elementGUID";
        String allURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/any-type?startingAtEnd={4}&forLineage={5}&forDuplicateProcessing={6}&startFrom={7}&pageSize={8}";
        String specificURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/type/{4}?startingAtEnd={5}&forLineage={6}&forDuplicateProcessing={7}&startFrom={8}&pageSize={9}";
        this.invalidParameterHandler.validateUserId(userId, "getRelatedMetadataElements");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getRelatedMetadataElements");
        ResultsRequestBody requestBody = new ResultsRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setAsOfTime(asOfTime);
        requestBody.setSequencingOrder(sequencingOrder);
        requestBody.setSequencingProperty(sequencingProperty);
        RelatedMetadataElementListResponse restResult = relationshipTypeName == null ? this.restClient.callRelatedMetadataElementListPostRESTCall("getRelatedMetadataElements", allURLTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, elementGUID, startingAtEnd, forLineage, forDuplicateProcessing, startFrom, pageSize) : this.restClient.callRelatedMetadataElementListPostRESTCall("getRelatedMetadataElements", specificURLTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, elementGUID, relationshipTypeName, startingAtEnd, forLineage, forDuplicateProcessing, startFrom, pageSize);
        return restResult.getRelatedElementList();
    }

    @Override
    public OpenMetadataElementGraph getAnchoredElementsGraph(String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, Date asOfTime, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAnchoredElementsGraph";
        String guidParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/with-anchored-elements?startFrom={4}&pageSize={5}";
        this.invalidParameterHandler.validateUserId(userId, "getAnchoredElementsGraph");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getAnchoredElementsGraph");
        AnyTimeRequestBody requestBody = new AnyTimeRequestBody();
        requestBody.setAsOfTime(asOfTime);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        OpenMetadataGraphResponse restResult = this.restClient.callOpenMetadataGraphPostRESTCall("getAnchoredElementsGraph", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, elementGUID, startFrom, pageSize);
        return restResult.getElementGraph();
    }

    @Override
    public RelatedMetadataElement getRelatedMetadataElement(String userId, String elementGUID, int startingAtEnd, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedMetadataElement";
        RelatedMetadataElementList relationships = this.getRelatedMetadataElements(userId, elementGUID, startingAtEnd, relationshipTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, 0, 0);
        if (relationships != null && relationships.getElementList() != null && !relationships.getElementList().isEmpty()) {
            if (relationships.getElementList().size() == 1) {
                return relationships.getElementList().get(0);
            }
            RelatedMetadataElement result = null;
            for (RelatedMetadataElement relatedMetadataElement : relationships.getElementList()) {
                if (relatedMetadataElement == null) continue;
                if (result == null) {
                    result = relatedMetadataElement;
                    continue;
                }
                throw new PropertyServerException(OpenMetadataStoreErrorCode.MULTIPLE_RELATIONSHIPS_FOUND.getMessageDefinition(relationshipTypeName, elementGUID), this.getClass().getName(), "getRelatedMetadataElement");
            }
            return result;
        }
        return null;
    }

    @Override
    public List<OpenMetadataElement> getMetadataElementHistory(String userId, String elementGUID, Date fromTime, Date toTime, boolean oldestFirst, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementHistory";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/history?forLineage={4}&forDuplicateProcessing={5}&oldestFirst={6}&startFrom={7}&pageSize={8}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementHistory");
        HistoryRequestBody requestBody = new HistoryRequestBody();
        requestBody.setFromTime(fromTime);
        requestBody.setToTime(toTime);
        requestBody.setEffectiveTime(effectiveTime);
        OpenMetadataElementsResponse restResult = this.restClient.callOpenMetadataElementsPostRESTCall("getMetadataElementHistory", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, elementGUID, forLineage, forDuplicateProcessing, oldestFirst, startFrom, pageSize);
        return restResult.getElementList();
    }

    @Override
    public OpenMetadataRelationshipList getMetadataElementRelationships(String userId, String metadataElementAtEnd1GUID, String metadataElementAtEnd2GUID, String relationshipTypeName, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedMetadataElements";
        String guid1ParameterName = "metadataElementAtEnd1GUID";
        String allURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/linked-by-any-type/to-elements/{4}?&forLineage={5}&forDuplicateProcessing={6}&startFrom={7}&pageSize={8}";
        String specificURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/linked-by-type/{4}/to-elements/{5}?forLineage={6}&forDuplicateProcessing={7}&startFrom={8}&pageSize={9}";
        this.invalidParameterHandler.validateUserId(userId, "getRelatedMetadataElements");
        this.invalidParameterHandler.validateGUID(metadataElementAtEnd1GUID, "metadataElementAtEnd1GUID", "getRelatedMetadataElements");
        ResultsRequestBody requestBody = new ResultsRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setAsOfTime(asOfTime);
        requestBody.setSequencingOrder(sequencingOrder);
        requestBody.setSequencingProperty(sequencingProperty);
        OpenMetadataRelationshipListResponse restResult = relationshipTypeName == null ? this.restClient.callOpenMetadataRelationshipListPostRESTCall("getRelatedMetadataElements", allURLTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementAtEnd1GUID, metadataElementAtEnd2GUID, forLineage, forDuplicateProcessing, startFrom, pageSize) : this.restClient.callOpenMetadataRelationshipListPostRESTCall("getRelatedMetadataElements", specificURLTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementAtEnd1GUID, relationshipTypeName, metadataElementAtEnd2GUID, forLineage, forDuplicateProcessing, startFrom, pageSize);
        return restResult.getRelationshipList();
    }

    public List<OpenMetadataElement> getMetadataElementsByClassificationPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String classificationName, String classificationPropertyName, String classificationPropertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PrimitiveTypePropertyValue requestedPropertyValue = new PrimitiveTypePropertyValue();
        requestedPropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        requestedPropertyValue.setPrimitiveValue(classificationPropertyValue);
        requestedPropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PropertyCondition nameCondition = new PropertyCondition();
        nameCondition.setProperty(classificationPropertyName);
        nameCondition.setOperator(PropertyComparisonOperator.EQ);
        nameCondition.setValue(requestedPropertyValue);
        conditions.add(nameCondition);
        SearchProperties searchClassificationProperties = new SearchProperties();
        searchClassificationProperties.setConditions(conditions);
        searchClassificationProperties.setMatchCriteria(MatchCriteria.ANY);
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        classificationCondition.setName(classificationName);
        classificationCondition.setSearchProperties(searchClassificationProperties);
        classificationConditions.add(classificationCondition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, null, limitResultsByStatus, asOfTime, searchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> getMetadataElementsByClassificationPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String classificationName, String classificationPropertyName, int classificationPropertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PrimitiveTypePropertyValue requestedPropertyValue = new PrimitiveTypePropertyValue();
        requestedPropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT);
        requestedPropertyValue.setPrimitiveValue(classificationPropertyValue);
        requestedPropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT.getName());
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PropertyCondition nameCondition = new PropertyCondition();
        nameCondition.setProperty(classificationPropertyName);
        nameCondition.setOperator(PropertyComparisonOperator.EQ);
        nameCondition.setValue(requestedPropertyValue);
        conditions.add(nameCondition);
        SearchProperties searchClassificationProperties = new SearchProperties();
        searchClassificationProperties.setConditions(conditions);
        searchClassificationProperties.setMatchCriteria(MatchCriteria.ANY);
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        classificationCondition.setName(classificationName);
        classificationCondition.setSearchProperties(searchClassificationProperties);
        classificationConditions.add(classificationCondition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, null, limitResultsByStatus, asOfTime, searchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElementsByClassificationPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String classificationName, String classificationPropertyName, String classificationPropertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PrimitiveTypePropertyValue requestedPropertyValue = new PrimitiveTypePropertyValue();
        requestedPropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        requestedPropertyValue.setPrimitiveValue(".*" + Pattern.quote(classificationPropertyValue) + ".*");
        requestedPropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PropertyCondition nameCondition = new PropertyCondition();
        nameCondition.setProperty(classificationPropertyName);
        nameCondition.setOperator(PropertyComparisonOperator.LIKE);
        nameCondition.setValue(requestedPropertyValue);
        conditions.add(nameCondition);
        SearchProperties searchClassificationProperties = new SearchProperties();
        searchClassificationProperties.setConditions(conditions);
        searchClassificationProperties.setMatchCriteria(MatchCriteria.ANY);
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        classificationCondition.setName(classificationName);
        classificationCondition.setSearchProperties(searchClassificationProperties);
        classificationConditions.add(classificationCondition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, null, limitResultsByStatus, asOfTime, searchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> getMetadataElementsByClassificationPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String classificationName, List<String> classificationPropertyNames, String classificationPropertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PrimitiveTypePropertyValue requestedPropertyValue = new PrimitiveTypePropertyValue();
        requestedPropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        requestedPropertyValue.setPrimitiveValue(classificationPropertyValue);
        requestedPropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        if (classificationPropertyNames != null) {
            for (String propertyName : classificationPropertyNames) {
                PropertyCondition nameCondition = new PropertyCondition();
                nameCondition.setProperty(propertyName);
                nameCondition.setOperator(PropertyComparisonOperator.EQ);
                nameCondition.setValue(requestedPropertyValue);
                conditions.add(nameCondition);
            }
        }
        SearchProperties searchClassificationProperties = new SearchProperties();
        searchClassificationProperties.setConditions(conditions);
        searchClassificationProperties.setMatchCriteria(MatchCriteria.ANY);
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        classificationCondition.setName(classificationName);
        classificationCondition.setSearchProperties(searchClassificationProperties);
        classificationConditions.add(classificationCondition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, null, limitResultsByStatus, asOfTime, searchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElementsByClassificationPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String classificationName, List<String> classificationPropertyNames, String classificationPropertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PrimitiveTypePropertyValue requestedPropertyValue = new PrimitiveTypePropertyValue();
        requestedPropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        requestedPropertyValue.setPrimitiveValue(".*" + Pattern.quote(classificationPropertyValue) + ".*");
        requestedPropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        if (classificationPropertyNames != null) {
            for (String propertyName : classificationPropertyNames) {
                PropertyCondition nameCondition = new PropertyCondition();
                nameCondition.setProperty(propertyName);
                nameCondition.setOperator(PropertyComparisonOperator.LIKE);
                nameCondition.setValue(requestedPropertyValue);
                conditions.add(nameCondition);
            }
        }
        SearchProperties searchClassificationProperties = new SearchProperties();
        searchClassificationProperties.setConditions(conditions);
        searchClassificationProperties.setMatchCriteria(MatchCriteria.ANY);
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        classificationCondition.setName(classificationName);
        classificationCondition.setSearchProperties(searchClassificationProperties);
        classificationConditions.add(classificationCondition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, null, limitResultsByStatus, asOfTime, searchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> getMetadataElementsByClassification(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String classificationName, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        classificationCondition.setName(classificationName);
        classificationConditions.add(classificationCondition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, null, limitResultsByStatus, asOfTime, searchClassifications, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> getMetadataElementsByPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String propertyName, String propertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<String> propertyNames = List.of(propertyName);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, this.propertyHelper.getSearchPropertiesByName(propertyNames, propertyValue, PropertyComparisonOperator.EQ), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElementsByPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, String propertyName, String propertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<String> propertyNames = List.of(propertyName);
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, this.propertyHelper.getSearchPropertiesByName(propertyNames, propertyValue, PropertyComparisonOperator.LIKE), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> getMetadataElementsByPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, List<String> propertyNames, String propertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, this.propertyHelper.getSearchPropertiesByName(propertyNames, propertyValue, PropertyComparisonOperator.EQ), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElementsByPropertyValue(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, List<String> propertyNames, String propertyValue, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findMetadataElements(userId, metadataElementTypeName, metadataElementSubtypeNames, this.propertyHelper.getSearchPropertiesByName(propertyNames, propertyValue, PropertyComparisonOperator.LIKE), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    @Override
    public List<OpenMetadataElement> findMetadataElements(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, Date asOfTime, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findMetadataElements";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-conditions?forLineage={3}&forDuplicateProcessing={4}&startFrom={5}&pageSize={6}";
        this.invalidParameterHandler.validateUserId(userId, "findMetadataElements");
        FindRequestBody requestBody = new FindRequestBody();
        requestBody.setMetadataElementTypeName(metadataElementTypeName);
        requestBody.setMetadataElementSubtypeNames(metadataElementSubtypeNames);
        requestBody.setSearchProperties(searchProperties);
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setMatchClassifications(matchClassifications);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setEffectiveTime(effectiveTime);
        if (sequencingOrder == null) {
            requestBody.setSequencingOrder(SequencingOrder.LAST_UPDATE_RECENT);
        } else {
            requestBody.setSequencingOrder(sequencingOrder);
        }
        requestBody.setAsOfTime(asOfTime);
        OpenMetadataElementsResponse restResult = this.restClient.callOpenMetadataElementsPostRESTCall("findMetadataElements", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, startFrom, pageSize);
        return restResult.getElementList();
    }

    @Override
    public OpenMetadataRelationshipList findRelationshipsBetweenMetadataElements(String userId, String relationshipTypeName, SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findRelationshipsBetweenMetadataElements";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/relationships/by-search-conditions?forLineage={3}&forDuplicateProcessing={4}&startFrom={5}&pageSize={6}";
        this.invalidParameterHandler.validateUserId(userId, "findRelationshipsBetweenMetadataElements");
        FindRelationshipRequestBody requestBody = new FindRelationshipRequestBody();
        requestBody.setRelationshipTypeName(relationshipTypeName);
        requestBody.setSearchProperties(searchProperties);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setSequencingOrder(sequencingOrder);
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setAsOfTime(asOfTime);
        requestBody.setEffectiveTime(effectiveTime);
        OpenMetadataRelationshipListResponse restResult = this.restClient.callOpenMetadataRelationshipListPostRESTCall("findRelationshipsBetweenMetadataElements", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, startFrom, pageSize);
        return restResult.getRelationshipList();
    }

    @Override
    public OpenMetadataRelationship getRelationshipByGUID(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date asOfTime, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelationshipByGUID";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/relationships/by-guid/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getRelationshipByGUID");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "getRelationshipByGUID");
        AnyTimeRequestBody requestBody = new AnyTimeRequestBody();
        requestBody.setAsOfTime(asOfTime);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        OpenMetadataRelationshipResponse restResult = this.restClient.callOpenMetadataRelationshipPostRESTCall("getRelationshipByGUID", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, relationshipGUID);
        return restResult.getElement();
    }

    @Override
    public OpenMetadataRelationshipList getRelationshipHistory(String userId, String relationshipGUID, Date fromTime, Date toTime, boolean oldestFirst, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelationshipHistory";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/relationships/{3}/history?forLineage={4}&forDuplicateProcessing={5}&oldestFirst={6}&startFrom={7}&pageSize={8}";
        this.invalidParameterHandler.validateUserId(userId, "getRelationshipHistory");
        HistoryRequestBody requestBody = new HistoryRequestBody();
        requestBody.setFromTime(fromTime);
        requestBody.setToTime(toTime);
        requestBody.setEffectiveTime(effectiveTime);
        OpenMetadataRelationshipListResponse restResult = this.restClient.callOpenMetadataRelationshipListPostRESTCall("getRelationshipHistory", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, relationshipGUID, forLineage, forDuplicateProcessing, oldestFirst, startFrom, pageSize);
        return restResult.getRelationshipList();
    }

    @Override
    public String createMetadataElementInStore(String userId, String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createMetadataElementInStore(userId, null, null, metadataElementTypeName, initialStatus, null, null, false, null, effectiveFrom, effectiveTo, properties, null, null, null, true, false, false, null);
    }

    @Override
    public String createMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createMetadataElementInStore(userId, externalSourceGUID, externalSourceName, metadataElementTypeName, initialStatus, null, null, false, null, effectiveFrom, effectiveTo, properties, null, null, null, true, false, false, null);
    }

    @Override
    public String createMetadataElementInStore(String userId, String metadataElementTypeName, ElementStatus initialStatus, Map<String, ElementProperties> initialClassifications, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createMetadataElementInStore(userId, null, null, metadataElementTypeName, initialStatus, initialClassifications, anchorGUID, isOwnAnchor, anchorScopeGUID, effectiveFrom, effectiveTo, properties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public String createMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementTypeName, ElementStatus initialStatus, Map<String, ElementProperties> initialClassifications, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createMetadataElementInStore";
        String elementTypeParameterName = "metadataElementTypeName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements";
        this.invalidParameterHandler.validateUserId(userId, "createMetadataElementInStore");
        this.invalidParameterHandler.validateName(metadataElementTypeName, "metadataElementTypeName", "createMetadataElementInStore");
        if (parentGUID != null) {
            String parentRelationshipTypeNameParameterName = "parentRelationshipTypeName";
            this.invalidParameterHandler.validateName(parentRelationshipTypeName, "parentRelationshipTypeName", "createMetadataElementInStore");
        }
        NewOpenMetadataElementRequestBody requestBody = new NewOpenMetadataElementRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setTypeName(metadataElementTypeName);
        requestBody.setInitialStatus(initialStatus);
        requestBody.setInitialClassifications(initialClassifications);
        requestBody.setAnchorGUID(anchorGUID);
        requestBody.setIsOwnAnchor(isOwnAnchor);
        requestBody.setAnchorScopeGUID(anchorScopeGUID);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setParentGUID(parentGUID);
        requestBody.setParentRelationshipTypeName(parentRelationshipTypeName);
        requestBody.setParentRelationshipProperties(parentRelationshipProperties);
        requestBody.setParentAtEnd1(parentAtEnd1);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createMetadataElementInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public String createMetadataElementFromTemplate(String userId, String metadataElementTypeName, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createMetadataElementFromTemplate(userId, null, null, metadataElementTypeName, anchorGUID, isOwnAnchor, anchorScopeGUID, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public String createMetadataElementFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String metadataElementTypeName, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createMetadataElementFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/from-template";
        this.invalidParameterHandler.validateUserId(userId, "createMetadataElementFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createMetadataElementFromTemplate");
        if (parentGUID != null) {
            String parentRelationshipTypeNameParameterName = "parentRelationshipTypeName";
            this.invalidParameterHandler.validateName(parentRelationshipTypeName, "parentRelationshipTypeName", "createMetadataElementFromTemplate");
        }
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setTypeName(metadataElementTypeName);
        requestBody.setAnchorGUID(anchorGUID);
        requestBody.setIsOwnAnchor(isOwnAnchor);
        requestBody.setAnchorScopeGUID(anchorScopeGUID);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setTemplateGUID(templateGUID);
        requestBody.setReplacementProperties(replacementProperties);
        requestBody.setPlaceholderPropertyValues(placeholderProperties);
        requestBody.setParentGUID(parentGUID);
        requestBody.setParentRelationshipTypeName(parentRelationshipTypeName);
        requestBody.setParentRelationshipProperties(parentRelationshipProperties);
        requestBody.setParentAtEnd1(parentAtEnd1);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createMetadataElementFromTemplate", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public String getMetadataElementFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String metadataElementTypeName, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/from-template?allowRetrieve={3}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "getMetadataElementFromTemplate");
        if (parentGUID != null) {
            String parentRelationshipTypeNameParameterName = "parentRelationshipTypeName";
            this.invalidParameterHandler.validateName(parentRelationshipTypeName, "parentRelationshipTypeName", "getMetadataElementFromTemplate");
        }
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setTypeName(metadataElementTypeName);
        requestBody.setAnchorGUID(anchorGUID);
        requestBody.setIsOwnAnchor(isOwnAnchor);
        requestBody.setAnchorScopeGUID(anchorScopeGUID);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setTemplateGUID(templateGUID);
        requestBody.setReplacementProperties(replacementProperties);
        requestBody.setPlaceholderPropertyValues(placeholderProperties);
        requestBody.setParentGUID(parentGUID);
        requestBody.setParentRelationshipTypeName(parentRelationshipTypeName);
        requestBody.setParentRelationshipProperties(parentRelationshipProperties);
        requestBody.setParentAtEnd1(parentAtEnd1);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("getMetadataElementFromTemplate", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, true);
        return restResult.getGUID();
    }

    @Override
    public void updateMetadataElementInStore(String userId, String metadataElementGUID, boolean replaceAllProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateMetadataElementInStore(userId, null, null, metadataElementGUID, replaceAllProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    @Override
    public void updateMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateMetadataElementInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID);
    }

    @Override
    public void updateMetadataElementStatusInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateMetadataElementStatusInStore(userId, null, null, metadataElementGUID, forLineage, forDuplicateProcessing, newElementStatus, effectiveTime);
    }

    @Override
    public void updateMetadataElementStatusInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementStatusInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-status";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementStatusInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementStatusInStore");
        UpdateStatusRequestBody requestBody = new UpdateStatusRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setNewStatus(newElementStatus);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementStatusInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID);
    }

    @Override
    public void updateMetadataElementEffectivityInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateMetadataElementEffectivityInStore(userId, null, null, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    @Override
    public void updateMetadataElementEffectivityInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementEffectivityInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementEffectivityInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementEffectivityInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID);
    }

    @Override
    public void deleteMetadataElementInStore(String userId, String metadataElementGUID, boolean cascadedDelete, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteMetadataElementInStore(userId, null, null, metadataElementGUID, cascadedDelete, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public void deleteMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean cascadedDelete, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/delete?cascadedDelete={4}";
        this.invalidParameterHandler.validateUserId(userId, "deleteMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "deleteMetadataElementInStore");
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("deleteMetadataElementInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID, cascadedDelete);
    }

    @Override
    public void archiveMetadataElementInStore(String userId, String metadataElementGUID, ArchiveProperties archiveProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.archiveMetadataElementInStore(userId, null, null, metadataElementGUID, archiveProperties, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public void archiveMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, ArchiveProperties archiveProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "archiveMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/archive";
        this.invalidParameterHandler.validateUserId(userId, "archiveMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "archiveMetadataElementInStore");
        ArchiveRequestBody requestBody = new ArchiveRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        requestBody.setArchiveProperties(archiveProperties);
        this.restClient.callVoidPostRESTCall("archiveMetadataElementInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID);
    }

    @Override
    public void classifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.classifyMetadataElementInStore(userId, null, null, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    @Override
    public void classifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "classifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}";
        this.invalidParameterHandler.validateUserId(userId, "classifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "classifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "classifyMetadataElementInStore");
        NewClassificationRequestBody requestBody = new NewClassificationRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("classifyMetadataElementInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName);
    }

    @Override
    public void reclassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.reclassifyMetadataElementInStore(userId, null, null, metadataElementGUID, classificationName, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    @Override
    public void reclassifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "reclassifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "reclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "reclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "reclassifyMetadataElementInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("reclassifyMetadataElementInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName);
    }

    @Override
    public void updateClassificationEffectivityInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateClassificationEffectivityInStore(userId, null, null, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    @Override
    public void updateClassificationEffectivityInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateClassificationEffectivityInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateClassificationEffectivityInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateClassificationEffectivityInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "updateClassificationEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateClassificationEffectivityInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName);
    }

    @Override
    public void declassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.declassifyMetadataElementInStore(userId, null, null, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public void declassifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "declassifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "declassifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "declassifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "declassifyMetadataElementInStore");
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("declassifyMetadataElementInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName);
    }

    @Override
    public String createRelatedElementsInStore(String userId, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createRelatedElementsInStore(userId, null, null, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    @Override
    public String createRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createRelatedElementsInStore";
        String elementTypeParameterName = "relationshipTypeName";
        String end1ParameterName = "metadataElement1GUID";
        String end2ParameterName = "metadataElement2GUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements";
        this.invalidParameterHandler.validateUserId(userId, "createRelatedElementsInStore");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "createRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", "createRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", "createRelatedElementsInStore");
        NewRelatedElementsRequestBody requestBody = new NewRelatedElementsRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setTypeName(relationshipTypeName);
        requestBody.setMetadataElement1GUID(metadataElement1GUID);
        requestBody.setMetadataElement2GUID(metadataElement2GUID);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createRelatedElementsInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public void updateRelationshipInStore(String userId, String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateRelationshipInStore(userId, null, null, relationshipGUID, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    @Override
    public void updateRelationshipInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelationshipInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "updateRelationshipInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateRelationshipInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setProperties(properties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateRelationshipInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, relationshipGUID);
    }

    @Override
    public void updateRelatedElementsInStore(String userId, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean replaceProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateRelatedElementsInStore(userId, null, null, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, replaceProperties, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    @Override
    public void updateRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean replaceProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelatedElementsInStore";
        String end1GUIDParameterName = "metadataElement1GUID";
        String end2GUIDParameterName = "metadataElement2GUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "updateRelatedElementsInStore");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "updateRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", "updateRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", "updateRelatedElementsInStore");
        OpenMetadataRelationshipList relationshipList = this.getMetadataElementRelationships(userId, metadataElement1GUID, metadataElement2GUID, relationshipTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, 0, 0);
        if (relationshipList != null && relationshipList.getElementList() != null) {
            for (OpenMetadataRelationship relationship : relationshipList.getElementList()) {
                if (relationship == null || !metadataElement1GUID.equals(relationship.getElementGUIDAtEnd1()) || !metadataElement2GUID.equals(relationship.getElementGUIDAtEnd2())) continue;
                this.updateRelationshipInStore(userId, externalSourceGUID, externalSourceName, relationship.getRelationshipGUID(), replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
                this.updateRelationshipEffectivityInStore(userId, externalSourceGUID, externalSourceName, relationship.getRelationshipGUID(), forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
            }
        }
    }

    @Override
    public void updateRelationshipEffectivityInStore(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateRelationshipEffectivityInStore(userId, null, null, relationshipGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    @Override
    public void updateRelationshipEffectivityInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelatedElementsEffectivityInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateRelatedElementsEffectivityInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateRelatedElementsEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateRelatedElementsEffectivityInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, relationshipGUID);
    }

    @Override
    public void deleteRelationshipInStore(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteRelationshipInStore(userId, null, null, relationshipGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public void deleteRelationshipInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteRelatedElementsInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "deleteRelatedElementsInStore");
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("deleteRelatedElementsInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, relationshipGUID);
    }

    @Override
    public void detachRelatedElementsInStore(String userId, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.detachRelatedElementsInStore(userId, null, null, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public void detachRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachRelatedElementsInStore";
        String end1GUIDParameterName = "metadataElement1GUID";
        String end2GUIDParameterName = "metadataElement2GUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "detachRelatedElementsInStore");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "detachRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", "detachRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", "detachRelatedElementsInStore");
        OpenMetadataRelationshipList relationshipList = this.getMetadataElementRelationships(userId, metadataElement1GUID, metadataElement2GUID, relationshipTypeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, 0, 0);
        if (relationshipList != null && relationshipList.getElementList() != null) {
            for (OpenMetadataRelationship relationship : relationshipList.getElementList()) {
                if (relationship == null || !metadataElement1GUID.equals(relationship.getElementGUIDAtEnd1()) || !metadataElement2GUID.equals(relationship.getElementGUIDAtEnd2())) continue;
                this.deleteRelationshipInStore(userId, externalSourceGUID, externalSourceName, relationship.getRelationshipGUID(), forLineage, forDuplicateProcessing, effectiveTime);
            }
        }
    }

    @Override
    public String createIncidentReport(String userId, String qualifiedName, int domainIdentifier, String background, List<IncidentImpactedElement> impactedResources, List<IncidentDependency> previousIncidents, Map<String, Integer> incidentClassifiers, Map<String, String> additionalProperties, String originatorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIncidentReport";
        String qualifiedNameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/incident-reports";
        this.invalidParameterHandler.validateUserId(userId, "createIncidentReport");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createIncidentReport");
        IncidentReportRequestBody requestBody = new IncidentReportRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDomainIdentifier(domainIdentifier);
        requestBody.setBackground(background);
        requestBody.setImpactedResources(impactedResources);
        requestBody.setPreviousIncidents(previousIncidents);
        requestBody.setIncidentClassifiers(incidentClassifiers);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setOriginatorGUID(originatorGUID);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createIncidentReport", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public String openToDo(String userId, String qualifiedName, String title, String instructions, String category, int priority, Date dueDate, Map<String, String> additionalProperties, String assignToGUID, String sponsorGUID, String originatorGUID, List<NewActionTarget> actionTargets) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "openToDo";
        String toDoQualifiedNameParameterName = "qualifiedName";
        String assignToParameterName = "assignToGUID";
        this.propertyHelper.validateMandatoryName(qualifiedName, "qualifiedName", "openToDo");
        this.propertyHelper.validateMandatoryName(assignToGUID, "assignToGUID", "openToDo");
        ElementProperties properties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName);
        properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.NAME.name, title);
        properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.DESCRIPTION.name, instructions);
        properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.TO_DO_TYPE.name, category);
        properties = this.propertyHelper.addDateProperty(properties, OpenMetadataProperty.DUE_TIME.name, dueDate);
        properties = this.propertyHelper.addIntProperty(properties, OpenMetadataProperty.PRIORITY.name, priority);
        properties = this.propertyHelper.addEnumProperty(properties, OpenMetadataProperty.TO_DO_STATUS.name, ToDoStatus.getOpenTypeName(), ToDoStatus.OPEN.getName());
        String toDoGUID = this.createMetadataElementInStore(userId, OpenMetadataType.TO_DO.typeName, ElementStatus.ACTIVE, null, null, false, null, null, null, properties, assignToGUID, OpenMetadataType.ACTION_ASSIGNMENT_RELATIONSHIP.typeName, null, true, true, false, null);
        if (toDoGUID != null) {
            if (actionTargets != null) {
                for (NewActionTarget actionTarget : actionTargets) {
                    if (actionTarget == null || actionTarget.getActionTargetGUID() == null) continue;
                    ElementProperties relationshipProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.ACTION_TARGET_NAME.name, actionTarget.getActionTargetName());
                    this.createRelatedElementsInStore(userId, OpenMetadataType.ACTION_TARGET_RELATIONSHIP.typeName, toDoGUID, actionTarget.getActionTargetGUID(), false, false, null, null, relationshipProperties, null);
                }
            }
            if (sponsorGUID != null) {
                this.createRelatedElementsInStore(userId, OpenMetadataType.ACTION_SPONSOR_RELATIONSHIP.typeName, sponsorGUID, toDoGUID, false, false, null, null, null, null);
            }
            if (originatorGUID != null) {
                this.createRelatedElementsInStore(userId, OpenMetadataType.TO_DO_SOURCE_RELATIONSHIP.typeName, originatorGUID, toDoGUID, false, false, null, null, null, null);
            }
        }
        return toDoGUID;
    }

    @Override
    public String registerContextEvent(String userId, String anchorGUID, Map<String, DependentContextEventProperties> parentContextEvents, Map<String, DependentContextEventProperties> childContextEvents, Map<String, RelatedContextEventProperties> relatedContextEvents, Map<String, ContextEventImpactProperties> impactedElements, Map<String, RelationshipProperties> effectedDataResourceGUIDs, Map<String, RelationshipProperties> contextEventEvidenceGUIDs, ContextEventProperties contextEventProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerContextEvent";
        String qualifiedNameParameterName = "qualifiedName";
        if (contextEventProperties == null) {
            this.propertyHelper.validateMandatoryName(null, "qualifiedName", "registerContextEvent");
            return null;
        }
        this.propertyHelper.validateMandatoryName(contextEventProperties.getQualifiedName(), "qualifiedName", "registerContextEvent");
        ElementProperties properties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, contextEventProperties.getQualifiedName());
        properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.NAME.name, contextEventProperties.getName());
        properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.DESCRIPTION.name, contextEventProperties.getEventDescription());
        properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.CONTEXT_EVENT_TYPE.name, contextEventProperties.getContextEventType());
        properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.EVENT_EFFECT.name, contextEventProperties.getEventEffect());
        properties = this.propertyHelper.addDateProperty(properties, OpenMetadataProperty.PLANNED_START_DATE.name, contextEventProperties.getPlannedStartDate());
        properties = this.propertyHelper.addDateProperty(properties, OpenMetadataProperty.ACTUAL_START_DATE.name, contextEventProperties.getActualStartDate());
        properties = this.propertyHelper.addDateProperty(properties, OpenMetadataProperty.PLANNED_COMPLETION_DATE.name, contextEventProperties.getPlannedCompletionDate());
        properties = this.propertyHelper.addDateProperty(properties, OpenMetadataProperty.ACTUAL_COMPLETION_DATE.name, contextEventProperties.getActualCompletionDate());
        properties = this.propertyHelper.addDateProperty(properties, OpenMetadataProperty.REFERENCE_EFFECTIVE_FROM.name, contextEventProperties.getReferenceEffectiveFrom());
        properties = this.propertyHelper.addDateProperty(properties, OpenMetadataProperty.REFERENCE_EFFECTIVE_TO.name, contextEventProperties.getReferenceEffectiveTo());
        properties = this.propertyHelper.addLongProperty(properties, OpenMetadataProperty.PLANNED_DURATION.name, contextEventProperties.getPlannedDuration());
        properties = this.propertyHelper.addLongProperty(properties, OpenMetadataProperty.ACTUAL_DURATION.name, contextEventProperties.getActualDuration());
        properties = this.propertyHelper.addLongProperty(properties, OpenMetadataProperty.REPEAT_INTERVAL.name, contextEventProperties.getRepeatInterval());
        properties = this.propertyHelper.addStringMapProperty(properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, contextEventProperties.getAdditionalProperties());
        boolean isOwnAnchor = anchorGUID == null;
        String contextEventGUID = this.createMetadataElementInStore(userId, OpenMetadataType.CONTEXT_EVENT.typeName, ElementStatus.ACTIVE, null, anchorGUID, isOwnAnchor, null, contextEventProperties.getEffectiveFrom(), contextEventProperties.getEffectiveTo(), properties, null, null, null, true, true, false, null);
        if (contextEventGUID != null) {
            ElementProperties relationshipProperties;
            RelationshipProperties suppliedRelationshipProperties;
            if (parentContextEvents != null) {
                for (String guid : parentContextEvents.keySet()) {
                    if (guid == null) continue;
                    suppliedRelationshipProperties = parentContextEvents.get(guid);
                    if (suppliedRelationshipProperties != null) {
                        relationshipProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.DESCRIPTION.name, ((DependentContextEventProperties)suppliedRelationshipProperties).getDescription());
                        this.createRelatedElementsInStore(userId, OpenMetadataType.DEPENDENT_CONTEXT_EVENT_RELATIONSHIP.typeName, guid, contextEventGUID, false, false, suppliedRelationshipProperties.getEffectiveFrom(), suppliedRelationshipProperties.getEffectiveTo(), relationshipProperties, new Date());
                        continue;
                    }
                    this.createRelatedElementsInStore(userId, OpenMetadataType.DEPENDENT_CONTEXT_EVENT_RELATIONSHIP.typeName, guid, contextEventGUID, false, false, null, null, null, new Date());
                }
            }
            if (childContextEvents != null) {
                for (String guid : childContextEvents.keySet()) {
                    if (guid == null) continue;
                    suppliedRelationshipProperties = childContextEvents.get(guid);
                    if (suppliedRelationshipProperties != null) {
                        relationshipProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.DESCRIPTION.name, ((DependentContextEventProperties)suppliedRelationshipProperties).getDescription());
                        this.createRelatedElementsInStore(userId, OpenMetadataType.DEPENDENT_CONTEXT_EVENT_RELATIONSHIP.typeName, contextEventGUID, guid, false, false, suppliedRelationshipProperties.getEffectiveFrom(), suppliedRelationshipProperties.getEffectiveTo(), relationshipProperties, new Date());
                        continue;
                    }
                    this.createRelatedElementsInStore(userId, OpenMetadataType.DEPENDENT_CONTEXT_EVENT_RELATIONSHIP.typeName, contextEventGUID, guid, false, false, null, null, null, new Date());
                }
            }
            if (relatedContextEvents != null) {
                for (String guid : relatedContextEvents.keySet()) {
                    if (guid == null) continue;
                    suppliedRelationshipProperties = relatedContextEvents.get(guid);
                    if (suppliedRelationshipProperties != null) {
                        relationshipProperties = this.propertyHelper.addIntProperty(null, OpenMetadataProperty.STATUS_IDENTIFIER.name, ((RelatedContextEventProperties)suppliedRelationshipProperties).getStatusIdentifier());
                        relationshipProperties = this.propertyHelper.addIntProperty(relationshipProperties, OpenMetadataProperty.CONFIDENCE.name, ((RelatedContextEventProperties)suppliedRelationshipProperties).getConfidence());
                        relationshipProperties = this.propertyHelper.addStringProperty(relationshipProperties, OpenMetadataProperty.STEWARD.name, ((RelatedContextEventProperties)suppliedRelationshipProperties).getSteward());
                        relationshipProperties = this.propertyHelper.addStringProperty(relationshipProperties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, ((RelatedContextEventProperties)suppliedRelationshipProperties).getStewardTypeName());
                        relationshipProperties = this.propertyHelper.addStringProperty(relationshipProperties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, ((RelatedContextEventProperties)suppliedRelationshipProperties).getStewardPropertyName());
                        relationshipProperties = this.propertyHelper.addStringProperty(relationshipProperties, OpenMetadataProperty.SOURCE.name, ((RelatedContextEventProperties)suppliedRelationshipProperties).getSource());
                        relationshipProperties = this.propertyHelper.addStringProperty(relationshipProperties, OpenMetadataProperty.NOTES.name, ((RelatedContextEventProperties)suppliedRelationshipProperties).getNotes());
                        this.createRelatedElementsInStore(userId, OpenMetadataType.RELATED_CONTEXT_EVENT_RELATIONSHIP.typeName, guid, contextEventGUID, false, false, suppliedRelationshipProperties.getEffectiveFrom(), suppliedRelationshipProperties.getEffectiveTo(), relationshipProperties, new Date());
                        continue;
                    }
                    this.createRelatedElementsInStore(userId, OpenMetadataType.RELATED_CONTEXT_EVENT_RELATIONSHIP.typeName, guid, contextEventGUID, false, false, null, null, null, new Date());
                }
            }
            if (impactedElements != null) {
                for (String guid : impactedElements.keySet()) {
                    if (guid == null) continue;
                    suppliedRelationshipProperties = impactedElements.get(guid);
                    if (suppliedRelationshipProperties != null) {
                        relationshipProperties = this.propertyHelper.addIntProperty(null, OpenMetadataProperty.SEVERITY_LEVEL_IDENTIFIER.name, ((ContextEventImpactProperties)suppliedRelationshipProperties).getSeverityLevelIdentifier());
                        relationshipProperties = this.propertyHelper.addStringProperty(relationshipProperties, OpenMetadataProperty.DESCRIPTION.name, ((ContextEventImpactProperties)suppliedRelationshipProperties).getDescription());
                        this.createRelatedElementsInStore(userId, OpenMetadataType.CONTEXT_EVENT_IMPACT_RELATIONSHIP.typeName, guid, contextEventGUID, false, false, suppliedRelationshipProperties.getEffectiveFrom(), suppliedRelationshipProperties.getEffectiveTo(), relationshipProperties, new Date());
                        continue;
                    }
                    this.createRelatedElementsInStore(userId, OpenMetadataType.CONTEXT_EVENT_IMPACT_RELATIONSHIP.typeName, guid, contextEventGUID, false, false, null, null, null, new Date());
                }
            }
            if (effectedDataResourceGUIDs != null) {
                for (String guid : effectedDataResourceGUIDs.keySet()) {
                    if (guid == null) continue;
                    suppliedRelationshipProperties = effectedDataResourceGUIDs.get(guid);
                    if (suppliedRelationshipProperties != null) {
                        this.createRelatedElementsInStore(userId, OpenMetadataType.CONTEXT_EVENT_FOR_TIMELINE_EFFECTS_RELATIONSHIP.typeName, guid, contextEventGUID, false, false, suppliedRelationshipProperties.getEffectiveFrom(), suppliedRelationshipProperties.getEffectiveTo(), null, new Date());
                        continue;
                    }
                    this.createRelatedElementsInStore(userId, OpenMetadataType.CONTEXT_EVENT_FOR_TIMELINE_EFFECTS_RELATIONSHIP.typeName, guid, contextEventGUID, false, false, null, null, null, new Date());
                }
            }
            if (contextEventEvidenceGUIDs != null) {
                for (String guid : contextEventEvidenceGUIDs.keySet()) {
                    if (guid == null) continue;
                    RelationshipProperties suppliedProperties = contextEventEvidenceGUIDs.get(guid);
                    if (suppliedProperties != null) {
                        this.createRelatedElementsInStore(userId, OpenMetadataType.CONTEXT_EVENT_EVIDENCE_RELATIONSHIP.typeName, contextEventGUID, guid, false, false, suppliedProperties.getEffectiveFrom(), suppliedProperties.getEffectiveTo(), null, new Date());
                        continue;
                    }
                    this.createRelatedElementsInStore(userId, OpenMetadataType.CONTEXT_EVENT_EVIDENCE_RELATIONSHIP.typeName, contextEventGUID, guid, false, false, null, null, null, new Date());
                }
            }
        }
        return contextEventGUID;
    }

    @Override
    public void setTranslation(String userId, String elementGUID, TranslationDetail translationDetail) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTranslation";
        String elementGUIDParameterName = "elementGUID";
        String translationDetailParameterName = "translationDetail";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/multi-language/set-translation/{3}";
        this.invalidParameterHandler.validateUserId(userId, "setTranslation");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "setTranslation");
        this.invalidParameterHandler.validateObject(translationDetail, "translationDetail", "setTranslation");
        this.restClient.callVoidPostRESTCall("setTranslation", urlTemplate, translationDetail, this.serverName, this.serviceURLMarker, userId, elementGUID);
    }

    @Override
    public void clearTranslation(String userId, String elementGUID, String language, String locale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTranslation";
        String elementGUIDParameterName = "elementGUID";
        String languageParameterName = "language";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/multi-language/clear-translation/{3}?language={4}&locale={5}";
        this.invalidParameterHandler.validateUserId(userId, "clearTranslation");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "clearTranslation");
        this.invalidParameterHandler.validateName(language, "language", "clearTranslation");
        this.restClient.callVoidPostRESTCall("clearTranslation", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, elementGUID, language, locale);
    }

    @Override
    public TranslationDetail getTranslation(String userId, String elementGUID, String language, String locale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTranslation";
        String elementGUIDParameterName = "elementGUID";
        String languageParameterName = "language";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/multi-language/get-translation/{3}?language={4}&locale={5}";
        this.invalidParameterHandler.validateUserId(userId, "getTranslation");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getTranslation");
        this.invalidParameterHandler.validateName(language, "language", "getTranslation");
        TranslationDetailResponse response = this.restClient.callTranslationDetailGetRESTCall("getTranslation", urlTemplate, this.serverName, this.serviceURLMarker, userId, elementGUID, language, locale);
        return response.getElement();
    }

    @Override
    public List<TranslationDetail> getTranslations(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTranslations";
        String elementGUIDParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/multi-language/get-translations/{3}?startFrom={4}&pageSize={5}";
        this.invalidParameterHandler.validateUserId(userId, "getTranslations");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getTranslations");
        TranslationListResponse response = this.restClient.callTranslationListGetRESTCall("getTranslations", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, elementGUID, startFrom, pageSize);
        return response.getElements();
    }

    @Override
    public void setUpValidMetadataValue(String userId, String typeName, String propertyName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setUpValidMetadataValue";
        String propertyNameParameterName = "propertyName";
        String propertiesParameterName = "validMetadataValue";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/setup-value/{3}?typeName={4}";
        this.invalidParameterHandler.validateUserId(userId, "setUpValidMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataValue");
        this.invalidParameterHandler.validateObject(validMetadataValue, "validMetadataValue", "setUpValidMetadataValue");
        this.restClient.callVoidPostRESTCall("setUpValidMetadataValue", urlTemplate, validMetadataValue, this.serverName, this.serviceURLMarker, userId, propertyName, typeName);
    }

    @Override
    public void setUpValidMetadataMapName(String userId, String typeName, String propertyName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setUpValidMetadataMapName";
        String propertyNameParameterName = "propertyName";
        String propertiesParameterName = "validMetadataValue";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/setup-map-name/{3}?typeName={4}";
        this.invalidParameterHandler.validateUserId(userId, "setUpValidMetadataMapName");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataMapName");
        this.invalidParameterHandler.validateObject(validMetadataValue, "validMetadataValue", "setUpValidMetadataMapName");
        this.restClient.callVoidPostRESTCall("setUpValidMetadataMapName", urlTemplate, validMetadataValue, this.serverName, this.serviceURLMarker, userId, propertyName, typeName);
    }

    @Override
    public void setUpValidMetadataMapValue(String userId, String typeName, String propertyName, String mapName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setUpValidMetadataMapValue";
        String propertyNameParameterName = "propertyName";
        String mapNameParameterName = "mapName";
        String propertiesParameterName = "validMetadataValue";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/setup-map-value/{3}/{4}?typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "setUpValidMetadataMapValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataMapValue");
        this.invalidParameterHandler.validateName(mapName, "mapName", "setUpValidMetadataMapValue");
        this.invalidParameterHandler.validateObject(validMetadataValue, "validMetadataValue", "setUpValidMetadataMapValue");
        this.restClient.callVoidPostRESTCall("setUpValidMetadataMapValue", urlTemplate, validMetadataValue, this.serverName, this.serviceURLMarker, userId, propertyName, mapName, typeName);
    }

    @Override
    public void clearValidMetadataValue(String userId, String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearValidMetadataValue";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/clear-value/{3}?preferredValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "clearValidMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataValue");
        this.restClient.callVoidPostRESTCall("clearValidMetadataValue", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, propertyName, preferredValue, typeName);
    }

    @Override
    public void clearValidMetadataMapName(String userId, String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearValidMetadataMapName";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/clear-map-name/{3}?preferredValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "clearValidMetadataMapName");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataMapName");
        this.restClient.callVoidPostRESTCall("clearValidMetadataMapName", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, propertyName, preferredValue, typeName);
    }

    @Override
    public void clearValidMetadataMapValue(String userId, String typeName, String propertyName, String mapName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearValidMetadataMapValue";
        String propertyNameParameterName = "propertyName";
        String mapNameParameterName = "mapName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/clear-map-value/{3}/{4}?preferredValue={5}&typeName={6}";
        this.invalidParameterHandler.validateUserId(userId, "clearValidMetadataMapValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataMapValue");
        this.invalidParameterHandler.validateName(mapName, "mapName", "clearValidMetadataMapValue");
        this.restClient.callVoidPostRESTCall("clearValidMetadataMapValue", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, propertyName, mapName, preferredValue, typeName);
    }

    @Override
    public boolean validateMetadataValue(String userId, String typeName, String propertyName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateMetadataValue";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/validate-value/{3}?actualValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "validateMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataValue");
        BooleanResponse response = this.restClient.callBooleanGetRESTCall("validateMetadataValue", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, actualValue, typeName);
        return response.getFlag();
    }

    @Override
    public boolean validateMetadataMapName(String userId, String typeName, String propertyName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateMetadataMapName";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/validate-map-name/{3}?actualValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "validateMetadataMapName");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataMapName");
        BooleanResponse response = this.restClient.callBooleanGetRESTCall("validateMetadataMapName", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, actualValue, typeName);
        return response.getFlag();
    }

    @Override
    public boolean validateMetadataMapValue(String userId, String typeName, String propertyName, String mapName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateMetadataMapValue";
        String propertyNameParameterName = "propertyName";
        String mapNameParameterName = "mapName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/validate-map-value/{3}/{4}?actualValue={5}&typeName={6}";
        this.invalidParameterHandler.validateUserId(userId, "validateMetadataMapValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataMapValue");
        this.invalidParameterHandler.validateName(mapName, "mapName", "validateMetadataMapValue");
        BooleanResponse response = this.restClient.callBooleanGetRESTCall("validateMetadataMapValue", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, mapName, actualValue, typeName);
        return response.getFlag();
    }

    @Override
    public ValidMetadataValue getValidMetadataValue(String userId, String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidMetadataValue";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/get-value/{3}?preferredValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "getValidMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataValue");
        ValidMetadataValueResponse response = this.restClient.callValidMetadataValueGetRESTCall("getValidMetadataValue", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, preferredValue, typeName);
        return response.getElement();
    }

    @Override
    public ValidMetadataValue getValidMetadataMapName(String userId, String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidMetadataMapName";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/get-map-name/{3}?preferredValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "getValidMetadataMapName");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataMapName");
        ValidMetadataValueResponse response = this.restClient.callValidMetadataValueGetRESTCall("getValidMetadataMapName", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, preferredValue, typeName);
        return response.getElement();
    }

    @Override
    public ValidMetadataValue getValidMetadataMapValue(String userId, String typeName, String propertyName, String mapName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidMetadataMapValue";
        String propertyNameParameterName = "propertyName";
        String mapNameParameterName = "mapName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/get-map-value/{3}/{4}?preferredValue={5}&typeName={6}";
        this.invalidParameterHandler.validateUserId(userId, "getValidMetadataMapValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataMapValue");
        this.invalidParameterHandler.validateName(mapName, "mapName", "getValidMetadataMapValue");
        ValidMetadataValueResponse response = this.restClient.callValidMetadataValueGetRESTCall("getValidMetadataMapValue", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, mapName, preferredValue, typeName);
        return response.getElement();
    }

    @Override
    public List<ValidMetadataValueDetail> getValidMetadataValues(String userId, String typeName, String propertyName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidMetadataValues";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/get-valid-metadata-values/{3}?typeName={4}&startFrom={5}&pageSize={6}";
        this.invalidParameterHandler.validateUserId(userId, "getValidMetadataValues");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataValues");
        ValidMetadataValueDetailListResponse response = this.restClient.callValidMetadataValueDetailListGetRESTCall("getValidMetadataValues", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, typeName, startFrom, pageSize);
        return response.getElementList();
    }

    @Override
    public List<ValidMetadataValue> getConsistentMetadataValues(String userId, String typeName, String propertyName, String mapName, String preferredValue, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConsistentMetadataValues";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/{3}/consistent-metadata-values?typeName={4}&mapName={5}&preferredValue={6}&startFrom={7}&pageSize={8}";
        this.invalidParameterHandler.validateUserId(userId, "getConsistentMetadataValues");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getConsistentMetadataValues");
        ValidMetadataValueListResponse response = this.restClient.callValidMetadataValueListGetRESTCall("getConsistentMetadataValues", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, typeName, mapName, preferredValue, startFrom, pageSize);
        return response.getElementList();
    }

    @Override
    public void setConsistentMetadataValues(String userId, String typeName1, String propertyName1, String mapName1, String preferredValue1, String typeName2, String propertyName2, String mapName2, String preferredValue2) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setConsistentMetadataValues";
        String propertyName1ParameterName = "propertyName1";
        String preferredValue1ParameterName = "preferredValue1";
        String propertyName2ParameterName = "propertyName2";
        String preferredValue2ParameterName = "preferredValue2";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/{3}/consistent-metadata-values/{4}?typeName1={5}&typeName2={6}&preferredValue1={7}&preferredValue2={8}&mapName1={9}&mapName2={10}";
        this.invalidParameterHandler.validateUserId(userId, "setConsistentMetadataValues");
        this.invalidParameterHandler.validateName(propertyName1, "propertyName1", "setConsistentMetadataValues");
        this.invalidParameterHandler.validateObject(preferredValue1, "preferredValue1", "setConsistentMetadataValues");
        this.invalidParameterHandler.validateName(propertyName2, "propertyName2", "setConsistentMetadataValues");
        this.invalidParameterHandler.validateObject(preferredValue2, "preferredValue2", "setConsistentMetadataValues");
        this.restClient.callVoidPostRESTCall("setConsistentMetadataValues", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, propertyName1, propertyName2, typeName1, typeName2, preferredValue1, preferredValue2, mapName1, mapName2);
    }

    @Override
    public Map<String, List<Map<String, String>>> getSpecification(String userId, String elementGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getSpecification";
        HashMap<String, List<Map<String, String>>> specification = new HashMap<String, List<Map<String, String>>>();
        RelatedMetadataElementList refDataElements = this.getRelatedMetadataElements(userId, elementGUID, 1, OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, new Date(), 0, 0);
        if (refDataElements != null && refDataElements.getElementList() != null) {
            for (RelatedMetadataElement refDataElement : refDataElements.getElementList()) {
                String propertyType;
                if (refDataElement == null || (propertyType = this.propertyHelper.getStringProperty(this.serviceURLMarker, OpenMetadataProperty.PROPERTY_TYPE.name, refDataElement.getRelationshipProperties(), "getSpecification")) == null) continue;
                Map<String, String> additionalProperties = this.propertyHelper.getStringMapFromProperty(this.serviceURLMarker, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, refDataElement.getElement().getElementProperties(), "getSpecification");
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<String, String>();
                }
                additionalProperties.put(propertyType + "Name", this.propertyHelper.getStringProperty(this.serviceURLMarker, OpenMetadataProperty.PREFERRED_VALUE.name, refDataElement.getElement().getElementProperties(), "getSpecification"));
                ArrayList<Map<String, String>> properties = (ArrayList<Map<String, String>>)specification.get(propertyType);
                if (properties == null) {
                    properties = new ArrayList<Map<String, String>>();
                }
                properties.add(additionalProperties);
                specification.put(propertyType, properties);
            }
        }
        if (!specification.isEmpty()) {
            return specification;
        }
        return null;
    }

    @Override
    public void addExternalIdentifier(String userId, String externalScopeGUID, String externalScopeName, String externalScopeTypeName, String openMetadataElementGUID, String openMetadataElementTypeName, ExternalIdentifierProperties externalIdentifierProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addExternalIdentifier";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        String externalScopeNameParameterName = "externalScopeName";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String openMetadataTypeParameterName = "openMetadataElementTypeName";
        String externalIdentifierPropertiesParameterName = "externalIdentifierProperties";
        String externalIdentifierParameterName = "externalIdentifierProperties.externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "addExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalScopeGUID, "externalScopeGUID", "addExternalIdentifier");
        this.invalidParameterHandler.validateName(externalScopeName, "externalScopeName", "addExternalIdentifier");
        this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "addExternalIdentifier");
        this.invalidParameterHandler.validateName(openMetadataElementTypeName, "openMetadataElementTypeName", "addExternalIdentifier");
        this.invalidParameterHandler.validateObject(externalIdentifierProperties, "externalIdentifierProperties", "addExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalIdentifierProperties.getExternalIdentifier(), "externalIdentifierProperties.externalIdentifier", "addExternalIdentifier");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/{4}/external-identifiers/add?forLineage={5}&forDuplicateProcessing={6}";
        MetadataCorrelationProperties metadataCorrelationProperties = new MetadataCorrelationProperties(externalIdentifierProperties);
        metadataCorrelationProperties.setExternalScopeGUID(externalScopeGUID);
        metadataCorrelationProperties.setExternalScopeName(externalScopeName);
        metadataCorrelationProperties.setExternalScopeTypeName(externalScopeTypeName);
        UpdateMetadataCorrelatorsRequestBody requestBody = new UpdateMetadataCorrelatorsRequestBody();
        requestBody.setMetadataCorrelationProperties(metadataCorrelationProperties);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("addExternalIdentifier", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, openMetadataElementTypeName, openMetadataElementGUID, forLineage, forDuplicateProcessing);
    }

    @Override
    public void updateExternalIdentifier(String userId, String externalScopeGUID, String externalScopeName, String externalScopeTypeName, String openMetadataElementGUID, String openMetadataElementTypeName, ExternalIdentifierProperties externalIdentifierProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateExternalIdentifier";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        String externalScopeNameParameterName = "externalScopeName";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String openMetadataTypeParameterName = "openMetadataElementTypeName";
        String externalIdentifierPropertiesParameterName = "externalIdentifierProperties";
        String externalIdentifierParameterName = "externalIdentifierProperties.externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "updateExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalScopeGUID, "externalScopeGUID", "updateExternalIdentifier");
        this.invalidParameterHandler.validateName(externalScopeName, "externalScopeName", "updateExternalIdentifier");
        this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "updateExternalIdentifier");
        this.invalidParameterHandler.validateName(openMetadataElementTypeName, "openMetadataElementTypeName", "updateExternalIdentifier");
        this.invalidParameterHandler.validateObject(externalIdentifierProperties, "externalIdentifierProperties", "updateExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalIdentifierProperties.getExternalIdentifier(), "externalIdentifierProperties.externalIdentifier", "updateExternalIdentifier");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/{4}/external-identifiers/update?forLineage={5}&forDuplicateProcessing={6}";
        MetadataCorrelationProperties metadataCorrelationProperties = new MetadataCorrelationProperties(externalIdentifierProperties);
        metadataCorrelationProperties.setExternalScopeGUID(externalScopeGUID);
        metadataCorrelationProperties.setExternalScopeName(externalScopeName);
        metadataCorrelationProperties.setExternalScopeTypeName(externalScopeTypeName);
        UpdateMetadataCorrelatorsRequestBody requestBody = new UpdateMetadataCorrelatorsRequestBody();
        requestBody.setMetadataCorrelationProperties(metadataCorrelationProperties);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateExternalIdentifier", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, openMetadataElementTypeName, openMetadataElementGUID, forLineage, forDuplicateProcessing);
    }

    @Override
    public void removeExternalIdentifier(String userId, String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName, String externalIdentifier, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeExternalIdentifier";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        String externalScopeNameParameterName = "externalScopeName";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String openMetadataTypeParameterName = "openMetadataElementTypeName";
        String externalIdentifierParameterName = "externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "removeExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalScopeGUID, "externalScopeGUID", "removeExternalIdentifier");
        this.invalidParameterHandler.validateName(externalScopeName, "externalScopeName", "removeExternalIdentifier");
        this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "removeExternalIdentifier");
        this.invalidParameterHandler.validateName(openMetadataElementTypeName, "openMetadataElementTypeName", "removeExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalIdentifier, "externalIdentifier", "removeExternalIdentifier");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/{4}/external-identifiers/remove?forLineage={5}&forDuplicateProcessing={6}";
        UpdateMetadataCorrelatorsRequestBody requestBody = new UpdateMetadataCorrelatorsRequestBody();
        MetadataCorrelationProperties metadataCorrelationProperties = new MetadataCorrelationProperties();
        metadataCorrelationProperties.setExternalScopeGUID(externalScopeGUID);
        metadataCorrelationProperties.setExternalScopeName(externalScopeName);
        metadataCorrelationProperties.setExternalIdentifier(externalIdentifier);
        requestBody.setMetadataCorrelationProperties(metadataCorrelationProperties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("removeExternalIdentifier", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, openMetadataElementTypeName, openMetadataElementGUID, forLineage, forDuplicateProcessing);
    }

    @Override
    public void removeExternalScope(String userId, String externalScopeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeExternalScope";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeExternalScope");
        this.invalidParameterHandler.validateGUID(externalScopeGUID, "externalScopeGUID", "removeExternalScope");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/external-scope/{3}/remove?forLineage={4}&forDuplicateProcessing={5}";
        EffectiveTimeRequestBody requestBody = new EffectiveTimeRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("removeExternalScope", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, externalScopeGUID, forLineage, forDuplicateProcessing);
    }

    @Override
    public void confirmSynchronization(String userId, String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName, String externalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "confirmSynchronization";
        String openMetadataGUIDParameterName = "openMetadataElementGUID";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        String externalScopeNameParameterName = "externalScopeName";
        String externalIdentifierParameterName = "externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "confirmSynchronization");
        this.invalidParameterHandler.validateGUID(externalScopeGUID, "externalScopeGUID", "confirmSynchronization");
        this.invalidParameterHandler.validateName(externalScopeName, "externalScopeName", "confirmSynchronization");
        this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "confirmSynchronization");
        this.invalidParameterHandler.validateGUID(externalIdentifier, "externalIdentifier", "confirmSynchronization");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/{4}/synchronized";
        MetadataCorrelationProperties requestBody = new MetadataCorrelationProperties();
        requestBody.setExternalScopeGUID(externalScopeGUID);
        requestBody.setExternalScopeName(externalScopeName);
        requestBody.setExternalIdentifier(externalIdentifier);
        this.restClient.callVoidPostRESTCall("confirmSynchronization", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, openMetadataElementTypeName, openMetadataElementGUID);
    }

    @Override
    public List<ElementHeader> getElementsForExternalIdentifier(String userId, String externalScopeGUID, String externalScopeName, String externalIdentifier, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsForExternalIdentifier";
        String externalScopeGUIDParameterName = "externalScopeGUID";
        String externalScopeNameParameterName = "externalScopeName";
        String externalIdentifierParameterName = "externalIdentifier";
        this.invalidParameterHandler.validateUserId(userId, "getElementsForExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalScopeGUID, "externalScopeGUID", "getElementsForExternalIdentifier");
        this.invalidParameterHandler.validateName(externalScopeName, "externalScopeName", "getElementsForExternalIdentifier");
        this.invalidParameterHandler.validateGUID(externalIdentifier, "externalIdentifier", "getElementsForExternalIdentifier");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getElementsForExternalIdentifier");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/external-identifiers/open-metadata-elements?startFrom={3}&pageSize={4}";
        UpdateMetadataCorrelatorsRequestBody requestBody = new UpdateMetadataCorrelatorsRequestBody();
        MetadataCorrelationProperties metadataCorrelationProperties = new MetadataCorrelationProperties();
        metadataCorrelationProperties.setExternalScopeGUID(externalScopeGUID);
        metadataCorrelationProperties.setExternalScopeName(externalScopeName);
        metadataCorrelationProperties.setExternalIdentifier(externalIdentifier);
        requestBody.setMetadataCorrelationProperties(metadataCorrelationProperties);
        requestBody.setEffectiveTime(effectiveTime);
        ElementHeadersResponse restResult = this.restClient.callElementHeadersPostRESTCall("getElementsForExternalIdentifier", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, startFrom, validatedPageSize);
        return restResult.getElementHeaders();
    }

    @Override
    public boolean validateExternalIdentifier(String userId, String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName, String elementExternalIdentifier, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (elementExternalIdentifier != null && externalScopeGUID != null && externalScopeName != null) {
            String methodName = "getExternalIdentifiers";
            String guidParameterName = "openMetadataElementGUID";
            this.invalidParameterHandler.validateUserId(userId, "getExternalIdentifiers");
            this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "getExternalIdentifiers");
            String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/{4}/external-identifiers/validate";
            BooleanResponse restResult = this.restClient.callBooleanPostRESTCall("getExternalIdentifiers", urlTemplate, this.getEffectiveTimeQueryRequestBody(externalScopeGUID, externalScopeName, null), this.serverName, this.serviceURLMarker, userId, openMetadataElementTypeName, openMetadataElementGUID);
            return restResult.getFlag();
        }
        return true;
    }

    @Override
    public List<MetadataCorrelationHeader> getExternalIdentifiers(String userId, String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalIdentifiers";
        String guidParameterName = "openMetadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getExternalIdentifiers");
        this.invalidParameterHandler.validateGUID(openMetadataElementGUID, "openMetadataElementGUID", "getExternalIdentifiers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/{4}/external-identifiers";
        MetadataCorrelationHeadersResponse restResult = this.restClient.callCorrelationHeadersPostRESTCall("getExternalIdentifiers", urlTemplate, this.getEffectiveTimeQueryRequestBody(externalScopeGUID, externalScopeName, null), this.serverName, this.serviceURLMarker, userId, openMetadataElementTypeName, openMetadataElementGUID);
        return restResult.getElementList();
    }

    @Override
    public Map<String, Map<String, String>> getVendorProperties(String userId, String openMetadataElementGUID, String openMetadataElementTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getVendorProperties";
        RelatedMetadataElementList propertyFacets = this.getRelatedMetadataElements(userId, openMetadataElementGUID, 1, OpenMetadataType.REFERENCEABLE_FACET.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, new Date(), 0, 0);
        if (propertyFacets != null && propertyFacets.getElementList() != null) {
            HashMap<String, Map<String, String>> vendorProperties = new HashMap<String, Map<String, String>>();
            for (RelatedMetadataElement relatedMetadataElement : propertyFacets.getElementList()) {
                String propertyFacetDescription;
                String vendorIdentifier;
                if (relatedMetadataElement == null || (vendorIdentifier = this.propertyHelper.getStringProperty(this.serverName, OpenMetadataProperty.SOURCE.name, relatedMetadataElement.getRelationshipProperties(), "getVendorProperties")) == null || !"vendorProperties".equals(propertyFacetDescription = this.propertyHelper.getStringProperty(this.serverName, OpenMetadataProperty.DESCRIPTION.name, relatedMetadataElement.getElement().getElementProperties(), "getVendorProperties"))) continue;
                Map<String, String> facetProperties = this.propertyHelper.getStringMapFromProperty(this.serverName, OpenMetadataProperty.PROPERTIES.name, relatedMetadataElement.getElement().getElementProperties(), "getVendorProperties");
                vendorProperties.put(vendorIdentifier, facetProperties);
            }
            return vendorProperties;
        }
        return null;
    }

    protected EffectiveTimeQueryRequestBody getEffectiveTimeQueryRequestBody(String externalScopeGUID, String externalScopeName, Date effectiveTime) {
        EffectiveTimeQueryRequestBody requestBody = new EffectiveTimeQueryRequestBody();
        if (externalScopeGUID != null) {
            requestBody.setExternalScopeGUID(externalScopeGUID);
            requestBody.setExternalScopeName(externalScopeName);
        }
        requestBody.setEffectiveTime(effectiveTime);
        return requestBody;
    }
}

