/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.omf.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AnyTimeRequestBody
extends EffectiveTimeRequestBody {
    private Date asOfTime = null;
    private boolean forLineage = false;
    private boolean forDuplicateProcessing = false;

    public AnyTimeRequestBody() {
    }

    public AnyTimeRequestBody(AnyTimeRequestBody template) {
        super(template);
        if (template != null) {
            this.asOfTime = template.getAsOfTime();
            this.forLineage = template.getForLineage();
            this.forDuplicateProcessing = template.getForDuplicateProcessing();
        }
    }

    public Date getAsOfTime() {
        return this.asOfTime;
    }

    public void setAsOfTime(Date asOfTime) {
        this.asOfTime = asOfTime;
    }

    public boolean getForLineage() {
        return this.forLineage;
    }

    public void setForLineage(boolean forLineage) {
        this.forLineage = forLineage;
    }

    public boolean getForDuplicateProcessing() {
        return this.forDuplicateProcessing;
    }

    public void setForDuplicateProcessing(boolean forDuplicateProcessing) {
        this.forDuplicateProcessing = forDuplicateProcessing;
    }

    @Override
    public String toString() {
        return "AnyTimeRequestBody{asOfTime=" + String.valueOf(this.asOfTime) + ", forLineage=" + this.forLineage + ", forDuplicateProcessing=" + this.forDuplicateProcessing + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AnyTimeRequestBody that = (AnyTimeRequestBody)objectToCompare;
        return this.forLineage == that.forLineage && this.forDuplicateProcessing == that.forDuplicateProcessing && Objects.equals(this.asOfTime, that.asOfTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.asOfTime, this.forLineage, this.forDuplicateProcessing);
    }
}

