/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.omf.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HistoryRequestBody
extends EffectiveTimeRequestBody {
    private Date fromTime = null;
    private Date toTime = null;
    private boolean forLineage = false;
    private boolean forDuplicateProcessing = false;

    public HistoryRequestBody() {
    }

    public HistoryRequestBody(HistoryRequestBody template) {
        super(template);
        if (template != null) {
            this.fromTime = template.getFromTime();
            this.toTime = template.getToTime();
            this.forLineage = template.getForLineage();
            this.forDuplicateProcessing = template.getForDuplicateProcessing();
        }
    }

    public Date getFromTime() {
        return this.fromTime;
    }

    public void setFromTime(Date fromTime) {
        this.fromTime = fromTime;
    }

    public Date getToTime() {
        return this.toTime;
    }

    public void setToTime(Date toTime) {
        this.toTime = toTime;
    }

    public boolean getForLineage() {
        return this.forLineage;
    }

    public void setForLineage(boolean forLineage) {
        this.forLineage = forLineage;
    }

    public boolean getForDuplicateProcessing() {
        return this.forDuplicateProcessing;
    }

    public void setForDuplicateProcessing(boolean forDuplicateProcessing) {
        this.forDuplicateProcessing = forDuplicateProcessing;
    }

    @Override
    public String toString() {
        return "HistoryRequestBody{fromTime=" + String.valueOf(this.fromTime) + ", toTime=" + String.valueOf(this.toTime) + ", forLineage=" + this.forLineage + ", forDuplicateProcessing=" + this.forDuplicateProcessing + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        HistoryRequestBody that = (HistoryRequestBody)objectToCompare;
        return this.forLineage == that.forLineage && this.forDuplicateProcessing == that.forDuplicateProcessing && Objects.equals(this.fromTime, that.fromTime) && Objects.equals(this.toTime, that.toTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.forLineage, this.forDuplicateProcessing, this.fromTime, this.toTime);
    }
}

