/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.auditlog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecord;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogDestinationsReport;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogStoreReport;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecordOriginator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSAuditLogDestination
extends AuditLogDestination {
    private final OMRSAuditLogRecordOriginator omrsOriginator = new OMRSAuditLogRecordOriginator();
    private List<OMRSAuditLogStore> auditLogStores = null;
    private static final Logger log = LoggerFactory.getLogger(OMRSAuditLogDestination.class);

    public OMRSAuditLogDestination(String localServerName, String localServerType, String localOrganizationName, List<OMRSAuditLogStore> auditLogStores) {
        if (this.originatorProperties == null) {
            this.originatorProperties = new HashMap<String, String>();
        }
        this.originatorProperties.put(OMRSAuditLogRecordOriginator.SERVER_NAME_PROPERTY, localServerName);
        this.originatorProperties.put(OMRSAuditLogRecordOriginator.SERVER_TYPE_PROPERTY, localServerType);
        this.originatorProperties.put(OMRSAuditLogRecordOriginator.ORGANIZATION_NAME_PROPERTY, localOrganizationName);
        this.omrsOriginator.setServerName(localServerName);
        this.omrsOriginator.setServerType(localServerType);
        this.omrsOriginator.setOrganizationName(localOrganizationName);
        if (auditLogStores != null) {
            this.auditLogStores = new ArrayList<OMRSAuditLogStore>(auditLogStores);
        }
    }

    public void setLocalMetadataCollectionId(String localMetadataCollectionId) {
        this.originatorProperties.put(OMRSAuditLogRecordOriginator.METADATA_COLLECTION_ID_PROPERTY, localMetadataCollectionId);
        this.omrsOriginator.setMetadataCollectionId(localMetadataCollectionId);
    }

    OMRSAuditLogRecordOriginator getOriginator() {
        return this.omrsOriginator;
    }

    @Override
    public void addLogRecord(AuditLogRecord logRecord) {
        this.addLogRecord(new OMRSAuditLogRecord(logRecord));
    }

    void addLogRecord(OMRSAuditLogRecord logRecord) {
        if (this.auditLogStores != null) {
            for (OMRSAuditLogStore auditLogStore : this.auditLogStores) {
                if (auditLogStore == null) continue;
                try {
                    auditLogStore.storeLogRecord(new OMRSAuditLogRecord(logRecord));
                }
                catch (Exception error) {
                    log.error("Error: " + String.valueOf(error) + " writing audit log: " + String.valueOf(logRecord) + " to destination " + auditLogStore.getClass().getName());
                }
            }
        }
    }

    OMRSAuditLogDestinationsReport getDestinationsReport() {
        OMRSAuditLogDestinationsReport report = null;
        if (this.auditLogStores != null) {
            report = new OMRSAuditLogDestinationsReport();
            ArrayList<OMRSAuditLogStoreReport> storeReportList = new ArrayList<OMRSAuditLogStoreReport>();
            for (OMRSAuditLogStore auditLogStore : this.auditLogStores) {
                if (auditLogStore == null) continue;
                OMRSAuditLogStoreReport auditLogStoreReport = new OMRSAuditLogStoreReport();
                auditLogStoreReport.setDestinationName(auditLogStore.getDestinationName());
                auditLogStoreReport.setSupportedSeverities(auditLogStore.getSupportedSeverities());
                auditLogStoreReport.setImplementationClass(auditLogStore.getClass().getName());
                storeReportList.add(auditLogStoreReport);
            }
            if (!storeReportList.isEmpty()) {
                report.setLogStoreReports(storeReportList);
            }
        }
        return report;
    }
}

