/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EnumPropertyValue
extends InstancePropertyValue {
    private static final long serialVersionUID = 1L;
    private int ordinal = 99;
    private String symbolicName = null;
    private String description = null;

    public EnumPropertyValue() {
        super(InstancePropertyCategory.ENUM);
    }

    public EnumPropertyValue(EnumPropertyValue template) {
        super(template);
        if (template != null) {
            this.ordinal = template.getOrdinal();
            this.symbolicName = template.getSymbolicName();
            this.description = template.getDescription();
        }
    }

    @Override
    public InstancePropertyValue cloneFromSubclass() {
        return new EnumPropertyValue(this);
    }

    @Override
    public String valueAsString() {
        return this.symbolicName == null ? "<null>" : this.symbolicName;
    }

    @Override
    public Object valueAsObject() {
        return this.symbolicName;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return "EnumPropertyValue{ordinal=" + this.ordinal + ", symbolicName='" + this.symbolicName + "', description='" + this.description + "', instancePropertyCategory=" + String.valueOf(this.getInstancePropertyCategory()) + ", typeGUID='" + this.getTypeGUID() + "', typeName='" + this.getTypeName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof EnumPropertyValue)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        EnumPropertyValue that = (EnumPropertyValue)objectToCompare;
        return this.getOrdinal() == that.getOrdinal() && Objects.equals(this.getSymbolicName(), that.getSymbolicName()) && Objects.equals(this.getDescription(), that.getDescription());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getOrdinal(), this.getSymbolicName(), this.getDescription());
    }
}

