/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Classification.class, name="Classification"), @JsonSubTypes.Type(value=InstanceHeader.class, name="InstanceHeader")})
public abstract class InstanceAuditHeader
extends InstanceElementHeader {
    private static final long serialVersionUID = 1L;
    public static final long CURRENT_AUDIT_HEADER_VERSION = 1L;
    private InstanceType type = null;
    private InstanceProvenanceType instanceProvenanceType = null;
    private String metadataCollectionId = null;
    private String metadataCollectionName = null;
    private String replicatedBy = null;
    private String instanceLicense = null;
    private String createdBy = null;
    private String updatedBy = null;
    private List<String> maintainedBy = null;
    private Date createTime = null;
    private Date updateTime = null;
    private long version = 0L;
    private InstanceStatus currentStatus = null;
    private InstanceStatus statusOnDelete = null;
    private Map<String, Serializable> mappingProperties = null;

    public InstanceAuditHeader() {
    }

    public InstanceAuditHeader(InstanceAuditHeader template) {
        super(template);
        if (template != null) {
            this.type = template.getType();
            this.instanceProvenanceType = template.getInstanceProvenanceType();
            this.metadataCollectionId = template.getMetadataCollectionId();
            this.metadataCollectionName = template.getMetadataCollectionName();
            this.replicatedBy = template.getReplicatedBy();
            this.instanceLicense = template.getInstanceLicense();
            this.createdBy = template.getCreatedBy();
            this.updatedBy = template.getUpdatedBy();
            this.maintainedBy = template.getMaintainedBy();
            this.createTime = template.getCreateTime();
            this.updateTime = template.getUpdateTime();
            this.version = template.getVersion();
            this.currentStatus = template.getStatus();
            this.statusOnDelete = template.getStatusOnDelete();
            this.mappingProperties = template.getMappingProperties();
        }
    }

    public InstanceType getType() {
        if (this.type == null) {
            return null;
        }
        return new InstanceType(this.type);
    }

    public void setType(InstanceType type) {
        this.type = type;
    }

    public InstanceProvenanceType getInstanceProvenanceType() {
        return this.instanceProvenanceType;
    }

    public void setInstanceProvenanceType(InstanceProvenanceType instanceProvenanceType) {
        this.instanceProvenanceType = instanceProvenanceType;
    }

    public String getMetadataCollectionId() {
        return this.metadataCollectionId;
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
    }

    public String getMetadataCollectionName() {
        return this.metadataCollectionName;
    }

    public void setMetadataCollectionName(String metadataCollectionName) {
        this.metadataCollectionName = metadataCollectionName;
    }

    public String getReplicatedBy() {
        return this.replicatedBy;
    }

    public void setReplicatedBy(String replicatedBy) {
        this.replicatedBy = replicatedBy;
    }

    public String getInstanceLicense() {
        return this.instanceLicense;
    }

    public void setInstanceLicense(String instanceLicense) {
        this.instanceLicense = instanceLicense;
    }

    public InstanceStatus getStatus() {
        return this.currentStatus;
    }

    public void setStatus(InstanceStatus newStatus) {
        this.currentStatus = newStatus;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public List<String> getMaintainedBy() {
        if (this.maintainedBy == null) {
            return null;
        }
        if (this.maintainedBy.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.maintainedBy);
    }

    public void setMaintainedBy(List<String> maintainedBy) {
        this.maintainedBy = maintainedBy;
    }

    public Date getCreateTime() {
        if (this.createTime == null) {
            return null;
        }
        return new Date(this.createTime.getTime());
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        if (this.updateTime == null) {
            return null;
        }
        return new Date(this.updateTime.getTime());
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public InstanceStatus getStatusOnDelete() {
        return this.statusOnDelete;
    }

    public void setStatusOnDelete(InstanceStatus statusOnDelete) {
        this.statusOnDelete = statusOnDelete;
    }

    public Map<String, Serializable> getMappingProperties() {
        if (this.mappingProperties == null) {
            return null;
        }
        if (this.mappingProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Serializable>(this.mappingProperties);
    }

    public void setMappingProperties(Map<String, Serializable> mappingProperties) {
        this.mappingProperties = mappingProperties;
    }

    public String toString() {
        return "InstanceAuditHeader{headerVersion=" + this.getHeaderVersion() + ", type=" + String.valueOf(this.type) + ", instanceProvenanceType=" + String.valueOf(this.instanceProvenanceType) + ", metadataCollectionId='" + this.metadataCollectionId + "', metadataCollectionName='" + this.metadataCollectionName + "', replicatedBy='" + this.replicatedBy + "', instanceLicense='" + this.instanceLicense + "', createdBy='" + this.createdBy + "', updatedBy='" + this.updatedBy + "', maintainedBy=" + String.valueOf(this.maintainedBy) + ", createTime=" + String.valueOf(this.createTime) + ", updateTime=" + String.valueOf(this.updateTime) + ", version=" + this.version + ", currentStatus=" + String.valueOf(this.currentStatus) + ", statusOnDelete=" + String.valueOf(this.statusOnDelete) + ", mappingProperties=" + String.valueOf(this.mappingProperties) + ", status=" + String.valueOf(this.getStatus()) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof InstanceAuditHeader)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        InstanceAuditHeader that = (InstanceAuditHeader)objectToCompare;
        if (this.version != that.version) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.instanceProvenanceType != that.instanceProvenanceType) {
            return false;
        }
        if (this.metadataCollectionId != null ? !this.metadataCollectionId.equals(that.metadataCollectionId) : that.metadataCollectionId != null) {
            return false;
        }
        if (this.metadataCollectionName != null ? !this.metadataCollectionName.equals(that.metadataCollectionName) : that.metadataCollectionName != null) {
            return false;
        }
        if (this.replicatedBy != null ? !this.replicatedBy.equals(that.replicatedBy) : that.replicatedBy != null) {
            return false;
        }
        if (this.instanceLicense != null ? !this.instanceLicense.equals(that.instanceLicense) : that.instanceLicense != null) {
            return false;
        }
        if (this.createdBy != null ? !this.createdBy.equals(that.createdBy) : that.createdBy != null) {
            return false;
        }
        if (this.updatedBy != null ? !this.updatedBy.equals(that.updatedBy) : that.updatedBy != null) {
            return false;
        }
        if (this.maintainedBy != null ? !this.maintainedBy.equals(that.maintainedBy) : that.maintainedBy != null) {
            return false;
        }
        if (this.createTime != null ? !this.createTime.equals(that.createTime) : that.createTime != null) {
            return false;
        }
        if (this.updateTime != null ? !this.updateTime.equals(that.updateTime) : that.updateTime != null) {
            return false;
        }
        if (this.currentStatus != that.currentStatus) {
            return false;
        }
        if (this.statusOnDelete != that.statusOnDelete) {
            return false;
        }
        return this.mappingProperties != null ? this.mappingProperties.equals(that.mappingProperties) : that.mappingProperties == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.instanceProvenanceType != null ? this.instanceProvenanceType.hashCode() : 0);
        result = 31 * result + (this.metadataCollectionId != null ? this.metadataCollectionId.hashCode() : 0);
        result = 31 * result + (this.metadataCollectionName != null ? this.metadataCollectionName.hashCode() : 0);
        result = 31 * result + (this.replicatedBy != null ? this.replicatedBy.hashCode() : 0);
        result = 31 * result + (this.instanceLicense != null ? this.instanceLicense.hashCode() : 0);
        result = 31 * result + (this.createdBy != null ? this.createdBy.hashCode() : 0);
        result = 31 * result + (this.updatedBy != null ? this.updatedBy.hashCode() : 0);
        result = 31 * result + (this.maintainedBy != null ? this.maintainedBy.hashCode() : 0);
        result = 31 * result + (this.createTime != null ? this.createTime.hashCode() : 0);
        result = 31 * result + (this.updateTime != null ? this.updateTime.hashCode() : 0);
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        result = 31 * result + (this.currentStatus != null ? this.currentStatus.hashCode() : 0);
        result = 31 * result + (this.statusOnDelete != null ? this.statusOnDelete.hashCode() : 0);
        result = 31 * result + (this.mappingProperties != null ? this.mappingProperties.hashCode() : 0);
        return result;
    }
}

