/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class InstanceType
extends InstanceElementHeader {
    private static final long serialVersionUID = 1L;
    private TypeDefCategory typeDefCategory = TypeDefCategory.UNKNOWN_DEF;
    private String typeDefGUID = null;
    private String typeDefName = null;
    private long typeDefVersion = 0L;
    public static final long CURRENT_INSTANCE_TYPE_HEADER_VERSION = 1L;

    public InstanceType() {
    }

    public InstanceType(TypeDefCategory typeDefCategory, String typeDefGUID, String typeDefName, long typeDefVersion) {
        this.typeDefCategory = typeDefCategory;
        this.typeDefGUID = typeDefGUID;
        this.typeDefName = typeDefName;
        this.typeDefVersion = typeDefVersion;
    }

    public InstanceType(InstanceType template) {
        super(template);
        if (template != null) {
            this.typeDefCategory = template.getTypeDefCategory();
            this.typeDefGUID = template.getTypeDefGUID();
            this.typeDefName = template.getTypeDefName();
            this.typeDefVersion = template.getTypeDefVersion();
        }
    }

    public TypeDefCategory getTypeDefCategory() {
        return this.typeDefCategory;
    }

    public void setTypeDefCategory(TypeDefCategory typeDefCategory) {
        this.typeDefCategory = typeDefCategory;
    }

    public String getTypeDefGUID() {
        return this.typeDefGUID;
    }

    public void setTypeDefGUID(String typeDefGUID) {
        this.typeDefGUID = typeDefGUID;
    }

    public String getTypeDefName() {
        return this.typeDefName;
    }

    public void setTypeDefName(String typeDefName) {
        this.typeDefName = typeDefName;
    }

    public long getTypeDefVersion() {
        return this.typeDefVersion;
    }

    public void setTypeDefVersion(long typeDefVersion) {
        this.typeDefVersion = typeDefVersion;
    }

    public String toString() {
        return "InstanceType{typeDefName='" + this.typeDefName + "', typeDefCategory=" + String.valueOf(this.typeDefCategory) + ", typeDefGUID='" + this.typeDefGUID + "', typeDefVersion=" + this.typeDefVersion + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof InstanceType)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        InstanceType that = (InstanceType)objectToCompare;
        if (this.typeDefVersion != that.typeDefVersion) {
            return false;
        }
        if (this.typeDefCategory != that.typeDefCategory) {
            return false;
        }
        if (this.typeDefGUID != null ? !this.typeDefGUID.equals(that.typeDefGUID) : that.typeDefGUID != null) {
            return false;
        }
        return !(this.typeDefName != null ? !this.typeDefName.equals(that.typeDefName) : that.typeDefName != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.typeDefCategory != null ? this.typeDefCategory.hashCode() : 0);
        result = 31 * result + (this.typeDefGUID != null ? this.typeDefGUID.hashCode() : 0);
        result = 31 * result + (this.typeDefName != null ? this.typeDefName.hashCode() : 0);
        result = 31 * result + (int)(this.typeDefVersion ^ this.typeDefVersion >>> 32);
        return result;
    }
}

