/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIRequest;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EntityCreateRequest
extends OMRSAPIRequest {
    private static final long serialVersionUID = 1L;
    private String entityTypeGUID = null;
    private InstanceProperties initialProperties = null;
    private List<Classification> initialClassifications = null;
    private InstanceStatus initialStatus = null;
    private String metadataCollectionId = null;
    private String metadataCollectionName = null;

    public EntityCreateRequest() {
    }

    public EntityCreateRequest(EntityCreateRequest template) {
        super(template);
        if (template != null) {
            this.entityTypeGUID = template.getEntityTypeGUID();
            this.metadataCollectionId = template.getMetadataCollectionId();
            this.metadataCollectionName = template.getMetadataCollectionName();
            this.initialProperties = template.getInitialProperties();
            this.initialClassifications = template.getInitialClassifications();
            this.initialStatus = template.getInitialStatus();
        }
    }

    public String getEntityTypeGUID() {
        return this.entityTypeGUID;
    }

    public void setEntityTypeGUID(String entityTypeGUID) {
        this.entityTypeGUID = entityTypeGUID;
    }

    public InstanceProperties getInitialProperties() {
        if (this.initialProperties == null) {
            return null;
        }
        return new InstanceProperties(this.initialProperties);
    }

    public void setInitialProperties(InstanceProperties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public List<Classification> getInitialClassifications() {
        if (this.initialClassifications == null) {
            return null;
        }
        if (this.initialClassifications.isEmpty()) {
            return null;
        }
        return this.initialClassifications;
    }

    public void setInitialClassifications(List<Classification> initialClassifications) {
        this.initialClassifications = initialClassifications;
    }

    public InstanceStatus getInitialStatus() {
        return this.initialStatus;
    }

    public void setInitialStatus(InstanceStatus initialStatus) {
        this.initialStatus = initialStatus;
    }

    public String getMetadataCollectionId() {
        return this.metadataCollectionId;
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
    }

    public String getMetadataCollectionName() {
        return this.metadataCollectionName;
    }

    public void setMetadataCollectionName(String metadataCollectionName) {
        this.metadataCollectionName = metadataCollectionName;
    }

    public String toString() {
        return "EntityCreateRequest{entityTypeGUID='" + this.entityTypeGUID + "', initialProperties=" + String.valueOf(this.initialProperties) + ", initialClassifications=" + String.valueOf(this.initialClassifications) + ", initialStatus=" + String.valueOf(this.initialStatus) + "', metadataCollectionId='" + this.metadataCollectionId + "', metadataCollectionName='" + this.metadataCollectionName + "'}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof EntityCreateRequest)) {
            return false;
        }
        EntityCreateRequest that = (EntityCreateRequest)objectToCompare;
        return Objects.equals(this.getEntityTypeGUID(), that.getEntityTypeGUID()) && Objects.equals(this.getInitialProperties(), that.getInitialProperties()) && Objects.equals(this.getInitialClassifications(), that.getInitialClassifications()) && this.getInitialStatus() == that.getInitialStatus() && Objects.equals(this.getMetadataCollectionId(), that.getMetadataCollectionId()) && Objects.equals(this.getMetadataCollectionName(), that.getMetadataCollectionName());
    }

    public int hashCode() {
        return Objects.hash(this.getEntityTypeGUID(), this.getInitialProperties(), this.getInitialClassifications(), this.getInitialStatus());
    }
}

