/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.designmodels.base;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.archiveutilities.designmodels.base.properties.ConceptModelDecoration;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveGUIDMap;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;

public class DesignModelArchiveBuilder {
    private static final String guidMapFileNamePostFix = "GUIDMap.json";
    private static final String GLOSSARY_TYPE_NAME = "Glossary";
    private static final String EXTERNAL_GLOSSARY_LINK_TYPE_NAME = "ExternalGlossaryLink";
    private static final String EXTERNALLY_SOURCED_GLOSSARY_TYPE_NAME = "ExternallySourcedGlossary";
    private static final String CANONICAL_VOCABULARY_TYPE_NAME = "CanonicalVocabulary";
    private static final String GLOSSARY_CATEGORY_TYPE_NAME = "GlossaryCategory";
    private static final String SUBJECT_AREA_TYPE_NAME = "SubjectArea";
    private static final String CATEGORY_ANCHOR_TYPE_NAME = "CategoryAnchor";
    private static final String CATEGORY_HIERARCHY_LINK_TYPE_NAME = "CategoryHierarchyLink";
    private static final String GLOSSARY_TERM_TYPE_NAME = "GlossaryTerm";
    private static final String TERM_ANCHOR_TYPE_NAME = "TermAnchor";
    private static final String TERM_CATEGORIZATION_TYPE_NAME = "TermCategorization";
    private static final String SEMANTIC_ASSIGNMENT_TYPE_NAME = "TermAnchor";
    private static final String MORE_INFORMATION_TYPE_NAME = "MoreInformation";
    private static final String DESIGN_MODEL_TYPE_NAME = "DesignModel";
    private static final String DESIGN_MODEL_GROUP_TYPE_NAME = "DesignModelGroup";
    private static final String DESIGN_MODEL_ELEMENT_OWNERSHIP_TYPE_NAME = "DesignModelElementOwnership";
    private static final String DESIGN_MODEL_GROUP_OWNERSHIP_TYPE_NAME = "DesignModelGroupOwnership";
    private static final String DESIGN_MODEL_GROUP_HIERARCHY_TYPE_NAME = "DesignModelGroupHierarchy";
    private static final String DESIGN_MODEL_GROUP_MEMBERSHIP_TYPE_NAME = "DesignModelGroupMembership";
    private static final String CONCEPT_BEAD_TYPE_NAME = "ConceptBead";
    private static final String CONCEPT_BEAD_LINK_TYPE_NAME = "ConceptBeadLink";
    private static final String CONCEPT_BEAD_ATTRIBUTE_TYPE_NAME = "ConceptBeadAttribute";
    private static final String CONCEPT_BEAD_ATTRIBUTE_LINK_TYPE_NAME = "ConceptBeadAttributeLink";
    private static final String CONCEPT_BEAD_RELATIONSHIP_TYPE_NAME = "ConceptBeadRelationshipEnd";
    private static final String SPINE_OBJECT_NAME = "SpineObject";
    private static final String SPINE_ATTRIBUTE_NAME = "SpineAttribute";
    private static final String ISA_RELATIONSHIP_NAME = "ISARelationship";
    private static final String HAS_A_RELATIONSHIP_NAME = "TermHASARelationship";
    private static final String RELATED_TERM_RELATIONSHIP_NAME = "RelatedTerm";
    private static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";
    private static final String NAME_PROPERTY = "Name";
    private static final String EXAMPLES_PROPERTY = "examples";
    private static final String TECHNICAL_NAME_PROPERTY = "technicalName";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String LANGUAGE_PROPERTY = "language";
    private static final String USAGE_PROPERTY = "usage";
    private static final String SCOPE_PROPERTY = "scope";
    private static final String URL_PROPERTY = "url";
    private static final String ORGANIZATION_PROPERTY = "organization";
    private static final String VERSION_PROPERTY = "version";
    private static final String VERSION_NUMBER_PROPERTY = "versionNumber";
    private static final String STATUS_PROPERTY = "status";
    private static final String CONFIDENCE_PROPERTY = "confidence";
    private static final String AUTHOR_PROPERTY = "author";
    private static final String ATTRIBUTE_NAME_PROPERTY = "attribute";
    private static final String DECORATION_PROPERTY = "decoration";
    private static final String POSITION_PROPERTY = "position";
    private static final String MIN_CARDINALITY_PROPERTY = "minCardinality";
    private static final String MAX_CARDINALITY_PROPERTY = "maxCardinality";
    private static final String UNIQUE_VALUES_PROPERTY = "uniqueValues";
    private static final String ORDERED_VALUES_PROPERTY = "orderedValues";
    private static final String NAVIGABLE_PROPERTY = "navigable";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;
    private OMRSArchiveGUIDMap idToGUIDMap;
    private String archiveRootName;
    private String originatorName;
    private String versionName;
    protected boolean writeToFile = true;

    protected DesignModelArchiveBuilder(String archiveGUID, String archiveName, String archiveDescription, OpenMetadataArchiveType archiveType, String archiveRootName, String originatorName, String originatorLicense, Date creationDate, long versionNumber, String versionName) {
        this.initialize(archiveGUID, archiveName, archiveDescription, archiveType, archiveRootName, originatorName, originatorLicense, creationDate, versionNumber, versionName);
    }

    protected void initialize(String archiveGUID, String archiveName, String archiveDescription, OpenMetadataArchiveType archiveType, String archiveRootName, String originatorName, String originatorLicense, Date creationDate, long versionNumber, String versionName) {
        ArrayList<OpenMetadataArchive> dependentOpenMetadataArchives = new ArrayList<OpenMetadataArchive>();
        dependentOpenMetadataArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, originatorLicense, creationDate, dependentOpenMetadataArchives);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, versionNumber, versionName);
        this.archiveRootName = archiveRootName;
        this.originatorName = originatorName;
        this.versionName = versionName;
        this.idToGUIDMap = new OMRSArchiveGUIDMap(archiveRootName + guidMapFileNamePostFix);
    }

    public DesignModelArchiveBuilder() {
    }

    protected String addGlossary(String qualifiedName, String displayName, String description, String language, String usage, String externalLink, String scope) {
        String methodName = "addGlossary";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, LANGUAGE_PROPERTY, language, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, USAGE_PROPERTY, usage, "addGlossary");
        ArrayList<Classification> classifications = null;
        if (scope != null) {
            Classification canonicalVocabClassification = this.archiveHelper.getClassification(CANONICAL_VOCABULARY_TYPE_NAME, this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, SCOPE_PROPERTY, scope, "addGlossary"), InstanceStatus.ACTIVE);
            classifications = new ArrayList<Classification>();
            classifications.add(canonicalVocabClassification);
        }
        EntityDetail glossaryEntity = this.archiveHelper.getEntityDetail(GLOSSARY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(glossaryEntity);
        if (externalLink != null) {
            String externalLinkQualifiedName = qualifiedName + "_external_link";
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, externalLinkQualifiedName, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, URL_PROPERTY, externalLink, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ORGANIZATION_PROPERTY, this.originatorName, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, VERSION_PROPERTY, this.versionName, "addGlossary");
            EntityDetail externalLinkEntity = this.archiveHelper.getEntityDetail(EXTERNAL_GLOSSARY_LINK_TYPE_NAME, this.idToGUIDMap.getGUID(externalLinkQualifiedName), properties, InstanceStatus.ACTIVE, classifications);
            this.archiveBuilder.addEntity(externalLinkEntity);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(glossaryEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(externalLinkEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(EXTERNALLY_SOURCED_GLOSSARY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_link_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return glossaryEntity.getGUID();
    }

    protected String addCategory(String glossaryId, String qualifiedName, String displayName, String description, String subjectArea) {
        String methodName = "addCategory";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addCategory");
        ArrayList<Classification> classifications = null;
        if (subjectArea != null) {
            Classification subjectAreaClassification = this.archiveHelper.getClassification(SUBJECT_AREA_TYPE_NAME, this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, NAME_PROPERTY, subjectArea, "addCategory"), InstanceStatus.ACTIVE);
            classifications = new ArrayList<Classification>();
            classifications.add(subjectAreaClassification);
        }
        EntityDetail categoryEntity = this.archiveHelper.getEntityDetail(GLOSSARY_CATEGORY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(categoryEntity);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(glossaryId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(categoryEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CATEGORY_ANCHOR_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_anchor_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        return categoryEntity.getGUID();
    }

    protected String addTerm(String glossaryId, List<String> categoryIds, String qualifiedName, String displayName, String description) {
        return this.addTerm(glossaryId, categoryIds, qualifiedName, displayName, description, null, false, false, false);
    }

    protected String addTerm(String glossaryId, List<String> categoryIds, String qualifiedName, String displayName, String description, String examples, boolean isSpineObject, boolean isSpineAttribute, boolean categoriesAsNames) {
        Classification subjectAreaClassification;
        String methodName = "addTerm";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addTerm");
        if (examples != null) {
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, EXAMPLES_PROPERTY, examples, "addTerm");
        }
        ArrayList<Classification> classifications = null;
        if (isSpineObject) {
            subjectAreaClassification = this.archiveHelper.getClassification(SPINE_OBJECT_NAME, null, InstanceStatus.ACTIVE);
            classifications = new ArrayList<Classification>();
            classifications.add(subjectAreaClassification);
        }
        if (isSpineAttribute) {
            subjectAreaClassification = this.archiveHelper.getClassification(SPINE_ATTRIBUTE_NAME, null, InstanceStatus.ACTIVE);
            classifications = new ArrayList();
            classifications.add(subjectAreaClassification);
        }
        EntityDetail termEntity = this.archiveHelper.getEntityDetail(GLOSSARY_TERM_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(termEntity);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(glossaryId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(termEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("TermAnchor", this.idToGUIDMap.getGUID(qualifiedName + "_anchor_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        if (categoryIds != null) {
            for (String categoryId : categoryIds) {
                if (categoryId == null) continue;
                if (categoriesAsNames) {
                    categoryId = this.idToGUIDMap.getGUID(categoryId);
                }
                end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(categoryId));
                this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(TERM_CATEGORIZATION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_category_" + categoryId + "_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
            }
        }
        return termEntity.getGUID();
    }

    protected void addCategoryToCategory(String parentCategoryId, String childCategoryId) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(parentCategoryId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(childCategoryId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CATEGORY_HIERARCHY_LINK_TYPE_NAME, this.idToGUIDMap.getGUID(parentCategoryId + "_to_" + childCategoryId), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void addMoreInformationLink(String describedElementId, String describerElementId) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(describedElementId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(describerElementId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(MORE_INFORMATION_TYPE_NAME, this.idToGUIDMap.getGUID(describedElementId + "_to_" + describerElementId), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void linkTermToReferenceable(String termId, String referenceableId) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(referenceableId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("TermAnchor", this.idToGUIDMap.getGUID(referenceableId + "_to_" + termId), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected String addDesignModel(String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author) {
        String methodName = "addDesignModel";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TECHNICAL_NAME_PROPERTY, technicalName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, VERSION_NUMBER_PROPERTY, versionNumber, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, AUTHOR_PROPERTY, author, "addDesignModel");
        EntityDetail modelEntity = this.archiveHelper.getEntityDetail(DESIGN_MODEL_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(modelEntity);
        return modelEntity.getGUID();
    }

    protected String addDesignModelGroup(String modelId, String parentGroupId, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author) {
        EntityProxy end2;
        EntityProxy end1;
        String methodName = "addDesignModelGroup";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addDesignModelGroup");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addDesignModelGroup");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TECHNICAL_NAME_PROPERTY, technicalName, "addDesignModelGroup");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addDesignModelGroup");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, VERSION_NUMBER_PROPERTY, versionNumber, "addDesignModelGroup");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, AUTHOR_PROPERTY, author, "addDesignModelGroup");
        EntityDetail modelGroupEntity = this.archiveHelper.getEntityDetail(DESIGN_MODEL_GROUP_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(modelGroupEntity);
        if (modelId != null) {
            end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(modelId));
            end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(modelGroupEntity.getGUID()));
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_ELEMENT_OWNERSHIP_TYPE_NAME, this.idToGUIDMap.getGUID(modelId + "_to_" + modelGroupEntity.getGUID()), null, InstanceStatus.ACTIVE, end1, end2));
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_GROUP_OWNERSHIP_TYPE_NAME, this.idToGUIDMap.getGUID(modelId + "_to_" + modelGroupEntity.getGUID()), null, InstanceStatus.ACTIVE, end1, end2));
        }
        if (parentGroupId != null) {
            end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(parentGroupId));
            end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(modelGroupEntity.getGUID()));
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_GROUP_HIERARCHY_TYPE_NAME, this.idToGUIDMap.getGUID(parentGroupId + "_to_" + modelGroupEntity.getGUID()), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return modelGroupEntity.getGUID();
    }

    protected String addConceptModelElement(String typeName, String modelId, List<String> groupIds, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author) {
        String methodName = "addConceptModelElement";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConceptModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConceptModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TECHNICAL_NAME_PROPERTY, technicalName, "addConceptModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConceptModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, VERSION_NUMBER_PROPERTY, versionNumber, "addConceptModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, AUTHOR_PROPERTY, author, "addConceptModelElement");
        EntityDetail modelElementEntity = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(modelElementEntity);
        if (modelId != null) {
            EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(modelId));
            EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(modelElementEntity.getGUID()));
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_ELEMENT_OWNERSHIP_TYPE_NAME, this.idToGUIDMap.getGUID(modelId + "_to_" + modelElementEntity.getGUID()), null, InstanceStatus.ACTIVE, end1, end2));
        }
        if (groupIds != null) {
            for (String groupId : groupIds) {
                EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(groupId));
                EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(modelElementEntity.getGUID()));
                this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_GROUP_MEMBERSHIP_TYPE_NAME, this.idToGUIDMap.getGUID(groupId + "_to_" + modelElementEntity.getGUID()), null, InstanceStatus.ACTIVE, end1, end2));
            }
        }
        return modelElementEntity.getGUID();
    }

    protected String addConceptBead(String modelId, List<String> groupIds, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author) {
        return this.addConceptModelElement(CONCEPT_BEAD_TYPE_NAME, modelId, groupIds, qualifiedName, displayName, technicalName, description, versionNumber, author);
    }

    protected String addConceptBeadLink(String modelId, List<String> groupIds, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author) {
        return this.addConceptModelElement(CONCEPT_BEAD_LINK_TYPE_NAME, modelId, groupIds, qualifiedName, displayName, technicalName, description, versionNumber, author);
    }

    protected String addConceptBeadAttribute(String modelId, List<String> groupIds, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author) {
        return this.addConceptModelElement(CONCEPT_BEAD_ATTRIBUTE_TYPE_NAME, modelId, groupIds, qualifiedName, displayName, technicalName, description, versionNumber, author);
    }

    protected void addAttributeToBead(String beadId, String attributeId, int position, int minCardinality, int maxCardinality, boolean uniqueValues, boolean orderedValues) {
        String methodName = "addAttributeToBead";
        InstanceProperties properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, null, POSITION_PROPERTY, position, "addAttributeToBead");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MIN_CARDINALITY_PROPERTY, minCardinality, "addAttributeToBead");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MAX_CARDINALITY_PROPERTY, maxCardinality, "addAttributeToBead");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, UNIQUE_VALUES_PROPERTY, uniqueValues, "addAttributeToBead");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, ORDERED_VALUES_PROPERTY, orderedValues, "addAttributeToBead");
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(beadId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(attributeId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONCEPT_BEAD_ATTRIBUTE_LINK_TYPE_NAME, this.idToGUIDMap.getGUID(beadId + "_to_" + attributeId), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void addLinkToBead(String beadId, String linkId, String attributeName, ConceptModelDecoration decoration, int position, int minCardinality, int maxCardinality, boolean uniqueValues, boolean orderedValues) {
        String methodName = "addLinkToBead";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, ATTRIBUTE_NAME_PROPERTY, attributeName, "addLinkToBead");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, POSITION_PROPERTY, position, "addLinkToBead");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MIN_CARDINALITY_PROPERTY, minCardinality, "addLinkToBead");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MAX_CARDINALITY_PROPERTY, maxCardinality, "addLinkToBead");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, UNIQUE_VALUES_PROPERTY, uniqueValues, "addLinkToBead");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, ORDERED_VALUES_PROPERTY, orderedValues, "addLinkToBead");
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(beadId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(linkId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONCEPT_BEAD_RELATIONSHIP_TYPE_NAME, this.idToGUIDMap.getGUID(beadId + "_to_" + linkId), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void addISARelationship(String specialTermQName, String generalizedTermQName) {
        String specializedTermId = this.idToGUIDMap.getGUID(specialTermQName);
        String generalizedTermId = this.idToGUIDMap.getGUID(generalizedTermQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(generalizedTermId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(specializedTermId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(ISA_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(generalizedTermId + "_to_" + specializedTermId), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void addHasARelationship(String conceptQName, String propertyQName) {
        String conceptId = this.idToGUIDMap.getGUID(conceptQName);
        String propertyId = this.idToGUIDMap.getGUID(propertyQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(propertyId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(conceptId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(HAS_A_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(conceptId + "_to_" + propertyId + "_hasa"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void addRelatedTermRelationship(String conceptQName, String propertyQName) {
        String conceptId = this.idToGUIDMap.getGUID(conceptQName);
        String propertyId = this.idToGUIDMap.getGUID(propertyQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(conceptId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(propertyId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(RELATED_TERM_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(conceptId + "_to_" + propertyId + "_related"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void addCategoryHierarchy(String childCategoryName, Set<String> parentNames) {
        String childId = this.idToGUIDMap.getGUID(childCategoryName);
        for (String parentName : parentNames) {
            String parentId = this.idToGUIDMap.getGUID(parentName);
            this.addCategoryToCategory(parentId, childId);
        }
    }

    protected OpenMetadataArchive getOpenMetadataArchive() {
        System.out.println("GUIDs map size: " + this.idToGUIDMap.getSize());
        if (this.writeToFile) {
            this.idToGUIDMap.saveGUIDs();
        }
        return this.archiveBuilder.getOpenMetadataArchive();
    }

    protected void logBadArchiveContent(String methodName) {
        this.archiveBuilder.logBadArchiveContent(methodName);
    }
}

