/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.designmodel.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.designmodel.api.DataDesignInterface;
import org.odpi.openmetadata.accessservices.designmodel.client.DesignModelClientBase;
import org.odpi.openmetadata.accessservices.designmodel.ffdc.DesignModelAuditCode;
import org.odpi.openmetadata.commonservices.mermaid.DataClassMermaidGraphBuilder;
import org.odpi.openmetadata.commonservices.mermaid.DataFieldMermaidGraphBuilder;
import org.odpi.openmetadata.commonservices.mermaid.DataStructureMermaidGraphBuilder;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.converters.DataClassConverter;
import org.odpi.openmetadata.frameworks.openmetadata.converters.DataFieldConverter;
import org.odpi.openmetadata.frameworks.openmetadata.converters.DataStructureConverter;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataClassElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataFieldElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataStructureElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MemberDataField;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.openmetadata.properties.datadictionaries.DataClassProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.datadictionaries.DataFieldProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.datadictionaries.DataStructureProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.datadictionaries.MemberDataFieldProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class DataDesignManager
extends DesignModelClientBase
implements DataDesignInterface {
    public DataDesignManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public DataDesignManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public String createDataStructure(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, DataStructureProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createDataStructure";
        String propertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDataStructure");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createDataStructure");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createDataStructure");
        String elementTypeName = OpenMetadataType.DATA_STRUCTURE.typeName;
        if (properties.getTypeName() != null) {
            elementTypeName = properties.getTypeName();
        }
        return this.openMetadataStoreClient.createMetadataElementInStore(userId, externalSourceGUID, externalSourceName, elementTypeName, ElementStatus.ACTIVE, null, anchorGUID, isOwnAnchor, null, properties.getEffectiveFrom(), properties.getEffectiveTo(), this.getElementProperties(properties), parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public String createDataStructureFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.createMetadataElementFromTemplate(userId, externalSourceGUID, externalSourceName, OpenMetadataType.DATA_STRUCTURE.typeName, anchorGUID, isOwnAnchor, anchorScopeGUID, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void updateDataStructure(String userId, String externalSourceGUID, String externalSourceName, String dataStructureGUID, boolean replaceAllProperties, DataStructureProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateDataStructure";
        String propertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        String guidParameterName = "dataStructureGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateDataStructure");
        this.invalidParameterHandler.validateGUID(dataStructureGUID, "dataStructureGUID", "updateDataStructure");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateDataStructure");
        if (replaceAllProperties) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateDataStructure");
        }
        this.openMetadataStoreClient.updateMetadataElementInStore(userId, externalSourceGUID, externalSourceName, dataStructureGUID, replaceAllProperties, forLineage, forDuplicateProcessing, this.getElementProperties(properties), effectiveTime);
    }

    public void linkMemberDataField(String userId, String externalSourceGUID, String externalSourceName, String parentDataStructureGUID, String memberDataFieldGUID, MemberDataFieldProperties relationshipProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkMemberDataField";
        String end1GUIDParameterName = "parentDataStructureGUID";
        String end2GUIDParameterName = "memberDataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkMemberDataField");
        this.invalidParameterHandler.validateGUID(parentDataStructureGUID, "parentDataStructureGUID", "linkMemberDataField");
        this.invalidParameterHandler.validateGUID(memberDataFieldGUID, "memberDataFieldGUID", "linkMemberDataField");
        if (relationshipProperties != null) {
            this.openMetadataStoreClient.createRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.MEMBER_DATA_FIELD_RELATIONSHIP.typeName, parentDataStructureGUID, memberDataFieldGUID, forLineage, forDuplicateProcessing, relationshipProperties.getEffectiveFrom(), relationshipProperties.getEffectiveTo(), this.getElementProperties(relationshipProperties), effectiveTime);
        } else {
            this.openMetadataStoreClient.createRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.MEMBER_DATA_FIELD_RELATIONSHIP.typeName, parentDataStructureGUID, memberDataFieldGUID, forLineage, forDuplicateProcessing, null, null, null, effectiveTime);
        }
    }

    public void detachMemberDataField(String userId, String externalSourceGUID, String externalSourceName, String parentDataStructureGUID, String nestedDataFieldGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "detachMemberDataField";
        String end1GUIDParameterName = "parentDataStructureGUID";
        String end2GUIDParameterName = "nestedDataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachMemberDataField");
        this.invalidParameterHandler.validateGUID(parentDataStructureGUID, "parentDataStructureGUID", "detachMemberDataField");
        this.invalidParameterHandler.validateGUID(nestedDataFieldGUID, "nestedDataFieldGUID", "detachMemberDataField");
        this.openMetadataStoreClient.detachRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.MEMBER_DATA_FIELD_RELATIONSHIP.typeName, parentDataStructureGUID, nestedDataFieldGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void deleteDataStructure(String userId, String externalSourceGUID, String externalSourceName, String dataStructureGUID, boolean cascadedDelete, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteDataStructure";
        String guidParameterName = "dataStructureGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteDataStructure");
        this.invalidParameterHandler.validateGUID(dataStructureGUID, "dataStructureGUID", "deleteDataStructure");
        this.openMetadataStoreClient.deleteMetadataElementInStore(userId, externalSourceGUID, externalSourceName, dataStructureGUID, cascadedDelete, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public List<DataStructureElement> getDataStructuresByName(String userId, String name, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getDataStructuresByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDataStructuresByName");
        this.invalidParameterHandler.validateName(name, "name", "getDataStructuresByName");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDataStructuresByName");
        List<String> propertyNames = Arrays.asList(OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataProperty.DISPLAY_NAME.name);
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, OpenMetadataType.DATA_STRUCTURE.typeName, null, this.propertyHelper.getSearchPropertiesByName(propertyNames, name, PropertyComparisonOperator.EQ), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertDataStructures(userId, openMetadataElements, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "getDataStructuresByName");
    }

    public DataStructureElement getDataStructureByGUID(String userId, String dataStructureGUID, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getDataStructureByGUID";
        String guidParameterName = "dataStructureGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataStructureByGUID");
        this.invalidParameterHandler.validateGUID(dataStructureGUID, "dataStructureGUID", "getDataStructureByGUID");
        OpenMetadataElement openMetadataElement = this.openMetadataStoreClient.getMetadataElementByGUID(userId, dataStructureGUID, forLineage, forDuplicateProcessing, asOfTime, effectiveTime);
        if (openMetadataElement != null && this.propertyHelper.isTypeOf((ElementControlHeader)openMetadataElement, OpenMetadataType.DATA_STRUCTURE.typeName)) {
            return this.convertDataStructure(userId, openMetadataElement, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "getDataStructureByGUID");
        }
        return null;
    }

    public List<DataStructureElement> findDataStructures(String userId, String searchString, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDataStructures";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDataStructures");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDataStructures");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDataStructures");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElementsWithString(userId, searchString, OpenMetadataType.DATA_STRUCTURE.typeName, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertDataStructures(userId, openMetadataElements, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "findDataStructures");
    }

    public String createDataField(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, DataFieldProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createDataField";
        String propertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDataField");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createDataField");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createDataField");
        String elementTypeName = OpenMetadataType.DATA_FIELD.typeName;
        if (properties.getTypeName() != null) {
            elementTypeName = properties.getTypeName();
        }
        return this.openMetadataStoreClient.createMetadataElementInStore(userId, externalSourceGUID, externalSourceName, elementTypeName, ElementStatus.ACTIVE, null, anchorGUID, isOwnAnchor, null, properties.getEffectiveFrom(), properties.getEffectiveTo(), this.getElementProperties(properties), parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public String createDataFieldFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.createMetadataElementFromTemplate(userId, externalSourceGUID, externalSourceName, OpenMetadataType.DATA_FIELD.typeName, anchorGUID, isOwnAnchor, anchorScopeGUID, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void updateDataField(String userId, String externalSourceGUID, String externalSourceName, String dataFieldGUID, boolean replaceAllProperties, DataFieldProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateDataField";
        String propertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        String guidParameterName = "dataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateDataField");
        this.invalidParameterHandler.validateGUID(dataFieldGUID, "dataFieldGUID", "updateDataField");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateDataField");
        if (replaceAllProperties) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateDataField");
        }
        this.openMetadataStoreClient.updateMetadataElementInStore(userId, externalSourceGUID, externalSourceName, dataFieldGUID, replaceAllProperties, forLineage, forDuplicateProcessing, this.getElementProperties(properties), effectiveTime);
    }

    public void linkNestedDataFields(String userId, String externalSourceGUID, String externalSourceName, String parentDataFieldGUID, String nestedDataFieldGUID, MemberDataFieldProperties relationshipProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkNestedDataFields";
        String end1GUIDParameterName = "parentDataFieldGUID";
        String end2GUIDParameterName = "nestedDataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkNestedDataFields");
        this.invalidParameterHandler.validateGUID(parentDataFieldGUID, "parentDataFieldGUID", "linkNestedDataFields");
        this.invalidParameterHandler.validateGUID(nestedDataFieldGUID, "nestedDataFieldGUID", "linkNestedDataFields");
        if (relationshipProperties != null) {
            this.openMetadataStoreClient.createRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.NESTED_DATA_FIELD_RELATIONSHIP.typeName, parentDataFieldGUID, nestedDataFieldGUID, forLineage, forDuplicateProcessing, relationshipProperties.getEffectiveFrom(), relationshipProperties.getEffectiveTo(), this.getElementProperties(relationshipProperties), effectiveTime);
        } else {
            this.openMetadataStoreClient.createRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.NESTED_DATA_FIELD_RELATIONSHIP.typeName, parentDataFieldGUID, nestedDataFieldGUID, forLineage, forDuplicateProcessing, null, null, null, effectiveTime);
        }
    }

    public void detachNestedDataFields(String userId, String externalSourceGUID, String externalSourceName, String parentDataFieldGUID, String nestedDataFieldGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "detachNestedDataFields";
        String end1GUIDParameterName = "parentDataFieldGUID";
        String end2GUIDParameterName = "nestedDataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachNestedDataFields");
        this.invalidParameterHandler.validateGUID(parentDataFieldGUID, "parentDataFieldGUID", "detachNestedDataFields");
        this.invalidParameterHandler.validateGUID(nestedDataFieldGUID, "nestedDataFieldGUID", "detachNestedDataFields");
        this.openMetadataStoreClient.detachRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.NESTED_DATA_FIELD_RELATIONSHIP.typeName, parentDataFieldGUID, nestedDataFieldGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void deleteDataField(String userId, String externalSourceGUID, String externalSourceName, String dataFieldGUID, boolean cascadedDelete, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteDataField";
        String guidParameterName = "dataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteDataField");
        this.invalidParameterHandler.validateGUID(dataFieldGUID, "dataFieldGUID", "deleteDataField");
        this.openMetadataStoreClient.deleteMetadataElementInStore(userId, externalSourceGUID, externalSourceName, dataFieldGUID, cascadedDelete, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public List<DataFieldElement> getDataFieldsByName(String userId, String name, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getDataFieldsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDataFieldsByName");
        this.invalidParameterHandler.validateName(name, "name", "getDataFieldsByName");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDataFieldsByName");
        List<String> propertyNames = Arrays.asList(OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataProperty.DISPLAY_NAME.name);
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, OpenMetadataType.DATA_FIELD.typeName, null, this.propertyHelper.getSearchPropertiesByName(propertyNames, name, PropertyComparisonOperator.EQ), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertDataFields(userId, openMetadataElements, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "getDataFieldsByName");
    }

    public DataFieldElement getDataFieldByGUID(String userId, String dataFieldGUID, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getDataFieldByGUID";
        String guidParameterName = "dataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataFieldByGUID");
        this.invalidParameterHandler.validateGUID(dataFieldGUID, "dataFieldGUID", "getDataFieldByGUID");
        OpenMetadataElement openMetadataElement = this.openMetadataStoreClient.getMetadataElementByGUID(userId, dataFieldGUID, forLineage, forDuplicateProcessing, asOfTime, effectiveTime);
        if (openMetadataElement != null && this.propertyHelper.isTypeOf((ElementControlHeader)openMetadataElement, OpenMetadataType.DATA_FIELD.typeName)) {
            return this.convertDataField(userId, openMetadataElement, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "getDataFieldByGUID");
        }
        return null;
    }

    public List<DataFieldElement> findDataFields(String userId, String searchString, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDataFields";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDataFields");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDataFields");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDataFields");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElementsWithString(userId, searchString, OpenMetadataType.DATA_FIELD.typeName, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertDataFields(userId, openMetadataElements, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "findDataFields");
    }

    public String createDataClass(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, DataClassProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createDataClass";
        String propertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDataClass");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createDataClass");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createDataClass");
        String elementTypeName = OpenMetadataType.DATA_CLASS.typeName;
        if (properties.getTypeName() != null) {
            elementTypeName = properties.getTypeName();
        }
        return this.openMetadataStoreClient.createMetadataElementInStore(userId, externalSourceGUID, externalSourceName, elementTypeName, ElementStatus.ACTIVE, null, anchorGUID, isOwnAnchor, null, properties.getEffectiveFrom(), properties.getEffectiveTo(), this.getElementProperties(properties), parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public String createDataClassFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.createMetadataElementFromTemplate(userId, externalSourceGUID, externalSourceName, OpenMetadataType.DATA_CLASS.typeName, anchorGUID, isOwnAnchor, anchorScopeGUID, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void updateDataClass(String userId, String externalSourceGUID, String externalSourceName, String dataClassGUID, boolean replaceAllProperties, DataClassProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateDataClass";
        String propertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        String guidParameterName = "dataClassGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateDataClass");
        this.invalidParameterHandler.validateGUID(dataClassGUID, "dataClassGUID", "updateDataClass");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateDataClass");
        if (replaceAllProperties) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateDataClass");
        }
        this.openMetadataStoreClient.updateMetadataElementInStore(userId, externalSourceGUID, externalSourceName, dataClassGUID, replaceAllProperties, forLineage, forDuplicateProcessing, this.getElementProperties(properties), effectiveTime);
    }

    public void linkNestedDataClass(String userId, String externalSourceGUID, String externalSourceName, String parentDataClassGUID, String childDataClassGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkNestedDataClass";
        String end1GUIDParameterName = "parentDataClassGUID";
        String end2GUIDParameterName = "childDataClassGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkNestedDataClass");
        this.invalidParameterHandler.validateGUID(parentDataClassGUID, "parentDataClassGUID", "linkNestedDataClass");
        this.invalidParameterHandler.validateGUID(childDataClassGUID, "childDataClassGUID", "linkNestedDataClass");
        this.openMetadataStoreClient.createRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.DATA_CLASS_COMPOSITION.typeName, parentDataClassGUID, childDataClassGUID, forLineage, forDuplicateProcessing, null, null, null, effectiveTime);
    }

    public void detachNestedDataClass(String userId, String externalSourceGUID, String externalSourceName, String parentDataClassGUID, String childDataClassGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "detachNestedDataClass";
        String end1GUIDParameterName = "parentDataClassGUID";
        String end2GUIDParameterName = "childDataClassGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachNestedDataClass");
        this.invalidParameterHandler.validateGUID(parentDataClassGUID, "parentDataClassGUID", "detachNestedDataClass");
        this.invalidParameterHandler.validateGUID(childDataClassGUID, "childDataClassGUID", "detachNestedDataClass");
        this.openMetadataStoreClient.detachRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.DATA_CLASS_COMPOSITION.typeName, parentDataClassGUID, childDataClassGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void linkSpecialistDataClass(String userId, String externalSourceGUID, String externalSourceName, String parentDataClassGUID, String childDataClassGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkSpecialistDataClass";
        String end1GUIDParameterName = "parentDataClassGUID";
        String end2GUIDParameterName = "childDataClassGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkSpecialistDataClass");
        this.invalidParameterHandler.validateGUID(parentDataClassGUID, "parentDataClassGUID", "linkSpecialistDataClass");
        this.invalidParameterHandler.validateGUID(childDataClassGUID, "childDataClassGUID", "linkSpecialistDataClass");
        this.openMetadataStoreClient.createRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.DATA_CLASS_HIERARCHY.typeName, parentDataClassGUID, childDataClassGUID, forLineage, forDuplicateProcessing, null, null, null, effectiveTime);
    }

    public void detachSpecialistDataClass(String userId, String externalSourceGUID, String externalSourceName, String parentDataClassGUID, String childDataClassGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "detachSpecialistDataClass";
        String end1GUIDParameterName = "parentDataClassGUID";
        String end2GUIDParameterName = "childDataClassGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachSpecialistDataClass");
        this.invalidParameterHandler.validateGUID(parentDataClassGUID, "parentDataClassGUID", "detachSpecialistDataClass");
        this.invalidParameterHandler.validateGUID(childDataClassGUID, "childDataClassGUID", "detachSpecialistDataClass");
        this.openMetadataStoreClient.detachRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.DATA_CLASS_HIERARCHY.typeName, parentDataClassGUID, childDataClassGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void deleteDataClass(String userId, String externalSourceGUID, String externalSourceName, String dataClassGUID, boolean cascadedDelete, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteDataClass";
        String guidParameterName = "dataClassGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteDataClass");
        this.invalidParameterHandler.validateGUID(dataClassGUID, "dataClassGUID", "deleteDataClass");
        this.openMetadataStoreClient.deleteMetadataElementInStore(userId, externalSourceGUID, externalSourceName, dataClassGUID, cascadedDelete, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public List<DataClassElement> getDataClassesByName(String userId, String name, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getDataClassesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDataClassesByName");
        this.invalidParameterHandler.validateName(name, "name", "getDataClassesByName");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDataClassesByName");
        List<String> propertyNames = Arrays.asList(OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataProperty.DISPLAY_NAME.name);
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, OpenMetadataType.DATA_CLASS.typeName, null, this.propertyHelper.getSearchPropertiesByName(propertyNames, name, PropertyComparisonOperator.EQ), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertDataClasses(userId, openMetadataElements, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "getDataClassesByName");
    }

    public DataClassElement getDataClassByGUID(String userId, String dataClassGUID, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getDataClassByGUID";
        String guidParameterName = "dataClassGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataClassByGUID");
        this.invalidParameterHandler.validateGUID(dataClassGUID, "dataClassGUID", "getDataClassByGUID");
        OpenMetadataElement openMetadataElement = this.openMetadataStoreClient.getMetadataElementByGUID(userId, dataClassGUID, forLineage, forDuplicateProcessing, asOfTime, effectiveTime);
        if (openMetadataElement != null && this.propertyHelper.isTypeOf((ElementControlHeader)openMetadataElement, OpenMetadataType.DATA_CLASS.typeName)) {
            return this.convertDataClass(userId, openMetadataElement, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "getDataClassByGUID");
        }
        return null;
    }

    public List<DataClassElement> findDataClasses(String userId, String searchString, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDataClasses";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDataClasses");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDataClasses");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDataClasses");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElementsWithString(userId, searchString, OpenMetadataType.DATA_CLASS.typeName, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertDataClasses(userId, openMetadataElements, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "findDataClasses");
    }

    public void linkDataClassDefinition(String userId, String externalSourceGUID, String externalSourceName, String dataDefinitionGUID, String dataClassGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkDataClassDefinition";
        String end1GUIDParameterName = "dataDefinitionGUID";
        String end2GUIDParameterName = "dataClassGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkDataClassDefinition");
        this.invalidParameterHandler.validateGUID(dataDefinitionGUID, "dataDefinitionGUID", "linkDataClassDefinition");
        this.invalidParameterHandler.validateGUID(dataClassGUID, "dataClassGUID", "linkDataClassDefinition");
        this.openMetadataStoreClient.createRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.DATA_CLASS_DEFINITION_RELATIONSHIP.typeName, dataDefinitionGUID, dataClassGUID, forLineage, forDuplicateProcessing, null, null, null, effectiveTime);
    }

    public void detachDataClassDefinition(String userId, String externalSourceGUID, String externalSourceName, String dataDefinitionGUID, String dataClassGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "detachDataClassDefinition";
        String end1GUIDParameterName = "dataDefinitionGUID";
        String end2GUIDParameterName = "dataClassGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachDataClassDefinition");
        this.invalidParameterHandler.validateGUID(dataDefinitionGUID, "dataDefinitionGUID", "detachDataClassDefinition");
        this.invalidParameterHandler.validateGUID(dataClassGUID, "dataClassGUID", "detachDataClassDefinition");
        this.openMetadataStoreClient.detachRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.DATA_CLASS_DEFINITION_RELATIONSHIP.typeName, dataDefinitionGUID, dataClassGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void linkSemanticDefinition(String userId, String externalSourceGUID, String externalSourceName, String dataDefinitionGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkSemanticDefinition";
        String end1GUIDParameterName = "parentDataClassGUID";
        String end2GUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkSemanticDefinition");
        this.invalidParameterHandler.validateGUID(dataDefinitionGUID, "parentDataClassGUID", "linkSemanticDefinition");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "linkSemanticDefinition");
        this.openMetadataStoreClient.createRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.SEMANTIC_DEFINITION_RELATIONSHIP.typeName, dataDefinitionGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, null, null, null, effectiveTime);
    }

    public void detachSemanticDefinition(String userId, String externalSourceGUID, String externalSourceName, String dataDefinitionGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "detachSemanticDefinition";
        String end1GUIDParameterName = "dataDefinitionGUID";
        String end2GUIDParameterName = "glossaryTermGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachSemanticDefinition");
        this.invalidParameterHandler.validateGUID(dataDefinitionGUID, "dataDefinitionGUID", "detachSemanticDefinition");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "detachSemanticDefinition");
        this.openMetadataStoreClient.detachRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.SEMANTIC_DEFINITION_RELATIONSHIP.typeName, dataDefinitionGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void linkCertificationTypeToDataStructure(String userId, String externalSourceGUID, String externalSourceName, String certificationTypeGUID, String dataStructureGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkCertificationTypeToDataStructure";
        String end1GUIDParameterName = "certificationTypeGUID";
        String end2GUIDParameterName = "dataStructureGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkCertificationTypeToDataStructure");
        this.invalidParameterHandler.validateGUID(certificationTypeGUID, "certificationTypeGUID", "linkCertificationTypeToDataStructure");
        this.invalidParameterHandler.validateGUID(dataStructureGUID, "dataStructureGUID", "linkCertificationTypeToDataStructure");
        this.openMetadataStoreClient.createRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.DATA_STRUCTURE_DEFINITION_RELATIONSHIP.typeName, certificationTypeGUID, dataStructureGUID, forLineage, forDuplicateProcessing, null, null, null, effectiveTime);
    }

    public void detachCertificationTypeToDataStructure(String userId, String externalSourceGUID, String externalSourceName, String certificationTypeGUID, String dataStructureGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "detachCertificationTypeToDataStructure";
        String end1GUIDParameterName = "certificationTypeGUID";
        String end2GUIDParameterName = "dataStructureGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachCertificationTypeToDataStructure");
        this.invalidParameterHandler.validateGUID(certificationTypeGUID, "certificationTypeGUID", "detachCertificationTypeToDataStructure");
        this.invalidParameterHandler.validateGUID(dataStructureGUID, "dataStructureGUID", "detachCertificationTypeToDataStructure");
        this.openMetadataStoreClient.detachRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.DATA_STRUCTURE_DEFINITION_RELATIONSHIP.typeName, certificationTypeGUID, dataStructureGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    private ElementProperties getElementProperties(DataStructureProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, properties.getQualifiedName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DISPLAY_NAME.name, properties.getDisplayName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NAMESPACE.name, properties.getNamespace());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.VERSION_IDENTIFIER.name, properties.getVersionIdentifier());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, properties.getAdditionalProperties());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(DataFieldProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, properties.getQualifiedName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DISPLAY_NAME.name, properties.getDisplayName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NAMESPACE.name, properties.getNamespace());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.VERSION_IDENTIFIER.name, properties.getVersionIdentifier());
            elementProperties = this.propertyHelper.addStringArrayProperty(elementProperties, OpenMetadataProperty.ALIASES.name, properties.getAliases());
            elementProperties = this.propertyHelper.addStringArrayProperty(elementProperties, OpenMetadataProperty.NAME_PATTERNS.name, properties.getNamePatterns());
            elementProperties = this.propertyHelper.addBooleanProperty(elementProperties, OpenMetadataProperty.IS_DEPRECATED.name, properties.getIsDeprecated());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DEFAULT_VALUE.name, properties.getDefaultValue());
            elementProperties = this.propertyHelper.addBooleanProperty(elementProperties, OpenMetadataProperty.IS_NULLABLE.name, properties.getIsNullable());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DATA_TYPE.name, properties.getDataType());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.UNITS.name, properties.getUnits());
            elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.MINIMUM_LENGTH.name, properties.getMinimumLength());
            elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.LENGTH.name, properties.getLength());
            elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.PRECISION.name, properties.getPrecision());
            elementProperties = this.propertyHelper.addBooleanProperty(elementProperties, OpenMetadataProperty.ORDERED_VALUES.name, properties.getOrderedValues());
            if (properties.getSortOrder() != null) {
                elementProperties = this.propertyHelper.addEnumProperty(elementProperties, OpenMetadataProperty.SORT_ORDER.name, DataItemSortOrder.getOpenTypeName(), properties.getSortOrder().getName());
            }
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, properties.getAdditionalProperties());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(MemberDataFieldProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addIntProperty(null, OpenMetadataProperty.POSITION.name, properties.getDataFieldPosition());
            elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.MAX_CARDINALITY.name, properties.getMaxCardinality());
            elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.MIN_CARDINALITY.name, properties.getMaxCardinality());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(DataClassProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, properties.getQualifiedName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DISPLAY_NAME.name, properties.getDisplayName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NAMESPACE.name, properties.getNamespace());
            elementProperties = this.propertyHelper.addStringArrayProperty(elementProperties, OpenMetadataProperty.MATCH_PROPERTY_NAMES.name, properties.getMatchPropertyNames());
            elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.MATCH_THRESHOLD.name, properties.getMatchThreshold());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.SPECIFICATION.name, properties.getSpecification());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.SPECIFICATION_DETAILS.name, properties.getSpecificationDetails());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DATA_TYPE.name, properties.getDataType());
            elementProperties = this.propertyHelper.addBooleanProperty(elementProperties, OpenMetadataProperty.ALLOWS_DUPLICATE_VALUES.name, properties.getAllowsDuplicateValues());
            elementProperties = this.propertyHelper.addBooleanProperty(elementProperties, OpenMetadataProperty.IS_CASE_SENSITIVE.name, properties.getIsCaseSensitive());
            elementProperties = this.propertyHelper.addBooleanProperty(elementProperties, OpenMetadataProperty.IS_NULLABLE.name, properties.getIsNullable());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DEFAULT_VALUE.name, properties.getDefaultValue());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.AVERAGE_VALUE.name, properties.getAverageValue());
            elementProperties = this.propertyHelper.addStringArrayProperty(elementProperties, OpenMetadataProperty.VALUE_LIST.name, properties.getValueList());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.VALUE_RANGE_FROM.name, properties.getValueRangeFrom());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.VALUE_RANGE_TO.name, properties.getValueRangeTo());
            elementProperties = this.propertyHelper.addStringArrayProperty(elementProperties, OpenMetadataProperty.SAMPLE_VALUES.name, properties.getSampleValues());
            elementProperties = this.propertyHelper.addStringArrayProperty(elementProperties, OpenMetadataProperty.DATA_PATTERNS.name, properties.getDataPatterns());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, properties.getAdditionalProperties());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private List<DataStructureElement> convertDataStructures(String userId, List<OpenMetadataElement> openMetadataElements, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        if (openMetadataElements != null) {
            ArrayList<DataStructureElement> dataStructureElements = new ArrayList<DataStructureElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                dataStructureElements.add(this.convertDataStructure(userId, openMetadataElement, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
            return dataStructureElements;
        }
        return null;
    }

    private DataStructureElement convertDataStructure(String userId, OpenMetadataElement openMetadataElement, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        try {
            ArrayList<MemberDataField> relatedFields = new ArrayList<MemberDataField>();
            ArrayList<RelatedMetadataElement> otherRelatedElements = new ArrayList<RelatedMetadataElement>();
            int startFrom = 0;
            RelatedMetadataElementList relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 0, null, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom, this.invalidParameterHandler.getMaxPagingSize());
            while (relatedMetadataElementList != null && relatedMetadataElementList.getElementList() != null) {
                for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList.getElementList()) {
                    if (relatedMetadataElement == null) continue;
                    if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, OpenMetadataType.MEMBER_DATA_FIELD_RELATIONSHIP.typeName)) {
                        relatedFields.add(this.convertMemberDataField(userId, relatedMetadataElement, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                        continue;
                    }
                    otherRelatedElements.add(relatedMetadataElement);
                }
                relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 0, null, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize());
            }
            DataStructureConverter converter = new DataStructureConverter(this.propertyHelper, this.serviceName, this.serverName);
            DataStructureElement dataStructureElement = (DataStructureElement)converter.getNewComplexBean(DataStructureElement.class, openMetadataElement, otherRelatedElements, methodName);
            if (dataStructureElement != null) {
                if (!relatedFields.isEmpty()) {
                    dataStructureElement.setMemberDataFields(relatedFields);
                }
                DataStructureMermaidGraphBuilder graphBuilder = new DataStructureMermaidGraphBuilder(dataStructureElement);
                dataStructureElement.setMermaidGraph(graphBuilder.getMermaidGraph());
            }
            return dataStructureElement;
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logMessage(methodName, DesignModelAuditCode.UNEXPECTED_CONVERTER_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), methodName, error.getMessage()}));
            }
            return null;
        }
    }

    private List<DataFieldElement> convertDataFields(String userId, List<OpenMetadataElement> openMetadataElements, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        if (openMetadataElements != null) {
            ArrayList<DataFieldElement> dataFieldElements = new ArrayList<DataFieldElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                dataFieldElements.add(this.convertDataField(userId, openMetadataElement, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
            return dataFieldElements;
        }
        return null;
    }

    private DataFieldElement convertDataField(String userId, OpenMetadataElement openMetadataElement, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        try {
            ArrayList<MemberDataField> relatedFields = new ArrayList<MemberDataField>();
            ArrayList<RelatedMetadataElement> otherRelatedElements = new ArrayList<RelatedMetadataElement>();
            int startFrom = 0;
            RelatedMetadataElementList relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 0, null, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom, this.invalidParameterHandler.getMaxPagingSize());
            while (relatedMetadataElementList != null && relatedMetadataElementList.getElementList() != null) {
                for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList.getElementList()) {
                    if (relatedMetadataElement == null) continue;
                    if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, OpenMetadataType.NESTED_DATA_FIELD_RELATIONSHIP.typeName) && !relatedMetadataElement.getElementAtEnd1()) {
                        relatedFields.add(this.convertMemberDataField(userId, relatedMetadataElement, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                        continue;
                    }
                    otherRelatedElements.add(relatedMetadataElement);
                }
                relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 0, null, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize());
            }
            DataFieldConverter converter = new DataFieldConverter(this.propertyHelper, this.serviceName, this.serverName);
            DataFieldElement dataFieldElement = (DataFieldElement)converter.getNewComplexBean(DataFieldElement.class, openMetadataElement, otherRelatedElements, methodName);
            if (dataFieldElement != null) {
                if (!relatedFields.isEmpty()) {
                    dataFieldElement.setNestedDataFields(relatedFields);
                }
                DataFieldMermaidGraphBuilder graphBuilder = new DataFieldMermaidGraphBuilder(dataFieldElement);
                dataFieldElement.setMermaidGraph(graphBuilder.getMermaidGraph());
            }
            return dataFieldElement;
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logMessage(methodName, DesignModelAuditCode.UNEXPECTED_CONVERTER_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), methodName, error.getMessage()}));
            }
            return null;
        }
    }

    private MemberDataField convertMemberDataField(String userId, RelatedMetadataElement startingMetadataElement, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        if (startingMetadataElement != null) {
            MemberDataField memberDataField = new MemberDataField(this.convertDataField(userId, startingMetadataElement.getElement(), asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            DataFieldConverter converter = new DataFieldConverter(this.propertyHelper, this.serviceName, this.serverName);
            memberDataField.setMemberDataFieldProperties(converter.getMemberDataFieldProperties(startingMetadataElement));
            return memberDataField;
        }
        return null;
    }

    private List<DataClassElement> convertDataClasses(String userId, List<OpenMetadataElement> openMetadataElements, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        if (openMetadataElements != null) {
            ArrayList<DataClassElement> dataClassElements = new ArrayList<DataClassElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                dataClassElements.add(this.convertDataClass(userId, openMetadataElement, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
            return dataClassElements;
        }
        return null;
    }

    private DataClassElement convertDataClass(String userId, OpenMetadataElement openMetadataElement, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        try {
            RelatedMetadataElementList relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 0, null, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, 0, this.invalidParameterHandler.getMaxPagingSize());
            DataClassConverter converter = new DataClassConverter(this.propertyHelper, this.serviceName, this.serverName);
            DataClassElement dataClassElement = (DataClassElement)converter.getNewComplexBean(DataClassElement.class, openMetadataElement, relatedMetadataElementList, methodName);
            if (dataClassElement != null) {
                DataClassMermaidGraphBuilder graphBuilder = new DataClassMermaidGraphBuilder(dataClassElement);
                dataClassElement.setMermaidGraph(graphBuilder.getMermaidGraph());
            }
            return dataClassElement;
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logMessage(methodName, DesignModelAuditCode.UNEXPECTED_CONVERTER_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), methodName, error.getMessage()}));
            }
            return null;
        }
    }
}

