/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.designmodel.client;

import org.odpi.openmetadata.accessservices.designmodel.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;

abstract class DesignModelClientBase {
    protected final String serviceName = AccessServiceDescription.DESIGN_MODEL_OMAS.getAccessServiceFullName();
    String serverName;
    String serverPlatformURLRoot;
    AuditLog auditLog;
    InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    final OpenMetadataStoreClient openMetadataStoreClient;
    final PropertyHelper propertyHelper = new PropertyHelper();

    public DesignModelClientBase(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public DesignModelClientBase(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }
}

