/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.devops.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.devops.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.devops.properties.ITInfrastructureProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SoftwareServerProperties
extends ITInfrastructureProperties {
    private static final long serialVersionUID = 1L;
    private static final String deployedImplementationTypeProperty = "deployedImplementationType";
    private static final String versionProperty = "serverVersion";
    private static final String sourceProperty = "source";
    private static final String userIdProperty = "userId";
    private String softwareServerType = null;
    private String softwareServerVersion = null;
    private String softwareServerSource = null;
    private String softwareServerUserId = null;

    public SoftwareServerProperties() {
    }

    public SoftwareServerProperties(SoftwareServerProperties template) {
        super(template);
        if (template != null) {
            this.softwareServerType = template.getSoftwareServerType();
            this.softwareServerVersion = template.getSoftwareServerVersion();
            this.softwareServerSource = template.getSoftwareServerSource();
            this.softwareServerUserId = template.getSoftwareServerUserId();
        }
    }

    public SoftwareServerProperties(AssetProperties template) {
        super(template);
        Map<String, Object> assetExtendedProperties;
        if (template != null && (assetExtendedProperties = template.getExtendedProperties()) != null) {
            if (assetExtendedProperties.get(deployedImplementationTypeProperty) != null) {
                this.softwareServerType = assetExtendedProperties.get(deployedImplementationTypeProperty).toString();
                assetExtendedProperties.remove(deployedImplementationTypeProperty);
            }
            if (assetExtendedProperties.get(versionProperty) != null) {
                this.softwareServerVersion = assetExtendedProperties.get(versionProperty).toString();
                assetExtendedProperties.remove(versionProperty);
            }
            if (assetExtendedProperties.get(sourceProperty) != null) {
                this.softwareServerSource = assetExtendedProperties.get(sourceProperty).toString();
                assetExtendedProperties.remove(sourceProperty);
            }
            if (assetExtendedProperties.get(userIdProperty) != null) {
                this.softwareServerUserId = assetExtendedProperties.get(userIdProperty).toString();
                assetExtendedProperties.remove(userIdProperty);
            }
            super.setExtendedProperties(assetExtendedProperties);
        }
    }

    public AssetProperties cloneToAsset() {
        return this.cloneToAsset("SoftwareServer");
    }

    @Override
    public AssetProperties cloneToAsset(String subTypeName) {
        AssetProperties assetProperties = super.cloneToAsset(subTypeName);
        Map<String, Object> assetExtendedProperties = assetProperties.getExtendedProperties();
        if (assetExtendedProperties == null) {
            assetExtendedProperties = new HashMap<String, Object>();
        }
        if (this.softwareServerType != null) {
            assetExtendedProperties.put(deployedImplementationTypeProperty, this.softwareServerType);
        }
        if (this.softwareServerVersion != null) {
            assetExtendedProperties.put(versionProperty, this.softwareServerVersion);
        }
        if (this.softwareServerSource != null) {
            assetExtendedProperties.put(sourceProperty, this.softwareServerSource);
        }
        if (this.softwareServerUserId != null) {
            assetExtendedProperties.put(userIdProperty, this.softwareServerUserId);
        }
        if (!assetExtendedProperties.isEmpty()) {
            assetProperties.setExtendedProperties(assetExtendedProperties);
        }
        return assetProperties;
    }

    public String getSoftwareServerType() {
        return this.softwareServerType;
    }

    public void setSoftwareServerType(String softwareServerType) {
        this.softwareServerType = softwareServerType;
    }

    public String getSoftwareServerVersion() {
        return this.softwareServerVersion;
    }

    public void setSoftwareServerVersion(String softwareServerVersion) {
        this.softwareServerVersion = softwareServerVersion;
    }

    public String getSoftwareServerSource() {
        return this.softwareServerSource;
    }

    public void setSoftwareServerSource(String softwareServerSource) {
        this.softwareServerSource = softwareServerSource;
    }

    public String getSoftwareServerUserId() {
        return this.softwareServerUserId;
    }

    public void setSoftwareServerUserId(String softwareServerUserId) {
        this.softwareServerUserId = softwareServerUserId;
    }

    @Override
    public String toString() {
        return "SoftwareServerProperties{softwareServerType='" + this.softwareServerType + "', softwareServerVersion='" + this.softwareServerVersion + "', softwareServerSource='" + this.softwareServerSource + "', softwareServerUserId='" + this.softwareServerUserId + "', displayName='" + this.getDisplayName() + "', description='" + this.getDescription() + "', effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SoftwareServerProperties that = (SoftwareServerProperties)objectToCompare;
        return Objects.equals(this.softwareServerType, that.softwareServerType) && Objects.equals(this.softwareServerVersion, that.softwareServerVersion) && Objects.equals(this.softwareServerSource, that.softwareServerSource) && Objects.equals(this.softwareServerUserId, that.softwareServerUserId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.softwareServerType, this.softwareServerVersion, this.softwareServerSource, this.softwareServerUserId);
    }
}

