/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.devops.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.devops.properties.ByteOrdering;
import org.odpi.openmetadata.accessservices.devops.properties.ConfigurationItemProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OperatingPlatformProperties
extends ConfigurationItemProperties {
    private static final long serialVersionUID = 1L;
    private String displayName = null;
    private String description = null;
    private String operatingSystem = null;
    private ByteOrdering byteOrdering = null;

    public OperatingPlatformProperties() {
    }

    public OperatingPlatformProperties(OperatingPlatformProperties template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.operatingSystem = template.getOperatingSystem();
            this.byteOrdering = template.getByteOrdering();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public ByteOrdering getByteOrdering() {
        return this.byteOrdering;
    }

    public void setByteOrdering(ByteOrdering byteOrdering) {
        this.byteOrdering = byteOrdering;
    }

    @Override
    public String toString() {
        return "OperatingPlatformProperties{displayName='" + this.displayName + "', description='" + this.description + "', operatingSystem='" + this.operatingSystem + "', byteOrdering=" + this.byteOrdering + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        OperatingPlatformProperties that = (OperatingPlatformProperties)objectToCompare;
        return Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.operatingSystem, that.operatingSystem) && this.byteOrdering == that.byteOrdering;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.displayName, this.description, this.operatingSystem, this.byteOrdering);
    }
}

