/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.devopspipeline.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum DevopsPipelineAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMVS-DEVOPS-PIPELINE-0001", AuditLogRecordSeverityLevel.STARTUP, "The Devops Pipeline Open Metadata View Service (OMVS) is initializing", "The local server is initializing the Devops Pipeline Open Metadata View Service. If the initialization is successful then audit message OMVS-DEVOPS-PIPELINE-0002 will be issued, if there were errors then they should be shown in the audit log. ", "No action is required. This is part of the normal operation of the Devops Pipeline Open Metadata View Service."),
    SERVICE_INITIALIZED("OMVS-DEVOPS-PIPELINE-0002", AuditLogRecordSeverityLevel.STARTUP, "The Devops Pipeline Open Metadata View Service (OMVS) is initialized", "The Devops Pipeline OMVS has completed initialization. Calls will be accepted by this service, if OMRS is also configured and the view server has been started. ", "No action is required.  This is part of the normal operation of the Devops Pipeline Open Metadata View Service. Once the OMRS is configured and the server is started, Devops Pipeline view service requests can be accepted."),
    SERVICE_SHUTDOWN("OMVS-DEVOPS-PIPELINE-0003", AuditLogRecordSeverityLevel.SHUTDOWN, "The Devops Pipeline Open Metadata View Service (OMVS) is shutting down", "The local server has requested shutdown of the Devops Pipeline OMVS.", "No action is required. The operator should verify that shutdown was intended. This is part of the normal operation of the Devops Pipeline OMVS."),
    SERVICE_INSTANCE_FAILURE("OMVS-DEVOPS-PIPELINE-0004", AuditLogRecordSeverityLevel.EXCEPTION, "The Devops Pipeline Open Metadata View Service (OMVS) is unable to initialize a new instance; error message is {0}", "The view service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    SERVICE_TERMINATING("OMVS-DEVOPS-PIPELINE-0005", AuditLogRecordSeverityLevel.SHUTDOWN, "The Devops Pipeline Open Metadata View Service (OMVS) is shutting down server instance {0}", "The local handler has requested shut down of the Devops Pipeline OMVS.", "No action is required. This is part of the normal operation of the service."),
    UNEXPECTED_EXCEPTION("OMVS-DEVOPS-PIPELINE-0006", AuditLogRecordSeverityLevel.EXCEPTION, "The Open Metadata Service has generated an unexpected {0} exception during method {1}.  The message was: {2}", "The request returned an Exception.", "This is probably a logic error. Review the stack trace to identify where the error occurred and work to resolve the cause.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private DevopsPipelineAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "DevopsPipelineAuditCode{logMessageId='" + this.logMessageId + "', severity=" + String.valueOf(this.severity) + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "', messageDefinition=" + String.valueOf(this.getMessageDefinition()) + "}";
    }
}

