/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum DigitalServiceImplementationStyle implements Serializable
{
    UNCLASSIFIED(0, "Unclassified", "The digital service implementation style is undefined."),
    API(1, "API", "The digital service provides one or more APIs."),
    PERSONAL_APP(2, "Personal App", "The digital service provides a user interface via a client application that is owned and installed by the end user."),
    BROWSER_APP(3, "Browser App", "The digital service provides a user interface via a browser."),
    LOCATION_APP(4, "Location App", "The digital service is installed at a specific location."),
    INFRASTRUCTURE_APP(5, "Infrastructure App", "The digital service is installed as part of some infrastructure."),
    DATA_FEED(6, "Data Feed", "The digital service continuously produces data that consumers can subscribe to."),
    DATA_SINK(7, "Data Sink", "The digital service is receiving and accumulating data from other digital services."),
    CLIENT_SERVER(8, "Client-Server", "The digital service provides a thick client tightly coupled with a backend server."),
    OTHER(99, "Other", "The digital service's implementation style is locally defined.");

    private static final long serialVersionUID = 1L;
    private int ordinal;
    private String name;
    private String description;

    private DigitalServiceImplementationStyle(int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "DigitalServiceImplementationStyle{ordinal=" + this.ordinal + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

