/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.ffdc.exceptions;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DigitalArchitectureRuntimeException
extends RuntimeException {
    private int reportedHTTPCode;
    private String reportingClassName;
    private String reportingActionDescription;
    private String reportedErrorMessage;
    private String reportedSystemAction;
    private String reportedUserAction;
    private Map<String, Object> relatedProperties;
    private Throwable reportedCaughtException = null;

    public DigitalArchitectureRuntimeException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Map<String, Object> relatedProperties) {
        super(errorMessage);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.relatedProperties = relatedProperties;
    }

    public DigitalArchitectureRuntimeException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError, Map<String, Object> relatedProperties) {
        super(errorMessage, caughtError);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.reportedCaughtException = caughtError;
        this.relatedProperties = relatedProperties;
    }

    public int getReportedHTTPCode() {
        return this.reportedHTTPCode;
    }

    public String getReportingClassName() {
        return this.reportingClassName;
    }

    public String getReportingActionDescription() {
        return this.reportingActionDescription;
    }

    public String getErrorMessage() {
        return this.reportedErrorMessage;
    }

    public String getReportedSystemAction() {
        return this.reportedSystemAction;
    }

    public String getReportedUserAction() {
        return this.reportedUserAction;
    }

    public Throwable getReportedCaughtException() {
        return this.reportedCaughtException;
    }

    public Map<String, Object> getRelatedProperties() {
        if (this.relatedProperties == null) {
            return null;
        }
        if (this.relatedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.relatedProperties);
    }

    @Override
    public String toString() {
        return "DigitalArchitectureRuntimeException{reportedHTTPCode=" + this.reportedHTTPCode + ", reportingClassName='" + this.reportingClassName + '\'' + ", reportingActionDescription='" + this.reportingActionDescription + '\'' + ", reportedErrorMessage='" + this.reportedErrorMessage + '\'' + ", reportedSystemAction='" + this.reportedSystemAction + '\'' + ", reportedUserAction='" + this.reportedUserAction + '\'' + ", reportedCaughtException=" + this.reportedCaughtException + ", relatedProperties=" + this.relatedProperties + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof DigitalArchitectureRuntimeException)) {
            return false;
        }
        DigitalArchitectureRuntimeException that = (DigitalArchitectureRuntimeException)objectToCompare;
        return this.getReportedHTTPCode() == that.getReportedHTTPCode() && Objects.equals(this.getReportingClassName(), that.getReportingClassName()) && Objects.equals(this.getReportingActionDescription(), that.getReportingActionDescription()) && Objects.equals(this.getErrorMessage(), that.getErrorMessage()) && Objects.equals(this.getReportedSystemAction(), that.getReportedSystemAction()) && Objects.equals(this.getReportedUserAction(), that.getReportedUserAction()) && Objects.equals(this.getRelatedProperties(), that.getRelatedProperties()) && Objects.equals(this.getReportedCaughtException(), that.getReportedCaughtException());
    }

    public int hashCode() {
        return Objects.hash(this.getReportedHTTPCode(), this.getReportingClassName(), this.getReportingActionDescription(), this.getErrorMessage(), this.getReportedSystemAction(), this.getReportedUserAction(), this.getRelatedProperties(), this.getReportedCaughtException());
    }
}

