/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.OwnerCategory;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ReferenceDataAssetProperties
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private String displayName = null;
    protected String description = null;
    protected String owner = null;
    protected OwnerCategory ownerCategory = null;
    protected List<String> zoneMembership = null;
    protected Map<String, String> origin = null;
    protected String latestChange = null;

    public ReferenceDataAssetProperties() {
    }

    public ReferenceDataAssetProperties(ReferenceDataAssetProperties template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.owner = template.getOwner();
            this.ownerCategory = template.getOwnerCategory();
            this.zoneMembership = template.getZoneMembership();
            this.origin = template.getOrigin();
            this.latestChange = template.getLatestChange();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public OwnerCategory getOwnerCategory() {
        return this.ownerCategory;
    }

    public void setOwnerCategory(OwnerCategory ownerType) {
        this.ownerCategory = ownerType;
    }

    public List<String> getZoneMembership() {
        if (this.zoneMembership == null) {
            return null;
        }
        if (this.zoneMembership.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.zoneMembership);
    }

    public void setZoneMembership(List<String> zoneMembership) {
        this.zoneMembership = zoneMembership;
    }

    public Map<String, String> getOrigin() {
        if (this.origin == null) {
            return null;
        }
        if (this.origin.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.origin);
    }

    public void setOrigin(Map<String, String> origin) {
        this.origin = origin;
    }

    public String getLatestChange() {
        return this.latestChange;
    }

    public void setLatestChange(String latestChange) {
        this.latestChange = latestChange;
    }

    @Override
    public String toString() {
        return "ReferenceDataAssetProperties{displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", owner='" + this.owner + '\'' + ", ownerCategory=" + this.ownerCategory + ", zoneMembership=" + this.zoneMembership + ", origin=" + this.origin + ", latestChange='" + this.latestChange + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", meanings=" + this.getMeanings() + ", classifications=" + this.getClassifications() + ", typeName='" + this.getTypeName() + '\'' + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ReferenceDataAssetProperties asset = (ReferenceDataAssetProperties)objectToCompare;
        return Objects.equals(this.getDisplayName(), asset.getDisplayName()) && Objects.equals(this.getDescription(), asset.getDescription()) && Objects.equals(this.getOwner(), asset.getOwner()) && this.getOwnerCategory() == asset.getOwnerCategory() && Objects.equals(this.getZoneMembership(), asset.getZoneMembership()) && Objects.equals(this.getOrigin(), asset.getOrigin()) && Objects.equals(this.getLatestChange(), asset.getLatestChange());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDisplayName(), this.getDescription(), this.getOwner(), this.getOwnerCategory(), this.getZoneMembership(), this.getOrigin(), this.getLatestChange());
    }
}

