/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ElementClassification;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ElementOrigin;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ElementType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ElementHeader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String guid = null;
    private ElementType type = null;
    private ElementOrigin origin = null;
    private List<ElementClassification> classifications = null;

    public ElementHeader() {
    }

    public ElementHeader(ElementHeader template) {
        if (template != null) {
            this.guid = template.getGUID();
            this.type = template.getType();
            this.origin = template.getOrigin();
            this.classifications = template.getClassifications();
        }
    }

    public ElementType getType() {
        if (this.type == null) {
            return null;
        }
        return this.type;
    }

    public void setType(ElementType type) {
        this.type = type;
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    public ElementOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(ElementOrigin origin) {
        this.origin = origin;
    }

    public List<ElementClassification> getClassifications() {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        return new ArrayList<ElementClassification>(this.classifications);
    }

    public void setClassifications(List<ElementClassification> classifications) {
        this.classifications = classifications;
    }

    public String toString() {
        return "ElementHeader{guid='" + this.guid + '\'' + ", type=" + this.type + ", origin=" + this.origin + ", classifications=" + this.classifications + ", GUID='" + this.getGUID() + '\'' + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ElementHeader)) {
            return false;
        }
        ElementHeader that = (ElementHeader)objectToCompare;
        return Objects.equals(this.getType(), that.getType()) && Objects.equals(this.guid, that.guid) && Objects.equals(this.getOrigin(), that.getOrigin()) && Objects.equals(this.classifications, that.classifications);
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.type, this.origin, this.classifications);
    }
}

