/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EndpointProperties
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private String technicalName = null;
    private String technicalDescription = null;
    private String address = null;
    private String protocol = null;
    private String encryptionMethod = null;

    public EndpointProperties() {
    }

    public EndpointProperties(EndpointProperties template) {
        super(template);
        if (template != null) {
            this.technicalName = template.getTechnicalName();
            this.technicalDescription = template.getTechnicalDescription();
            this.address = template.getAddress();
            this.protocol = template.getProtocol();
            this.encryptionMethod = template.getEncryptionMethod();
        }
    }

    public void setTechnicalName(String technicalName) {
        this.technicalName = technicalName;
    }

    public String getTechnicalName() {
        return this.technicalName;
    }

    public void setTechnicalDescription(String technicalDescription) {
        this.technicalDescription = technicalDescription;
    }

    public String getTechnicalDescription() {
        return this.technicalDescription;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setEncryptionMethod(String encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
    }

    public String getEncryptionMethod() {
        return this.encryptionMethod;
    }

    @Override
    public String toString() {
        return "EndpointProperties{technicalName='" + this.technicalName + "', technicalDescription='" + this.technicalDescription + "', address='" + this.address + "', protocol='" + this.protocol + "', encryptionMethod='" + this.encryptionMethod + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", classifications=" + this.getClassifications() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        EndpointProperties that = (EndpointProperties)objectToCompare;
        return Objects.equals(this.technicalName, that.technicalName) && Objects.equals(this.technicalDescription, that.technicalDescription) && Objects.equals(this.address, that.address) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.encryptionMethod, that.encryptionMethod);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.technicalName, this.technicalDescription, this.address, this.protocol, this.encryptionMethod);
    }
}

