/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.CollectionOrder;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CollectionProperties
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private String description = null;
    private CollectionOrder collectionOrdering = null;
    private String orderPropertyName = null;

    public CollectionProperties() {
    }

    public CollectionProperties(CollectionProperties template) {
        super(template);
        if (template != null) {
            this.name = template.getName();
            this.description = template.getDescription();
            this.collectionOrdering = template.getCollectionOrdering();
            this.orderPropertyName = template.getOrderPropertyName();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CollectionOrder getCollectionOrdering() {
        return this.collectionOrdering;
    }

    public void setCollectionOrdering(CollectionOrder collectionOrdering) {
        this.collectionOrdering = collectionOrdering;
    }

    public String getOrderPropertyName() {
        return this.orderPropertyName;
    }

    public void setOrderPropertyName(String orderPropertyName) {
        this.orderPropertyName = orderPropertyName;
    }

    @Override
    public String toString() {
        return "CollectionProperties{name='" + this.name + "', description='" + this.description + "', collectionOrdering=" + this.collectionOrdering + ", orderPropertyName='" + this.orderPropertyName + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CollectionProperties that = (CollectionProperties)objectToCompare;
        return this.getCollectionOrdering() == that.getCollectionOrdering() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getOrderPropertyName(), that.getOrderPropertyName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getDescription(), this.getCollectionOrdering(), this.getOrderPropertyName());
    }
}

