/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Date;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CollectionMember
implements MetadataElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private ElementHeader elementHeader = null;
    private Date dateAddedToCollection = null;
    private String membershipRationale = null;
    private ReferenceableProperties properties = null;

    public CollectionMember() {
    }

    public CollectionMember(CollectionMember template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.dateAddedToCollection = template.getDateAddedToCollection();
            this.membershipRationale = template.getMembershipRationale();
            this.properties = template.getProperties();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public Date getDateAddedToCollection() {
        if (this.dateAddedToCollection == null) {
            return null;
        }
        return new Date(this.dateAddedToCollection.getTime());
    }

    public void setDateAddedToCollection(Date dateAddedToCollection) {
        this.dateAddedToCollection = dateAddedToCollection;
    }

    public String getMembershipRationale() {
        return this.membershipRationale;
    }

    public void setMembershipRationale(String membershipRationale) {
        this.membershipRationale = membershipRationale;
    }

    public ReferenceableProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ReferenceableProperties properties) {
        this.properties = properties;
    }

    public String toString() {
        return "CollectionMember{elementHeader=" + this.elementHeader + ", dateAddedToCollection=" + this.dateAddedToCollection + ", membershipRationale='" + this.membershipRationale + "', properties=" + this.properties + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof CollectionMember)) {
            return false;
        }
        CollectionMember that = (CollectionMember)objectToCompare;
        if (this.elementHeader != null ? !this.elementHeader.equals((Object)that.elementHeader) : that.elementHeader != null) {
            return false;
        }
        if (this.dateAddedToCollection != null ? !this.dateAddedToCollection.equals(that.dateAddedToCollection) : that.dateAddedToCollection != null) {
            return false;
        }
        if (this.membershipRationale != null ? !this.membershipRationale.equals(that.membershipRationale) : that.membershipRationale != null) {
            return false;
        }
        return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
    }

    public int hashCode() {
        int result = this.elementHeader != null ? this.elementHeader.hashCode() : 0;
        result = 31 * result + (this.dateAddedToCollection != null ? this.dateAddedToCollection.hashCode() : 0);
        result = 31 * result + (this.membershipRationale != null ? this.membershipRationale.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

