/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum CollectionMemberStatus {
    UNKNOWN(0, 0, "Unknown", "The status of the member is not known or not specified. This is the default value."),
    DISCOVERED(1, 1, "Discovered", "The member was added by a discovery process."),
    PROPOSED(2, 2, "Proposed", "The member was proposed by a consumer."),
    IMPORTED(3, 3, "Imported", "The member was imported from another system."),
    VALIDATED(4, 4, "Validated", "The member has been validated by a custodian/steward/approver and can be trusted."),
    DEPRECATED(5, 5, "Deprecated", "The membership has been deprecated. Consider stopping using it."),
    OBSOLETE(6, 6, "Obsolete", "The membership is obsolete and should not be used."),
    OTHER(99, 99, "Other", "The membership has a different status not covered by the open metadata types.");

    private static final String ENUM_TYPE_GUID = "a3bdb2ac-c28e-4e5a-8ab7-76aa01038832";
    private static final String ENUM_TYPE_NAME = "MembershipStatus";
    private final int openTypeOrdinal;
    private final int ordinal;
    private final String name;
    private final String description;

    private CollectionMemberStatus(int ordinal, int openTypeOrdinal, String name, String description) {
        this.ordinal = ordinal;
        this.openTypeOrdinal = openTypeOrdinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public String toString() {
        return "CollectionMemberStatus : " + this.name;
    }
}

