/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OrderBy;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CollectionProperties
extends ReferenceableProperties {
    private String name = null;
    private String description = null;
    private String collectionType = null;
    private OrderBy collectionOrder = null;
    private String orderByPropertyName = null;

    public CollectionProperties() {
    }

    public CollectionProperties(CollectionProperties template) {
        super(template);
        if (template != null) {
            this.name = template.getName();
            this.description = template.getDescription();
            this.collectionType = template.getCollectionType();
            this.collectionOrder = template.getCollectionOrder();
            this.orderByPropertyName = template.getOrderByPropertyName();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }

    public OrderBy getCollectionOrder() {
        return this.collectionOrder;
    }

    public void setCollectionOrder(OrderBy collectionOrder) {
        this.collectionOrder = collectionOrder;
    }

    public String getOrderByPropertyName() {
        return this.orderByPropertyName;
    }

    public void setOrderByPropertyName(String orderByPropertyName) {
        this.orderByPropertyName = orderByPropertyName;
    }

    @Override
    public String toString() {
        return "CollectionProperties{name='" + this.name + "', description='" + this.description + "', collectionType='" + this.collectionType + "', collectionOrdering=" + this.collectionOrder + ", orderPropertyName='" + this.orderByPropertyName + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CollectionProperties that = (CollectionProperties)objectToCompare;
        return this.getCollectionOrder() == that.getCollectionOrder() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getCollectionType(), that.getCollectionType()) && Objects.equals(this.getOrderByPropertyName(), that.getOrderByPropertyName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getDescription(), this.getCollectionType(), this.getCollectionOrder(), this.getOrderByPropertyName());
    }
}

