/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.digitalarchitecture.api.ManageValidValues;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.DigitalArchitectureClientBase;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.rest.DigitalArchitectureRESTClient;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ReferenceValueAssignmentDefinitionElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ReferenceValueAssignmentItemElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueAssignmentConsumerElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueAssignmentDefinitionElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueImplAssetElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueImplDefinitionElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueMappingElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValuesMappingElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ReferenceValueAssignmentProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValueAssignmentProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValueProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValuesImplProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValuesMappingProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ReferenceValueAssignmentDefinitionsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ReferenceValueAssignmentItemsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueAssignmentConsumersResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueAssignmentDefinitionsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueMappingsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesImplAssetsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesImplDefinitionsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesMappingsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class ValidValuesManager
extends DigitalArchitectureClientBase
implements ManageValidValues {
    public ValidValuesManager(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public ValidValuesManager(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public ValidValuesManager(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public ValidValuesManager(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public ValidValuesManager(String serverName, String serverPlatformURLRoot, DigitalArchitectureRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public String createValidValueSet(String userId, String qualifiedName, String displayName, String description, String usage, String scope, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createValidValueSet";
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createValidValueSet");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createValidValueSet");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/sets";
        ValidValueProperties requestBody = new ValidValueProperties();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setUsage(usage);
        requestBody.setScope(scope);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setTypeName(typeName);
        requestBody.setExtendedProperties(extendedProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createValidValueSet", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/sets", requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createValidValueDefinition(String userId, String setGUID, String qualifiedName, String displayName, String description, String usage, String scope, String preferredValue, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createValidValueDefinition";
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createValidValueDefinition");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createValidValueDefinition");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/sets/{2}";
        ValidValueProperties requestBody = new ValidValueProperties();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setUsage(usage);
        requestBody.setScope(scope);
        requestBody.setPreferredValue(preferredValue);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setTypeName(typeName);
        requestBody.setExtendedProperties(extendedProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createValidValueDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/sets/{2}", requestBody, new Object[]{this.serverName, userId, setGUID});
        return restResult.getGUID();
    }

    public void updateValidValue(String userId, String validValueGUID, String qualifiedName, String displayName, String description, String usage, String scope, String preferredValue, boolean isDeprecated, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateValidValue";
        String guidParameter = "validValueGUID";
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateValidValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "updateValidValue");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateValidValue");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/update";
        ValidValueProperties requestBody = new ValidValueProperties();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setUsage(usage);
        requestBody.setScope(scope);
        requestBody.setPreferredValue(preferredValue);
        requestBody.setIsDeprecated(isDeprecated);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        this.restClient.callVoidPostRESTCall("updateValidValue", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/update", requestBody, new Object[]{this.serverName, userId, validValueGUID});
    }

    public void deleteValidValue(String userId, String validValueGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteValidValue";
        String guidParameter = "validValueGUID";
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "deleteValidValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "deleteValidValue");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteValidValue");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/delete";
        this.restClient.callVoidPostRESTCall("deleteValidValue", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/delete", qualifiedName, new Object[]{this.serverName, userId, validValueGUID});
    }

    public void attachValidValueToSet(String userId, String setGUID, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachValidValueToSet";
        String setGUIDParameter = "setGUID";
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "attachValidValueToSet");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "attachValidValueToSet");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "attachValidValueToSet");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/sets/{2}/members/{3}";
        this.restClient.callVoidPostRESTCall("attachValidValueToSet", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/sets/{2}/members/{3}", nullRequestBody, new Object[]{this.serverName, userId, setGUID, validValueGUID});
    }

    public void detachValidValueFromSet(String userId, String setGUID, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachValidValueFromSet";
        String setGUIDParameter = "setGUID";
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachValidValueFromSet");
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", "detachValidValueFromSet");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "detachValidValueFromSet");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/sets/{2}/members/{3}/delete";
        this.restClient.callVoidPostRESTCall("detachValidValueFromSet", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/sets/{2}/members/{3}/delete", nullRequestBody, new Object[]{this.serverName, userId, setGUID, validValueGUID});
    }

    public void linkValidValueToImplementation(String userId, String validValueGUID, String assetGUID, String symbolicName, String implementationValue, Map<String, String> additionalValues) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkValidValueToImplementation";
        String validValueGUIDParameter = "validValueGUID";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkValidValueToImplementation");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "linkValidValueToImplementation");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "linkValidValueToImplementation");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/implementations/{3}";
        ValidValuesImplProperties requestBody = new ValidValuesImplProperties();
        requestBody.setSymbolicName(symbolicName);
        requestBody.setImplementationValue(implementationValue);
        requestBody.setAdditionalValues(additionalValues);
        this.restClient.callVoidPostRESTCall("linkValidValueToImplementation", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/implementations/{3}", requestBody, new Object[]{this.serverName, userId, validValueGUID, assetGUID});
    }

    public void classifyAssetAsReferenceData(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "classifyAssetAsReferenceData";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "classifyAssetAsReferenceData");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "classifyAssetAsReferenceData");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/assets/classify-as-reference-data";
        this.restClient.callVoidPostRESTCall("classifyAssetAsReferenceData", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/assets/classify-as-reference-data", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void unlinkValidValueFromImplementation(String userId, String validValueGUID, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkValidValueFromImplementation";
        String validValueGUIDParameter = "validValueGUID";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "unlinkValidValueFromImplementation");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "unlinkValidValueFromImplementation");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "unlinkValidValueFromImplementation");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/implementations/{3}/delete";
        this.restClient.callVoidPostRESTCall("unlinkValidValueFromImplementation", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/implementations/{3}/delete", nullRequestBody, new Object[]{this.serverName, userId, validValueGUID, assetGUID});
    }

    public void declassifyAssetAsReferenceData(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "declassifyAssetAsReferenceData";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "declassifyAssetAsReferenceData");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "declassifyAssetAsReferenceData");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/assets/declassify-as-reference-data";
        this.restClient.callVoidPostRESTCall("declassifyAssetAsReferenceData", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/assets/declassify-as-reference-data", nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void assignValidValueToConsumer(String userId, String validValueGUID, String consumerGUID, boolean strictRequirement) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "assignValidValueToConsumer";
        String validValueGUIDParameter = "validValueGUID";
        String consumerGUIDParameter = "consumerGUID";
        this.invalidParameterHandler.validateUserId(userId, "assignValidValueToConsumer");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "assignValidValueToConsumer");
        this.invalidParameterHandler.validateGUID(consumerGUID, "consumerGUID", "assignValidValueToConsumer");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/consumers/{3}";
        ValidValueAssignmentProperties requestBody = new ValidValueAssignmentProperties();
        requestBody.setStrictRequirement(strictRequirement);
        this.restClient.callVoidPostRESTCall("assignValidValueToConsumer", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/consumers/{3}", requestBody, new Object[]{this.serverName, userId, validValueGUID, consumerGUID});
    }

    public void unassignValidValueFromConsumer(String userId, String validValueGUID, String consumerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unassignValidValueFromConsumer";
        String validValueGUIDParameter = "validValueGUID";
        String consumerGUIDParameter = "consumerGUID";
        this.invalidParameterHandler.validateUserId(userId, "unassignValidValueFromConsumer");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "unassignValidValueFromConsumer");
        this.invalidParameterHandler.validateGUID(consumerGUID, "consumerGUID", "unassignValidValueFromConsumer");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/consumers/{3}/delete";
        this.restClient.callVoidPostRESTCall("unassignValidValueFromConsumer", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/consumers/{3}/delete", nullRequestBody, new Object[]{this.serverName, userId, validValueGUID, consumerGUID});
    }

    public void assignReferenceValueToItem(String userId, String validValueGUID, String referenceableGUID, int confidence, String steward, String notes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "assignReferenceValueToItem";
        String validValueGUIDParameter = "validValueGUID";
        String referenceableGUIDParameter = "referenceableGUID";
        this.invalidParameterHandler.validateUserId(userId, "assignReferenceValueToItem");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "assignReferenceValueToItem");
        this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", "assignReferenceValueToItem");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/reference-values/{2}/items/{3}";
        ReferenceValueAssignmentProperties requestBody = new ReferenceValueAssignmentProperties();
        requestBody.setConfidence(confidence);
        requestBody.setSteward(steward);
        requestBody.setNotes(notes);
        this.restClient.callVoidPostRESTCall("assignReferenceValueToItem", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/reference-values/{2}/items/{3}", requestBody, new Object[]{this.serverName, userId, validValueGUID, referenceableGUID});
    }

    public void unassignReferenceValueFromItem(String userId, String validValueGUID, String referenceableGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unassignReferenceValueFromItem";
        String validValueGUIDParameter = "validValueGUID";
        String referenceableGUIDParameter = "referenceableGUID";
        this.invalidParameterHandler.validateUserId(userId, "unassignReferenceValueFromItem");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "unassignReferenceValueFromItem");
        this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", "unassignReferenceValueFromItem");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/reference-values/{2}/items/{3}/delete";
        this.restClient.callVoidPostRESTCall("unassignReferenceValueFromItem", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/reference-values/{2}/items/{3}/delete", nullRequestBody, new Object[]{this.serverName, userId, validValueGUID, referenceableGUID});
    }

    public void mapValidValues(String userId, String validValue1GUID, String validValue2GUID, String associationDescription, int confidence, String steward, String notes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "mapValidValues";
        String validValue1GUIDParameter = "validValue1GUID";
        String validValue2GUIDParameter = "validValue2GUID";
        this.invalidParameterHandler.validateUserId(userId, "mapValidValues");
        this.invalidParameterHandler.validateGUID(validValue1GUID, "validValue1GUID", "mapValidValues");
        this.invalidParameterHandler.validateGUID(validValue2GUID, "validValue2GUID", "mapValidValues");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/map/{3}";
        ValidValuesMappingProperties requestBody = new ValidValuesMappingProperties();
        requestBody.setAssociationDescription(associationDescription);
        requestBody.setConfidence(confidence);
        requestBody.setSteward(steward);
        requestBody.setNotes(notes);
        this.restClient.callVoidPostRESTCall("mapValidValues", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/map/{3}", requestBody, new Object[]{this.serverName, userId, validValue1GUID, validValue2GUID});
    }

    public void unmapValidValues(String userId, String validValue1GUID, String validValue2GUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unmapValidValues";
        String validValue1GUIDParameter = "validValue1GUID";
        String validValue2GUIDParameter = "validValue2GUID";
        this.invalidParameterHandler.validateUserId(userId, "unmapValidValues");
        this.invalidParameterHandler.validateGUID(validValue1GUID, "validValue1GUID", "unmapValidValues");
        this.invalidParameterHandler.validateGUID(validValue2GUID, "validValue2GUID", "unmapValidValues");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/map/{3}/delete";
        this.restClient.callVoidPostRESTCall("unmapValidValues", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/map/{3}/delete", nullRequestBody, new Object[]{this.serverName, userId, validValue1GUID, validValue2GUID});
    }

    public ValidValueElement getValidValueByGUID(String userId, String validValueGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueByGUID";
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueByGUID");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getValidValueByGUID");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}";
        ValidValueResponse restResult = this.restClient.callValidValueGetRESTCall("getValidValueByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}", this.serverName, userId, validValueGUID);
        return restResult.getElement();
    }

    public List<ValidValueElement> getValidValueByName(String userId, String validValueName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueByName";
        String validValueNameParameter = "validValueName";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueByName");
        this.invalidParameterHandler.validateName(validValueName, "validValueName", "getValidValueByName");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(validValueName);
        requestBody.setNamePropertyName("validValueName");
        ValidValuesResponse restResult = this.restClient.callValidValuesPostRESTCall("getValidValueByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/by-name?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ValidValueElement> findValidValues(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findValidValues";
        String parameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findValidValues");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findValidValues");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findValidValues");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ValidValuesResponse restResult = this.restClient.callValidValuesPostRESTCall("findValidValues", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/by-search-string?startFrom={2}&pageSize={3}", requestBody, this.serverName, userId, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ValidValueElement> getValidValueSetMembers(String userId, String validValueSetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueSetMembers";
        String validValueGUIDParameter = "validValueSetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueSetMembers");
        this.invalidParameterHandler.validateGUID(validValueSetGUID, "validValueSetGUID", "getValidValueSetMembers");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValueSetMembers");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/sets/{2}/members?startFrom={3}&pageSize={4}";
        ValidValuesResponse restResult = this.restClient.callValidValuesGetRESTCall("getValidValueSetMembers", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/sets/{2}/members?startFrom={3}&pageSize={4}", this.serverName, userId, validValueSetGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ValidValueElement> getSetsForValidValue(String userId, String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSetsForValidValue";
        String validValueGUIDParameter = "validValueSetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSetsForValidValue");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueSetGUID", "getSetsForValidValue");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSetsForValidValue");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/set-membership?startFrom={3}&pageSize={4}";
        ValidValuesResponse restResult = this.restClient.callValidValuesGetRESTCall("getSetsForValidValue", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/set-membership?startFrom={3}&pageSize={4}", this.serverName, userId, validValueGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ValidValueAssignmentConsumerElement> getValidValuesAssignmentConsumers(String userId, String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValuesAssignmentConsumers";
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "getValidValuesAssignmentConsumers");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getValidValuesAssignmentConsumers");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValuesAssignmentConsumers");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/consumers?startFrom={3}&pageSize={4}";
        ValidValueAssignmentConsumersResponse restResult = this.restClient.callValidValueAssignmentConsumersGetRESTCall("getValidValuesAssignmentConsumers", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/consumers?startFrom={3}&pageSize={4}", this.serverName, userId, validValueGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ValidValueAssignmentDefinitionElement> getValidValuesAssignmentDefinition(String userId, String referenceableGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValuesAssignmentDefinition";
        String referenceableGUIDParameter = "referenceableGUID";
        this.invalidParameterHandler.validateUserId(userId, "getValidValuesAssignmentDefinition");
        this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", "getValidValuesAssignmentDefinition");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValuesAssignmentDefinition");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/referenceables/{2}/valid-value-assignments?startFrom={3}&pageSize={4}";
        ValidValueAssignmentDefinitionsResponse restResult = this.restClient.callValidValueAssignmentDefinitionsGetRESTCall("getValidValuesAssignmentDefinition", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/referenceables/{2}/valid-value-assignments?startFrom={3}&pageSize={4}", this.serverName, userId, referenceableGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ValidValueImplAssetElement> getValidValuesImplementationAssets(String userId, String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValuesImplementationAssets";
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "getValidValuesImplementationAssets");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getValidValuesImplementationAssets");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValuesImplementationAssets");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/implementations?startFrom={3}&pageSize={4}";
        ValidValuesImplAssetsResponse restResult = this.restClient.callValidValuesImplAssetsGetRESTCall("getValidValuesImplementationAssets", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/implementations?startFrom={3}&pageSize={4}", this.serverName, userId, validValueGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ValidValueImplDefinitionElement> getValidValuesImplementationDefinitions(String userId, String assetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValuesImplementationDefinitions";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getValidValuesImplementationDefinitions");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getValidValuesImplementationDefinitions");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValuesImplementationDefinitions");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/implementations?startFrom={3}&pageSize={4}";
        ValidValuesImplDefinitionsResponse restResult = this.restClient.callValidValuesImplDefinitionsGetRESTCall("getValidValuesImplementationDefinitions", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/implementations?startFrom={3}&pageSize={4}", this.serverName, userId, assetGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ValidValueMappingElement> getValidValueMappings(String userId, String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValueMappings";
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "getValidValueMappings");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getValidValueMappings");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValueMappings");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/mapped-values?startFrom={3}&pageSize={4}";
        ValidValueMappingsResponse restResult = this.restClient.callValidValueMappingsGetRESTCall("getValidValueMappings", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/mapped-values?startFrom={3}&pageSize={4}", this.serverName, userId, validValueGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ValidValuesMappingElement> getValidValuesMappings(String userId, String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidValuesMappings";
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "getValidValuesMappings");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getValidValuesMappings");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getValidValuesMappings");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/map-relationships?startFrom={3}&pageSize={4}";
        ValidValuesMappingsResponse restResult = this.restClient.callValidValuesMappingsGetRESTCall("getValidValuesMappings", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/map-relationships?startFrom={3}&pageSize={4}", this.serverName, userId, validValueGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ReferenceValueAssignmentItemElement> getReferenceValueAssignedItems(String userId, String validValueGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getReferenceValueAssignedItems";
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, "getReferenceValueAssignedItems");
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", "getReferenceValueAssignedItems");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getReferenceValueAssignedItems");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/reference-values/assigned-items?startFrom={3}&pageSize={4}";
        ReferenceValueAssignmentItemsResponse restResult = this.restClient.callReferenceValueAssignmentItemsGetRESTCall("getReferenceValueAssignedItems", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/valid-values/{2}/reference-values/assigned-items?startFrom={3}&pageSize={4}", this.serverName, userId, validValueGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public List<ReferenceValueAssignmentDefinitionElement> getReferenceValueAssignments(String userId, String referenceableGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getReferenceValueAssignments";
        String referenceableGUIDParameter = "referenceableGUID";
        this.invalidParameterHandler.validateUserId(userId, "getReferenceValueAssignments");
        this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", "getReferenceValueAssignments");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getReferenceValueAssignments");
        String urlTemplate = "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/referenceables/{2}/reference-value-assignments?startFrom={3}&pageSize={4}";
        ReferenceValueAssignmentDefinitionsResponse restResult = this.restClient.callReferenceValueAssignmentDefinitionsGetRESTCall("getReferenceValueAssignments", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/referenceables/{2}/reference-value-assignments?startFrom={3}&pageSize={4}", this.serverName, userId, referenceableGUID, startFrom, pageSize);
        return restResult.getElementList();
    }
}

