/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.digitalarchitecture.api.ManageLocations;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.DigitalArchitectureClientBase;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.rest.DigitalArchitectureRESTClient;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.LocationElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.LocationProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.DigitalLocationRequestBody;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.FixedLocationRequestBody;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.LocationResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.LocationsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.SecureLocationRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class LocationManager
extends DigitalArchitectureClientBase
implements ManageLocations {
    public LocationManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public LocationManager(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public LocationManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public LocationManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public LocationManager(String serverName, String serverPlatformURLRoot, DigitalArchitectureRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public String createLocation(String userId, LocationProperties locationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLocation";
        String nameParameter = "qualifiedName";
        String propertiesParameter = "locationProperties";
        this.invalidParameterHandler.validateUserId(userId, "createLocation");
        this.invalidParameterHandler.validateObject((Object)locationProperties, "locationProperties", "createLocation");
        this.invalidParameterHandler.validateName(locationProperties.getQualifiedName(), "qualifiedName", "createLocation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createLocation", urlTemplate, locationProperties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createLocationFromTemplate(String userId, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLocationFromTemplate";
        String nameParameter = "qualifiedName";
        String propertiesParameter = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, "createLocationFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createLocationFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createLocationFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/from-template/{2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createLocationFromTemplate", urlTemplate, templateProperties, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    public void updateLocation(String userId, boolean isMergeUpdate, String locationGUID, LocationProperties locationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateLocation";
        String guidParameter = "locationGUID";
        String propertiesParameter = "locationProperties";
        String qualifiedNameParameter = "locationProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateLocation");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "updateLocation");
        this.invalidParameterHandler.validateObject((Object)locationProperties, "locationProperties", "updateLocation");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(locationProperties.getQualifiedName(), "locationProperties.qualifiedName", "updateLocation");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/{2}/update?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateLocation", urlTemplate, locationProperties, new Object[]{this.serverName, userId, locationGUID, isMergeUpdate});
    }

    public void setLocationAsFixedPhysical(String userId, String locationGUID, String coordinates, String mapProjection, String postalAddress, String timeZone) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setLocationAsFixedPhysical";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "setLocationAsFixedPhysical");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "setLocationAsFixedPhysical");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/{2}/classify-as-fixed-location";
        FixedLocationRequestBody requestBody = new FixedLocationRequestBody();
        requestBody.setCoordinates(coordinates);
        requestBody.setMapProjection(mapProjection);
        requestBody.setPostalAddress(postalAddress);
        requestBody.setTimeZone(timeZone);
        this.restClient.callVoidPostRESTCall("setLocationAsFixedPhysical", urlTemplate, requestBody, new Object[]{this.serverName, userId, locationGUID});
    }

    public void clearLocationAsFixedPhysical(String userId, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearLocationAsFixedPhysical";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearLocationAsFixedPhysical");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "clearLocationAsFixedPhysical");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/classify-as-fixed-location/delete";
        this.restClient.callVoidPostRESTCall("clearLocationAsFixedPhysical", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, locationGUID});
    }

    public void setLocationAsSecure(String userId, String locationGUID, String description, String level) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setLocationAsSecure";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "setLocationAsSecure");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "setLocationAsSecure");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/classify-as-secure-location";
        SecureLocationRequestBody requestBody = new SecureLocationRequestBody();
        requestBody.setDescription(description);
        requestBody.setLevel(level);
        this.restClient.callVoidPostRESTCall("setLocationAsSecure", urlTemplate, requestBody, new Object[]{this.serverName, userId, locationGUID});
    }

    public void clearLocationAsSecure(String userId, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearLocationAsSecure";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearLocationAsSecure");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "clearLocationAsSecure");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/classify-as-secure-location/delete";
        this.restClient.callVoidPostRESTCall("clearLocationAsSecure", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, locationGUID});
    }

    public void setLocationAsDigital(String userId, String locationGUID, String networkAddress) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setLocationAsDigital";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "setLocationAsDigital");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "setLocationAsDigital");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/classify-as-digital-location";
        DigitalLocationRequestBody requestBody = new DigitalLocationRequestBody();
        requestBody.setNetworkAddress(networkAddress);
        this.restClient.callVoidPostRESTCall("setLocationAsDigital", urlTemplate, requestBody, new Object[]{this.serverName, userId, locationGUID});
    }

    public void clearLocationAsDigital(String userId, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearLocationAsDigital";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearLocationAsDigital");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "clearLocationAsDigital");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/classify-as-digital-location/delete";
        this.restClient.callVoidPostRESTCall("clearLocationAsDigital", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, locationGUID});
    }

    public void removeLocation(String userId, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeLocation";
        String guidParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeLocation");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "removeLocation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/{2}/delete";
        this.restClient.callVoidPostRESTCall("removeLocation", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, locationGUID});
    }

    public void setupNestedLocation(String userId, String parentLocationGUID, String childLocationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupNestedLocation";
        String parentLocationGUIDParameter = "parentLocationGUID";
        String childLocationGUIDParameter = "childLocationGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupNestedLocation");
        this.invalidParameterHandler.validateGUID(parentLocationGUID, "parentLocationGUID", "setupNestedLocation");
        this.invalidParameterHandler.validateGUID(childLocationGUID, "childLocationGUID", "setupNestedLocation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/{2}/has-nested-location/{3}";
        this.restClient.callVoidPostRESTCall("setupNestedLocation", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, parentLocationGUID, childLocationGUID});
    }

    public void clearNestedLocation(String userId, String parentLocationGUID, String childLocationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearNestedLocation";
        String parentLocationGUIDParameter = "parentLocationGUID";
        String childLocationGUIDParameter = "childLocationGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearNestedLocation");
        this.invalidParameterHandler.validateGUID(parentLocationGUID, "parentLocationGUID", "clearNestedLocation");
        this.invalidParameterHandler.validateGUID(childLocationGUID, "childLocationGUID", "clearNestedLocation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/{2}/has-nested-location/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearNestedLocation", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, parentLocationGUID, childLocationGUID});
    }

    public void setupAdjacentLocation(String userId, String locationOneGUID, String locationTwoGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAdjacentLocation";
        String locationOneGUIDParameter = "locationOneGUID";
        String locationTwoGUIDParameter = "locationTwoGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupAdjacentLocation");
        this.invalidParameterHandler.validateGUID(locationOneGUID, "locationOneGUID", "setupAdjacentLocation");
        this.invalidParameterHandler.validateGUID(locationTwoGUID, "locationTwoGUID", "setupAdjacentLocation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/{2}/linked-to-peer-location/{3}";
        this.restClient.callVoidPostRESTCall("setupAdjacentLocation", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, locationOneGUID, locationTwoGUID});
    }

    public void clearAdjacentLocation(String userId, String locationOneGUID, String locationTwoGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAdjacentLocation";
        String locationOneGUIDParameter = "locationOneGUID";
        String locationTwoGUIDParameter = "locationTwoGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearAdjacentLocation");
        this.invalidParameterHandler.validateGUID(locationOneGUID, "locationOneGUID", "clearAdjacentLocation");
        this.invalidParameterHandler.validateGUID(locationTwoGUID, "locationTwoGUID", "clearAdjacentLocation");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/{2}/linked-to-peer-location/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearAdjacentLocation", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, locationOneGUID, locationTwoGUID});
    }

    public List<LocationElement> findLocations(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findLocations";
        String parameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findLocations");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findLocations");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findLocations");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        LocationsResponse restResult = this.restClient.callLocationsPostRESTCall("findLocations", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<LocationElement> getLocationsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLocationsByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getLocationsByName");
        this.invalidParameterHandler.validateName(name, "name", "getLocationsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLocationsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        LocationsResponse restResult = this.restClient.callLocationsPostRESTCall("getLocationsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public LocationElement getLocationByGUID(String userId, String locationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getLocationByGUID";
        String locationGUIDParameter = "locationGUID";
        this.invalidParameterHandler.validateUserId(userId, "getLocationByGUID");
        this.invalidParameterHandler.validateGUID(locationGUID, "locationGUID", "getLocationByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/locations/{2}";
        LocationResponse restResult = this.restClient.callLocationGetRESTCall("getLocationByGUID", urlTemplate, this.serverName, userId, locationGUID);
        return restResult.getElement();
    }
}

