/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.odpi.openmetadata.accessservices.digitalarchitecture.api.ManageTemplates;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.DigitalArchitectureClientBase;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.rest.DigitalArchitectureRESTClient;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.TemplateElement;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ClassificationCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.properties.templates.TemplateClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class TemplateManager
extends DigitalArchitectureClientBase
implements ManageTemplates {
    public TemplateManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public TemplateManager(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public TemplateManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public TemplateManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public TemplateManager(String serverName, String serverPlatformURLRoot, DigitalArchitectureRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public void addTemplateClassification(String userId, String elementGUID, TemplateClassificationProperties properties, Map<String, List<Map<String, String>>> specification) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addTemplateClassification";
        String elementGUIDParameter = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "addTemplateClassification");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "addTemplateClassification");
        ElementProperties elementProperties = null;
        if (properties != null) {
            elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.NAME.name, properties.getName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.VERSION_IDENTIFIER.name, properties.getVersionIdentifier());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, properties.getAdditionalProperties());
        }
        this.openMetadataStoreClient.classifyMetadataElementInStore(userId, null, null, elementGUID, OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName, false, false, null, null, elementProperties, new Date());
    }

    public void removeTemplateClassification(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeTemplateClassification";
        String elementGUIDParameter = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeTemplateClassification");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "removeTemplateClassification");
    }

    public List<TemplateElement> getTemplatesForType(String userId, String typeName, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTemplatesForType";
        this.invalidParameterHandler.validateUserId(userId, "getTemplatesForType");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTemplatesForType");
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        classificationCondition.setName(OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName);
        classificationConditions.add(classificationCondition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, typeName, null, null, null, null, searchClassifications, OpenMetadataProperty.QUALIFIED_NAME.name, SequencingOrder.PROPERTY_ASCENDING, false, false, effectiveTime, startFrom, pageSize);
        return this.convertTemplates(openMetadataElements, userId, this.openMetadataStoreClient);
    }

    private List<TemplateElement> convertTemplates(List<OpenMetadataElement> openMetadataElements, String userId, OpenMetadataStoreClient openHandler) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (openMetadataElements != null) {
            ArrayList<TemplateElement> templateElements = new ArrayList<TemplateElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                TemplateElement templateElement = new TemplateElement();
                templateElement.setRelatedElement(openMetadataElement);
                templateElement.setSpecification(openHandler.getSpecification(userId, openMetadataElement.getElementGUID()));
                templateElements.add(templateElement);
            }
            return templateElements;
        }
        return null;
    }

    public List<TemplateElement> findTemplates(String userId, String searchString, String typeName, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findTemplates";
        String parameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findTemplates");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findTemplates");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findTemplates");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, typeName, null, null, null, null, this.getSearchClassifications(searchString, PropertyComparisonOperator.LIKE), OpenMetadataProperty.QUALIFIED_NAME.name, SequencingOrder.PROPERTY_ASCENDING, false, false, effectiveTime, startFrom, pageSize);
        return this.convertTemplates(openMetadataElements, userId, this.openMetadataStoreClient);
    }

    public List<TemplateElement> getTemplatesByName(String userId, String name, String typeName, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTemplatesByName";
        String parameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getTemplatesByName");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTemplatesByName");
        this.invalidParameterHandler.validateName(name, "name", "getTemplatesByName");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, typeName, null, null, null, null, this.getSearchClassifications(name, PropertyComparisonOperator.EQ), OpenMetadataProperty.QUALIFIED_NAME.name, SequencingOrder.PROPERTY_ASCENDING, false, false, effectiveTime, startFrom, pageSize);
        return this.convertTemplates(openMetadataElements, userId, this.openMetadataStoreClient);
    }

    private SearchClassifications getSearchClassifications(String searchValue, PropertyComparisonOperator propertyComparisonOperator) {
        PrimitiveTypePropertyValue requestedPropertyValue = new PrimitiveTypePropertyValue();
        requestedPropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        if (PropertyComparisonOperator.LIKE.equals((Object)propertyComparisonOperator)) {
            requestedPropertyValue.setPrimitiveValue((Object)(".*" + Pattern.quote(searchValue) + ".*"));
        } else {
            requestedPropertyValue.setPrimitiveValue((Object)searchValue);
        }
        requestedPropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        PropertyCondition nameCondition = new PropertyCondition();
        nameCondition.setProperty(OpenMetadataProperty.NAME.name);
        nameCondition.setOperator(propertyComparisonOperator);
        nameCondition.setValue((PropertyValue)requestedPropertyValue);
        PropertyCondition resourceNameCondition = new PropertyCondition();
        nameCondition.setProperty(OpenMetadataProperty.RESOURCE_NAME.name);
        nameCondition.setOperator(propertyComparisonOperator);
        nameCondition.setValue((PropertyValue)requestedPropertyValue);
        PropertyCondition descriptionCondition = new PropertyCondition(nameCondition);
        descriptionCondition.setProperty(OpenMetadataProperty.DESCRIPTION.name);
        PropertyCondition versionCondition = new PropertyCondition(nameCondition);
        versionCondition.setProperty(OpenMetadataProperty.VERSION_IDENTIFIER.name);
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        conditions.add(nameCondition);
        conditions.add(resourceNameCondition);
        conditions.add(descriptionCondition);
        conditions.add(versionCondition);
        SearchProperties searchClassificationProperties = new SearchProperties();
        searchClassificationProperties.setConditions(conditions);
        searchClassificationProperties.setMatchCriteria(MatchCriteria.ANY);
        SearchClassifications searchClassifications = new SearchClassifications();
        ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
        ClassificationCondition classificationCondition = new ClassificationCondition();
        classificationCondition.setName(OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName);
        classificationCondition.setSearchProperties(searchClassificationProperties);
        classificationConditions.add(classificationCondition);
        searchClassifications.setConditions(classificationConditions);
        searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        return searchClassifications;
    }
}

