/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.digitalarchitecture.api.ManageConnections;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.DigitalArchitectureClientBase;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.rest.DigitalArchitectureRESTClient;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.TemplateProperties;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorTypesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.EmbeddedConnectionRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.EndpointResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.EndpointsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ConnectionElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.EndpointElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.ConnectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.ConnectorTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.EndpointProperties;

public class ConnectionManager
extends DigitalArchitectureClientBase
implements ManageConnections {
    public ConnectionManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public ConnectionManager(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public ConnectionManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public ConnectionManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public ConnectionManager(String serverName, String serverPlatformURLRoot, DigitalArchitectureRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public String createConnection(String userId, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnection";
        String nameParameter = "qualifiedName";
        String propertiesParameter = "connectionDetails";
        this.invalidParameterHandler.validateUserId(userId, "createConnection");
        this.invalidParameterHandler.validateObject((Object)connectionProperties, "connectionDetails", "createConnection");
        this.invalidParameterHandler.validateName(connectionProperties.getQualifiedName(), "qualifiedName", "createConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connections";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnection", urlTemplate, connectionProperties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createConnectionFromTemplate(String userId, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectionFromTemplate";
        String nameParameter = "qualifiedName";
        String propertiesParameter = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, "createConnectionFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createConnectionFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createConnectionFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connections/from-template/{2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnectionFromTemplate", urlTemplate, templateProperties, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    public void updateConnection(String userId, String connectionGUID, boolean isMergeUpdate, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnection";
        String guidParameter = "connectionGUID";
        String propertiesParameter = "connectionDetails";
        String qualifiedNameParameter = "connectionDetails.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "updateConnection");
        this.invalidParameterHandler.validateObject((Object)connectionProperties, "connectionDetails", "updateConnection");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(connectionProperties.getQualifiedName(), "connectionDetails.qualifiedName", "updateConnection");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connections/{2}/update?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateConnection", urlTemplate, connectionProperties, new Object[]{this.serverName, userId, connectionGUID, isMergeUpdate});
    }

    public void setupConnectorType(String userId, String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupConnectorType";
        String connectionGUIDParameter = "connectionGUID";
        String connectorTypeGUIDParameter = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupConnectorType");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "setupConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connections/{2}/connector-types/{3}";
        this.restClient.callVoidPostRESTCall("setupConnectorType", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, connectionGUID, connectorTypeGUID});
    }

    public void clearConnectorType(String userId, String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearConnectorType";
        String connectionGUIDParameter = "connectionGUID";
        String connectorTypeGUIDParameter = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearConnectorType");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "clearConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connections/{2}/connector-types/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearConnectorType", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, connectionGUID, connectorTypeGUID});
    }

    public void setupEndpoint(String userId, String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEndpoint";
        String connectionGUIDParameter = "connectionGUID";
        String endpointGUIDParameter = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupEndpoint");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "setupEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connections/{2}/endpoints/{3}";
        this.restClient.callVoidPostRESTCall("setupEndpoint", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, connectionGUID, endpointGUID});
    }

    public void clearEndpoint(String userId, String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEndpoint";
        String connectionGUIDParameter = "connectionGUID";
        String endpointGUIDParameter = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearEndpoint");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "clearEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connections/{2}/endpoints/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearEndpoint", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, connectionGUID, endpointGUID});
    }

    public void setupEmbeddedConnection(String userId, String connectionGUID, int position, String displayName, Map<String, Object> arguments, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEmbeddedConnection";
        String connectionGUIDParameter = "connectionGUID";
        String embeddedConnectionGUIDParameter = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, "embeddedConnectionGUID", "setupEmbeddedConnection");
        EmbeddedConnectionRequestBody requestBody = new EmbeddedConnectionRequestBody();
        requestBody.setPosition(position);
        requestBody.setDisplayName(displayName);
        requestBody.setArguments(arguments);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connections/{2}/embedded-connections/{3}";
        this.restClient.callVoidPostRESTCall("setupEmbeddedConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId, connectionGUID, embeddedConnectionGUID});
    }

    public void clearEmbeddedConnection(String userId, String connectionGUID, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEmbeddedConnection";
        String connectionGUIDParameter = "connectionGUID";
        String embeddedConnectionGUIDParameter = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, "embeddedConnectionGUID", "clearEmbeddedConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connections/{2}/embedded-connections/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearEmbeddedConnection", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, connectionGUID, embeddedConnectionGUID});
    }

    public void setupAssetConnection(String userId, String assetGUID, String assetSummary, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAssetConnection";
        String assetGUIDParameter = "assetGUID";
        String connectionGUIDParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupAssetConnection");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "setupAssetConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupAssetConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/assets/{2}/connections/{3}";
        StringRequestBody requestBody = new StringRequestBody();
        requestBody.setString(assetSummary);
        this.restClient.callVoidPostRESTCall("setupAssetConnection", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, connectionGUID});
    }

    public void clearAssetConnection(String userId, String assetGUID, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetConnection";
        String assetGUIDParameter = "assetGUID";
        String connectionGUIDParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearAssetConnection");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "clearAssetConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearAssetConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/assets/{2}/connections/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearAssetConnection", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, assetGUID, connectionGUID});
    }

    public void removeConnection(String userId, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConnection";
        String guidParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "removeConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connections/{2}/delete";
        this.restClient.callVoidPostRESTCall("removeConnection", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, connectionGUID});
    }

    public List<ConnectionElement> findConnections(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findConnections";
        String parameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findConnections");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findConnections");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findConnections");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connections/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ConnectionsResponse restResult = this.restClient.callConnectionsPostRESTCall("findConnections", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<ConnectionElement> getConnectionsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionsByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionsByName");
        this.invalidParameterHandler.validateName(name, "name", "getConnectionsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectionsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connections/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        ConnectionsResponse restResult = this.restClient.callConnectionsPostRESTCall("getConnectionsByName", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public ConnectionElement getConnectionByGUID(String userId, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionByGUID";
        String connectionGUIDParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionByGUID");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getConnectionByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connections/{2}";
        ConnectionResponse restResult = this.restClient.callConnectionGetRESTCall("getConnectionByGUID", urlTemplate, new Object[]{this.serverName, userId, connectionGUID});
        return restResult.getElement();
    }

    public String createEndpoint(String userId, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpoint";
        String nameParameter = "qualifiedName";
        String propertiesParameter = "endpointProperties";
        this.invalidParameterHandler.validateUserId(userId, "createEndpoint");
        this.invalidParameterHandler.validateObject((Object)endpointProperties, "endpointProperties", "createEndpoint");
        this.invalidParameterHandler.validateName(endpointProperties.getQualifiedName(), "qualifiedName", "createEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/endpoints";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createEndpoint", urlTemplate, endpointProperties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createEndpointFromTemplate(String userId, String networkAddress, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpointFromTemplate";
        String nameParameter = "qualifiedName";
        String propertiesParameter = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, "createEndpointFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createEndpointFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createEndpointFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/endpoints/network-address/{2}/from-template/{3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createEndpointFromTemplate", urlTemplate, templateProperties, new Object[]{this.serverName, userId, networkAddress, templateGUID});
        return restResult.getGUID();
    }

    public void updateEndpoint(String userId, boolean isMergeUpdate, String endpointGUID, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEndpoint";
        String guidParameter = "endpointGUID";
        String propertiesParameter = "endpointProperties";
        String qualifiedNameParameter = "endpointProperties.qualifiedName";
        if (isMergeUpdate) {
            this.invalidParameterHandler.validateName(endpointProperties.getQualifiedName(), "endpointProperties.qualifiedName", "updateEndpoint");
        }
        this.invalidParameterHandler.validateUserId(userId, "updateEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "updateEndpoint");
        this.invalidParameterHandler.validateObject((Object)endpointProperties, "endpointProperties", "updateEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/endpoints/{2}/update?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateEndpoint", urlTemplate, endpointProperties, new Object[]{this.serverName, userId, endpointGUID, isMergeUpdate});
    }

    public void removeEndpoint(String userId, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeEndpoint";
        String guidParameter = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "removeEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/endpoints/{2}/delete";
        this.restClient.callVoidPostRESTCall("removeEndpoint", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, endpointGUID});
    }

    public List<EndpointElement> findEndpoints(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findEndpoints";
        String parameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findEndpoints");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findEndpoints");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findEndpoints");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/endpoints/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        EndpointsResponse restResult = this.restClient.callEndpointsPostRESTCall("findEndpoints", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<EndpointElement> getEndpointsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointsByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointsByName");
        this.invalidParameterHandler.validateName(name, "name", "getEndpointsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getEndpointsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/endpoints/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        EndpointsResponse restResult = this.restClient.callEndpointsPostRESTCall("getEndpointsByName", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public EndpointElement getEndpointByGUID(String userId, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointByGUID";
        String endpointGUIDParameter = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointByGUID");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "getEndpointByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/endpoints/{2}";
        EndpointResponse restResult = this.restClient.callEndpointGetRESTCall("getEndpointByGUID", urlTemplate, new Object[]{this.serverName, userId, endpointGUID});
        return restResult.getElement();
    }

    public String createConnectorType(String userId, ConnectorTypeProperties connectorTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectorType";
        String nameParameter = "qualifiedName";
        String propertiesParameter = "connectorTypeProperties";
        this.invalidParameterHandler.validateUserId(userId, "createConnectorType");
        this.invalidParameterHandler.validateObject((Object)connectorTypeProperties, "connectorTypeProperties", "createConnectorType");
        this.invalidParameterHandler.validateName(connectorTypeProperties.getQualifiedName(), "qualifiedName", "createConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connector-types";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnectorType", urlTemplate, connectorTypeProperties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createConnectorTypeFromTemplate(String userId, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectorTypeFromTemplate";
        String nameParameter = "qualifiedName";
        String propertiesParameter = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, "createConnectorTypeFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createConnectorTypeFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createConnectorTypeFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connector-types/from-template/{2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnectorTypeFromTemplate", urlTemplate, templateProperties, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    public void updateConnectorType(String userId, boolean isMergeUpdate, String connectorTypeGUID, ConnectorTypeProperties connectorTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnectorType";
        String guidParameter = "connectorTypeGUID";
        String propertiesParameter = "connectorTypeProperties";
        String qualifiedNameParameter = "connectorTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "updateConnectorType");
        this.invalidParameterHandler.validateObject((Object)connectorTypeProperties, "connectorTypeProperties", "updateConnectorType");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(connectorTypeProperties.getQualifiedName(), "connectorTypeProperties.qualifiedName", "updateConnectorType");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connector-types/{2}/update?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateConnectorType", urlTemplate, connectorTypeProperties, new Object[]{this.serverName, userId, connectorTypeGUID, isMergeUpdate});
    }

    public void removeConnectorType(String userId, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConnectorType";
        String guidParameter = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "removeConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connector-types/{2}/delete";
        this.restClient.callVoidPostRESTCall("removeConnectorType", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, connectorTypeGUID});
    }

    public List<ConnectorTypeElement> findConnectorTypes(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findConnectorTypes";
        String parameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findConnectorTypes");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findConnectorTypes");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findConnectorTypes");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connector-types/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ConnectorTypesResponse restResult = this.restClient.callConnectorTypesPostRESTCall("findConnectorTypes", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public List<ConnectorTypeElement> getConnectorTypesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorTypesByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorTypesByName");
        this.invalidParameterHandler.validateName(name, "name", "getConnectorTypesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectorTypesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connector-types/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        ConnectorTypesResponse restResult = this.restClient.callConnectorTypesPostRESTCall("getConnectorTypesByName", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, validatedPageSize});
        return restResult.getElements();
    }

    public ConnectorTypeElement getConnectorTypeByGUID(String userId, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorTypeByGUID";
        String connectorTypeGUIDParameter = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorTypeByGUID");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "getConnectorTypeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/digital-architecture/users/{1}/connector-types/{2}";
        ConnectorTypeResponse restResult = this.restClient.callConnectorTypeGetRESTCall("getConnectorTypeByGUID", urlTemplate, new Object[]{this.serverName, userId, connectorTypeGUID});
        return restResult.getElement();
    }
}

