/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.digitalarchitecture.api.ManageSolutions;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.DigitalArchitectureClientBase;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.rest.DigitalArchitectureRESTClient;
import org.odpi.openmetadata.accessservices.digitalarchitecture.ffdc.DigitalArchitectureAuditCode;
import org.odpi.openmetadata.commonservices.mermaid.InformationSupplyChainMermaidGraphBuilder;
import org.odpi.openmetadata.commonservices.mermaid.SolutionBlueprintMermaidGraphBuilder;
import org.odpi.openmetadata.commonservices.mermaid.SolutionComponentMermaidGraphBuilder;
import org.odpi.openmetadata.commonservices.mermaid.SolutionRoleMermaidGraphBuilder;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.converters.InformationSupplyChainConverter;
import org.odpi.openmetadata.frameworks.openmetadata.converters.InformationSupplyChainSegmentConverter;
import org.odpi.openmetadata.frameworks.openmetadata.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.openmetadata.converters.RelatedMetadataElementSummaryConverter;
import org.odpi.openmetadata.frameworks.openmetadata.converters.SolutionBlueprintConverter;
import org.odpi.openmetadata.frameworks.openmetadata.converters.SolutionComponentConverter;
import org.odpi.openmetadata.frameworks.openmetadata.converters.SolutionRoleConverter;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SolutionPortDirection;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.InformationSupplyChainContext;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.InformationSupplyChainElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.InformationSupplyChainSegmentElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SolutionBlueprintComponent;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SolutionBlueprintElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SolutionComponentElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SolutionLinkingWireRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SolutionPortElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SolutionRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataRelationshipList;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ActorRoleProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.informationsupplychains.InformationSupplyChainLinkProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.informationsupplychains.InformationSupplyChainProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.informationsupplychains.InformationSupplyChainSegmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.solutions.ImplementedByProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.solutions.SolutionBlueprintCompositionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.solutions.SolutionBlueprintProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.solutions.SolutionComponentActorRelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.solutions.SolutionComponentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.solutions.SolutionLinkingWireProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.solutions.SolutionPortProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.openmetadata.search.SearchProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class SolutionManager
extends DigitalArchitectureClientBase
implements ManageSolutions {
    public SolutionManager(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
    }

    public SolutionManager(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
    }

    public SolutionManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize, auditLog);
    }

    public SolutionManager(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
    }

    public SolutionManager(String serverName, String serverPlatformURLRoot, DigitalArchitectureRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public String createInformationSupplyChain(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, InformationSupplyChainProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createInformationSupplyChain";
        String propertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createInformationSupplyChain");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createInformationSupplyChain");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createInformationSupplyChain");
        String elementTypeName = OpenMetadataType.INFORMATION_SUPPLY_CHAIN.typeName;
        if (properties.getTypeName() != null) {
            elementTypeName = properties.getTypeName();
        }
        return this.openMetadataStoreClient.createMetadataElementInStore(userId, externalSourceGUID, externalSourceName, elementTypeName, ElementStatus.ACTIVE, null, anchorGUID, isOwnAnchor, null, properties.getEffectiveFrom(), properties.getEffectiveTo(), this.getElementProperties(properties), parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public String createInformationSupplyChainFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.createMetadataElementFromTemplate(userId, externalSourceGUID, externalSourceName, OpenMetadataType.INFORMATION_SUPPLY_CHAIN.typeName, anchorGUID, isOwnAnchor, anchorScopeGUID, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void updateInformationSupplyChain(String userId, String externalSourceGUID, String externalSourceName, String informationSupplyChainGUID, boolean replaceAllProperties, InformationSupplyChainProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateInformationSupplyChain";
        String propertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        String guidParameterName = "informationSupplyChainGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateInformationSupplyChain");
        this.invalidParameterHandler.validateGUID(informationSupplyChainGUID, "informationSupplyChainGUID", "updateInformationSupplyChain");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateInformationSupplyChain");
        if (replaceAllProperties) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateInformationSupplyChain");
        }
        this.openMetadataStoreClient.updateMetadataElementInStore(userId, externalSourceGUID, externalSourceName, informationSupplyChainGUID, replaceAllProperties, forLineage, forDuplicateProcessing, this.getElementProperties(properties), effectiveTime);
    }

    public String createInformationSupplyChainSegment(String userId, String externalSourceGUID, String externalSourceName, InformationSupplyChainSegmentProperties properties, String informationSupplyChainGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createInformationSupplyChain";
        String propertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createInformationSupplyChain");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createInformationSupplyChain");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createInformationSupplyChain");
        String elementTypeName = OpenMetadataType.INFORMATION_SUPPLY_CHAIN_SEGMENT.typeName;
        if (properties.getTypeName() != null) {
            elementTypeName = properties.getTypeName();
        }
        if (informationSupplyChainGUID != null) {
            return this.openMetadataStoreClient.createMetadataElementInStore(userId, externalSourceGUID, externalSourceName, elementTypeName, ElementStatus.ACTIVE, null, informationSupplyChainGUID, false, null, properties.getEffectiveFrom(), properties.getEffectiveTo(), this.getElementProperties(properties), informationSupplyChainGUID, OpenMetadataType.INFORMATION_SUPPLY_CHAIN_COMPOSITION_RELATIONSHIP.typeName, null, true, forLineage, forDuplicateProcessing, effectiveTime);
        }
        return this.openMetadataStoreClient.createMetadataElementInStore(userId, externalSourceGUID, externalSourceName, elementTypeName, ElementStatus.ACTIVE, null, null, true, null, properties.getEffectiveFrom(), properties.getEffectiveTo(), this.getElementProperties(properties), null, null, null, true, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void updateInformationSupplyChainSegment(String userId, String externalSourceGUID, String externalSourceName, String segmentGUID, boolean replaceAllProperties, InformationSupplyChainSegmentProperties properties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateInformationSupplyChainSegment";
        String propertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        String guidParameterName = "segmentGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateInformationSupplyChainSegment");
        this.invalidParameterHandler.validateGUID(segmentGUID, "segmentGUID", "updateInformationSupplyChainSegment");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateInformationSupplyChainSegment");
        if (replaceAllProperties) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateInformationSupplyChainSegment");
        }
        this.openMetadataStoreClient.updateMetadataElementInStore(userId, externalSourceGUID, externalSourceName, segmentGUID, replaceAllProperties, forLineage, forDuplicateProcessing, this.getElementProperties(properties), effectiveTime);
    }

    public void linkSegments(String userId, String externalSourceGUID, String externalSourceName, String segment1GUID, String segment2GUID, InformationSupplyChainLinkProperties linkProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkSegments";
        String end1GUIDParameterName = "segment1GUID";
        String end2GUIDParameterName = "segment2GUID";
        this.invalidParameterHandler.validateUserId(userId, "linkSegments");
        this.invalidParameterHandler.validateGUID(segment1GUID, "segment1GUID", "linkSegments");
        this.invalidParameterHandler.validateGUID(segment2GUID, "segment2GUID", "linkSegments");
        if (linkProperties != null) {
            this.openMetadataStoreClient.createRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.INFORMATION_SUPPLY_CHAIN_COMPOSITION_RELATIONSHIP.typeName, segment1GUID, segment2GUID, forLineage, forDuplicateProcessing, linkProperties.getEffectiveFrom(), linkProperties.getEffectiveTo(), this.getElementProperties(linkProperties), effectiveTime);
        } else {
            this.openMetadataStoreClient.createRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.INFORMATION_SUPPLY_CHAIN_COMPOSITION_RELATIONSHIP.typeName, segment1GUID, segment2GUID, forLineage, forDuplicateProcessing, null, null, null, effectiveTime);
        }
    }

    public void detachSegments(String userId, String externalSourceGUID, String externalSourceName, String segment1GUID, String segment2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "detachSegments";
        String end1GUIDParameterName = "segment1GUID";
        String end2GUIDParameterName = "segment2GUID";
        this.invalidParameterHandler.validateUserId(userId, "detachSegments");
        this.invalidParameterHandler.validateGUID(segment1GUID, "segment1GUID", "detachSegments");
        this.invalidParameterHandler.validateGUID(segment2GUID, "segment2GUID", "detachSegments");
        OpenMetadataRelationshipList relationshipList = this.openMetadataStoreClient.getMetadataElementRelationships(userId, segment1GUID, segment2GUID, OpenMetadataType.INFORMATION_SUPPLY_CHAIN_COMPOSITION_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, 0, 0);
        if (relationshipList != null && relationshipList.getElementList() != null) {
            for (OpenMetadataRelationship relationship : relationshipList.getElementList()) {
                if (relationship == null || !segment1GUID.equals(relationship.getElementGUIDAtEnd1()) || !segment2GUID.equals(relationship.getElementGUIDAtEnd2())) continue;
                this.openMetadataStoreClient.deleteRelationshipInStore(userId, externalSourceGUID, externalSourceName, relationship.getRelationshipGUID(), forLineage, forDuplicateProcessing, effectiveTime);
            }
        }
    }

    public void deleteInformationSupplyChainSegment(String userId, String externalSourceGUID, String externalSourceName, String segmentGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteInformationSupplyChainSegment";
        String guidParameterName = "segmentGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteInformationSupplyChainSegment");
        this.invalidParameterHandler.validateGUID(segmentGUID, "segmentGUID", "deleteInformationSupplyChainSegment");
        this.openMetadataStoreClient.deleteMetadataElementInStore(userId, externalSourceGUID, externalSourceName, segmentGUID, false, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public void deleteInformationSupplyChain(String userId, String externalSourceGUID, String externalSourceName, String informationSupplyChainGUID, boolean cascadedDelete, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteInformationSupplyChain";
        String guidParameterName = "informationSupplyChainGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteInformationSupplyChain");
        this.invalidParameterHandler.validateGUID(informationSupplyChainGUID, "informationSupplyChainGUID", "deleteInformationSupplyChain");
        this.openMetadataStoreClient.deleteMetadataElementInStore(userId, externalSourceGUID, externalSourceName, informationSupplyChainGUID, cascadedDelete, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public List<InformationSupplyChainElement> getInformationSupplyChainsByName(String userId, String name, boolean addImplementation, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getInformationSupplyChainsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getInformationSupplyChainsByName");
        this.invalidParameterHandler.validateName(name, "name", "getInformationSupplyChainsByName");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getInformationSupplyChainsByName");
        List<String> propertyNames = Arrays.asList(OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataProperty.DISPLAY_NAME.name);
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, OpenMetadataType.INFORMATION_SUPPLY_CHAIN.typeName, null, this.propertyHelper.getSearchPropertiesByName(propertyNames, name, PropertyComparisonOperator.EQ), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertInformationSupplyChains(userId, openMetadataElements, addImplementation, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "getInformationSupplyChainsByName");
    }

    public InformationSupplyChainElement getInformationSupplyChainByGUID(String userId, String informationSupplyChainGUID, boolean addImplementation, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getInformationSupplyChainByGUID";
        String guidParameterName = "informationSupplyChainGUID";
        this.invalidParameterHandler.validateUserId(userId, "getInformationSupplyChainByGUID");
        this.invalidParameterHandler.validateGUID(informationSupplyChainGUID, "informationSupplyChainGUID", "getInformationSupplyChainByGUID");
        OpenMetadataElement openMetadataElement = this.openMetadataStoreClient.getMetadataElementByGUID(userId, informationSupplyChainGUID, forLineage, forDuplicateProcessing, asOfTime, effectiveTime);
        if (openMetadataElement != null && this.propertyHelper.isTypeOf((ElementControlHeader)openMetadataElement, OpenMetadataType.INFORMATION_SUPPLY_CHAIN.typeName)) {
            return this.convertInformationSupplyChain(userId, openMetadataElement, addImplementation, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "getInformationSupplyChainByGUID");
        }
        return null;
    }

    public List<InformationSupplyChainElement> findInformationSupplyChains(String userId, String searchString, boolean addImplementation, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findInformationSupplyChains";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findInformationSupplyChains");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findInformationSupplyChains");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findInformationSupplyChains");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElementsWithString(userId, searchString, OpenMetadataType.INFORMATION_SUPPLY_CHAIN.typeName, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertInformationSupplyChains(userId, openMetadataElements, addImplementation, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "findInformationSupplyChains");
    }

    public List<SolutionBlueprintElement> findSolutionBlueprints(String userId, String searchString, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSolutionBlueprints";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findSolutionBlueprints");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findSolutionBlueprints");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findSolutionBlueprints");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElementsWithString(userId, searchString, OpenMetadataType.SOLUTION_BLUEPRINT.typeName, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertSolutionBlueprints(userId, openMetadataElements, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "findSolutionBlueprints");
    }

    public List<SolutionRoleElement> findSolutionRoles(String userId, String searchString, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSolutionRoles";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findSolutionRoles");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findSolutionRoles");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findSolutionRoles");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElementsWithString(userId, searchString, OpenMetadataType.ACTOR_ROLE.typeName, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertSolutionRoles(userId, openMetadataElements, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "findSolutionRoles");
    }

    public List<SolutionComponentElement> findSolutionComponents(String userId, String searchString, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSolutionComponents";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findSolutionComponents");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findSolutionComponents");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findSolutionComponents");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElementsWithString(userId, searchString, OpenMetadataType.SOLUTION_COMPONENT.typeName, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertSolutionComponents(userId, openMetadataElements, true, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, true, "findSolutionComponents");
    }

    public List<RelatedMetadataElementSummary> getSolutionComponentImplementations(String userId, String solutionComponentGUID, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSolutionComponentImplementations";
        String parameterName = "solutionComponentGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSolutionComponentImplementations");
        this.invalidParameterHandler.validateGUID(solutionComponentGUID, "solutionComponentGUID", "getSolutionComponentImplementations");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSolutionComponentImplementations");
        RelatedMetadataElementList relatedMetadataElements = this.openMetadataStoreClient.getRelatedMetadataElements(userId, solutionComponentGUID, 1, OpenMetadataType.IMPLEMENTED_BY_RELATIONSHIP.typeName, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertSolutionComponentImplementations(relatedMetadataElements, "getSolutionComponentImplementations");
    }

    private List<InformationSupplyChainElement> convertInformationSupplyChains(String userId, List<OpenMetadataElement> openMetadataElements, boolean addImplementation, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        if (openMetadataElements != null) {
            ArrayList<InformationSupplyChainElement> informationSupplyChainElements = new ArrayList<InformationSupplyChainElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                informationSupplyChainElements.add(this.convertInformationSupplyChain(userId, openMetadataElement, addImplementation, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
            return informationSupplyChainElements;
        }
        return null;
    }

    private List<SolutionBlueprintElement> convertSolutionBlueprints(String userId, List<OpenMetadataElement> openMetadataElements, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        if (openMetadataElements != null) {
            ArrayList<SolutionBlueprintElement> solutionBlueprintElements = new ArrayList<SolutionBlueprintElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                solutionBlueprintElements.add(this.convertSolutionBlueprint(userId, openMetadataElement, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
            return solutionBlueprintElements;
        }
        return null;
    }

    private List<SolutionRoleElement> convertSolutionRoles(String userId, List<OpenMetadataElement> openMetadataElements, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        if (openMetadataElements != null) {
            ArrayList<SolutionRoleElement> solutionRoleElements = new ArrayList<SolutionRoleElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                SolutionRoleElement solutionRoleElement;
                if (openMetadataElement == null || (solutionRoleElement = this.convertSolutionRole(userId, openMetadataElement, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) continue;
                solutionRoleElements.add(solutionRoleElement);
            }
            return solutionRoleElements;
        }
        return null;
    }

    private List<SolutionComponentElement> convertSolutionComponents(String userId, List<OpenMetadataElement> openMetadataElements, boolean addParentContext, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, boolean fullDisplay, String methodName) {
        if (openMetadataElements != null) {
            ArrayList<SolutionComponentElement> solutionComponentElements = new ArrayList<SolutionComponentElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                solutionComponentElements.add(this.convertSolutionComponent(userId, openMetadataElement, addParentContext, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, fullDisplay, methodName));
            }
            return solutionComponentElements;
        }
        return null;
    }

    private List<RelatedMetadataElementSummary> convertSolutionComponentImplementations(RelatedMetadataElementList relatedMetadataElementList, String methodName) {
        if (relatedMetadataElementList != null && relatedMetadataElementList.getElementList() != null) {
            ArrayList<RelatedMetadataElementSummary> solutionComponentImplementationElements = new ArrayList<RelatedMetadataElementSummary>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList.getElementList()) {
                if (relatedMetadataElement == null) continue;
                solutionComponentImplementationElements.add(this.convertSolutionComponentImplementation(relatedMetadataElement, methodName));
            }
            return solutionComponentImplementationElements;
        }
        return null;
    }

    private InformationSupplyChainElement convertInformationSupplyChain(String userId, OpenMetadataElement openMetadataElement, boolean addImplementation, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        try {
            InformationSupplyChainConverter converter;
            InformationSupplyChainElement informationSupplyChainElement;
            ArrayList<InformationSupplyChainSegmentElement> relatedSegments = new ArrayList<InformationSupplyChainSegmentElement>();
            int startFrom = 0;
            RelatedMetadataElementList relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 1, OpenMetadataType.INFORMATION_SUPPLY_CHAIN_COMPOSITION_RELATIONSHIP.typeName, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom, this.invalidParameterHandler.getMaxPagingSize());
            while (relatedMetadataElementList != null && relatedMetadataElementList.getElementList() != null) {
                for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList.getElementList()) {
                    if (relatedMetadataElement == null) continue;
                    relatedSegments.add(this.convertInformationSupplyChainSegment(userId, relatedMetadataElement.getElement(), asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                }
                relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 1, OpenMetadataType.INFORMATION_SUPPLY_CHAIN_COMPOSITION_RELATIONSHIP.typeName, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize());
            }
            ArrayList lineageRelationships = null;
            if (addImplementation) {
                lineageRelationships = new ArrayList();
                startFrom = 0;
                SearchProperties searchProperties = new SearchProperties();
                ArrayList<PropertyCondition> propertyConditions = new ArrayList<PropertyCondition>();
                PropertyCondition propertyCondition = new PropertyCondition();
                propertyCondition.setProperty(OpenMetadataProperty.ISC_QUALIFIED_NAME.name);
                propertyCondition.setOperator(PropertyComparisonOperator.EQ);
                propertyCondition.setValue(openMetadataElement.getElementProperties().getPropertyValue(OpenMetadataProperty.QUALIFIED_NAME.name));
                propertyConditions.add(propertyCondition);
                searchProperties.setMatchCriteria(MatchCriteria.ANY);
                searchProperties.setConditions(propertyConditions);
                OpenMetadataRelationshipList relationshipList = this.openMetadataStoreClient.findRelationshipsBetweenMetadataElements(userId, null, searchProperties, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom, this.invalidParameterHandler.getMaxPagingSize());
                while (relationshipList != null && relationshipList.getElementList() != null) {
                    lineageRelationships.addAll(relationshipList.getElementList());
                    relationshipList = this.openMetadataStoreClient.findRelationshipsBetweenMetadataElements(userId, null, searchProperties, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize());
                }
            }
            if ((informationSupplyChainElement = (InformationSupplyChainElement)(converter = new InformationSupplyChainConverter(this.propertyHelper, this.serviceName, this.serverName, relatedSegments, lineageRelationships)).getNewBean(InformationSupplyChainElement.class, openMetadataElement, methodName)) != null) {
                InformationSupplyChainMermaidGraphBuilder graphBuilder = new InformationSupplyChainMermaidGraphBuilder(informationSupplyChainElement);
                informationSupplyChainElement.setMermaidGraph(graphBuilder.getMermaidGraph(false));
            }
            return informationSupplyChainElement;
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logMessage(methodName, DigitalArchitectureAuditCode.UNEXPECTED_CONVERTER_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), methodName, error.getMessage()}));
            }
            return null;
        }
    }

    private InformationSupplyChainSegmentElement convertInformationSupplyChainSegment(String userId, OpenMetadataElement openMetadataElement, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        try {
            ArrayList<RelatedMetadataElement> relatedMetadataElements = new ArrayList<RelatedMetadataElement>();
            ArrayList<RelatedMetadataElementSummary> relatedPortElements = new ArrayList<RelatedMetadataElementSummary>();
            ArrayList<SolutionLinkingWireRelationship> solutionLinkingWires = new ArrayList<SolutionLinkingWireRelationship>();
            int startFrom = 0;
            RelatedMetadataElementList relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 1, null, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom, this.invalidParameterHandler.getMaxPagingSize());
            while (relatedMetadataElementList != null && relatedMetadataElementList.getElementList() != null) {
                for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList.getElementList()) {
                    if (relatedMetadataElement == null) continue;
                    if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement.getElement(), OpenMetadataType.SOLUTION_COMPONENT.typeName)) {
                        List<SolutionLinkingWireRelationship> solutionLinkingWireRelationships;
                        List<RelatedMetadataElementSummary> componentPorts = this.convertPortSummaries(userId, relatedMetadataElement.getElement().getElementGUID(), asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                        if (componentPorts != null) {
                            relatedPortElements.addAll(componentPorts);
                        }
                        if ((solutionLinkingWireRelationships = this.convertSolutionLinkingWires(userId, relatedMetadataElement.getElement(), asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
                            solutionLinkingWires.addAll(solutionLinkingWireRelationships);
                        }
                    }
                    relatedMetadataElements.add(relatedMetadataElement);
                }
                relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 1, null, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize());
            }
            InformationSupplyChainSegmentConverter converter = new InformationSupplyChainSegmentConverter(this.propertyHelper, this.serviceName, this.serverName, solutionLinkingWires, relatedPortElements);
            return (InformationSupplyChainSegmentElement)converter.getNewComplexBean(InformationSupplyChainSegmentElement.class, openMetadataElement, relatedMetadataElements, methodName);
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logMessage(methodName, DigitalArchitectureAuditCode.UNEXPECTED_CONVERTER_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), methodName, error.getMessage()}));
            }
            return null;
        }
    }

    private List<SolutionLinkingWireRelationship> convertSolutionLinkingWires(String userId, OpenMetadataElement solutionComponent, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        block8: {
            try {
                OpenMetadataConverterBase wireConverter = new OpenMetadataConverterBase(this.propertyHelper, this.serviceName, this.serverName);
                ArrayList<SolutionLinkingWireRelationship> solutionLinkingWireRelationships = new ArrayList<SolutionLinkingWireRelationship>();
                ElementStub solutionComponentStub = wireConverter.getElementStub(ElementStub.class, solutionComponent, methodName);
                int startFrom = 0;
                RelatedMetadataElementList relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, solutionComponent.getElementGUID(), 0, OpenMetadataType.SOLUTION_LINKING_WIRE_RELATIONSHIP.typeName, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom, this.invalidParameterHandler.getMaxPagingSize());
                while (relatedMetadataElementList != null && relatedMetadataElementList.getElementList() != null) {
                    for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList.getElementList()) {
                        if (relatedMetadataElement == null) continue;
                        SolutionLinkingWireRelationship wire = new SolutionLinkingWireRelationship();
                        wire.setElementHeader(wireConverter.getMetadataElementHeader(ElementStub.class, (ElementControlHeader)relatedMetadataElement, relatedMetadataElement.getRelationshipGUID(), null, methodName));
                        if (relatedMetadataElement.getRelationshipProperties() != null) {
                            SolutionLinkingWireProperties wireProperties = new SolutionLinkingWireProperties();
                            ElementProperties elementProperties = new ElementProperties(relatedMetadataElement.getRelationshipProperties());
                            wireProperties.setLabel(wireConverter.removeLabel(elementProperties));
                            wireProperties.setDescription(wireConverter.removeDescription(elementProperties));
                            wireProperties.setInformationSupplyChainSegmentGUIDs(wireConverter.removeInformationSupplyChainSegmentGUIDs(elementProperties));
                            wireProperties.setExtendedProperties(wireConverter.getRemainingExtendedProperties(elementProperties));
                            wireProperties.setEffectiveFrom(relatedMetadataElement.getEffectiveFromTime());
                            wireProperties.setEffectiveTo(relatedMetadataElement.getEffectiveToTime());
                            wire.setProperties(wireProperties);
                        }
                        ElementStub otherEndStub = wireConverter.getElementStub(ElementStub.class, relatedMetadataElement.getElement(), methodName);
                        if (relatedMetadataElement.getElementAtEnd1()) {
                            wire.setEnd1Element(otherEndStub);
                            wire.setEnd2Element(solutionComponentStub);
                        } else {
                            wire.setEnd1Element(solutionComponentStub);
                            wire.setEnd2Element(otherEndStub);
                        }
                        solutionLinkingWireRelationships.add(wire);
                    }
                    relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, solutionComponent.getElementGUID(), 0, OpenMetadataType.SOLUTION_LINKING_WIRE_RELATIONSHIP.typeName, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize());
                }
                if (!solutionLinkingWireRelationships.isEmpty()) {
                    return solutionLinkingWireRelationships;
                }
            }
            catch (Exception error) {
                if (this.auditLog == null) break block8;
                this.auditLog.logMessage(methodName, DigitalArchitectureAuditCode.UNEXPECTED_CONVERTER_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), methodName, error.getMessage()}));
            }
        }
        return null;
    }

    private List<RelatedMetadataElementSummary> convertPortSummaries(String userId, String solutionComponentGUID, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        block5: {
            try {
                OpenMetadataConverterBase portConverter = new OpenMetadataConverterBase(this.propertyHelper, this.serviceName, this.serverName);
                ArrayList<RelatedMetadataElementSummary> portSummaries = new ArrayList<RelatedMetadataElementSummary>();
                int startFrom = 0;
                RelatedMetadataElementList relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, solutionComponentGUID, 1, OpenMetadataType.SOLUTION_COMPONENT_PORT_RELATIONSHIP.typeName, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom, this.invalidParameterHandler.getMaxPagingSize());
                while (relatedMetadataElementList != null && relatedMetadataElementList.getElementList() != null) {
                    for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList.getElementList()) {
                        if (!this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement.getElement(), OpenMetadataType.SOLUTION_COMPONENT.typeName)) continue;
                        portSummaries.add(portConverter.getRelatedElementSummary(RelatedMetadataElementSummary.class, relatedMetadataElement, methodName));
                    }
                    relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, solutionComponentGUID, 1, OpenMetadataType.SOLUTION_COMPONENT_PORT_RELATIONSHIP.typeName, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize());
                }
                if (!portSummaries.isEmpty()) {
                    return portSummaries;
                }
            }
            catch (Exception error) {
                if (this.auditLog == null) break block5;
                this.auditLog.logMessage(methodName, DigitalArchitectureAuditCode.UNEXPECTED_CONVERTER_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), methodName, error.getMessage()}));
            }
        }
        return null;
    }

    private SolutionBlueprintElement convertSolutionBlueprint(String userId, OpenMetadataElement openMetadataElement, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        try {
            ArrayList<SolutionBlueprintComponent> solutionBlueprintComponents = new ArrayList<SolutionBlueprintComponent>();
            OpenMetadataConverterBase solutionBlueprintConverter = new OpenMetadataConverterBase(this.propertyHelper, this.serviceName, this.serverName);
            int startFrom = 0;
            RelatedMetadataElementList relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 1, OpenMetadataType.SOLUTION_BLUEPRINT_COMPOSITION_RELATIONSHIP.typeName, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom, this.invalidParameterHandler.getMaxPagingSize());
            while (relatedMetadataElementList != null && relatedMetadataElementList.getElementList() != null) {
                for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList.getElementList()) {
                    if (relatedMetadataElement == null) continue;
                    SolutionBlueprintComponent solutionBlueprintComponent = new SolutionBlueprintComponent();
                    solutionBlueprintComponent.setElementHeader(solutionBlueprintConverter.getMetadataElementHeader(SolutionBlueprintComponent.class, (ElementControlHeader)relatedMetadataElement, relatedMetadataElement.getRelationshipGUID(), null, methodName));
                    SolutionBlueprintCompositionProperties relationshipProperties = new SolutionBlueprintCompositionProperties();
                    ElementProperties elementProperties = new ElementProperties(relatedMetadataElement.getRelationshipProperties());
                    relationshipProperties.setRole(solutionBlueprintConverter.removeRole(elementProperties));
                    relationshipProperties.setDescription(solutionBlueprintConverter.removeDescription(elementProperties));
                    relationshipProperties.setEffectiveFrom(relatedMetadataElement.getEffectiveFromTime());
                    relationshipProperties.setEffectiveTo(relatedMetadataElement.getEffectiveToTime());
                    relationshipProperties.setExtendedProperties(solutionBlueprintConverter.getRemainingExtendedProperties(elementProperties));
                    solutionBlueprintComponent.setProperties(relationshipProperties);
                    solutionBlueprintComponent.setSolutionComponent(this.convertSolutionComponent(userId, relatedMetadataElement.getElement(), false, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, false, methodName));
                    solutionBlueprintComponents.add(solutionBlueprintComponent);
                }
                relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 1, OpenMetadataType.SOLUTION_BLUEPRINT_COMPOSITION_RELATIONSHIP.typeName, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize());
            }
            SolutionBlueprintConverter converter = new SolutionBlueprintConverter(this.propertyHelper, this.serviceName, this.serverName, solutionBlueprintComponents);
            SolutionBlueprintElement solutionBlueprintElement = (SolutionBlueprintElement)converter.getNewBean(SolutionBlueprintElement.class, openMetadataElement, methodName);
            if (solutionBlueprintElement != null) {
                SolutionBlueprintMermaidGraphBuilder graphBuilder = new SolutionBlueprintMermaidGraphBuilder(solutionBlueprintElement);
                solutionBlueprintElement.setMermaidGraph(graphBuilder.getMermaidGraph());
            }
            return solutionBlueprintElement;
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logMessage(methodName, DigitalArchitectureAuditCode.UNEXPECTED_CONVERTER_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), methodName, error.getMessage()}));
            }
            return null;
        }
    }

    private SolutionRoleElement convertSolutionRole(String userId, OpenMetadataElement openMetadataElement, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        block5: {
            try {
                ArrayList relatedMetadataElements = new ArrayList();
                int startFrom = 0;
                RelatedMetadataElementList relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 1, OpenMetadataType.SOLUTION_COMPONENT_ACTOR_RELATIONSHIP.typeName, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom, this.invalidParameterHandler.getMaxPagingSize());
                while (relatedMetadataElementList != null && relatedMetadataElementList.getElementList() != null) {
                    relatedMetadataElements.addAll(relatedMetadataElementList.getElementList());
                    relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 1, OpenMetadataType.SOLUTION_COMPONENT_ACTOR_RELATIONSHIP.typeName, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize());
                }
                if (this.propertyHelper.isTypeOf((ElementControlHeader)openMetadataElement, OpenMetadataType.SOLUTION_ACTOR_ROLE.typeName) || !relatedMetadataElements.isEmpty()) {
                    SolutionRoleConverter converter = new SolutionRoleConverter(this.propertyHelper, this.serviceName, this.serverName);
                    SolutionRoleElement solutionRoleElement = (SolutionRoleElement)converter.getNewComplexBean(SolutionRoleElement.class, openMetadataElement, relatedMetadataElements, methodName);
                    if (solutionRoleElement != null) {
                        SolutionRoleMermaidGraphBuilder graphBuilder = new SolutionRoleMermaidGraphBuilder(solutionRoleElement);
                        solutionRoleElement.setMermaidGraph(graphBuilder.getMermaidGraph());
                    }
                    return solutionRoleElement;
                }
            }
            catch (Exception error) {
                if (this.auditLog == null) break block5;
                this.auditLog.logMessage(methodName, DigitalArchitectureAuditCode.UNEXPECTED_CONVERTER_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), methodName, error.getMessage()}));
            }
        }
        return null;
    }

    private SolutionComponentElement convertSolutionComponent(String userId, OpenMetadataElement openMetadataElement, boolean addParentContext, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, boolean fullDisplay, String methodName) {
        try {
            ArrayList<RelatedMetadataElement> relatedMetadataElements = new ArrayList<RelatedMetadataElement>();
            ArrayList<RelatedMetadataElement> relatedParentElements = new ArrayList<RelatedMetadataElement>();
            ArrayList<SolutionPortElement> relatedPortElements = new ArrayList<SolutionPortElement>();
            ArrayList<SolutionComponentElement> relatedSubComponentsElements = new ArrayList<SolutionComponentElement>();
            int startFrom = 0;
            RelatedMetadataElementList relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 0, null, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom, this.invalidParameterHandler.getMaxPagingSize());
            while (relatedMetadataElementList != null && relatedMetadataElementList.getElementList() != null) {
                for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList.getElementList()) {
                    if (relatedMetadataElement == null) continue;
                    if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, OpenMetadataType.SOLUTION_COMPOSITION_RELATIONSHIP.typeName)) {
                        if (relatedMetadataElement.getElementAtEnd1()) {
                            relatedParentElements.add(relatedMetadataElement);
                            continue;
                        }
                        relatedSubComponentsElements.add(this.convertSolutionComponent(userId, relatedMetadataElement.getElement(), addParentContext, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, fullDisplay, methodName));
                        continue;
                    }
                    if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, OpenMetadataType.IMPLEMENTED_BY_RELATIONSHIP.typeName)) {
                        if (relatedMetadataElement.getElementAtEnd1()) {
                            relatedParentElements.add(relatedMetadataElement);
                            continue;
                        }
                        relatedMetadataElements.add(relatedMetadataElement);
                        continue;
                    }
                    if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, OpenMetadataType.SOLUTION_COMPONENT_PORT_RELATIONSHIP.typeName)) {
                        relatedPortElements.add(this.convertSolutionPort(userId, relatedMetadataElement, asOfTime, effectiveTime, methodName));
                        continue;
                    }
                    relatedMetadataElements.add(relatedMetadataElement);
                }
                relatedMetadataElementList = this.openMetadataStoreClient.getRelatedMetadataElements(userId, openMetadataElement.getElementGUID(), 0, null, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize());
            }
            SolutionComponentConverter converter = new SolutionComponentConverter(this.propertyHelper, this.serviceName, this.serverName, relatedSubComponentsElements, relatedPortElements);
            SolutionComponentElement solutionComponentElement = (SolutionComponentElement)converter.getNewComplexBean(SolutionComponentElement.class, openMetadataElement, relatedMetadataElements, methodName);
            if (solutionComponentElement != null) {
                if (addParentContext) {
                    solutionComponentElement.setContext(this.getInformationSupplyChainContext(userId, relatedParentElements, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                }
                SolutionComponentMermaidGraphBuilder graphBuilder = new SolutionComponentMermaidGraphBuilder(solutionComponentElement, fullDisplay);
                solutionComponentElement.setMermaidGraph(graphBuilder.getMermaidGraph());
            }
            return solutionComponentElement;
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logMessage(methodName, DigitalArchitectureAuditCode.UNEXPECTED_CONVERTER_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), methodName, error.getMessage()}));
            }
            return null;
        }
    }

    private List<InformationSupplyChainContext> getInformationSupplyChainContext(String userId, List<RelatedMetadataElement> relatedParentElements, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws PropertyServerException {
        if (relatedParentElements != null) {
            RelatedMetadataElementSummaryConverter converter = new RelatedMetadataElementSummaryConverter(this.propertyHelper, this.serviceName, this.serverName);
            ArrayList<InformationSupplyChainContext> contexts = new ArrayList<InformationSupplyChainContext>();
            for (RelatedMetadataElement parentElement : relatedParentElements) {
                if (parentElement == null) continue;
                if (this.propertyHelper.isTypeOf((ElementControlHeader)parentElement.getElement(), OpenMetadataType.INFORMATION_SUPPLY_CHAIN.typeName)) {
                    InformationSupplyChainContext context = new InformationSupplyChainContext(null, null, (RelatedMetadataElementSummary)converter.getNewBean(RelatedMetadataElementSummary.class, parentElement, methodName));
                    contexts.add(context);
                    continue;
                }
                List<RelatedMetadataElement> fullParentContext = this.getFullParentContext(userId, parentElement, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                RelatedMetadataElementSummary informationSupplyChain = null;
                RelatedMetadataElementSummary linkedSegment = null;
                ArrayList<RelatedMetadataElementSummary> parentComponents = new ArrayList<RelatedMetadataElementSummary>();
                for (RelatedMetadataElement relatedMetadataElement : fullParentContext) {
                    if (relatedMetadataElement == null) continue;
                    RelatedMetadataElementSummary bean = (RelatedMetadataElementSummary)converter.getNewBean(RelatedMetadataElementSummary.class, relatedMetadataElement, methodName);
                    if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement.getElement(), OpenMetadataType.INFORMATION_SUPPLY_CHAIN_SEGMENT.typeName)) {
                        linkedSegment = bean;
                        continue;
                    }
                    if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement.getElement(), OpenMetadataType.INFORMATION_SUPPLY_CHAIN.typeName)) {
                        informationSupplyChain = bean;
                        continue;
                    }
                    parentComponents.add(bean);
                }
                if (parentComponents.isEmpty()) {
                    parentComponents = null;
                }
                InformationSupplyChainContext context = new InformationSupplyChainContext(parentComponents, linkedSegment, informationSupplyChain);
                contexts.add(context);
            }
            return contexts;
        }
        return null;
    }

    private List<RelatedMetadataElement> getFullParentContext(String userId, RelatedMetadataElement initialParentElement, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        ArrayList<RelatedMetadataElement> fullParentContext = new ArrayList<RelatedMetadataElement>();
        fullParentContext.add(initialParentElement);
        try {
            RelatedMetadataElementList additionalParents = this.openMetadataStoreClient.getRelatedMetadataElements(userId, initialParentElement.getElement().getElementGUID(), 2, null, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, 0, 0);
            if (additionalParents != null && additionalParents.getElementList() != null) {
                for (RelatedMetadataElement relatedMetadataElement : additionalParents.getElementList()) {
                    if (relatedMetadataElement == null) continue;
                    if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, OpenMetadataType.INFORMATION_SUPPLY_CHAIN_COMPOSITION_RELATIONSHIP.typeName)) {
                        fullParentContext.add(relatedMetadataElement);
                        continue;
                    }
                    if (!this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, OpenMetadataType.IMPLEMENTED_BY_RELATIONSHIP.typeName)) continue;
                    List<RelatedMetadataElement> higherParents = this.getFullParentContext(userId, relatedMetadataElement, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                    fullParentContext.addAll(higherParents);
                }
            }
        }
        catch (Exception error) {
            this.auditLog.logMessage(methodName, DigitalArchitectureAuditCode.UNEXPECTED_CONVERTER_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), methodName, error.getMessage()}));
        }
        return fullParentContext;
    }

    private SolutionPortElement convertSolutionPort(String userId, RelatedMetadataElement openMetadataElement, Date asOfTime, Date effectiveTime, String methodName) {
        return null;
    }

    private RelatedMetadataElementSummary convertSolutionComponentImplementation(RelatedMetadataElement relatedMetadataElement, String methodName) {
        RelatedMetadataElementSummaryConverter converter = new RelatedMetadataElementSummaryConverter(this.propertyHelper, this.serviceName, this.serverName);
        try {
            return converter.getRelatedElementSummary(RelatedMetadataElementSummary.class, relatedMetadataElement, methodName);
        }
        catch (PropertyServerException error) {
            if (this.auditLog != null) {
                this.auditLog.logMessage(methodName, DigitalArchitectureAuditCode.UNEXPECTED_CONVERTER_EXCEPTION.getMessageDefinition(new String[]{((Object)((Object)error)).getClass().getName(), methodName, error.getMessage()}));
            }
            return null;
        }
    }

    private ElementProperties getElementProperties(InformationSupplyChainProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, properties.getQualifiedName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DISPLAY_NAME.name, properties.getDisplayName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.SCOPE.name, properties.getScope());
            elementProperties = this.propertyHelper.addStringArrayProperty(elementProperties, OpenMetadataProperty.PURPOSES.name, properties.getPurposes());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, properties.getAdditionalProperties());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(InformationSupplyChainSegmentProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, properties.getQualifiedName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DISPLAY_NAME.name, properties.getDisplayName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.SCOPE.name, properties.getScope());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ESTIMATED_VOLUMETRICS.name, properties.getEstimatedVolumetrics());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, properties.getAdditionalProperties());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(InformationSupplyChainLinkProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.LABEL.name, properties.getLabel());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(SolutionBlueprintProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, properties.getQualifiedName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DISPLAY_NAME.name, properties.getDisplayName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.VERSION.name, properties.getVersion());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, properties.getAdditionalProperties());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(SolutionBlueprintCompositionProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.ROLE.name, properties.getRole());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(SolutionComponentProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, properties.getQualifiedName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DISPLAY_NAME.name, properties.getDisplayName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.VERSION.name, properties.getVersion());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.SOLUTION_COMPONENT_TYPE.name, properties.getSolutionComponentType());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.PLANNED_DEPLOYED_IMPLEMENTATION_TYPE.name, properties.getPlannedDeployedImplementationType());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, properties.getAdditionalProperties());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(SolutionLinkingWireProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.LABEL.name, properties.getLabel());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addStringArrayProperty(elementProperties, OpenMetadataProperty.INFORMATION_SUPPLY_CHAIN_SEGMENTS_GUIDS.name, properties.getInformationSupplyChainSegmentGUIDs());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(SolutionPortProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, properties.getQualifiedName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DISPLAY_NAME.name, properties.getDisplayName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.VERSION.name, properties.getVersion());
            if (properties.getSolutionPortDirection() != null) {
                elementProperties = this.propertyHelper.addEnumProperty(elementProperties, OpenMetadataProperty.DIRECTION.name, SolutionPortDirection.getOpenTypeName(), properties.getSolutionPortDirection().getName());
            }
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, properties.getAdditionalProperties());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(ActorRoleProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, properties.getQualifiedName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NAME.name, properties.getTitle());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.IDENTIFIER.name, properties.getRoleId());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.SCOPE.name, properties.getScope());
            elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.DOMAIN_IDENTIFIER.name, properties.getDomainIdentifier());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, properties.getAdditionalProperties());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(SolutionComponentActorRelationshipProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.ROLE.name, properties.getRole());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(ImplementedByProperties properties) {
        if (properties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.DESIGN_STEP.name, properties.getDesignStep());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.ROLE.name, properties.getRole());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, properties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.TRANSFORMATION.name, properties.getTransformation());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, properties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }
}

