/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.digitalarchitecture.client.ValidValuesManager;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.rest.DigitalArchitectureRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class InvalidParameterTest {
    private static final String testCaseName = "InvalidParameterTest";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            InvalidParameterTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        InvalidParameterTest thisTest = new InvalidParameterTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceCode(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceName(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceDescription(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceWiki());
        thisTest.testValidValuesManagerClient(serverName, serverPlatformRootURL, userId, auditLog);
    }

    private void testValidValuesManagerClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testValidValuesManagerClient";
        try {
            DigitalArchitectureRESTClient restClient = new DigitalArchitectureRESTClient(serverName, serverPlatformRootURL);
            ValidValuesManager client = new ValidValuesManager(serverName, serverPlatformRootURL, restClient, 100, auditLog);
            this.testCreateValidValuesSet(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testValidValuesManagerClient", unexpectedError);
        }
    }

    private void testCreateValidValuesSet(String userId, ValidValuesManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateValidValuesSet";
        try {
            this.testCreateValidValuesSetNoUserId(client);
            this.testCreateValidValuesSetNoProperties(client, userId);
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateValidValuesSet", unexpectedError);
        }
    }

    private void testCreateValidValuesSetNoUserId(ValidValuesManager client) throws FVTUnexpectedCondition {
        String activityName = "testCreateValidValuesSetNoUserId";
        try {
            client.createValidValueSet(null, null, null, null, null, null, null, null, null);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateValidValuesSetNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateValidValuesSetNoUserId", unexpectedError);
        }
    }

    private void testCreateValidValuesSetNoProperties(ValidValuesManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testCreateFileSystemNoProperties";
        try {
            client.createValidValueSet(userId, null, null, null, null, null, null, null, null);
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileSystemNoProperties");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testCreateFileSystemNoProperties", unexpectedError);
        }
    }
}

