/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.fvt.connections;

import java.util.List;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.ConnectionManager;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.rest.DigitalArchitectureRESTClient;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.EndpointProperties;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateConnectionTest {
    private static final String testCaseName = "CreateConnectionTest";
    private static final int maxPageSize = 100;
    private static final String connectionName = "TestConnection";
    private static final String connectionDisplayName = "Connection displayName";
    private static final String connectionDescription = "Connection description";
    private static final String endpointName = "TestEndpoint";
    private static final String endpointTechnicalName = "Endpoint technicalName";
    private static final String endpointTechnicalDescription = "Endpoint technicalDescription";
    private static final String connectorTypeName = "TestConnectorType";
    private static final String connectorTypeDisplayName = "ConnectorType displayName";
    private static final String connectorTypeDescription = "ConnectorType description";
    private static final String connectorProviderClassName = "string";
    private static final String connectorTypeTwoName = "TestConnectorType2";
    private static final String connectorTypeTwoDisplayName = "ConnectorType2 displayName";
    private static final boolean isMergeUpdate = true;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateConnectionTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateConnectionTest thisTest = new CreateConnectionTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceCode(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceName(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceDescription(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceWiki());
        ConnectionManager client = thisTest.getConnectionClient(serverName, serverPlatformRootURL, auditLog);
        String connectionGUID = thisTest.getConnection(client, userId);
        String endpointGUID = thisTest.createEndpoint(client, connectionGUID, userId);
        String connectorTypeGUID = thisTest.createConnectorType(client, connectionGUID, userId);
        String activityName = "deleteOneByOne";
        try {
            client.removeConnection(userId, connectionGUID);
            activityName = "deleteOneByOne - connection gone";
            thisTest.checkConnectionGone(client, connectionGUID, activityName, userId);
            thisTest.checkConnectorTypeOK(client, connectorTypeGUID, null, activityName, userId);
            thisTest.checkEndpointOK(client, endpointGUID, null, activityName, userId);
            client.removeConnectorType(userId, connectorTypeGUID);
            activityName = "deleteOneByOne - connectorType gone";
            thisTest.checkConnectorTypeGone(client, connectorTypeGUID, null, activityName, userId);
            thisTest.checkEndpointOK(client, endpointGUID, null, activityName, userId);
            thisTest.checkConnectionGone(client, connectionGUID, activityName, userId);
            client.removeEndpoint(userId, endpointGUID);
            activityName = "deleteOneByOne - endpoint gone";
            thisTest.checkConnectorTypeGone(client, connectorTypeGUID, null, activityName, userId);
            thisTest.checkEndpointGone(client, endpointGUID, null, activityName, userId);
            thisTest.checkConnectionGone(client, connectionGUID, activityName, userId);
            activityName = "updateNonExistentConnectorType";
            String connectorTypeTwoGUID = "Blah Blah";
            ConnectorTypeProperties connectorTypeProperties = new ConnectorTypeProperties();
            connectorTypeProperties.setQualifiedName(connectorTypeTwoName);
            connectorTypeProperties.setDisplayName(connectorTypeDisplayName);
            connectorTypeProperties.setDescription(connectorTypeDescription);
            connectorTypeProperties.setConnectorProviderClassName(connectorProviderClassName);
            try {
                client.updateConnectorType(userId, true, connectorTypeTwoGUID, connectorTypeProperties);
                throw new FVTUnexpectedCondition(testCaseName, activityName);
            }
            catch (InvalidParameterException invalidParameterException) {
                activityName = "updateConnectorTypeWithSameProperties";
                connectorTypeTwoGUID = client.createConnectorType(userId, connectorTypeProperties);
                ConnectorTypeElement beforeElement = client.getConnectorTypeByGUID(userId, connectorTypeTwoGUID);
                client.updateConnectorType(userId, true, connectorTypeTwoGUID, connectorTypeProperties);
                ConnectorTypeElement afterElement = client.getConnectorTypeByGUID(userId, connectorTypeTwoGUID);
                if (!beforeElement.getElementHeader().getVersions().equals((Object)afterElement.getElementHeader().getVersions())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(version changed from " + beforeElement.getElementHeader().getVersions() + " to " + afterElement.getElementHeader().getVersions() + ")");
                }
                activityName = "updateConnectorTypeProperties";
                connectorTypeProperties.setDisplayName(connectorTypeTwoDisplayName);
                client.updateConnectorType(userId, true, connectorTypeTwoGUID, connectorTypeProperties);
                afterElement = client.getConnectorTypeByGUID(userId, connectorTypeTwoGUID);
                if (beforeElement.getElementHeader().getVersions().equals((Object)afterElement.getElementHeader().getVersions())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(version did not change from " + beforeElement.getElementHeader().getVersions() + ")");
                }
                if (!connectorTypeTwoDisplayName.equals(afterElement.getConnectorTypeProperties().getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(display name should be ConnectorType2 displayName rather than " + afterElement.getConnectorTypeProperties().getDisplayName() + ")");
                }
            }
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private ConnectionManager getConnectionClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getConnectionExchangeClient";
        try {
            DigitalArchitectureRESTClient restClient = new DigitalArchitectureRESTClient(serverName, serverPlatformRootURL);
            return new ConnectionManager(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getConnectionExchangeClient", (Throwable)unexpectedError);
        }
    }

    private void checkConnectionGone(ConnectionManager client, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            ConnectionElement retrievedElement = client.getConnectionByGUID(userId, connectionGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Connection returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Retrieve returned)");
        }
        catch (InvalidParameterException retrievedElement) {
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private void checkConnectionOK(ConnectionManager client, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            ConnectionElement retrievedElement = client.getConnectionByGUID(userId, connectionGUID);
            if (retrievedElement == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectionElement from Retrieve)");
            }
            ConnectionProperties retrievedConnection = retrievedElement.getConnectionProperties();
            if (retrievedConnection == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectionProperties from Retrieve)");
            }
            if (!connectionName.equals(retrievedConnection.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve) =>>" + retrievedConnection);
            }
            if (!connectionDisplayName.equals(retrievedConnection.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve) =>>" + retrievedConnection);
            }
            if (!connectionDescription.equals(retrievedConnection.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve) =>>" + retrievedConnection);
            }
            List connectionList = client.getConnectionsByName(userId, connectionName, 0, 100);
            if (connectionList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Connection for RetrieveByName)");
            }
            if (connectionList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty Connection list for RetrieveByName)");
            }
            if (connectionList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Connection list for RetrieveByName contains" + connectionList.size() + " elements) =>>" + connectionList);
            }
            retrievedElement = (ConnectionElement)connectionList.get(0);
            retrievedConnection = retrievedElement.getConnectionProperties();
            if (!connectionName.equals(retrievedConnection.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName) =>>" + retrievedConnection);
            }
            if (!connectionDisplayName.equals(retrievedConnection.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName) =>>" + retrievedConnection);
            }
            if (!connectionDescription.equals(retrievedConnection.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName) =>>" + retrievedConnection);
            }
            connectionList = client.getConnectionsByName(userId, connectionName, 1, 100);
            if (connectionList != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "Connection for RetrieveByName (from 1) =>>" + retrievedConnection);
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
    }

    private String getConnection(ConnectionManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "getConnection";
        try {
            ConnectionProperties properties = new ConnectionProperties();
            properties.setQualifiedName(connectionName);
            properties.setDisplayName(connectionDisplayName);
            properties.setDescription(connectionDescription);
            String connectionGUID = client.createConnection(userId, properties);
            if (connectionGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getConnection(no GUID for Create)");
            }
            this.checkConnectionOK(client, connectionGUID, "getConnection", userId);
            return connectionGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getConnection", (Throwable)unexpectedError);
        }
    }

    private void checkEndpointGone(ConnectionManager client, String endpointGUID, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            EndpointElement retrievedElement = client.getEndpointByGUID(userId, endpointGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Endpoint returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getEndpointByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        if (connectionGUID != null) {
            try {
                ConnectionElement connection = client.getConnectionByGUID(userId, connectionGUID);
                ElementStub endpoint = connection.getEndpoint();
                if (endpoint != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Endpoint " + endpoint + " returned for connection)");
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private void checkEndpointOK(ConnectionManager client, String endpointGUID, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        block20: {
            try {
                EndpointElement retrievedElement = client.getEndpointByGUID(userId, endpointGUID);
                if (retrievedElement == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no EndpointElement from Retrieve)");
                }
                EndpointProperties retrievedEndpoint = retrievedElement.getEndpointProperties();
                if (retrievedEndpoint == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no EndpointProperties from Retrieve)");
                }
                if (!endpointName.equals(retrievedEndpoint.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve) =>>" + retrievedEndpoint);
                }
                if (!endpointTechnicalName.equals(retrievedEndpoint.getResourceName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad technicalName from Retrieve) =>>" + retrievedEndpoint);
                }
                if (!endpointTechnicalDescription.equals(retrievedEndpoint.getResourceDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad technicalDescription from Retrieve) =>>" + retrievedEndpoint);
                }
                List endpointList = client.getEndpointsByName(userId, endpointName, 0, 100);
                if (endpointList == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no Endpoint for RetrieveByName)");
                }
                if (endpointList.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty Endpoint list for RetrieveByName)");
                }
                if (endpointList.size() != 1) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Endpoint list for RetrieveByName contains" + endpointList.size() + " elements)");
                }
                retrievedElement = (EndpointElement)endpointList.get(0);
                retrievedEndpoint = retrievedElement.getEndpointProperties();
                if (!endpointName.equals(retrievedEndpoint.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName) =>>" + retrievedEndpoint);
                }
                if (!endpointTechnicalName.equals(retrievedEndpoint.getResourceName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName) =>>" + retrievedEndpoint);
                }
                if (!endpointTechnicalDescription.equals(retrievedEndpoint.getResourceDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName) =>>" + retrievedEndpoint);
                }
                if (connectionGUID == null) break block20;
                try {
                    ConnectionElement connection = client.getConnectionByGUID(userId, connectionGUID);
                    ElementStub endpoint = connection.getEndpoint();
                    if (endpoint == null) {
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(No Endpoint returned for connection)");
                    }
                    if (!endpointGUID.equals(endpoint.getGUID())) {
                        System.out.println("ConnectionGUID: " + connectionGUID);
                        System.out.println("EndpointGUID: " + endpointGUID);
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong Endpoint returned for connection: " + endpoint.getGUID() + "rather than " + endpointGUID + ")");
                    }
                    if (!endpointName.equals(endpoint.getUniqueName())) {
                        System.out.println("ConnectionGUID: " + connectionGUID);
                        System.out.println("Endpoint: " + endpoint);
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong Endpoint Qualified Name returned for connection: " + endpoint.getUniqueName() + "rather than TestEndpoint)");
                    }
                }
                catch (FVTUnexpectedCondition testCaseError) {
                    throw testCaseError;
                }
                catch (Exception unexpectedError) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private String createEndpoint(ConnectionManager client, String connectionGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createEndpoint";
        try {
            EndpointProperties properties = new EndpointProperties();
            properties.setQualifiedName(endpointName);
            properties.setResourceName(endpointTechnicalName);
            properties.setResourceDescription(endpointTechnicalDescription);
            String endpointGUID = client.createEndpoint(userId, properties);
            if (endpointGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createEndpoint(no GUID for endpointCreate)");
            }
            client.setupEndpoint(userId, connectionGUID, endpointGUID);
            this.checkEndpointOK(client, endpointGUID, connectionGUID, "createEndpoint", userId);
            return endpointGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createEndpoint", (Throwable)unexpectedError);
        }
    }

    private void checkConnectorTypeGone(ConnectionManager client, String connectorTypeGUID, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        try {
            ConnectorTypeElement retrievedElement = client.getConnectorTypeByGUID(userId, connectorTypeGUID);
            if (retrievedElement != null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(ConnectorType returned from Retrieve)");
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(getConnectorTypeByGUID returned");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (InvalidParameterException testCaseError) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
        }
        if (connectionGUID != null) {
            try {
                ConnectionElement connection = client.getConnectionByGUID(userId, connectionGUID);
                ElementStub connectorType = connection.getConnectorType();
                if (connectorType != null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Connector Type " + connectorType + " returned for Connection)");
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private void checkConnectorTypeOK(ConnectionManager client, String connectorTypeGUID, String connectionGUID, String activityName, String userId) throws FVTUnexpectedCondition {
        block20: {
            try {
                ConnectorTypeElement retrievedElement = client.getConnectorTypeByGUID(userId, connectorTypeGUID);
                if (retrievedElement == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectorTypeElement from Retrieve)");
                }
                ConnectorTypeProperties retrievedConnectorType = retrievedElement.getConnectorTypeProperties();
                if (retrievedConnectorType == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectorTypeProperties from Retrieve)");
                }
                if (!connectorTypeName.equals(retrievedConnectorType.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from Retrieve) =>>" + retrievedConnectorType);
                }
                if (!connectorTypeDisplayName.equals(retrievedConnectorType.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from Retrieve) =>>" + retrievedConnectorType);
                }
                if (!connectorTypeDescription.equals(retrievedConnectorType.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve) =>>" + retrievedConnectorType);
                }
                List connectorTypeList = client.getConnectorTypesByName(userId, connectorTypeName, 0, 100);
                if (connectorTypeList == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no ConnectorType for RetrieveByName)");
                }
                if (connectorTypeList.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty ConnectorType list for RetrieveByName)");
                }
                if (connectorTypeList.size() != 1) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(ConnectorType list for RetrieveByName contains" + connectorTypeList.size() + " elements)");
                }
                retrievedElement = (ConnectorTypeElement)connectorTypeList.get(0);
                retrievedConnectorType = retrievedElement.getConnectorTypeProperties();
                if (!connectorTypeName.equals(retrievedConnectorType.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad qualifiedName from RetrieveByName) =>>" + retrievedConnectorType);
                }
                if (!connectorTypeDisplayName.equals(retrievedConnectorType.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad displayName from RetrieveByName) =>>" + retrievedConnectorType);
                }
                if (!connectorTypeDescription.equals(retrievedConnectorType.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName) =>>" + retrievedConnectorType);
                }
                if (connectionGUID == null) break block20;
                try {
                    ConnectionElement connection = client.getConnectionByGUID(userId, connectionGUID);
                    ElementStub connectorType = connection.getConnectorType();
                    if (connectorType == null) {
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(No connectorType returned for connection: " + connection + ")");
                    }
                    if (!connectorTypeGUID.equals(connectorType.getGUID())) {
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong connector type returned for connection: " + connectorType.getGUID() + "rather than " + connectorTypeGUID + ")");
                    }
                    if (!connectorTypeName.equals(connectorType.getUniqueName())) {
                        throw new FVTUnexpectedCondition(testCaseName, activityName + "(Wrong connector type Qualified Name returned for connection: " + connectorType.getUniqueName() + "rather than TestEndpoint)");
                    }
                }
                catch (FVTUnexpectedCondition testCaseError) {
                    throw testCaseError;
                }
                catch (Exception unexpectedError) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
                }
            }
            catch (FVTUnexpectedCondition testCaseError) {
                throw testCaseError;
            }
            catch (Exception unexpectedError) {
                throw new FVTUnexpectedCondition(testCaseName, activityName, (Throwable)unexpectedError);
            }
        }
    }

    private String createConnectorType(ConnectionManager client, String connectionGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createConnectorType";
        try {
            ConnectorTypeProperties properties = new ConnectorTypeProperties();
            properties.setQualifiedName(connectorTypeName);
            properties.setDisplayName(connectorTypeDisplayName);
            properties.setDescription(connectorTypeDescription);
            properties.setConnectorProviderClassName(connectorProviderClassName);
            String connectorTypeGUID = client.createConnectorType(userId, properties);
            if (connectorTypeGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createConnectorType(no GUID for connectorTypeCreate)");
            }
            if (connectionGUID != null) {
                client.setupConnectorType(userId, connectionGUID, connectorTypeGUID);
            }
            this.checkConnectorTypeOK(client, connectorTypeGUID, connectionGUID, "createConnectorType", userId);
            return connectorTypeGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createConnectorType", (Throwable)unexpectedError);
        }
    }
}

