/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.fvt.clientconstructors;

import org.odpi.openmetadata.accessservices.digitalarchitecture.client.ReferenceDataManager;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.rest.DigitalArchitectureRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;

public class ClientConstructorTest {
    private static final String testCaseName = "ClientConstructorTest";
    private static final String serverUserId = "TestNPA";
    private static final String serverPassword = "TestNPAPassword";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            ClientConstructorTest.runIt(serverPlatformRootURL, serverName, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, FVTAuditLogDestination auditLogDestination) throws InvalidParameterException {
        ClientConstructorTest thisTest = new ClientConstructorTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceCode(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceName(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceDescription(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceWiki());
        thisTest.testValidValuesManagerClient(serverName, serverPlatformRootURL, auditLog);
    }

    private void testValidValuesManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new ReferenceDataManager(serverName, serverPlatformRootURL, 100, auditLog);
        new ReferenceDataManager(serverName, serverPlatformRootURL, 100);
        new ReferenceDataManager(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100, auditLog);
        new ReferenceDataManager(serverName, serverPlatformRootURL, serverUserId, serverPassword, 100);
        DigitalArchitectureRESTClient restClient = new DigitalArchitectureRESTClient(serverName, serverPlatformRootURL);
        new ReferenceDataManager(serverName, serverPlatformRootURL, restClient, 100, auditLog);
    }
}

