/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.fvt.locations;

import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.LocationManager;
import org.odpi.openmetadata.accessservices.digitalarchitecture.client.rest.DigitalArchitectureRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.LocationElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.locations.LocationProperties;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateLocationsTest {
    private static final String testCaseName = "CreateLocationTest";
    private static final int maxPageSize = 100;
    private static final String siteName = "Site:London";
    private static final String siteIdentifier = "London identifier";
    private static final String siteDisplayName = "London displayName";
    private static final String siteDescription = "London description";
    private static final String facility1Name = "Facility:London Data Centre";
    private static final String facility1Identifier = "London Data Centre identifier";
    private static final String facility1DisplayName = "London Data Centre displayName";
    private static final String facility1Description = "London Data Centre description";
    private static final String facility1AdditionalPropertyName = "London Data Centre additionalPropertyName";
    private static final String facility1AdditionalPropertyValue = "London Data Centre additionalPropertyValue";
    private static final String facility2Name = "Facility:London Office";
    private static final String facility2Identifier = "London Office identifier";
    private static final String facility2DisplayName = "London Office displayName";
    private static final String facility2Description = "London Office description";
    private static final String facility2NameUpdate = "Facility:London Office - updated";
    private static final String searchString = ".*London.*";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateLocationsTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateLocationsTest thisTest = new CreateLocationsTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceCode(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceName(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceDescription(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceWiki());
        LocationManager client = thisTest.getLocationManagerClient(serverName, serverPlatformRootURL, auditLog);
        String siteGUID = thisTest.createSite(client, userId);
        thisTest.createFacilities(client, siteGUID, userId);
        thisTest.deleteLocations(client, siteGUID, userId);
    }

    private LocationManager getLocationManagerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getLocationManagerClient";
        try {
            DigitalArchitectureRESTClient restClient = new DigitalArchitectureRESTClient(serverName, serverPlatformRootURL);
            return new LocationManager(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getLocationManagerClient", (Throwable)unexpectedError);
        }
    }

    private String createSite(LocationManager client, String userId) throws FVTUnexpectedCondition {
        String activityName = "createSite";
        try {
            LocationProperties locationProperties = new LocationProperties();
            locationProperties.setQualifiedName(siteName);
            locationProperties.setIdentifier(siteIdentifier);
            locationProperties.setDisplayName(siteDisplayName);
            locationProperties.setDescription(siteDescription);
            String siteGUID = client.createLocation(userId, locationProperties);
            if (siteGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createSite(no GUID for Create Site)");
            }
            client.setLocationAsFixedPhysical(userId, siteGUID, null, null, null, "GMT");
            LocationElement retrievedElement = client.getLocationByGUID(userId, siteGUID);
            LocationProperties retrievedSite = retrievedElement.getLocationProperties();
            if (retrievedSite == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createSite(no Site from Retrieve)");
            }
            if (!siteName.equals(retrievedSite.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createSite(Bad qualifiedName from Site Retrieve)");
            }
            if (!siteDisplayName.equals(retrievedSite.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createSite(Bad displayName from Site Retrieve)");
            }
            if (!siteDescription.equals(retrievedSite.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "createSite(Bad description from Site Retrieve)");
            }
            List siteList = client.getLocationsByName(userId, siteName, 0, 100);
            if (siteList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createSite(no site for RetrieveByName)");
            }
            if (siteList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "createSite(Empty location  list for Site RetrieveByName)");
            }
            if (siteList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "createSite(Site for RetrieveByName contains" + siteList.size() + " elements)");
            }
            retrievedElement = (LocationElement)siteList.get(0);
            retrievedSite = retrievedElement.getLocationProperties();
            if (!siteName.equals(retrievedSite.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createSite(Bad qualifiedName from Site RetrieveByName)");
            }
            if (!siteDisplayName.equals(retrievedSite.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createSite(Bad displayName from Site RetrieveByName)");
            }
            if (!siteDescription.equals(retrievedSite.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "createSite(Bad description from Site RetrieveByName)");
            }
            return siteGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createSite", (Throwable)unexpectedError);
        }
    }

    private void createFacilities(LocationManager client, String siteGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "createFacilities";
        try {
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            additionalProperties.put(facility1AdditionalPropertyName, facility1AdditionalPropertyValue);
            LocationProperties locationProperties = new LocationProperties();
            locationProperties.setQualifiedName(facility1Name);
            locationProperties.setIdentifier(facility1Identifier);
            locationProperties.setDisplayName(facility1DisplayName);
            locationProperties.setDescription(facility1Description);
            locationProperties.setAdditionalProperties(additionalProperties);
            String facility1GUID = client.createLocation(userId, locationProperties);
            if (facility1GUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(no GUID for Create of definition 1)");
            }
            client.setLocationAsFixedPhysical(userId, facility1GUID, null, null, null, "GMT");
            client.setupNestedLocation(userId, siteGUID, facility1GUID);
            LocationElement retrievedElement = client.getLocationByGUID(userId, facility1GUID);
            LocationProperties retrievedProperties = retrievedElement.getLocationProperties();
            if (retrievedProperties == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(no Valid Values definition 1 from Retrieve)");
            }
            if (!facility1Name.equals(retrievedProperties.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad qualifiedName from Retrieve of 1)");
            }
            if (!facility1DisplayName.equals(retrievedProperties.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad displayName from Retrieve of 1)");
            }
            if (!facility1Description.equals(retrievedProperties.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad description from Retrieve of 1)");
            }
            if (retrievedProperties.getAdditionalProperties() == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(null additionalProperties from Retrieve of 1)");
            }
            if (!facility1AdditionalPropertyValue.equals(retrievedProperties.getAdditionalProperties().get(facility1AdditionalPropertyName))) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(bad additionalProperties from Retrieve of 1)");
            }
            List facilityList = client.getLocationsByName(userId, facility1Name, 0, 100);
            if (facilityList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(no facility for RetrieveByName of 1)");
            }
            if (facilityList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Empty facility list for RetrieveByName of 1)");
            }
            if (facilityList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Facility list for RetrieveByName of 1 contains" + facilityList.size() + " elements)");
            }
            retrievedElement = (LocationElement)facilityList.get(0);
            retrievedProperties = retrievedElement.getLocationProperties();
            if (retrievedProperties == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(no Facility 1 from Retrieve)");
            }
            if (!facility1Name.equals(retrievedProperties.getQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad qualifiedName from Facility 1 RetrieveByName of 1)");
            }
            if (!facility1DisplayName.equals(retrievedProperties.getDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad displayName from Facility 1 RetrieveByName of 1)");
            }
            if (!facility1Description.equals(retrievedProperties.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad description from Facility 1 RetrieveByName of 1)");
            }
            facilityList = client.findLocations(userId, searchString, 0, 100);
            if (facilityList == null) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(no location  for findLocations of 1)");
            }
            if (facilityList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Empty location  list for findLocations of 1)");
            }
            if (facilityList.size() != 2) {
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Locations for findLocations of 1 contains" + facilityList.size() + " elements)");
            }
            try {
                client.createLocation(userId, locationProperties);
                throw new FVTUnexpectedCondition(testCaseName, "createFacilities(duplicate create of facility allowed)");
            }
            catch (InvalidParameterException invalidParameterException) {
                locationProperties = new LocationProperties();
                locationProperties.setQualifiedName(facility2Name);
                locationProperties.setIdentifier(facility2Identifier);
                locationProperties.setDisplayName(facility2DisplayName);
                locationProperties.setDescription(facility2Description);
                locationProperties.setAdditionalProperties(additionalProperties);
                String facility2GUID = client.createLocation(userId, locationProperties);
                if (facility2GUID == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(no GUID for Create of definition 2)");
                }
                retrievedElement = client.getLocationByGUID(userId, facility2GUID);
                retrievedProperties = retrievedElement.getLocationProperties();
                if (retrievedProperties == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(no Valid Values definition 2 from Retrieve)");
                }
                if (!facility2Name.equals(retrievedProperties.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad qualifiedName from Retrieve of 2)");
                }
                if (!facility2DisplayName.equals(retrievedProperties.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad displayName from Retrieve of 2)");
                }
                if (!facility2Description.equals(retrievedProperties.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad description from Retrieve of 2)");
                }
                facilityList = client.getLocationsByName(userId, facility2Name, 0, 100);
                if (facilityList == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(no location  for RetrieveByName of 2)");
                }
                if (facilityList.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Empty location  list for RetrieveByName of 2)");
                }
                if (facilityList.size() != 1) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Locations for RetrieveByName of 2 contains" + facilityList.size() + " elements)");
                }
                retrievedElement = (LocationElement)facilityList.get(0);
                retrievedProperties = retrievedElement.getLocationProperties();
                if (!facility2Name.equals(retrievedProperties.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad qualifiedName from RetrieveByName of 2)");
                }
                if (!facility2DisplayName.equals(retrievedProperties.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad displayName from RetrieveByName of 2)");
                }
                if (!facility2Description.equals(retrievedProperties.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad description from RetrieveByName of 2)");
                }
                facilityList = client.findLocations(userId, searchString, 0, 100);
                if (facilityList == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(no location  for findLocations of all)");
                }
                if (facilityList.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Empty location  list for findLocations of all)");
                }
                if (facilityList.size() != 3) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Locations for findLocations of all contains" + facilityList.size() + " elements)");
                }
                locationProperties = new LocationProperties();
                locationProperties.setDisplayName(facility2NameUpdate);
                client.updateLocation(userId, true, facility2GUID, locationProperties);
                retrievedElement = client.getLocationByGUID(userId, facility2GUID);
                retrievedProperties = retrievedElement.getLocationProperties();
                if (!facility2Name.equals(retrievedProperties.getQualifiedName())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad qualifiedName from RetrieveUpdate of 2)");
                }
                if (!facility2NameUpdate.equals(retrievedProperties.getDisplayName())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad displayName from RetrieveUpdate of 2)");
                }
                if (!facility2Description.equals(retrievedProperties.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad description from RetrieveUpdate of 2)");
                }
                if (!facility2Identifier.equals(retrievedProperties.getIdentifier())) {
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad identifier from RetrieveUpdate of 2)");
                }
                try {
                    locationProperties = new LocationProperties();
                    locationProperties.setQualifiedName(facility1Name);
                    client.updateLocation(userId, true, facility2GUID, locationProperties);
                    throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Duplicate update allowed)");
                }
                catch (InvalidParameterException invalidParameterException2) {
                    retrievedElement = client.getLocationByGUID(userId, facility2GUID);
                    retrievedProperties = retrievedElement.getLocationProperties();
                    if (!facility2Name.equals(retrievedProperties.getQualifiedName())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad qualifiedName from RetrieveUpdate of 2 after qualified name failed change)");
                    }
                    if (!facility2NameUpdate.equals(retrievedProperties.getDisplayName())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad displayName from RetrieveUpdate of 2 after qualified name failed change)");
                    }
                    if (!facility2Description.equals(retrievedProperties.getDescription())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad description from RetrieveUpdate of 2 after qualified name failed change)");
                    }
                    if (!facility2Identifier.equals(retrievedProperties.getIdentifier())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad identifier from RetrieveUpdate of 2)");
                    }
                    locationProperties = new LocationProperties();
                    locationProperties.setQualifiedName(facility2NameUpdate);
                    client.updateLocation(userId, true, facility2GUID, locationProperties);
                    retrievedElement = client.getLocationByGUID(userId, facility2GUID);
                    retrievedProperties = retrievedElement.getLocationProperties();
                    if (!facility2NameUpdate.equals(retrievedProperties.getQualifiedName())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad qualifiedName from RetrieveUpdate of 2 after qualified name change)");
                    }
                    if (!facility2NameUpdate.equals(retrievedProperties.getDisplayName())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad displayName from RetrieveUpdate of 2 after qualified name change)");
                    }
                    if (!facility2Description.equals(retrievedProperties.getDescription())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad description from RetrieveUpdate of 2 after qualified name change)");
                    }
                    if (!facility2Identifier.equals(retrievedProperties.getIdentifier())) {
                        throw new FVTUnexpectedCondition(testCaseName, "createFacilities(Bad identifier from RetrieveUpdate of 2 after qualified name change)");
                    }
                }
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "createFacilities", (Throwable)unexpectedError);
        }
    }

    private void deleteLocations(LocationManager client, String siteGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "deleteValidValuesSet";
        try {
            client.removeLocation(userId, siteGUID);
            try {
                client.getLocationByGUID(userId, siteGUID);
                throw new FVTUnexpectedCondition(testCaseName, "deleteValidValuesSet(Deleted site returned)");
            }
            catch (InvalidParameterException invalidParameterException) {
                List searchResults = client.findLocations(userId, searchString, 0, 100);
                if (searchResults == null) {
                    throw new FVTUnexpectedCondition(testCaseName, "deleteValidValuesSet(cascaded delete occurred)");
                }
                for (LocationElement locationElement : searchResults) {
                    client.removeLocation(userId, locationElement.getElementHeader().getGUID());
                }
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "deleteValidValuesSet", (Throwable)unexpectedError);
        }
    }
}

