/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ReferenceDataAssetElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ReferenceValueAssignmentDefinitionElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ReferenceValueAssignmentItemElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueAssignmentConsumerElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueAssignmentDefinitionElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueImplAssetElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueImplDefinitionElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueMappingElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValuesMappingElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ReferenceValueAssignmentProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValueAssignmentProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValueProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValuesImplProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValuesMappingProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ReferenceValueAssignmentDefinitionsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ReferenceValueAssignmentItemsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueAssignmentConsumersResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueAssignmentDefinitionsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueMappingsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesImplAssetsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesImplDefinitionsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesMappingsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.server.DigitalArchitectureInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ValidValuesHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class ValidValuesRESTServices {
    private static DigitalArchitectureInstanceHandler instanceHandler = new DigitalArchitectureInstanceHandler();
    private static RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ValidValuesRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createValidValueSet(String serverName, String userId, ValidValueProperties requestBody) {
        String methodName = "createValidValueSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createValidValueSet");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createValidValueSet");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "createValidValueSet");
                response.setGUID(handler.createValidValueSet(userId, null, null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.getIsDeprecated(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "createValidValueSet"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createValidValueSet", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createValidValueSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createValidValueDefinition(String serverName, String userId, String setGUID, ValidValueProperties requestBody) {
        String methodName = "createValidValueDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createValidValueDefinition");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createValidValueDefinition");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "createValidValueDefinition");
                response.setGUID(handler.createValidValueDefinition(userId, null, null, setGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.getPreferredValue(), requestBody.getIsDeprecated(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "createValidValueDefinition"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createValidValueDefinition", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createValidValueDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateValidValue(String serverName, String userId, String validValueGUID, ValidValueProperties requestBody) {
        String methodName = "updateValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateValidValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateValidValue");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "updateValidValue");
                handler.updateValidValue(userId, null, null, validValueGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.getPreferredValue(), requestBody.getIsDeprecated(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "updateValidValue");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateValidValue", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteValidValue(String serverName, String userId, String validValueGUID, String qualifiedName) {
        String methodName = "deleteValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteValidValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteValidValue");
            if (qualifiedName != null) {
                ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "deleteValidValue");
                handler.deleteValidValue(userId, null, null, validValueGUID, qualifiedName, "deleteValidValue");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "deleteValidValue", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "deleteValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachValidValueToSet(String serverName, String userId, String setGUID, String validValueGUID, NullRequestBody requestBody) {
        String methodName = "attachValidValueToSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachValidValueToSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachValidValueToSet");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "attachValidValueToSet");
            handler.attachValidValueToSet(userId, null, null, setGUID, validValueGUID, "attachValidValueToSet");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "attachValidValueToSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachValidValueFromSet(String serverName, String userId, String setGUID, String validValueGUID, NullRequestBody requestBody) {
        String methodName = "detachValidValueFromSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachValidValueFromSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachValidValueFromSet");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "detachValidValueFromSet");
            handler.detachValidValueFromSet(userId, null, null, setGUID, validValueGUID, "detachValidValueFromSet");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "detachValidValueFromSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkValidValueToImplementation(String serverName, String userId, String validValueGUID, String assetGUID, ValidValuesImplProperties requestBody) {
        String methodName = "linkValidValueToImplementation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkValidValueToImplementation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        String symbolicName = null;
        String implementationValue = null;
        Map additionalValues = null;
        if (requestBody != null) {
            symbolicName = requestBody.getSymbolicName();
            implementationValue = requestBody.getImplementationValue();
            additionalValues = requestBody.getAdditionalValues();
        }
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkValidValueToImplementation");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "linkValidValueToImplementation");
            handler.linkValidValueToImplementation(userId, null, null, validValueGUID, assetGUID, symbolicName, implementationValue, additionalValues, "linkValidValueToImplementation");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "linkValidValueToImplementation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse classifyAssetAsReferenceData(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "classifyAssetAsReferenceData";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "classifyAssetAsReferenceData");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "classifyAssetAsReferenceData");
            AssetHandler<ReferenceDataAssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "classifyAssetAsReferenceData");
            handler.classifyAssetAsReferenceData(userId, assetGUID, "assetGUID", "classifyAssetAsReferenceData");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "classifyAssetAsReferenceData", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkValidValueFromImplementation(String serverName, String userId, String validValueGUID, String assetGUID, NullRequestBody requestBody) {
        String methodName = "unlinkValidValueFromImplementation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkValidValueFromImplementation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkValidValueFromImplementation");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "unlinkValidValueFromImplementation");
            handler.unlinkValidValueFromImplementation(userId, null, null, validValueGUID, assetGUID, "unlinkValidValueFromImplementation");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "unlinkValidValueFromImplementation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse declassifyAssetAsReferenceData(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "declassifyAssetAsReferenceData";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "declassifyAssetAsReferenceData");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "declassifyAssetAsReferenceData");
            AssetHandler<ReferenceDataAssetElement> handler = instanceHandler.getAssetHandler(userId, serverName, "declassifyAssetAsReferenceData");
            handler.declassifyAssetAsReferenceData(userId, assetGUID, "assetGUID", "declassifyAssetAsReferenceData");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "declassifyAssetAsReferenceData", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse assignValidValueToConsumer(String serverName, String userId, String validValueGUID, String consumerGUID, ValidValueAssignmentProperties requestBody) {
        String methodName = "assignValidValueToConsumer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "assignValidValueToConsumer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        boolean strictRequirement = false;
        if (requestBody != null) {
            strictRequirement = requestBody.getStrictRequirement();
        }
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "assignValidValueToConsumer");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "assignValidValueToConsumer");
            handler.assignValidValueToConsumer(userId, null, null, validValueGUID, consumerGUID, strictRequirement, "assignValidValueToConsumer");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "assignValidValueToConsumer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unassignValidValueFromConsumer(String serverName, String userId, String validValueGUID, String consumerGUID, NullRequestBody requestBody) {
        String methodName = "unassignValidValueFromConsumer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unassignValidValueFromConsumer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unassignValidValueFromConsumer");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "unassignValidValueFromConsumer");
            handler.unassignValidValueFromConsumer(userId, null, null, validValueGUID, consumerGUID, "unassignValidValueFromConsumer");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "unassignValidValueFromConsumer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse assignReferenceValueToItem(String serverName, String userId, String validValueGUID, String referenceableGUID, ReferenceValueAssignmentProperties requestBody) {
        String methodName = "assignReferenceValueToItem";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "assignReferenceValueToItem");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        int confidence = 0;
        String steward = null;
        String notes = null;
        if (requestBody != null) {
            confidence = requestBody.getConfidence();
            steward = requestBody.getSteward();
            notes = requestBody.getNotes();
        }
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "assignReferenceValueToItem");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "assignReferenceValueToItem");
            handler.assignReferenceValueToItem(userId, null, null, validValueGUID, referenceableGUID, confidence, steward, notes, "assignReferenceValueToItem");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "assignReferenceValueToItem", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unassignReferenceValueFromItem(String serverName, String userId, String validValueGUID, String referenceableGUID, NullRequestBody requestBody) {
        String methodName = "unassignReferenceValueFromItem";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unassignReferenceValueFromItem");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unassignReferenceValueFromItem");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "unassignReferenceValueFromItem");
            handler.unassignReferenceValueFromItem(userId, null, null, validValueGUID, referenceableGUID, "unassignReferenceValueFromItem");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "unassignReferenceValueFromItem", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse mapValidValues(String serverName, String userId, String validValue1GUID, String validValue2GUID, ValidValuesMappingProperties requestBody) {
        String methodName = "mapValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "mapValidValues");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        String associationDescription = null;
        int confidence = 0;
        String steward = null;
        String notes = null;
        if (requestBody != null) {
            associationDescription = requestBody.getAssociationDescription();
            confidence = requestBody.getConfidence();
            steward = requestBody.getSteward();
            notes = requestBody.getNotes();
        }
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "mapValidValues");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "mapValidValues");
            handler.mapValidValues(userId, null, null, validValue1GUID, validValue2GUID, associationDescription, confidence, steward, notes, "mapValidValues");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "mapValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unmapValidValues(String serverName, String userId, String validValue1GUID, String validValue2GUID, NullRequestBody requestBody) {
        String methodName = "unmapValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unmapValidValues");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unmapValidValues");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "unmapValidValues");
            handler.unmapValidValues(userId, null, null, validValue1GUID, validValue2GUID, "unmapValidValues");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "unmapValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueResponse getValidValueByGUID(String serverName, String userId, String validValueGUID) {
        String methodName = "getValidValueByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueByGUID");
        ValidValueResponse response = new ValidValueResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueByGUID");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueByGUID");
            ValidValueElement validValue = (ValidValueElement)handler.getValidValueByGUID(userId, validValueGUID, "getValidValueByGUID");
            response.setElement(validValue);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getValidValueByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getValidValueByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String nameParameterName = "validValueName";
        String methodName = "getValidValueByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueByName");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueByName");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueByName");
                List validValues = handler.getValidValueByName(userId, requestBody.getName(), "validValueName", startFrom, pageSize, "getValidValueByName");
                response.setElementList(validValues);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getValidValueByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse findValidValues(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String searchStringParameterName = "searchString";
        String methodName = "findValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findValidValues");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findValidValues");
            if (requestBody != null) {
                ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "findValidValues");
                List validValues = handler.findValidValues(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, "findValidValues");
                response.setElementList(validValues);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "findValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getValidValueSetMembers(String serverName, String userId, String validValueSetGUID, int startFrom, int pageSize) {
        String validValueGUIDParameter = "validValueSetGUID";
        String methodName = "getValidValueSetMembers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueSetMembers");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueSetMembers");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueSetMembers");
            List validValues = handler.getValidValueSetMembers(userId, validValueSetGUID, "validValueSetGUID", startFrom, pageSize, "getValidValueSetMembers");
            response.setElementList(validValues);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getValidValueSetMembers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getSetsForValidValue(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String validValueGUIDParameter = "validValueGUID";
        String methodName = "getSetsForValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSetsForValidValue");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSetsForValidValue");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getSetsForValidValue");
            List validValues = handler.getSetsForValidValue(userId, validValueGUID, "validValueGUID", startFrom, pageSize, "getSetsForValidValue");
            response.setElementList(validValues);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getSetsForValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueAssignmentConsumersResponse getValidValuesAssignmentConsumers(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String validValueGUIDParameter = "validValueGUID";
        String methodName = "getValidValuesAssignmentConsumers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesAssignmentConsumers");
        ValidValueAssignmentConsumersResponse response = new ValidValueAssignmentConsumersResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesAssignmentConsumers");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValuesAssignmentConsumers");
            List validValueConsumers = handler.getValidValuesAssignmentConsumers(userId, validValueGUID, "validValueGUID", instanceHandler.getSupportedZones(userId, serverName, "getValidValuesAssignmentConsumers"), startFrom, pageSize, "getValidValuesAssignmentConsumers");
            response.setElementList(validValueConsumers);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getValidValuesAssignmentConsumers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueAssignmentDefinitionsResponse getValidValuesAssignmentDefinition(String serverName, String userId, String referenceableGUID, int startFrom, int pageSize) {
        String referenceableGUIDParameter = "referencableGUID";
        String methodName = "getValidValuesAssignmentDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesAssignmentDefinition");
        ValidValueAssignmentDefinitionsResponse response = new ValidValueAssignmentDefinitionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesAssignmentDefinition");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValuesAssignmentDefinition");
            List validValueAssignmentDefinitions = handler.getValidValuesAssignmentDefinition(userId, referenceableGUID, "referencableGUID", startFrom, pageSize, "getValidValuesAssignmentDefinition");
            response.setElementList(validValueAssignmentDefinitions);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getValidValuesAssignmentDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesImplAssetsResponse getValidValuesImplementationAssets(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String methodName = "getValidValuesImplementationAssets";
        String validValueGUIDParameterName = "validValueGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesImplementationAssets");
        ValidValuesImplAssetsResponse response = new ValidValuesImplAssetsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesImplementationAssets");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> validValuesHandler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValuesImplementationAssets");
            List validValueImplAssetElements = validValuesHandler.getValidValuesImplementationAssets(userId, validValueGUID, "validValueGUID", instanceHandler.getSupportedZones(userId, serverName, "getValidValuesImplementationAssets"), startFrom, pageSize, "getValidValuesImplementationAssets");
            response.setElementList(validValueImplAssetElements);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getValidValuesImplementationAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesImplDefinitionsResponse getValidValuesImplementationDefinitions(String serverName, String userId, String assetGUID, int startFrom, int pageSize) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "getValidValuesImplementationDefinitions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesImplementationDefinitions");
        ValidValuesImplDefinitionsResponse response = new ValidValuesImplDefinitionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesImplementationDefinitions");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> validValuesHandler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValuesImplementationDefinitions");
            List definitions = validValuesHandler.getValidValuesImplementationDefinitions(userId, assetGUID, "assetGUID", startFrom, pageSize, "getValidValuesImplementationDefinitions");
            response.setElementList(definitions);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getValidValuesImplementationDefinitions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueMappingsResponse getValidValueMappings(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String validValueGUIDParameter = "validValueGUID";
        String methodName = "getValidValueMappings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueMappings");
        ValidValueMappingsResponse response = new ValidValueMappingsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueMappings");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueMappings");
            List validValuesMappings = handler.getValidValueMappings(userId, validValueGUID, "validValueGUID", startFrom, pageSize, "getValidValueMappings");
            response.setElementList(validValuesMappings);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getValidValueMappings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesMappingsResponse getValidValuesMappings(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String validValueGUIDParameter = "validValueGUID";
        String methodName = "getValidValuesMappings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesMappings");
        ValidValuesMappingsResponse response = new ValidValuesMappingsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesMappings");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValuesMappings");
            ValidValueElement validValueElement = (ValidValueElement)handler.getValidValueByGUID(userId, validValueGUID, "getValidValuesMappings");
            List validValuesMappings = handler.getValidValueMappings(userId, validValueGUID, "validValueGUID", startFrom, pageSize, "getValidValuesMappings");
            if (validValuesMappings != null && !validValuesMappings.isEmpty()) {
                ArrayList<ValidValuesMappingElement> elements = new ArrayList<ValidValuesMappingElement>();
                for (ValidValueMappingElement validValueMapping : validValuesMappings) {
                    if (validValueMapping == null) continue;
                    ValidValuesMappingElement validValuesMappingElement = new ValidValuesMappingElement();
                    if (validValueMapping.getValidValueElement() != null) {
                        ArrayList<ValidValueElement> validValueElements = new ArrayList<ValidValueElement>();
                        validValueElements.add(validValueElement);
                        validValueElements.add(validValueMapping.getValidValueElement());
                        validValuesMappingElement.setValidValueElements(validValueElements);
                    }
                    validValuesMappingElement.setAssociationDescription(validValueMapping.getAssociationDescription());
                    validValuesMappingElement.setConfidence(validValueMapping.getConfidence());
                    validValuesMappingElement.setSteward(validValueMapping.getSteward());
                    validValuesMappingElement.setNotes(validValueMapping.getNotes());
                    elements.add(validValuesMappingElement);
                }
                if (!elements.isEmpty()) {
                    response.setElementList(elements);
                }
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getValidValuesMappings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ReferenceValueAssignmentItemsResponse getReferenceValueAssignedItems(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String validValueGUIDParameter = "validValueGUID";
        String methodName = "getReferenceValueAssignedItems";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getReferenceValueAssignedItems");
        ReferenceValueAssignmentItemsResponse response = new ReferenceValueAssignmentItemsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getReferenceValueAssignedItems");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getReferenceValueAssignedItems");
            List assignedItems = handler.getReferenceValueAssignedItems(userId, validValueGUID, "validValueGUID", instanceHandler.getSupportedZones(userId, serverName, "getReferenceValueAssignedItems"), startFrom, pageSize, "getReferenceValueAssignedItems");
            response.setElementList(assignedItems);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getReferenceValueAssignedItems", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ReferenceValueAssignmentDefinitionsResponse getReferenceValueAssignments(String serverName, String userId, String referenceableGUID, int startFrom, int pageSize) {
        String guidParameterName = "referenceableGUID";
        String methodName = "getValidValuesAssignmentDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesAssignmentDefinition");
        ReferenceValueAssignmentDefinitionsResponse response = new ReferenceValueAssignmentDefinitionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesAssignmentDefinition");
            ValidValuesHandler<ValidValueElement, ValidValueAssignmentConsumerElement, ValidValueAssignmentDefinitionElement, ValidValueImplAssetElement, ValidValueImplDefinitionElement, ValidValueMappingElement, ReferenceValueAssignmentDefinitionElement, ReferenceValueAssignmentItemElement> handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValuesAssignmentDefinition");
            List referenceValueAssignments = handler.getReferenceValueAssignments(userId, referenceableGUID, "referenceableGUID", startFrom, pageSize, "getValidValuesAssignmentDefinition");
            response.setElementList(referenceValueAssignments);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getValidValuesAssignmentDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

