/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ElementOrigin;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ElementOriginCategory;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ElementType;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ReferenceDataAssetElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ReferenceValueAssignmentDefinitionElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ReferenceValueAssignmentItemElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ReferenceableElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueAssignmentConsumerElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueAssignmentDefinitionElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueImplAssetElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueImplDefinitionElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueMappingElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValuesMappingElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.OwnerCategory;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ReferenceValueAssignmentProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValueAssignmentProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValueProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValuesImplProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValuesMappingProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ReferenceValueAssignmentDefinitionsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ReferenceValueAssignmentItemsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueAssignmentConsumersResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueAssignmentDefinitionsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueMappingsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesImplAssetsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesImplDefinitionsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesMappingsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.server.DigitalArchitectureInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AssetHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ValidValuesHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Classification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Meaning;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ReferenceValueAssignedItem;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ReferenceValueAssignment;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValue;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValueImplementationAsset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValueImplementationDefinition;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValueMapping;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValuesAssignmentConsumer;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValuesAssignmentDefinition;
import org.slf4j.LoggerFactory;

public class ValidValuesRESTServices {
    private static DigitalArchitectureInstanceHandler instanceHandler = new DigitalArchitectureInstanceHandler();
    private static RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ValidValuesRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createValidValueSet(String serverName, String userId, ValidValueProperties requestBody) {
        String methodName = "createValidValueSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createValidValueSet");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createValidValueSet");
            if (requestBody != null) {
                ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "createValidValueSet");
                response.setGUID(handler.createValidValueSet(userId, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.isDeprecated(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "createValidValueSet"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createValidValueSet", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createValidValueSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createExternalValidValueSet(String serverName, String userId, String externalSourceGUID, String externalSourceName, ValidValueProperties requestBody) {
        String methodName = "createExternalValidValueSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createExternalValidValueSet");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createExternalValidValueSet");
            if (requestBody != null) {
                ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "createExternalValidValueSet");
                response.setGUID(handler.createExternalValidValueSet(userId, externalSourceGUID, externalSourceName, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.isDeprecated(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "createExternalValidValueSet"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createExternalValidValueSet", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createExternalValidValueSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createValidValueDefinition(String serverName, String userId, String setGUID, ValidValueProperties requestBody) {
        String methodName = "createValidValueDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createValidValueDefinition");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createValidValueDefinition");
            if (requestBody != null) {
                ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "createValidValueDefinition");
                response.setGUID(handler.createValidValueDefinition(userId, setGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.getPreferredValue(), requestBody.isDeprecated(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "createValidValueDefinition"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createValidValueDefinition", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createValidValueDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createExternalValidValueDefinition(String serverName, String userId, String externalSourceGUID, String externalSourceName, String setGUID, ValidValueProperties requestBody) {
        String methodName = "createExternalValidValueDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createExternalValidValueDefinition");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createExternalValidValueDefinition");
            if (requestBody != null) {
                ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "createExternalValidValueDefinition");
                response.setGUID(handler.createExternalValidValueDefinition(userId, externalSourceGUID, externalSourceName, setGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.getPreferredValue(), requestBody.isDeprecated(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "createExternalValidValueDefinition"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createExternalValidValueDefinition", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createExternalValidValueDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateValidValue(String serverName, String userId, String validValueGUID, ValidValueProperties requestBody) {
        String methodName = "updateValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateValidValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateValidValue");
            if (requestBody != null) {
                ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "updateValidValue");
                handler.updateValidValue(userId, validValueGUID, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsage(), requestBody.getScope(), requestBody.getPreferredValue(), requestBody.isDeprecated(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), "updateValidValue");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateValidValue", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updateValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteValidValue(String serverName, String userId, String validValueGUID, String qualifiedName) {
        String methodName = "deleteValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteValidValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteValidValue");
            if (qualifiedName != null) {
                ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "deleteValidValue");
                handler.deleteValidValue(userId, validValueGUID, qualifiedName, "deleteValidValue");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "deleteValidValue", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "deleteValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse attachValidValueToSet(String serverName, String userId, String setGUID, String validValueGUID, NullRequestBody requestBody) {
        String methodName = "attachValidValueToSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "attachValidValueToSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "attachValidValueToSet");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "attachValidValueToSet");
            handler.attachValidValueToSet(userId, setGUID, validValueGUID, "attachValidValueToSet");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "attachValidValueToSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachValidValueFromSet(String serverName, String userId, String setGUID, String validValueGUID, NullRequestBody requestBody) {
        String methodName = "detachValidValueFromSet";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "detachValidValueFromSet");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachValidValueFromSet");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "detachValidValueFromSet");
            handler.detachValidValueFromSet(userId, setGUID, validValueGUID, "detachValidValueFromSet");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "detachValidValueFromSet", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkValidValueToImplementation(String serverName, String userId, String validValueGUID, String assetGUID, ValidValuesImplProperties requestBody) {
        String methodName = "linkValidValueToImplementation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkValidValueToImplementation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        String symbolicName = null;
        String implementationValue = null;
        Map additionalValues = null;
        if (requestBody != null) {
            symbolicName = requestBody.getSymbolicName();
            implementationValue = requestBody.getImplementationValue();
            additionalValues = requestBody.getAdditionalValues();
        }
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkValidValueToImplementation");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "linkValidValueToImplementation");
            handler.linkValidValueToImplementation(userId, validValueGUID, assetGUID, symbolicName, implementationValue, additionalValues, "linkValidValueToImplementation");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "linkValidValueToImplementation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse classifyAssetAsReferenceData(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String methodName = "classifyAssetAsReferenceData";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "classifyAssetAsReferenceData");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "classifyAssetAsReferenceData");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "classifyAssetAsReferenceData");
            handler.classifyAssetAsReferenceData(userId, assetGUID, instanceHandler.getSupportedZones(userId, serverName, "classifyAssetAsReferenceData"), "classifyAssetAsReferenceData");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "classifyAssetAsReferenceData", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unlinkValidValueFromImplementation(String serverName, String userId, String validValueGUID, String assetGUID, NullRequestBody requestBody) {
        String methodName = "unlinkValidValueFromImplementation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unlinkValidValueFromImplementation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkValidValueFromImplementation");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "unlinkValidValueFromImplementation");
            handler.unlinkValidValueFromImplementation(userId, validValueGUID, assetGUID, "unlinkValidValueFromImplementation");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "unlinkValidValueFromImplementation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse declassifyAssetAsReferenceData(String serverName, String userId, String assetGUID, NullRequestBody requestBody) {
        String methodName = "declassifyAssetAsReferenceData";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "declassifyAssetAsReferenceData");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "declassifyAssetAsReferenceData");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "declassifyAssetAsReferenceData");
            handler.declassifyAssetAsReferenceData(userId, assetGUID, instanceHandler.getSupportedZones(userId, serverName, "declassifyAssetAsReferenceData"), "declassifyAssetAsReferenceData");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "declassifyAssetAsReferenceData", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse assignValidValueToConsumer(String serverName, String userId, String validValueGUID, String consumerGUID, ValidValueAssignmentProperties requestBody) {
        String methodName = "assignValidValueToConsumer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "assignValidValueToConsumer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        boolean strictRequirement = false;
        if (requestBody != null) {
            strictRequirement = requestBody.isStrictRequirement();
        }
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "assignValidValueToConsumer");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "assignValidValueToConsumer");
            handler.assignValidValueToConsumer(userId, validValueGUID, consumerGUID, strictRequirement, "assignValidValueToConsumer");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "assignValidValueToConsumer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unassignValidValueFromConsumer(String serverName, String userId, String validValueGUID, String consumerGUID, NullRequestBody requestBody) {
        String methodName = "unassignValidValueFromConsumer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unassignValidValueFromConsumer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unassignValidValueFromConsumer");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "unassignValidValueFromConsumer");
            handler.unassignValidValueFromConsumer(userId, validValueGUID, consumerGUID, "unassignValidValueFromConsumer");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "unassignValidValueFromConsumer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse assignReferenceValueToItem(String serverName, String userId, String validValueGUID, String referenceableGUID, ReferenceValueAssignmentProperties requestBody) {
        String methodName = "assignReferenceValueToItem";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "assignReferenceValueToItem");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        int confidence = 0;
        String steward = null;
        String notes = null;
        if (requestBody != null) {
            confidence = requestBody.getConfidence();
            steward = requestBody.getSteward();
            notes = requestBody.getNotes();
        }
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "assignReferenceValueToItem");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "assignReferenceValueToItem");
            handler.assignReferenceValueToItem(userId, validValueGUID, referenceableGUID, confidence, steward, notes, "assignReferenceValueToItem");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "assignReferenceValueToItem", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unassignReferenceValueFromItem(String serverName, String userId, String validValueGUID, String referenceableGUID, NullRequestBody requestBody) {
        String methodName = "unassignReferenceValueFromItem";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unassignReferenceValueFromItem");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unassignReferenceValueFromItem");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "unassignReferenceValueFromItem");
            handler.unassignReferenceValueFromItem(userId, validValueGUID, referenceableGUID, "unassignReferenceValueFromItem");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "unassignReferenceValueFromItem", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse mapValidValues(String serverName, String userId, String validValue1GUID, String validValue2GUID, ValidValuesMappingProperties requestBody) {
        String methodName = "mapValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "mapValidValues");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        String associationDescription = null;
        int confidence = 0;
        String steward = null;
        String notes = null;
        if (requestBody != null) {
            associationDescription = requestBody.getAssociationDescription();
            confidence = requestBody.getConfidence();
            steward = requestBody.getSteward();
            notes = requestBody.getNotes();
        }
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "mapValidValues");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "mapValidValues");
            handler.mapValidValues(userId, validValue1GUID, validValue2GUID, associationDescription, confidence, steward, notes, "mapValidValues");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "mapValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unmapValidValues(String serverName, String userId, String validValue1GUID, String validValue2GUID, NullRequestBody requestBody) {
        String methodName = "unmapValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unmapValidValues");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unmapValidValues");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "unmapValidValues");
            handler.unmapValidValues(userId, validValue1GUID, validValue2GUID, "unmapValidValues");
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "unmapValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueResponse getValidValueByGUID(String serverName, String userId, String validValueGUID) {
        String methodName = "getValidValueByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueByGUID");
        ValidValueResponse response = new ValidValueResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueByGUID");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueByGUID");
            ValidValue validValue = handler.getValidValueByGUID(userId, validValueGUID, "getValidValueByGUID");
            response.setElement(this.getValidValue(validValue));
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getValidValueByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getValidValueByName(String serverName, String userId, String validValueName) {
        String methodName = "getValidValueByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueByName");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueByName");
            if (validValueName != null) {
                ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueByName");
                List validValues = handler.getValidValueByName(userId, validValueName, "getValidValueByName");
                response.setElementList(this.getValidValues(validValues));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getValidValueByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse findValidValues(String serverName, String userId, String searchString, int startFrom, int pageSize) {
        String methodName = "findValidValues";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findValidValues");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findValidValues");
            if (searchString != null) {
                ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "findValidValues");
                List validValues = handler.findValidValues(userId, searchString, startFrom, pageSize, "findValidValues");
                response.setElementList(this.getValidValues(validValues));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "findValidValues", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getValidValueSetMembers(String serverName, String userId, String validValueSetGUID, int startFrom, int pageSize) {
        String methodName = "getValidValueSetMembers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueSetMembers");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueSetMembers");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueSetMembers");
            List validValues = handler.getValidValueSetMembers(userId, validValueSetGUID, startFrom, pageSize, "getValidValueSetMembers");
            response.setElementList(this.getValidValues(validValues));
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getValidValueSetMembers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesResponse getSetsForValidValue(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String methodName = "getSetsForValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSetsForValidValue");
        ValidValuesResponse response = new ValidValuesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSetsForValidValue");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "getSetsForValidValue");
            List validValues = handler.getSetsForValidValue(userId, validValueGUID, startFrom, pageSize, "getSetsForValidValue");
            response.setElementList(this.getValidValues(validValues));
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getSetsForValidValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueAssignmentConsumersResponse getValidValuesAssignmentConsumers(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String methodName = "getValidValuesAssignmentConsumers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesAssignmentConsumers");
        ValidValueAssignmentConsumersResponse response = new ValidValueAssignmentConsumersResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesAssignmentConsumers");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValuesAssignmentConsumers");
            List validValueConsumers = handler.getValidValuesAssignmentConsumers(userId, validValueGUID, instanceHandler.getSupportedZones(userId, serverName, "getValidValuesAssignmentConsumers"), startFrom, pageSize, "getValidValuesAssignmentConsumers");
            if (validValueConsumers != null && !validValueConsumers.isEmpty()) {
                ArrayList<ValidValueAssignmentConsumerElement> elements = new ArrayList<ValidValueAssignmentConsumerElement>();
                for (ValidValuesAssignmentConsumer validValueConsumer : validValueConsumers) {
                    if (validValueConsumer == null) continue;
                    ValidValueAssignmentConsumerElement validValueAssignmentConsumerElement = new ValidValueAssignmentConsumerElement();
                    Referenceable referenceableBean = validValueConsumer.getConsumer();
                    ReferenceableElement referenceableElement = new ReferenceableElement();
                    referenceableElement.setElementHeader(this.getElementHeader(referenceableBean));
                    referenceableElement.setQualifiedName(referenceableBean.getQualifiedName());
                    referenceableElement.setTypeName(referenceableBean.getType().getElementTypeName());
                    referenceableElement.setAdditionalProperties(referenceableBean.getAdditionalProperties());
                    referenceableElement.setExtendedProperties(referenceableBean.getExtendedProperties());
                    referenceableElement.setClassifications(this.getClassifications(referenceableBean));
                    referenceableElement.setMeanings(this.getMeanings(referenceableBean));
                    validValueAssignmentConsumerElement.setConsumer(referenceableElement);
                    validValueAssignmentConsumerElement.setStrictRequirement(validValueConsumer.isStrictRequirement());
                    elements.add(validValueAssignmentConsumerElement);
                }
                if (!elements.isEmpty()) {
                    response.setElementList(elements);
                }
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getValidValuesAssignmentConsumers", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueAssignmentDefinitionsResponse getValidValuesAssignmentDefinition(String serverName, String userId, String referenceableGUID, int startFrom, int pageSize) {
        String methodName = "getValidValuesAssignmentDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesAssignmentDefinition");
        ValidValueAssignmentDefinitionsResponse response = new ValidValueAssignmentDefinitionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesAssignmentDefinition");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValuesAssignmentDefinition");
            List validValueAssignmentDefinitions = handler.getValidValuesAssignmentDefinition(userId, referenceableGUID, startFrom, pageSize, "getValidValuesAssignmentDefinition");
            if (validValueAssignmentDefinitions != null && !validValueAssignmentDefinitions.isEmpty()) {
                ArrayList<ValidValueAssignmentDefinitionElement> elements = new ArrayList<ValidValueAssignmentDefinitionElement>();
                for (ValidValuesAssignmentDefinition validValueDefinition : validValueAssignmentDefinitions) {
                    if (validValueDefinition == null) continue;
                    ValidValueAssignmentDefinitionElement validValueAssignmentDefinitionElement = new ValidValueAssignmentDefinitionElement();
                    if (validValueDefinition.getValidValue() != null) {
                        validValueAssignmentDefinitionElement.setValidValueElement(this.getValidValue(validValueDefinition.getValidValue()));
                    }
                    validValueAssignmentDefinitionElement.setStrictRequirement(validValueDefinition.isStrictRequirement());
                    elements.add(validValueAssignmentDefinitionElement);
                }
                if (!elements.isEmpty()) {
                    response.setElementList(elements);
                }
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getValidValuesAssignmentDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesImplAssetsResponse getValidValuesImplementationAssets(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String methodName = "getValidValuesImplementationAssets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesImplementationAssets");
        ValidValuesImplAssetsResponse response = new ValidValuesImplAssetsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesImplementationAssets");
            ValidValuesHandler validValuesHandler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValuesImplementationAssets");
            AssetHandler assetHandler = instanceHandler.getAssetHandler(userId, serverName, "getValidValuesImplementationAssets");
            List validValueImplementations = validValuesHandler.getValidValuesImplementationAssets(userId, validValueGUID, instanceHandler.getSupportedZones(userId, serverName, "getValidValuesImplementationAssets"), startFrom, pageSize, "getValidValuesImplementationAssets");
            if (validValueImplementations != null && !validValueImplementations.isEmpty()) {
                ArrayList<ValidValueImplAssetElement> validValueImplAssetElements = new ArrayList<ValidValueImplAssetElement>();
                for (ValidValueImplementationAsset assetImplementation : validValueImplementations) {
                    if (assetImplementation == null) continue;
                    ValidValueImplAssetElement validValueImplAssetElement = new ValidValueImplAssetElement();
                    validValueImplAssetElement.setAdditionalValues(assetImplementation.getAdditionalValues());
                    validValueImplAssetElement.setImplementationValue(assetImplementation.getImplementationValue());
                    validValueImplAssetElement.setSymbolicName(assetImplementation.getSymbolicName());
                    Asset asset = assetImplementation.getReferenceDataAsset();
                    if (asset != null) {
                        ReferenceDataAssetElement assetElement = new ReferenceDataAssetElement();
                        assetElement.setElementHeader(this.getElementHeader((Referenceable)asset));
                        assetElement.setDisplayName(asset.getDisplayName());
                        assetElement.setDescription(asset.getDescription());
                        assetElement.setLatestChange(asset.getLatestChange());
                        assetElement.setTypeName(asset.getType().getElementTypeName());
                        assetElement.setAdditionalProperties(asset.getAdditionalProperties());
                        assetElement.setExtendedProperties(asset.getExtendedProperties());
                        assetElement.setClassifications(this.getClassifications((Referenceable)asset));
                        assetElement.setMeanings(this.getMeanings((Referenceable)asset));
                        assetElement.setOrigin(asset.getOrigin());
                        assetElement.setZoneMembership(asset.getZoneMembership());
                        assetElement.setOwner(asset.getOwner());
                        if (asset.getOwnerType() != null) {
                            switch (asset.getOwnerType()) {
                                case USER_ID: {
                                    assetElement.setOwnerCategory(OwnerCategory.USER_ID);
                                    break;
                                }
                                case PROFILE_ID: {
                                    assetElement.setOwnerCategory(OwnerCategory.PROFILE_ID);
                                    break;
                                }
                                case OTHER: {
                                    assetElement.setOwnerCategory(OwnerCategory.OTHER);
                                }
                            }
                        }
                        validValueImplAssetElement.setReferenceDataAsset(assetElement);
                        validValueImplAssetElement.setReferenceDataConnections(assetHandler.getConnectionsForAsset(userId, asset.getGUID()));
                    }
                    validValueImplAssetElements.add(validValueImplAssetElement);
                }
                response.setElementList(validValueImplAssetElements);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getValidValuesImplementationAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesImplDefinitionsResponse getValidValuesImplementationDefinitions(String serverName, String userId, String assetGUID, int startFrom, int pageSize) {
        String methodName = "getValidValuesImplementationDefinitions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesImplementationDefinitions");
        ValidValuesImplDefinitionsResponse response = new ValidValuesImplDefinitionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesImplementationDefinitions");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getValidValuesImplementationDefinitions");
            List definitions = handler.getValidValuesImplementationDefinitions(userId, assetGUID, instanceHandler.getSupportedZones(userId, serverName, "getValidValuesImplementationDefinitions"), startFrom, pageSize, "getValidValuesImplementationDefinitions");
            if (definitions != null && !definitions.isEmpty()) {
                ArrayList<ValidValueImplDefinitionElement> elements = new ArrayList<ValidValueImplDefinitionElement>();
                for (ValidValueImplementationDefinition validValueDefinition : definitions) {
                    if (validValueDefinition == null) continue;
                    ValidValueImplDefinitionElement element = new ValidValueImplDefinitionElement();
                    if (validValueDefinition.getValidValue() != null) {
                        element.setValidValueElement(this.getValidValue(validValueDefinition.getValidValue()));
                    }
                    element.setSymbolicName(validValueDefinition.getSymbolicName());
                    element.setImplementationValue(validValueDefinition.getImplementationValue());
                    element.setAdditionalValues(validValueDefinition.getAdditionalValues());
                    elements.add(element);
                }
                if (!elements.isEmpty()) {
                    response.setElementList(elements);
                }
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getValidValuesImplementationDefinitions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValueMappingsResponse getValidValueMappings(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String methodName = "getValidValueMappings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValueMappings");
        ValidValueMappingsResponse response = new ValidValueMappingsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValueMappings");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValueMappings");
            List validValuesMappings = handler.getValidValueMappings(userId, validValueGUID, startFrom, pageSize, "getValidValueMappings");
            if (validValuesMappings != null && !validValuesMappings.isEmpty()) {
                ArrayList<ValidValueMappingElement> elements = new ArrayList<ValidValueMappingElement>();
                for (ValidValueMapping validValueMapping : validValuesMappings) {
                    if (validValueMapping == null) continue;
                    ValidValueMappingElement validValuesMappingElement = new ValidValueMappingElement();
                    if (validValueMapping.getValidValue() != null) {
                        validValuesMappingElement.setValidValueElement(this.getValidValue(validValueMapping.getValidValue()));
                    }
                    validValuesMappingElement.setAssociationDescription(validValueMapping.getAssociationDescription());
                    validValuesMappingElement.setConfidence(validValueMapping.getConfidence());
                    validValuesMappingElement.setSteward(validValueMapping.getSteward());
                    validValuesMappingElement.setNotes(validValueMapping.getNotes());
                    elements.add(validValuesMappingElement);
                }
                if (!elements.isEmpty()) {
                    response.setElementList(elements);
                }
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getValidValueMappings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ValidValuesMappingsResponse getValidValuesMappings(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String methodName = "getValidValuesMappings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesMappings");
        ValidValuesMappingsResponse response = new ValidValuesMappingsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesMappings");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValuesMappings");
            ValidValue thisValidValue = handler.getValidValueByGUID(userId, validValueGUID, "getValidValuesMappings");
            ValidValueElement thisValidValueElement = this.getValidValue(thisValidValue);
            List validValuesMappings = handler.getValidValueMappings(userId, validValueGUID, startFrom, pageSize, "getValidValuesMappings");
            if (validValuesMappings != null && !validValuesMappings.isEmpty()) {
                ArrayList<ValidValuesMappingElement> elements = new ArrayList<ValidValuesMappingElement>();
                for (ValidValueMapping validValueMapping : validValuesMappings) {
                    if (validValueMapping == null) continue;
                    ValidValuesMappingElement validValuesMappingElement = new ValidValuesMappingElement();
                    if (validValueMapping.getValidValue() != null) {
                        ArrayList<ValidValueElement> validValueElements = new ArrayList<ValidValueElement>();
                        validValueElements.add(thisValidValueElement);
                        validValueElements.add(this.getValidValue(validValueMapping.getValidValue()));
                        validValuesMappingElement.setValidValueElements(validValueElements);
                    }
                    validValuesMappingElement.setAssociationDescription(validValueMapping.getAssociationDescription());
                    validValuesMappingElement.setConfidence(validValueMapping.getConfidence());
                    validValuesMappingElement.setSteward(validValueMapping.getSteward());
                    validValuesMappingElement.setNotes(validValueMapping.getNotes());
                    elements.add(validValuesMappingElement);
                }
                if (!elements.isEmpty()) {
                    response.setElementList(elements);
                }
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getValidValuesMappings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ReferenceValueAssignmentItemsResponse getReferenceValueAssignedItems(String serverName, String userId, String validValueGUID, int startFrom, int pageSize) {
        String methodName = "getReferenceValueAssignedItems";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getReferenceValueAssignedItems");
        ReferenceValueAssignmentItemsResponse response = new ReferenceValueAssignmentItemsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getReferenceValueAssignedItems");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "getReferenceValueAssignedItems");
            List assignedItems = handler.getReferenceValueAssignedItems(userId, validValueGUID, instanceHandler.getSupportedZones(userId, serverName, "getReferenceValueAssignedItems"), startFrom, pageSize, "getReferenceValueAssignedItems");
            if (assignedItems != null && !assignedItems.isEmpty()) {
                ArrayList<ReferenceValueAssignmentItemElement> elements = new ArrayList<ReferenceValueAssignmentItemElement>();
                for (ReferenceValueAssignedItem assignedItem : assignedItems) {
                    if (assignedItem == null) continue;
                    ReferenceValueAssignmentItemElement element = new ReferenceValueAssignmentItemElement();
                    Referenceable referenceableBean = assignedItem.getAssignedItem();
                    ReferenceableElement referenceableElement = new ReferenceableElement();
                    referenceableElement.setElementHeader(this.getElementHeader(referenceableBean));
                    referenceableElement.setQualifiedName(referenceableBean.getQualifiedName());
                    referenceableElement.setTypeName(referenceableBean.getType().getElementTypeName());
                    referenceableElement.setAdditionalProperties(referenceableBean.getAdditionalProperties());
                    referenceableElement.setExtendedProperties(referenceableBean.getExtendedProperties());
                    referenceableElement.setClassifications(this.getClassifications(referenceableBean));
                    referenceableElement.setMeanings(this.getMeanings(referenceableBean));
                    element.setAssignedItem(referenceableElement);
                    element.setConfidence(assignedItem.getConfidence());
                    element.setSteward(assignedItem.getSteward());
                    element.setNotes(assignedItem.getNotes());
                    elements.add(element);
                }
                if (!elements.isEmpty()) {
                    response.setElementList(elements);
                }
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getReferenceValueAssignedItems", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ReferenceValueAssignmentDefinitionsResponse getReferenceValueAssignments(String serverName, String userId, String referenceableGUID, int startFrom, int pageSize) {
        String methodName = "getValidValuesAssignmentDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getValidValuesAssignmentDefinition");
        ReferenceValueAssignmentDefinitionsResponse response = new ReferenceValueAssignmentDefinitionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getValidValuesAssignmentDefinition");
            ValidValuesHandler handler = instanceHandler.getValidValuesHandler(userId, serverName, "getValidValuesAssignmentDefinition");
            List referenceValueAssignments = handler.getReferenceValueAssignments(userId, referenceableGUID, startFrom, pageSize, "getValidValuesAssignmentDefinition");
            if (referenceValueAssignments != null && !referenceValueAssignments.isEmpty()) {
                ArrayList<ReferenceValueAssignmentDefinitionElement> elements = new ArrayList<ReferenceValueAssignmentDefinitionElement>();
                for (ReferenceValueAssignment referenceValueAssignment : referenceValueAssignments) {
                    if (referenceValueAssignment == null) continue;
                    ReferenceValueAssignmentDefinitionElement element = new ReferenceValueAssignmentDefinitionElement();
                    if (referenceValueAssignment.getValidValue() != null) {
                        element.setValidValueElement(this.getValidValue(referenceValueAssignment.getValidValue()));
                    }
                    element.setConfidence(referenceValueAssignment.getConfidence());
                    element.setSteward(referenceValueAssignment.getSteward());
                    element.setNotes(referenceValueAssignment.getNotes());
                    elements.add(element);
                }
                if (!elements.isEmpty()) {
                    response.setElementList(elements);
                }
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getValidValuesAssignmentDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private ElementHeader getElementHeader(Referenceable bean) {
        ElementHeader header = null;
        if (bean != null) {
            header = new ElementHeader();
            header.setGUID(bean.getGUID());
            if (bean.getType() != null) {
                ElementType type = new ElementType();
                ElementOrigin origin = new ElementOrigin();
                type.setTypeId(bean.getType().getElementTypeId());
                type.setTypeName(bean.getType().getElementTypeName());
                type.setTypeDescription(bean.getType().getElementTypeDescription());
                type.setTypeVersion(bean.getType().getElementTypeVersion());
                type.setSuperTypeNames(bean.getType().getElementSuperTypeNames());
                origin.setHomeMetadataCollectionId(bean.getType().getElementHomeMetadataCollectionId());
                origin.setHomeMetadataCollectionName(bean.getType().getElementHomeMetadataCollectionName());
                origin.setLicense(bean.getType().getElementLicense());
                origin.setSourceServer(bean.getType().getElementSourceServer());
                if (bean.getType().getElementOrigin() != null) {
                    switch (bean.getType().getElementOrigin()) {
                        case UNKNOWN: {
                            origin.setOriginCategory(ElementOriginCategory.UNKNOWN);
                            break;
                        }
                        case LOCAL_COHORT: {
                            origin.setOriginCategory(ElementOriginCategory.LOCAL_COHORT);
                            break;
                        }
                        case EXPORT_ARCHIVE: {
                            origin.setOriginCategory(ElementOriginCategory.EXPORT_ARCHIVE);
                            break;
                        }
                        case CONTENT_PACK: {
                            origin.setOriginCategory(ElementOriginCategory.CONTENT_PACK);
                            break;
                        }
                        case DEREGISTERED_REPOSITORY: {
                            origin.setOriginCategory(ElementOriginCategory.DEREGISTERED_REPOSITORY);
                            break;
                        }
                        case CONFIGURATION: {
                            origin.setOriginCategory(ElementOriginCategory.CONFIGURATION);
                            break;
                        }
                        case EXTERNAL_SOURCE: {
                            origin.setOriginCategory(ElementOriginCategory.EXTERNAL_SOURCE);
                        }
                    }
                }
                header.setType(type);
                header.setOrigin(origin);
            }
        }
        return header;
    }

    private List<org.odpi.openmetadata.accessservices.digitalarchitecture.properties.Classification> getClassifications(Referenceable bean) {
        ArrayList<org.odpi.openmetadata.accessservices.digitalarchitecture.properties.Classification> classifications = null;
        if (bean != null && bean.getClassifications() != null) {
            classifications = new ArrayList<org.odpi.openmetadata.accessservices.digitalarchitecture.properties.Classification>();
            for (Classification classification : bean.getClassifications()) {
                if (classification == null) continue;
                org.odpi.openmetadata.accessservices.digitalarchitecture.properties.Classification result = new org.odpi.openmetadata.accessservices.digitalarchitecture.properties.Classification();
                result.setClassificationName(classification.getClassificationName());
                result.setClassificationProperties(classification.getClassificationProperties());
                classifications.add(result);
            }
            if (classifications.isEmpty()) {
                classifications = null;
            }
        }
        return classifications;
    }

    private List<String> getMeanings(Referenceable bean) {
        ArrayList<String> meanings = null;
        if (bean != null && bean.getMeanings() != null) {
            meanings = new ArrayList<String>();
            for (Meaning meaning : bean.getMeanings()) {
                if (meaning == null) continue;
                meanings.add(meaning.getGUID());
            }
            if (meanings.isEmpty()) {
                meanings = null;
            }
        }
        return meanings;
    }

    private ValidValueElement getValidValue(ValidValue validValue) {
        ValidValueElement validValueElement = null;
        if (validValue != null) {
            validValueElement = new ValidValueElement();
            validValueElement.setElementHeader(this.getElementHeader((Referenceable)validValue));
            validValueElement.setQualifiedName(validValue.getQualifiedName());
            validValueElement.setDisplayName(validValue.getDisplayName());
            validValueElement.setDescription(validValue.getDescription());
            validValueElement.setDeprecated(validValue.isDeprecated());
            validValueElement.setScope(validValue.getScope());
            validValueElement.setUsage(validValue.getUsage());
            validValueElement.setPreferredValue(validValue.getPreferredValue());
            validValueElement.setTypeName(validValue.getType().getElementTypeName());
            validValueElement.setAdditionalProperties(validValue.getAdditionalProperties());
            validValueElement.setExtendedProperties(validValue.getExtendedProperties());
            validValueElement.setClassifications(this.getClassifications((Referenceable)validValue));
            validValueElement.setMeanings(this.getMeanings((Referenceable)validValue));
        }
        return validValueElement;
    }

    private List<ValidValueElement> getValidValues(List<ValidValue> validValueBeans) {
        ArrayList<ValidValueElement> validValueElements = null;
        if (validValueBeans != null) {
            validValueElements = new ArrayList<ValidValueElement>();
            for (ValidValue validValue : validValueBeans) {
                if (validValue == null) continue;
                validValueElements.add(this.getValidValue(validValue));
            }
            if (validValueElements.isEmpty()) {
                validValueElements = null;
            }
        }
        return validValueElements;
    }
}

