/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.converters;

import org.odpi.openmetadata.accessservices.digitalarchitecture.converters.DigitalArchitectureOMASConverter;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ReferenceableElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueAssignmentConsumerElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ValidValueAssignmentConsumerConverter<B>
extends DigitalArchitectureOMASConverter<B> {
    public ValidValueAssignmentConsumerConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof ValidValueAssignmentConsumerElement) {
                ValidValueAssignmentConsumerElement bean = (ValidValueAssignmentConsumerElement)returnBean;
                ReferenceableElement consumer = new ReferenceableElement();
                ReferenceableProperties referenceableProperties = new ReferenceableProperties();
                consumer.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                referenceableProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                referenceableProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                referenceableProperties.setTypeName(consumer.getElementHeader().getType().getTypeName());
                referenceableProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                consumer.setReferenceableProperties(referenceableProperties);
                bean.setConsumer(consumer);
                if (relationship != null) {
                    instanceProperties = relationship.getProperties();
                    bean.setStrictRequirement(this.getStrictRequirement(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    void updateSimpleMetadataElement(MetadataElement metadataElement, EntityDetail entity, Relationship relationship) {
        if (metadataElement instanceof ValidValueAssignmentConsumerElement) {
            // empty if block
        }
    }
}

