/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.converters;

import java.util.Map;
import org.odpi.openmetadata.accessservices.digitalarchitecture.converters.DigitalArchitectureOMASConverter;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ReferenceDataAssetElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.OwnerCategory;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ReferenceDataAssetProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ReferenceDataAssetConverter<B>
extends DigitalArchitectureOMASConverter<B> {
    public ReferenceDataAssetConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof ReferenceDataAssetElement) {
                ReferenceDataAssetElement bean = (ReferenceDataAssetElement)returnBean;
                this.updateSimpleMetadataElement(beanClass, bean, entity, methodName);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof ReferenceDataAssetElement) {
                ReferenceDataAssetElement bean = (ReferenceDataAssetElement)returnBean;
                this.updateSimpleMetadataElement(beanClass, bean, entity, methodName);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    void updateSimpleMetadataElement(Class<B> beanClass, ReferenceDataAssetElement bean, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
            ReferenceDataAssetProperties referenceDataAssetProperties = new ReferenceDataAssetProperties();
            InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
            referenceDataAssetProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
            referenceDataAssetProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
            referenceDataAssetProperties.setDisplayName(this.removeName(instanceProperties));
            referenceDataAssetProperties.setDescription(this.removeDescription(instanceProperties));
            referenceDataAssetProperties.setOwner(this.removeOwner(instanceProperties));
            referenceDataAssetProperties.setOwnerCategory(this.removeOwnerCategoryFromProperties(instanceProperties));
            referenceDataAssetProperties.setZoneMembership(this.removeZoneMembership(instanceProperties));
            referenceDataAssetProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
            referenceDataAssetProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            instanceProperties = super.getClassificationProperties("AssetZoneMembership", entity);
            referenceDataAssetProperties.setZoneMembership(this.getZoneMembership(instanceProperties));
            instanceProperties = super.getClassificationProperties("AssetOwnership", entity);
            referenceDataAssetProperties.setOwner(this.getOwner(instanceProperties));
            referenceDataAssetProperties.setOwnerCategory(this.getOwnerCategoryFromProperties(instanceProperties));
            instanceProperties = super.getClassificationProperties("AssetOrigin", entity);
            referenceDataAssetProperties.setOriginOrganizationGUID(this.getOriginOrganizationGUID(instanceProperties));
            referenceDataAssetProperties.setOriginBusinessCapabilityGUID(this.getOriginBusinessCapabilityGUID(instanceProperties));
            referenceDataAssetProperties.setOtherOriginValues(this.getOtherOriginValues(instanceProperties));
            bean.setReferenceDataAssetProperties(referenceDataAssetProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
    }

    private OwnerCategory removeOwnerCategoryFromProperties(InstanceProperties properties) {
        OwnerCategory ownerCategory = this.getOwnerCategoryFromProperties(properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove("ownerType");
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return ownerCategory;
    }

    private OwnerCategory getOwnerCategoryFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        OwnerCategory ownerCategory = OwnerCategory.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get("ownerType")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    ownerCategory = OwnerCategory.USER_ID;
                    break;
                }
                case 1: {
                    ownerCategory = OwnerCategory.PROFILE_ID;
                    break;
                }
                case 99: {
                    ownerCategory = OwnerCategory.OTHER;
                }
            }
        }
        return ownerCategory;
    }
}

