/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.converters;

import org.odpi.openmetadata.accessservices.digitalarchitecture.converters.DigitalArchitectureOMASConverter;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ValidValueElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValueProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ValidValueConverter<B>
extends DigitalArchitectureOMASConverter<B> {
    public ValidValueConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof ValidValueElement) {
                this.updateSimpleMetadataElement(beanClass, (ValidValueElement)returnBean, entity, methodName);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof ValidValueElement) {
                this.updateSimpleMetadataElement(beanClass, (ValidValueElement)returnBean, entity, methodName);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    void updateSimpleMetadataElement(Class<B> beanClass, ValidValueElement bean, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
            ValidValueProperties validValueProperties = new ValidValueProperties();
            InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
            validValueProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
            validValueProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
            validValueProperties.setDisplayName(this.removeName(instanceProperties));
            validValueProperties.setDescription(this.removeDescription(instanceProperties));
            validValueProperties.setUsage(this.removeUsage(instanceProperties));
            validValueProperties.setScope(this.removeScope(instanceProperties));
            validValueProperties.setPreferredValue(this.removePreferredValue(instanceProperties));
            validValueProperties.setIsDeprecated(this.removeIsDeprecated(instanceProperties));
            validValueProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
            validValueProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            bean.setValidValueProperties(validValueProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
    }
}

