/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.server;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ConnectionsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ConnectorTypesResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.EmbeddedConnectionRequestBody;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.EndpointResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.EndpointsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.server.DigitalArchitectureInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EndpointHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class ConnectionRESTServices {
    private static final DigitalArchitectureInstanceHandler instanceHandler = new DigitalArchitectureInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ConnectionRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createConnection(String serverName, String userId, ConnectionProperties requestBody) {
        String methodName = "createConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnection");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnection");
            if (requestBody != null) {
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "createConnection");
                response.setGUID(handler.createConnection(userId, null, null, null, null, null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getSecuredProperties(), requestBody.getConfigurationProperties(), requestBody.getUserId(), requestBody.getClearPassword(), requestBody.getEncryptedPassword(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, null, null, null, null, false, false, new Date(), "createConnection"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createConnection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createConnectionFromTemplate(String serverName, String userId, String templateGUID, TemplateProperties templateProperties) {
        String methodName = "createConnectionFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnectionFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnectionFromTemplate");
            if (templateProperties != null) {
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "createConnectionFromTemplate");
                response.setGUID(handler.createConnectionFromTemplate(userId, null, null, templateGUID, "templateGUID", templateProperties.getQualifiedName(), "qualifiedName", templateProperties.getDisplayName(), templateProperties.getDescription(), "createConnectionFromTemplate"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createConnectionFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createConnectionFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateConnection(String serverName, String userId, String connectionGUID, boolean isMergeUpdate, ConnectionProperties requestBody) {
        String methodName = "updateConnection";
        String guidParameter = "connectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateConnection");
            if (requestBody != null) {
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "updateConnection");
                handler.updateConnection(userId, null, null, connectionGUID, "connectionGUID", requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getSecuredProperties(), requestBody.getConfigurationProperties(), requestBody.getUserId(), requestBody.getClearPassword(), requestBody.getEncryptedPassword(), requestBody.getTypeName(), requestBody.getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updateConnection");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateConnection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupConnectorType(String serverName, String userId, String connectionGUID, String connectorTypeGUID, NullRequestBody requestBody) {
        String methodName = "setupConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupConnectorType");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupConnectorType");
            if (requestBody != null) {
                handler.addConnectionConnectorType(userId, null, null, connectionGUID, "connectionGUID", connectorTypeGUID, "connectorTypeGUID", null, null, false, false, new Date(), "setupConnectorType");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupConnectorType", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearConnectorType(String serverName, String userId, String connectionGUID, String connectorTypeGUID, NullRequestBody requestBody) {
        String methodName = "clearConnectorType";
        String connectionGUIDParameterName = "connectionGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearConnectorType");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearConnectorType");
            if (requestBody != null) {
                handler.removeConnectionConnectorType(userId, null, null, connectionGUID, "connectionGUID", connectorTypeGUID, "connectorTypeGUID", false, false, new Date(), "clearConnectorType");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearConnectorType", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupEndpoint(String serverName, String userId, String connectionGUID, String endpointGUID, NullRequestBody requestBody) {
        String methodName = "setupEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupEndpoint");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupEndpoint");
            if (requestBody != null) {
                handler.addConnectionEndpoint(userId, null, null, connectionGUID, "connectionGUID", endpointGUID, "endpointGUID", null, null, false, false, new Date(), "setupEndpoint");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupEndpoint", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearEndpoint(String serverName, String userId, String connectionGUID, String endpointGUID, NullRequestBody requestBody) {
        String methodName = "clearEndpoint";
        String connectionGUIDParameterName = "connectionGUID";
        String endpointGUIDParameterName = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearEndpoint");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearEndpoint");
            if (requestBody != null) {
                handler.removeConnectionEndpoint(userId, null, null, connectionGUID, "connectionGUID", endpointGUID, "endpointGUID", false, false, new Date(), "clearEndpoint");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearEndpoint", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupEmbeddedConnection(String serverName, String userId, String connectionGUID, String embeddedConnectionGUID, EmbeddedConnectionRequestBody requestBody) {
        String methodName = "setupEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupEmbeddedConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupEmbeddedConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupEmbeddedConnection");
            if (requestBody != null) {
                handler.addEmbeddedConnection(userId, null, null, connectionGUID, "connectionGUID", requestBody.getPosition(), requestBody.getDisplayName(), requestBody.getArguments(), embeddedConnectionGUID, "embeddedConnectionGUID", null, null, false, false, new Date(), "setupEmbeddedConnection");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupEmbeddedConnection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupEmbeddedConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearEmbeddedConnection(String serverName, String userId, String connectionGUID, String embeddedConnectionGUID, NullRequestBody requestBody) {
        String methodName = "clearEmbeddedConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearEmbeddedConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearEmbeddedConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearEmbeddedConnection");
            if (requestBody != null) {
                handler.removeEmbeddedConnection(userId, null, null, connectionGUID, "connectionGUID", embeddedConnectionGUID, "embeddedConnectionGUID", false, false, new Date(), "clearEmbeddedConnection");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearEmbeddedConnection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearEmbeddedConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAssetConnection(String serverName, String userId, String assetGUID, String connectionGUID, StringRequestBody requestBody) {
        String methodName = "setupAssetConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupAssetConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAssetConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "setupAssetConnection");
            if (requestBody != null) {
                handler.addConnectionToAsset(userId, null, null, connectionGUID, "connectionGUID", assetGUID, "assetGUID", requestBody.getString(), null, null, false, false, new Date(), "setupAssetConnection");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupAssetConnection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupAssetConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAssetConnection(String serverName, String userId, String assetGUID, String connectionGUID, NullRequestBody requestBody) {
        String methodName = "clearAssetConnection";
        String connectionGUIDParameterName = "connectionGUID";
        String assetGUIDParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAssetConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAssetConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "clearAssetConnection");
            if (requestBody != null) {
                handler.removeConnectionToAsset(userId, null, null, connectionGUID, "connectionGUID", assetGUID, "assetGUID", false, false, new Date(), "clearAssetConnection");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearAssetConnection", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearAssetConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeConnection(String serverName, String userId, String connectionGUID, NullRequestBody requestBody) {
        String methodName = "removeConnection";
        String guidParameter = "connectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeConnection");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "removeConnection");
            handler.removeConnection(userId, null, null, connectionGUID, "connectionGUID", false, false, new Date(), "removeConnection");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionsResponse findConnections(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findConnections";
        String parameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findConnections");
        ConnectionsResponse response = new ConnectionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findConnections");
            if (requestBody != null) {
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "findConnections");
                List connections = handler.findConnections(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findConnections");
                response.setElementList(connections);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findConnections", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionsResponse getConnectionsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getConnectionsByName";
        String parameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionsByName");
        ConnectionsResponse response = new ConnectionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionsByName");
            if (requestBody != null) {
                ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "getConnectionsByName");
                List connections = handler.getConnectionsByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getConnectionsByName");
                response.setElementList(connections);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectionsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionResponse getConnectionByGUID(String serverName, String userId, String connectionGUID) {
        String methodName = "getConnectionByGUID";
        String connectionGUIDParameter = "connectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionByGUID");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionByGUID");
            ConnectionHandler<ConnectionElement> handler = instanceHandler.getConnectionHandler(userId, serverName, "getConnectionByGUID");
            ConnectionElement connection = (ConnectionElement)handler.getConnectionByGUID(userId, connectionGUID, "connectionGUID", false, false, new Date(), "getConnectionByGUID");
            response.setElement(connection);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectionByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEndpoint(String serverName, String userId, EndpointProperties endpointProperties) {
        String methodName = "createEndpoint";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEndpoint");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEndpoint");
            if (endpointProperties != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "createEndpoint");
                String endpointGUID = handler.createEndpoint(userId, null, null, null, endpointProperties.getQualifiedName(), endpointProperties.getTechnicalName(), endpointProperties.getTechnicalDescription(), endpointProperties.getAddress(), endpointProperties.getProtocol(), endpointProperties.getEncryptionMethod(), endpointProperties.getAdditionalProperties(), endpointProperties.getTypeName(), endpointProperties.getExtendedProperties(), null, null, new Date(), "createEndpoint");
                response.setGUID(endpointGUID);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createEndpoint", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createEndpointFromTemplate(String serverName, String userId, String networkAddress, String templateGUID, TemplateProperties templateProperties) {
        String methodName = "createEndpointFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createEndpointFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createEndpointFromTemplate");
            if (templateProperties != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "createEndpointFromTemplate");
                response.setGUID(handler.createEndpointFromTemplate(userId, null, null, templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), networkAddress, "createEndpointFromTemplate"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createEndpointFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createEndpointFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateEndpoint(String serverName, String userId, String endpointGUID, boolean isMergeUpdate, EndpointProperties endpointProperties) {
        String methodName = "updateEndpoint";
        String guidParameter = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateEndpoint");
            if (endpointProperties != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "updateEndpoint");
                handler.updateEndpoint(userId, null, null, endpointGUID, "endpointGUID", endpointProperties.getQualifiedName(), endpointProperties.getTechnicalName(), endpointProperties.getTechnicalDescription(), endpointProperties.getAddress(), endpointProperties.getProtocol(), endpointProperties.getEncryptionMethod(), endpointProperties.getAdditionalProperties(), endpointProperties.getTypeName(), endpointProperties.getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updateEndpoint");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateEndpoint", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeEndpoint(String serverName, String userId, String endpointGUID, NullRequestBody requestBody) {
        String methodName = "removeEndpoint";
        String guidParameter = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeEndpoint");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeEndpoint");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "removeEndpoint");
            handler.removeEndpoint(userId, null, null, endpointGUID, "endpointGUID", false, false, new Date(), "removeEndpoint");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeEndpoint", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointsResponse findEndpoints(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findEndpoints";
        String parameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findEndpoints");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findEndpoints");
            if (requestBody != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "findEndpoints");
                List endpoints = handler.findEndpoints(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findEndpoints");
                response.setElementList(endpoints);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findEndpoints", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointsResponse getEndpointsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getEndpointsByName";
        String parameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointsByName");
        EndpointsResponse response = new EndpointsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointsByName");
            if (requestBody != null) {
                EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "getEndpointsByName");
                List endpoints = handler.getEndpointsByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getEndpointsByName");
                response.setElementList(endpoints);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEndpointsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EndpointResponse getEndpointByGUID(String serverName, String userId, String endpointGUID) {
        String methodName = "getEndpointByGUID";
        String endpointGUIDParameter = "endpointGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEndpointByGUID");
        EndpointResponse response = new EndpointResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEndpointByGUID");
            EndpointHandler<EndpointElement> handler = instanceHandler.getEndpointHandler(userId, serverName, "getEndpointByGUID");
            EndpointElement endpoint = (EndpointElement)handler.getEndpointByGUID(userId, endpointGUID, "endpointGUID", false, false, new Date(), "getEndpointByGUID");
            response.setElement(endpoint);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEndpointByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createConnectorType(String serverName, String userId, ConnectorTypeProperties connectorTypeProperties) {
        String methodName = "createConnectorType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnectorType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnectorType");
            if (connectorTypeProperties != null) {
                ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "createConnectorType");
                response.setGUID(handler.createConnectorType(userId, null, null, null, connectorTypeProperties.getQualifiedName(), connectorTypeProperties.getDisplayName(), connectorTypeProperties.getDescription(), connectorTypeProperties.getSupportedAssetTypeName(), connectorTypeProperties.getExpectedDataFormat(), connectorTypeProperties.getConnectorProviderClassName(), connectorTypeProperties.getConnectorFrameworkName(), connectorTypeProperties.getConnectorInterfaceLanguage(), connectorTypeProperties.getConnectorInterfaces(), connectorTypeProperties.getTargetTechnologySource(), connectorTypeProperties.getTargetTechnologyName(), connectorTypeProperties.getTargetTechnologyInterfaces(), connectorTypeProperties.getTargetTechnologyVersions(), connectorTypeProperties.getRecognizedAdditionalProperties(), connectorTypeProperties.getRecognizedSecuredProperties(), connectorTypeProperties.getRecognizedConfigurationProperties(), connectorTypeProperties.getAdditionalProperties(), connectorTypeProperties.getTypeName(), connectorTypeProperties.getExtendedProperties(), null, null, new Date(), "createConnectorType"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createConnectorType", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createConnectorTypeFromTemplate(String serverName, String userId, String templateGUID, TemplateProperties templateProperties) {
        String methodName = "createConnectorTypeFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createConnectorTypeFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createConnectorTypeFromTemplate");
            if (templateProperties != null) {
                ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "createConnectorTypeFromTemplate");
                response.setGUID(handler.createConnectorTypeFromTemplate(userId, null, null, templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), "createConnectorTypeFromTemplate"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createConnectorTypeFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createConnectorTypeFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateConnectorType(String serverName, String userId, String connectorTypeGUID, boolean isMergeUpdate, ConnectorTypeProperties connectorTypeProperties) {
        String methodName = "updateConnectorType";
        String guidParameter = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateConnectorType");
            if (connectorTypeProperties != null) {
                ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "updateConnectorType");
                handler.updateConnectorType(userId, null, null, connectorTypeGUID, "connectorTypeGUID", connectorTypeProperties.getQualifiedName(), connectorTypeProperties.getDisplayName(), connectorTypeProperties.getDescription(), connectorTypeProperties.getSupportedAssetTypeName(), connectorTypeProperties.getExpectedDataFormat(), connectorTypeProperties.getConnectorProviderClassName(), connectorTypeProperties.getConnectorFrameworkName(), connectorTypeProperties.getConnectorInterfaceLanguage(), connectorTypeProperties.getConnectorInterfaces(), connectorTypeProperties.getTargetTechnologySource(), connectorTypeProperties.getTargetTechnologyName(), connectorTypeProperties.getTargetTechnologyInterfaces(), connectorTypeProperties.getTargetTechnologyVersions(), connectorTypeProperties.getRecognizedAdditionalProperties(), connectorTypeProperties.getRecognizedSecuredProperties(), connectorTypeProperties.getRecognizedConfigurationProperties(), connectorTypeProperties.getAdditionalProperties(), connectorTypeProperties.getTypeName(), connectorTypeProperties.getExtendedProperties(), null, null, isMergeUpdate, false, false, new Date(), "updateConnectorType");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateConnectorType", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeConnectorType(String serverName, String userId, String connectorTypeGUID, NullRequestBody requestBody) {
        String methodName = "removeConnectorType";
        String guidParameter = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeConnectorType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeConnectorType");
            ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "removeConnectorType");
            handler.removeConnectorType(userId, null, null, connectorTypeGUID, "connectorTypeGUID", false, false, new Date(), "removeConnectorType");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeConnectorType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypesResponse findConnectorTypes(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findConnectorTypes";
        String parameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findConnectorTypes");
        ConnectorTypesResponse response = new ConnectorTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findConnectorTypes");
            if (requestBody != null) {
                ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "findConnectorTypes");
                List connectorTypes = handler.findConnectorTypes(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findConnectorTypes");
                response.setElementList(connectorTypes);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findConnectorTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypesResponse getConnectorTypesByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getConnectorTypesByName";
        String parameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectorTypesByName");
        ConnectorTypesResponse response = new ConnectorTypesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectorTypesByName");
            if (requestBody != null) {
                ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "getConnectorTypesByName");
                List connectorTypes = handler.getConnectorTypesByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getConnectorTypesByName");
                response.setElementList(connectorTypes);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectorTypesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypeResponse getConnectorTypeByGUID(String serverName, String userId, String connectorTypeGUID) {
        String methodName = "getConnectorTypeByGUID";
        String connectorTypeGUIDParameter = "connectorTypeGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectorTypeByGUID");
        ConnectorTypeResponse response = new ConnectorTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectorTypeByGUID");
            ConnectorTypeHandler<ConnectorTypeElement> handler = instanceHandler.getConnectorTypeHandler(userId, serverName, "getConnectorTypeByGUID");
            ConnectorTypeElement connectorType = (ConnectorTypeElement)handler.getConnectorTypeByGUID(userId, connectorTypeGUID, "connectorTypeGUID", false, false, new Date(), "getConnectorTypeByGUID");
            response.setElement(connectorType);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectorTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

