/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.digitalarchitecture.converters.DigitalArchitectureOMASConverter;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.ReferenceDataAssetElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ReferenceDataAssetProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ReferenceDataAssetConverter<B>
extends DigitalArchitectureOMASConverter<B> {
    public ReferenceDataAssetConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ReferenceDataAssetElement) {
                ReferenceDataAssetElement bean = (ReferenceDataAssetElement)returnBean;
                this.updateSimpleMetadataElement(beanClass, bean, entity, methodName);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ReferenceDataAssetElement) {
                ReferenceDataAssetElement bean = (ReferenceDataAssetElement)returnBean;
                this.updateSimpleMetadataElement(beanClass, bean, entity, methodName);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    void updateSimpleMetadataElement(Class<B> beanClass, ReferenceDataAssetElement bean, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
            ReferenceDataAssetProperties referenceDataAssetProperties = new ReferenceDataAssetProperties();
            InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
            referenceDataAssetProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
            referenceDataAssetProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
            referenceDataAssetProperties.setDisplayName(this.removeName(instanceProperties));
            referenceDataAssetProperties.setDescription(this.removeDescription(instanceProperties));
            referenceDataAssetProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
            referenceDataAssetProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            bean.setReferenceDataAssetProperties(referenceDataAssetProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
    }
}

