/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.LocationElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.LocationProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.DigitalLocationRequestBody;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.FixedLocationRequestBody;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.LocationResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.LocationsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.SecureLocationRequestBody;
import org.odpi.openmetadata.accessservices.digitalarchitecture.server.DigitalArchitectureInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.LocationHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class LocationRESTServices {
    private static DigitalArchitectureInstanceHandler instanceHandler = new DigitalArchitectureInstanceHandler();
    private static RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(LocationRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createLocation(String serverName, String userId, LocationProperties locationProperties) {
        String methodName = "createLocation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createLocation");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createLocation");
            if (locationProperties != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "createLocation");
                response.setGUID(handler.createLocation(userId, locationProperties.getQualifiedName(), locationProperties.getDisplayName(), locationProperties.getDescription(), locationProperties.getAdditionalProperties(), locationProperties.getTypeName(), locationProperties.getExtendedProperties(), null, null, "createLocation"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createLocation", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createLocationFromTemplate(String serverName, String userId, String templateGUID, TemplateProperties templateProperties) {
        String methodName = "createLocationFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createLocationFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createLocationFromTemplate");
            if (templateProperties != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "createLocationFromTemplate");
                response.setGUID(handler.createLocationFromTemplate(userId, templateGUID, templateProperties.getQualifiedName(), templateProperties.getDisplayName(), templateProperties.getDescription(), "createLocationFromTemplate"));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createLocationFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createLocationFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateLocation(String serverName, String userId, String locationGUID, boolean isMergeUpdate, LocationProperties locationProperties) {
        String methodName = "updateLocation";
        String guidParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateLocation");
            if (locationProperties != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "updateLocation");
                handler.updateLocation(userId, locationGUID, "locationGUID", locationProperties.getQualifiedName(), locationProperties.getDisplayName(), locationProperties.getDescription(), locationProperties.getAdditionalProperties(), locationProperties.getTypeName(), locationProperties.getExtendedProperties(), isMergeUpdate, null, null, "updateLocation");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateLocation", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setLocationAsFixedPhysical(String serverName, String userId, String locationGUID, FixedLocationRequestBody requestBody) {
        String methodName = "setLocationAsFixedPhysical";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setLocationAsFixedPhysical");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setLocationAsFixedPhysical");
            if (requestBody != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "setLocationAsFixedPhysical");
                handler.addFixedLocationClassification(userId, locationGUID, "locationGUID", requestBody.getCoordinates(), requestBody.getMapProjection(), requestBody.getPostalAddress(), requestBody.getTimeZone(), "setLocationAsFixedPhysical");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setLocationAsFixedPhysical", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setLocationAsFixedPhysical", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearLocationAsFixedPhysical(String serverName, String userId, String locationGUID, NullRequestBody requestBody) {
        String methodName = "clearLocationAsFixedPhysical";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearLocationAsFixedPhysical");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearLocationAsFixedPhysical");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "clearLocationAsFixedPhysical");
            handler.removeFixedLocationClassification(userId, locationGUID, "locationGUID", "clearLocationAsFixedPhysical");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearLocationAsFixedPhysical", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setLocationAsSecure(String serverName, String userId, String locationGUID, SecureLocationRequestBody requestBody) {
        String methodName = "setLocationAsSecure";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setLocationAsSecure");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setLocationAsSecure");
            if (requestBody != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "setLocationAsSecure");
                handler.addSecureLocationClassification(userId, locationGUID, "locationGUID", requestBody.getDescription(), requestBody.getLevel(), "setLocationAsSecure");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setLocationAsSecure", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setLocationAsSecure", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearLocationAsSecure(String serverName, String userId, String locationGUID, NullRequestBody requestBody) {
        String methodName = "clearLocationAsSecure";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearLocationAsSecure");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearLocationAsSecure");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "clearLocationAsSecure");
            handler.removeSecureLocationClassification(userId, locationGUID, "locationGUID", "clearLocationAsSecure");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearLocationAsSecure", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setLocationAsDigital(String serverName, String userId, String locationGUID, DigitalLocationRequestBody requestBody) {
        String methodName = "setLocationAsDigital";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setLocationAsDigital");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setLocationAsDigital");
            if (requestBody != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "setLocationAsDigital");
                handler.addCyberLocationClassification(userId, locationGUID, "locationGUID", requestBody.getNetworkAddress(), "setLocationAsDigital");
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setLocationAsDigital", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setLocationAsDigital", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearLocationAsDigital(String serverName, String userId, String locationGUID, NullRequestBody requestBody) {
        String methodName = "clearLocationAsDigital";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearLocationAsDigital");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearLocationAsDigital");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "clearLocationAsDigital");
            handler.removeCyberLocationClassification(userId, locationGUID, "locationGUID", "clearLocationAsDigital");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearLocationAsDigital", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeLocation(String serverName, String userId, String locationGUID, NullRequestBody requestBody) {
        String methodName = "removeLocation";
        String guidParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "removeLocation");
            handler.removeLocation(userId, locationGUID, "locationGUID", "removeLocation");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupNestedLocation(String serverName, String userId, String parentLocationGUID, String childLocationGUID, NullRequestBody requestBody) {
        String methodName = "setupNestedLocation";
        String parentLocationGUIDParameter = "parentLocationGUID";
        String childLocationGUIDParameter = "childLocationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupNestedLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupNestedLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "setupNestedLocation");
            handler.setupNestedLocation(userId, parentLocationGUID, "parentLocationGUID", childLocationGUID, "childLocationGUID", null, null, "setupNestedLocation");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupNestedLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearNestedLocation(String serverName, String userId, String parentLocationGUID, String childLocationGUID, NullRequestBody requestBody) {
        String methodName = "clearNestedLocation";
        String parentLocationGUIDParameter = "parentLocationGUID";
        String childLocationGUIDParameter = "childLocationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearNestedLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearNestedLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "clearNestedLocation");
            handler.clearNestedLocation(userId, parentLocationGUID, "parentLocationGUID", childLocationGUID, "childLocationGUID", null, "clearNestedLocation");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearNestedLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAdjacentLocation(String serverName, String userId, String locationOneGUID, String locationTwoGUID, NullRequestBody requestBody) {
        String methodName = "setupAdjacentLocation";
        String locationOneGUIDParameter = "locationOneGUID";
        String locationTwoGUIDParameter = "locationTwoGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupAdjacentLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAdjacentLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "setupAdjacentLocation");
            handler.setupPeerLocations(userId, locationOneGUID, "locationOneGUID", locationTwoGUID, "locationTwoGUID", null, null, "setupAdjacentLocation");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupAdjacentLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAdjacentLocation(String serverName, String userId, String locationOneGUID, String locationTwoGUID, NullRequestBody requestBody) {
        String methodName = "clearAdjacentLocation";
        String locationOneGUIDParameter = "locationOneGUID";
        String locationTwoGUIDParameter = "locationTwoGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAdjacentLocation");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAdjacentLocation");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "clearAdjacentLocation");
            handler.clearPeerLocations(userId, locationOneGUID, "locationOneGUID", locationTwoGUID, "locationTwoGUID", null, "clearAdjacentLocation");
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearAdjacentLocation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LocationsResponse findLocations(String serverName, String userId, SearchStringRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "findLocations";
        String parameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findLocations");
        LocationsResponse response = new LocationsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findLocations");
            if (requestBody != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "findLocations");
                List locations = handler.findBeans(userId, requestBody.getSearchString(), "searchString", "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", null, startFrom, pageSize, new Date(), "findLocations");
                response.setElementList(locations);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findLocations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LocationsResponse getLocationsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getLocationsByName";
        String parameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLocationsByName");
        LocationsResponse response = new LocationsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLocationsByName");
            if (requestBody != null) {
                LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "getLocationsByName");
                ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
                specificMatchPropertyNames.add("qualifiedName");
                specificMatchPropertyNames.add("displayName");
                List locations = handler.getBeansByValue(userId, requestBody.getName(), "name", "3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", specificMatchPropertyNames, true, null, null, false, false, null, startFrom, pageSize, new Date(), "getLocationsByName");
                response.setElementList(locations);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getLocationsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LocationResponse getLocationByGUID(String serverName, String userId, String locationGUID) {
        String methodName = "getLocationByGUID";
        String locationGUIDParameter = "locationGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLocationByGUID");
        LocationResponse response = new LocationResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLocationByGUID");
            LocationHandler<LocationElement> handler = instanceHandler.getLocationHandler(userId, serverName, "getLocationByGUID");
            LocationElement location = (LocationElement)handler.getBeanFromRepository(userId, locationGUID, "locationGUID", "Location", false, false, new Date(), "getLocationByGUID");
            response.setElement(location);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getLocationByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

